/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ByteArrayBlockBuilder;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestByteArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestByteArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestByteArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestByteArrayBlock.alternatingNullValues(TestByteArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestByteArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestByteArrayBlock.createTestValue(100);
        ByteArrayBlockBuilder emptyBlockBuilder = new ByteArrayBlockBuilder(null, 0);
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, expectedValues.length);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestByteArrayBlock.writeValues(expectedValues, blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = (ByteArrayBlockBuilder)blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestByteArrayBlock.createTestValue(100);
        TestByteArrayBlock.assertEstimatedDataSizeForStats(TestByteArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        byte[] byteArray = new byte[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestByteArrayBlock.testCompactBlock((Block)new ByteArrayBlock(0, Optional.empty(), new byte[0]));
        TestByteArrayBlock.testCompactBlock((Block)new ByteArrayBlock(byteArray.length, Optional.of(valueIsNull), byteArray));
        TestByteArrayBlock.testIncompactBlock((Block)new ByteArrayBlock(byteArray.length - 1, Optional.of(valueIsNull), byteArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        Block block = TestByteArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, expectedValues.length);
        TestByteArrayBlock.writeValues(expectedValues, blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, ByteArrayBlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeByte(expectedValue.getByte(0));
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = Slices.wrappedBuffer((byte[])new byte[]{(byte)position});
        }
        return expectedValues;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

