/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import io.airlift.concurrent.Threads;
import io.airlift.slice.SizeOf;
import io.airlift.testing.Assertions;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NetworkTopology;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorConfig;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelector;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Split;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestNodeScheduler {
    private FinalizerService finalizerService;
    private NodeTaskMap nodeTaskMap;
    private InMemoryNodeManager nodeManager;
    private NodeSchedulerConfig nodeSchedulerConfig;
    private NodeScheduler nodeScheduler;
    private NodeSelector nodeSelector;
    private Map<InternalNode, RemoteTask> taskMap;
    private ExecutorService remoteTaskExecutor;
    private ScheduledExecutorService remoteTaskScheduledExecutor;
    private Session session;

    @BeforeEach
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().build();
        this.finalizerService = new FinalizerService();
        this.nodeTaskMap = new NodeTaskMap(this.finalizerService);
        this.nodeManager = new InMemoryNodeManager(new InternalNode[0]);
        this.nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setMinPendingSplitsPerTask(10).setMaxAdjustedPendingSplitsWeightPerTask(100).setIncludeCoordinator(false);
        this.nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)this.nodeManager, this.nodeSchedulerConfig, this.nodeTaskMap));
        this.taskMap = new HashMap<InternalNode, RemoteTask>();
        this.nodeSelector = this.nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
        this.remoteTaskExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remoteTaskExecutor-%s"));
        this.remoteTaskScheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"remoteTaskScheduledExecutor-%s"));
        this.finalizerService.start();
    }

    private void setUpNodes() {
        this.nodeManager.addNodes(new InternalNode[]{new InternalNode("other1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://10.0.0.1:13"), NodeVersion.UNKNOWN, false)});
    }

    @AfterEach
    public void tearDown() {
        this.remoteTaskExecutor.shutdown();
        this.remoteTaskExecutor = null;
        this.remoteTaskScheduledExecutor.shutdown();
        this.remoteTaskScheduledExecutor = null;
        this.nodeSchedulerConfig = null;
        this.nodeScheduler = null;
        this.nodeSelector = null;
        this.finalizerService.destroy();
        this.finalizerService = null;
    }

    @Test
    public void testAssignmentWhenNoNodes() {
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values()))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NO_NODES_AVAILABLE}).hasMessageMatching("No nodes available to run query");
    }

    @Test
    public void testScheduleLocal() {
        this.setUpNodes();
        Split split = new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocallyAccessible());
        ImmutableSet splits = ImmutableSet.of((Object)split);
        Map.Entry assignment = (Map.Entry)Iterables.getOnlyElement((Iterable)this.nodeSelector.computeAssignments((Set)splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments().entries());
        org.assertj.core.api.Assertions.assertThat((Object)((InternalNode)assignment.getKey()).getHostAndPort()).isEqualTo(split.getAddresses().get(0));
        org.assertj.core.api.Assertions.assertThat((Object)((Split)assignment.getValue())).isEqualTo((Object)split);
    }

    @Test
    @Timeout(value=60L)
    public void testTopologyAwareScheduling() {
        int i;
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{new InternalNode("node1", URI.create("http://host1.rack1:11"), NodeVersion.UNKNOWN, false), new InternalNode("node2", URI.create("http://host2.rack1:12"), NodeVersion.UNKNOWN, false), new InternalNode("node3", URI.create("http://host3.rack2:13"), NodeVersion.UNKNOWN, false)});
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(25).setIncludeCoordinator(false).setMinPendingSplitsPerTask(20);
        TestNetworkTopology topology = new TestNetworkTopology();
        TopologyAwareNodeSelectorFactory nodeSelectorFactory = new TopologyAwareNodeSelectorFactory((NetworkTopology)topology, (InternalNodeManager)nodeManager, nodeSchedulerConfig, nodeTaskMap, TestNodeScheduler.getNetworkTopologyConfig());
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)nodeSelectorFactory);
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
        ImmutableSet.Builder nonRackLocalBuilder = ImmutableSet.builder();
        for (int i2 = 0; i2 < 108; ++i2) {
            nonRackLocalBuilder.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"data.other_rack", (int)1))));
        }
        ImmutableSet nonRackLocalSplits = nonRackLocalBuilder.build();
        Multimap assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId(new StageId("test", 1), task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(25);
            nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        org.assertj.core.api.Assertions.assertThat((int)nonRackLocalSplits.size()).isEqualTo(3);
        ImmutableSet.Builder rackLocalSplits = ImmutableSet.builder();
        HostAddress dataHost1 = HostAddress.fromParts((String)"data.rack1", (int)1);
        HostAddress dataHost2 = HostAddress.fromParts((String)"data.rack2", (int)1);
        for (i = 0; i < 12; ++i) {
            rackLocalSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(dataHost1)));
        }
        for (i = 0; i < 6; ++i) {
            rackLocalSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(dataHost2)));
        }
        assignments = nodeSelector.computeAssignments((Set)rackLocalSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (Object node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get(node)).build());
        }
        Sets.SetView unassigned = Sets.difference((Set)rackLocalSplits.build(), new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)unassigned, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        unassigned = Sets.difference((Set)unassigned, new HashSet(assignments.values()));
        org.assertj.core.api.Assertions.assertThat((int)unassigned.size()).isEqualTo(3);
        int rack1 = 0;
        int rack2 = 0;
        block15: for (Split split : unassigned) {
            String rack;
            switch (rack = (String)topology.locate((HostAddress)split.getAddresses().get(0)).getSegments().get(0)) {
                case "rack1": {
                    ++rack1;
                    continue block15;
                }
                case "rack2": {
                    ++rack2;
                    continue block15;
                }
            }
            throw new AssertionError((Object)("Unexpected rack: " + rack));
        }
        org.assertj.core.api.Assertions.assertThat((int)rack1).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((int)rack2).isEqualTo(1);
        ImmutableSet.Builder localSplits = ImmutableSet.builder();
        localSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host1.rack1", (int)1))));
        localSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host2.rack1", (int)1))));
        localSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host3.rack2", (int)1))));
        assignments = nodeSelector.computeAssignments((Set)localSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments.size()).isEqualTo(3);
        org.assertj.core.api.Assertions.assertThat((int)assignments.keySet().size()).isEqualTo(3);
    }

    @Test
    public void testScheduleRemote() {
        this.setUpNodes();
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments.size()).isEqualTo(1);
    }

    @Test
    public void testBasicAssignment() {
        this.setUpNodes();
        Set activeCatalogNodes = (Set)this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE).stream().filter(node -> !node.isCoordinator()).collect(ImmutableSet.toImmutableSet());
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < activeCatalogNodes.size(); ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments.entries().size()).isEqualTo(assignments.size());
        for (InternalNode node2 : activeCatalogNodes) {
            org.assertj.core.api.Assertions.assertThat((Collection)assignments.keySet()).contains((Object[])new InternalNode[]{node2});
        }
    }

    @Test
    public void testMaxSplitsPerNode() {
        this.setUpNodes();
        InternalNode newNode = new InternalNode("other4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            initialSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        TaskId taskId1 = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId1));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask1);
        TaskId taskId2 = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId2));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask2);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((boolean)assignments.keySet().contains(newNode)).isFalse();
        remoteTask1.abort();
        remoteTask2.abort();
        org.assertj.core.api.Assertions.assertThat((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode)).isEqualTo((Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testBasicAssignmentMaxUnacknowledgedSplitsPerTask() {
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(1), Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
        this.setUpNodes();
        Set activeCatalogNodes = (Set)this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE).stream().filter(node -> !node.isCoordinator()).collect(ImmutableSet.toImmutableSet());
        int splitCount = activeCatalogNodes.size() + 1;
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < splitCount; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments.entries().size()).isEqualTo(activeCatalogNodes.size());
        for (InternalNode node2 : activeCatalogNodes) {
            org.assertj.core.api.Assertions.assertThat((Collection)assignments.keySet()).contains((Object[])new InternalNode[]{node2});
        }
    }

    @Test
    public void testMaxSplitsPerNodePerTask() {
        this.setUpNodes();
        InternalNode newNode = new InternalNode("other4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 20; ++i) {
            initialSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        for (InternalNode node : this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE)) {
            TaskId taskId = new TaskId(new StageId("test", 1), 1, 0);
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            tasks.add(remoteTask);
        }
        TaskId taskId = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask newRemoteTask = remoteTaskFactory.createTableScanTask(taskId, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(newNode, taskId));
        this.taskMap.put(newNode, newRemoteTask);
        this.nodeTaskMap.addTask(newNode, (RemoteTask)newRemoteTask);
        tasks.add(newRemoteTask);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments.keySet().size()).isEqualTo(3);
        org.assertj.core.api.Assertions.assertThat((boolean)assignments.keySet().contains(newNode)).isFalse();
        for (RemoteTask remoteTask : tasks) {
            remoteTask.abort();
        }
        org.assertj.core.api.Assertions.assertThat((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode)).isEqualTo((Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testTaskCompletion() throws Exception {
        this.setUpNodes();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE), (int)0);
        TaskId taskId = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask);
        org.assertj.core.api.Assertions.assertThat((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount()).isEqualTo(1);
        remoteTask.abort();
        TimeUnit.MILLISECONDS.sleep(100L);
        org.assertj.core.api.Assertions.assertThat((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode)).isEqualTo((Object)PartitionedSplitsInfo.forZeroSplits());
        remoteTask.abort();
        org.assertj.core.api.Assertions.assertThat((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode)).isEqualTo((Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testSplitCount() {
        this.setUpNodes();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE), (int)0);
        TaskId taskId1 = new TaskId(new StageId("test", 1), 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()), (Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId(new StageId("test", 1), 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createPartitionedSplitCountTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        org.assertj.core.api.Assertions.assertThat((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount()).isEqualTo(3);
        remoteTask1.abort();
        org.assertj.core.api.Assertions.assertThat((int)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode).getCount()).isEqualTo(1);
        remoteTask2.abort();
        org.assertj.core.api.Assertions.assertThat((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode)).isEqualTo((Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testPrioritizedAssignmentOfLocalSplit() {
        InternalNode node = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap initialAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)initialAssignment.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)initialAssignment.keySet().size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Collection)initialAssignment.keySet()).contains((Object[])new InternalNode[]{node});
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        Multimap finalAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)finalAssignment.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)finalAssignment.keySet().size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Collection)finalAssignment.keySet()).contains((Object[])new InternalNode[]{node});
        long countLocalSplits = finalAssignment.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)countLocalSplits).isEqualTo(1L);
    }

    @Test
    public void testAssignmentWhenMixedSplits() {
        int i;
        InternalNode node = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (i = 0; i < 10; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap initialAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)initialAssignment.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)initialAssignment.keySet().size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Collection)initialAssignment.keySet()).contains((Object[])new InternalNode[]{node});
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        Multimap finalAssignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)finalAssignment.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)finalAssignment.keySet().size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Collection)finalAssignment.keySet()).contains((Object[])new InternalNode[]{node});
        long countLocalSplits = finalAssignment.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)countLocalSplits).isEqualTo(11L);
    }

    @Test
    public void testOptimizedLocalScheduling() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node2});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignments1 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments1.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)assignments1.keySet().size()).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((Collection)assignments1.keySet()).contains((Object[])new InternalNode[]{node1});
        org.assertj.core.api.Assertions.assertThat((Collection)assignments1.keySet()).contains((Object[])new InternalNode[]{node2});
        for (int i = 0; i < 19; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"10.0.0.1:12"))));
        }
        Multimap assignments2 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments2.size()).isEqualTo(39);
        org.assertj.core.api.Assertions.assertThat((int)assignments2.keySet().size()).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((Collection)assignments2.keySet()).contains((Object[])new InternalNode[]{node1});
        org.assertj.core.api.Assertions.assertThat((Collection)assignments2.keySet()).contains((Object[])new InternalNode[]{node2});
        long node1Splits = assignments2.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)node1Splits).isEqualTo(20L);
        long node2Splits = assignments2.values().stream().map(Split::getConnectorSplit).filter(TestSplitRemote.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)node2Splits).isEqualTo(19L);
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"10.0.0.1:12"))));
        Multimap assignments3 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments3.size()).isEqualTo(40);
        org.assertj.core.api.Assertions.assertThat((int)assignments3.keySet().size()).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((Collection)assignments3.keySet()).contains((Object[])new InternalNode[]{node1});
        org.assertj.core.api.Assertions.assertThat((Collection)assignments3.keySet()).contains((Object[])new InternalNode[]{node2});
        node1Splits = assignments3.values().stream().map(Split::getConnectorSplit).filter(TestSplitLocal.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)node1Splits).isEqualTo(20L);
        node2Splits = assignments3.values().stream().map(Split::getConnectorSplit).filter(TestSplitRemote.class::isInstance).count();
        org.assertj.core.api.Assertions.assertThat((long)node2Splits).isEqualTo(20L);
    }

    @Test
    public void testEquateDistribution() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node2});
        InternalNode node3 = new InternalNode("node3", URI.create("http://10.0.0.1:13"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node3});
        InternalNode node4 = new InternalNode("node4", URI.create("http://10.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node4});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 20; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignment.size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)assignment.keySet().size()).isEqualTo(4);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node1).size()).isEqualTo(8);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node2).size()).isEqualTo(4);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node3).size()).isEqualTo(4);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node4).size()).isEqualTo(4);
    }

    @Test
    public void testEquateDistributionConsistentHashing() {
        this.testEquateDistributionConsistentHashing(5, 10, 0.0);
        this.testEquateDistributionConsistentHashing(5, 20, 0.055);
        this.testEquateDistributionConsistentHashing(10, 50, 0.0);
        this.testEquateDistributionConsistentHashing(10, 100, 0.045);
        this.testEquateDistributionConsistentHashing(10, 200, 0.09);
        this.testEquateDistributionConsistentHashing(50, 550, 0.045);
        this.testEquateDistributionConsistentHashing(50, 600, 0.047);
        this.testEquateDistributionConsistentHashing(50, 700, 0.045);
        this.testEquateDistributionConsistentHashing(100, 550, 0.036);
        this.testEquateDistributionConsistentHashing(100, 600, 0.054);
        this.testEquateDistributionConsistentHashing(100, 1000, 0.039);
        this.testEquateDistributionConsistentHashing(100, 1500, 0.045);
    }

    private void testEquateDistributionConsistentHashing(int numberOfNodes, int numberOfSplits, double misassignedSplitsRatio) {
        this.setUp();
        ImmutableList.Builder nodesBuilder = ImmutableList.builder();
        for (int i = 0; i < numberOfNodes; ++i) {
            InternalNode node = new InternalNode("node" + i, URI.create("http://10.0.0.1:" + (i + 10)), NodeVersion.UNKNOWN, false);
            nodesBuilder.add((Object)node);
            this.nodeManager.addNodes(new InternalNode[]{node});
        }
        ImmutableList nodes = nodesBuilder.build();
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        Random random = new Random(0L);
        ImmutableSetMultimap.Builder originalAssignmentBuilder = ImmutableSetMultimap.builder();
        for (int i = 0; i < numberOfSplits; ++i) {
            InternalNode node = (InternalNode)nodes.get(Hashing.consistentHash((long)random.nextInt(), (int)nodes.size()));
            Split split = new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal(node.getHostAndPort()));
            splits.add(split);
            originalAssignmentBuilder.put((Object)node, (Object)split);
        }
        ImmutableSetMultimap originalNodeAssignment = originalAssignmentBuilder.build().inverse();
        Multimap assignment = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        ImmutableSetMultimap nodeAssignment = ImmutableSetMultimap.copyOf((Multimap)assignment).inverse();
        int misassignedSplits = 0;
        for (Split split : splits) {
            if (((InternalNode)Iterables.getOnlyElement((Iterable)originalNodeAssignment.get((Object)split))).equals(Iterables.getOnlyElement((Iterable)nodeAssignment.get((Object)split)))) continue;
            ++misassignedSplits;
        }
        Assertions.assertLessThanOrEqual((Comparable)Double.valueOf((double)misassignedSplits / (double)numberOfSplits), (Comparable)Double.valueOf(misassignedSplitsRatio));
    }

    @Test
    public void testRedistributeSplit() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node2});
        HashMultimap assignment = HashMultimap.create();
        LinkedHashSet<Split> splitsAssignedToNode1 = new LinkedHashSet<Split>();
        for (int i = 0; i < 6; ++i) {
            splitsAssignedToNode1.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
            splitsAssignedToNode1.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        for (Split split : splitsAssignedToNode1) {
            assignment.put((Object)node1, (Object)split);
        }
        LinkedHashSet<Split> splitsAssignedToNode2 = new LinkedHashSet<Split>();
        for (int i = 0; i < 10; ++i) {
            splitsAssignedToNode2.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        for (Split split : splitsAssignedToNode2) {
            assignment.put((Object)node2, (Object)split);
        }
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node1).size()).isEqualTo(12);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node2).size()).isEqualTo(10);
        ImmutableSetMultimap.Builder nodesByHost = ImmutableSetMultimap.builder();
        try {
            nodesByHost.put((Object)node1.getInternalAddress(), (Object)node1);
            nodesByHost.put((Object)node2.getInternalAddress(), (Object)node2);
        }
        catch (UnknownHostException e) {
            System.out.println("Could not convert the address");
        }
        UniformNodeSelector.redistributeSplit((Multimap)assignment, (InternalNode)node1, (InternalNode)node2, (SetMultimap)nodesByHost.build());
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node1).size()).isEqualTo(11);
        org.assertj.core.api.Assertions.assertThat((int)assignment.get((Object)node2).size()).isEqualTo(11);
        Sets.SetView redistributedSplit = Sets.difference(new HashSet(assignment.get((Object)node2)), splitsAssignedToNode2);
        org.assertj.core.api.Assertions.assertThat((int)redistributedSplit.size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((boolean)(((Split)redistributedSplit.iterator().next()).getConnectorSplit() instanceof TestSplitRemote)).isTrue();
    }

    @Test
    public void testEmptyAssignmentWithFullNodes() {
        InternalNode node1 = new InternalNode("node1", URI.create("http://10.0.0.1:11"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node1});
        InternalNode node2 = new InternalNode("node2", URI.create("http://10.0.0.1:12"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNodes(new InternalNode[]{node2});
        LinkedHashSet<Split> splits = new LinkedHashSet<Split>();
        for (int i = 0; i < 70; ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitLocal()));
        }
        Multimap assignments1 = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((int)assignments1.size()).isEqualTo(40);
        org.assertj.core.api.Assertions.assertThat((int)assignments1.keySet().size()).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((int)assignments1.get((Object)node1).size()).isEqualTo(20);
        org.assertj.core.api.Assertions.assertThat((int)assignments1.get((Object)node2).size()).isEqualTo(20);
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments1.keySet()) {
            TaskId taskId = new TaskId(new StageId("test", 1), task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments1.get((Object)node)), this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId));
            remoteTask.startSplits(15);
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            this.taskMap.put(node, remoteTask);
        }
        Sets.SetView unassignedSplits = Sets.difference(splits, new HashSet(assignments1.values()));
        org.assertj.core.api.Assertions.assertThat((int)unassignedSplits.size()).isEqualTo(30);
        Multimap assignments2 = this.nodeSelector.computeAssignments((Set)unassignedSplits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        for (InternalNode node : assignments2.keySet()) {
            RemoteTask remoteTask = this.taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments2.get((Object)node)).build());
        }
        unassignedSplits = Sets.difference((Set)unassignedSplits, new HashSet(assignments2.values()));
        org.assertj.core.api.Assertions.assertThat((int)unassignedSplits.size()).isEqualTo(20);
        Multimap assignments3 = this.nodeSelector.computeAssignments((Set)unassignedSplits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        org.assertj.core.api.Assertions.assertThat((boolean)assignments3.isEmpty()).isTrue();
    }

    @Test
    public void testMaxUnacknowledgedSplitsPerTask() {
        int maxUnacknowledgedSplitsPerTask = 5;
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(maxUnacknowledgedSplitsPerTask), Optional.of(TestingHandles.TEST_CATALOG_HANDLE));
        this.setUpNodes();
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < maxUnacknowledgedSplitsPerTask; ++i) {
            initialSplits.add((Object)new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        List nodes = (List)this.nodeManager.getActiveCatalogNodes(TestingHandles.TEST_CATALOG_HANDLE).stream().filter(node -> !node.isCoordinator()).collect(ImmutableList.toImmutableList());
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int counter = 1;
        for (InternalNode node2 : nodes) {
            TaskId taskId = new TaskId(new StageId("test", 1), counter, 0);
            ++counter;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node2, (List<Split>)initialSplits.build(), this.nodeTaskMap.createPartitionedSplitCountTracker(node2, taskId));
            this.nodeTaskMap.addTask(node2, (RemoteTask)remoteTask);
            remoteTask.setMaxUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            remoteTask.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            tasks.add(remoteTask);
        }
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < nodes.size(); ++i) {
            splits.add(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestSplitRemote()));
        }
        SplitPlacementResult splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        org.assertj.core.api.Assertions.assertThat((int)splitPlacements.getAssignments().size()).isEqualTo(0);
        MockRemoteTaskFactory.MockRemoteTask taskOne = (MockRemoteTaskFactory.MockRemoteTask)tasks.get(0);
        taskOne.finishSplits(1);
        taskOne.setUnacknowledgedSplits(taskOne.getUnacknowledgedPartitionedSplitCount() - 1);
        org.assertj.core.api.Assertions.assertThat((boolean)splitPlacements.getBlocked().isDone()).isTrue();
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        org.assertj.core.api.Assertions.assertThat((int)splitPlacements.getAssignments().size()).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Collection)splitPlacements.getAssignments().keySet()).contains((Object[])new InternalNode[]{(InternalNode)nodes.get(0)});
        taskOne.clearSplits();
        tasks.forEach(task -> task.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask - 1));
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        org.assertj.core.api.Assertions.assertThat((int)splitPlacements.getAssignments().size()).isEqualTo(nodes.size());
        org.assertj.core.api.Assertions.assertThat((boolean)splitPlacements.getAssignments().keySet().containsAll(nodes)).isTrue();
    }

    private static Session sessionWithMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        return TestingSession.testSessionBuilder().setSystemProperty("max_unacknowledged_splits_per_task", Integer.toString(maxUnacknowledgedSplitsPerTask)).build();
    }

    private static TopologyAwareNodeSelectorConfig getNetworkTopologyConfig() {
        return new TopologyAwareNodeSelectorConfig().setLocationSegmentNames((List)ImmutableList.of((Object)"rack", (Object)"machine"));
    }

    private static class TestSplitRemote
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TestSplitRemote.class);
        private final List<HostAddress> hosts;
        private final SplitWeight splitWeight;

        TestSplitRemote() {
            this(HostAddress.fromString((String)String.format("10.%s.%s.%s:%s", ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(0, 255), ThreadLocalRandom.current().nextInt(15, 5000))));
        }

        TestSplitRemote(HostAddress host) {
            this(host, SplitWeight.standard());
        }

        TestSplitRemote(HostAddress host, SplitWeight splitWeight) {
            this.hosts = ImmutableList.of((Object)Objects.requireNonNull(host, "host is null"));
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public List<HostAddress> getAddresses() {
            return this.hosts;
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.hosts, HostAddress::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes();
        }
    }

    private static class TestSplitLocallyAccessible
    implements ConnectorSplit {
        private TestSplitLocallyAccessible() {
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of((Object)HostAddress.fromString((String)"10.0.0.1:11"));
        }

        public Object getInfo() {
            return this;
        }

        public long getRetainedSizeInBytes() {
            return 0L;
        }
    }

    private static class TestNetworkTopology
    implements NetworkTopology {
        private TestNetworkTopology() {
        }

        public NetworkLocation locate(HostAddress address) {
            ArrayList parts = new ArrayList(ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)address.getHostText())));
            Collections.reverse(parts);
            return new NetworkLocation(parts);
        }
    }

    private static class TestSplitLocal
    implements ConnectorSplit {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(TestSplitLocal.class);
        private final HostAddress address;
        private final SplitWeight splitWeight;

        private TestSplitLocal() {
            this(HostAddress.fromString((String)"10.0.0.1:11"));
        }

        private TestSplitLocal(HostAddress address) {
            this(address, SplitWeight.standard());
        }

        private TestSplitLocal(HostAddress address, SplitWeight splitWeight) {
            this.address = Objects.requireNonNull(address, "address is null");
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public boolean isRemotelyAccessible() {
            return true;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of((Object)this.address);
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.address.getRetainedSizeInBytes() + this.splitWeight.getRetainedSizeInBytes();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
        }
    }
}

