/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.RenameTableTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SaveMode;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameTable;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRenameTableTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testRenameExistingTable() {
        QualifiedObjectName tableName = TestRenameTableTask.qualifiedObjectName("existing_table");
        QualifiedObjectName newTableName = TestRenameTableTask.qualifiedObjectName("existing_view_new");
        this.metadata.createTable(this.testSession, "test_catalog", TestRenameTableTask.someTable(tableName), SaveMode.FAIL);
        MoreFutures.getFutureValue(this.executeRenameTable(TestRenameTableTask.asQualifiedName(tableName), TestRenameTableTask.asQualifiedName(newTableName), false));
        Assertions.assertThat(this.metadata.getTableHandle(this.testSession, tableName)).isEmpty();
        Assertions.assertThat(this.metadata.getTableHandle(this.testSession, newTableName)).isPresent();
    }

    @Test
    public void testRenameNotExistingTable() {
        QualifiedName tableName = TestRenameTableTask.qualifiedName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(tableName, TestRenameTableTask.qualifiedName("not_existing_table_new"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testRenameNotExistingTableIfExists() {
        QualifiedName tableName = TestRenameTableTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeRenameTable(tableName, TestRenameTableTask.qualifiedName("not_existing_table_new"), true));
    }

    @Test
    public void testRenameTableOnView() {
        QualifiedObjectName viewName = TestRenameTableTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestRenameTableTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(TestRenameTableTask.asQualifiedName(viewName), TestRenameTableTask.qualifiedName("existing_view_new"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW %s RENAME TO ...?", new Object[]{viewName, viewName});
    }

    @Test
    public void testRenameTableOnViewIfExists() {
        QualifiedObjectName viewName = TestRenameTableTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestRenameTableTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(TestRenameTableTask.asQualifiedName(viewName), TestRenameTableTask.qualifiedName("existing_view_new"), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a view with that name exists. Did you mean ALTER VIEW %s RENAME TO ...?", new Object[]{viewName, viewName});
    }

    @Test
    public void testRenameTableOnMaterializedView() {
        QualifiedName viewName = TestRenameTableTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(viewName, TestRenameTableTask.qualifiedName("existing_materialized_view_new"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a materialized view with that name exists. Did you mean ALTER MATERIALIZED VIEW test_catalog.schema.existing_materialized_view RENAME TO ...?", new Object[]{viewName});
    }

    @Test
    public void testRenameTableOnMaterializedViewIfExists() {
        QualifiedName viewName = TestRenameTableTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(viewName, TestRenameTableTask.qualifiedName("existing_materialized_view_new"), true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a materialized view with that name exists. Did you mean ALTER MATERIALIZED VIEW test_catalog.schema.existing_materialized_view RENAME TO ...?", new Object[]{viewName});
    }

    @Test
    public void testRenameTableTargetViewExists() {
        QualifiedObjectName tableName = TestRenameTableTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestRenameTableTask.someTable(tableName), SaveMode.FAIL);
        QualifiedName viewName = TestRenameTableTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, QualifiedObjectName.valueOf((String)viewName.toString()), TestRenameTableTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(TestRenameTableTask.asQualifiedName(tableName), viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Target table '%s' does not exist, but a view with that name exists.", new Object[]{viewName});
    }

    @Test
    public void testRenameTableTargetMaterializedViewExists() {
        QualifiedObjectName tableName = TestRenameTableTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestRenameTableTask.someTable(tableName), SaveMode.FAIL);
        QualifiedObjectName materializedViewName = TestRenameTableTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameTable(TestRenameTableTask.asQualifiedName(tableName), TestRenameTableTask.asQualifiedName(materializedViewName), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Target table '%s' does not exist, but a materialized view with that name exists.", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeRenameTable(QualifiedName source, QualifiedName target, boolean exists) {
        return new RenameTableTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new RenameTable(source, target, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

