/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.ClientCapabilities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.informationschema.InformationSchemaColumnHandle;
import io.trino.connector.informationschema.InformationSchemaMetadata;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestInformationSchemaMetadata {
    private static final int MAX_PREFIXES_COUNT = new OptimizerConfig().getMaxPrefetchedInformationSchemaPrefixes();
    private LocalQueryRunner queryRunner;
    private TransactionManager transactionManager;
    private Metadata metadata;

    @BeforeAll
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)"test_schema")).withListTables((connectorSession, schemaName) -> ImmutableList.of((Object)"test_view", (Object)"another_table")).withGetViews((connectorSession, prefix) -> {
            ConnectorViewDefinition definition = new ConnectorViewDefinition("select 1", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.of("test column comment"))), Optional.of("comment"), Optional.empty(), true, (List)ImmutableList.of());
            SchemaTableName viewName = new SchemaTableName("test_schema", "test_view");
            return ImmutableMap.of((Object)viewName, (Object)definition);
        }).build();
        this.queryRunner.createCatalog("test_catalog", (ConnectorFactory)mockConnectorFactory, (Map)ImmutableMap.of());
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.metadata = this.queryRunner.getMetadata();
    }

    @AfterAll
    public void tearDown() {
        try {
            if (this.queryRunner != null) {
                this.queryRunner.close();
            }
        }
        finally {
            this.metadata = null;
            this.transactionManager = null;
            this.queryRunner = null;
        }
    }

    @Test
    public void testInformationSchemaPredicatePushdown() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = ImmutableMap.builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.buildOrThrow()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)tableHandle.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), TestInformationSchemaMetadata::testConstraint, TestInformationSchemaMetadata.testConstraintColumns());
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "columns"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)tableHandle.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithoutSchemaPredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = ImmutableMap.builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_name"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_view")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.buildOrThrow()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)tableHandle.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", "test_view"), (Object)new QualifiedTablePrefix("test_catalog", "information_schema", "test_view")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithoutTablePredicate() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ImmutableMap.Builder domains = ImmutableMap.builder();
        domains.put((Object)new InformationSchemaColumnHandle("table_schema"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test_schema")));
        Constraint constraint = new Constraint(TupleDomain.withColumnDomains((Map)domains.buildOrThrow()));
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)tableHandle.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownWithConstraintPredicateOnViewsTable() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all(), TestInformationSchemaMetadata::testConstraint, TestInformationSchemaMetadata.testConstraintColumns());
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "views"));
        tableHandle = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)tableHandle.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema")));
    }

    @Test
    public void testInformationSchemaPredicatePushdownOnCatalogWiseTables() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        Constraint constraint = new Constraint(TupleDomain.all());
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)metadata.getTableHandle(session, new SchemaTableName("information_schema", "schemata"));
        Optional result = metadata.applyFilter(session, (ConnectorTableHandle)tableHandle, constraint);
        Assertions.assertThat((boolean)result.isPresent()).isFalse();
    }

    @Test
    public void testInformationSchemaPredicatePushdownForEmptyNames() {
        TransactionId transactionId = this.transactionManager.beginTransaction(false);
        ConnectorSession session = TestInformationSchemaMetadata.createNewSession(transactionId);
        InformationSchemaMetadata metadata = new InformationSchemaMetadata("test_catalog", this.metadata, MAX_PREFIXES_COUNT);
        InformationSchemaColumnHandle tableSchemaColumn = new InformationSchemaColumnHandle("table_schema");
        InformationSchemaColumnHandle tableNameColumn = new InformationSchemaColumnHandle("table_name");
        ConnectorTableHandle tableHandle = metadata.getTableHandle(session, new SchemaTableName("information_schema", "tables"));
        InformationSchemaTableHandle filtered = metadata.applyFilter(session, tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)tableSchemaColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"")))))).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)filtered.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "")));
        filtered = metadata.applyFilter(session, tableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)tableNameColumn, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"")))))).map(ConstraintApplicationResult::getHandle).map(InformationSchemaTableHandle.class::cast).orElseThrow(AssertionError::new);
        Assertions.assertThat((Collection)filtered.getPrefixes()).isEqualTo((Object)ImmutableSet.of((Object)new QualifiedTablePrefix("test_catalog", "test_schema", ""), (Object)new QualifiedTablePrefix("test_catalog", "information_schema", "")));
    }

    private static boolean testConstraint(Map<ColumnHandle, NullableValue> bindings) {
        NullableValue catalog = bindings.get(new InformationSchemaColumnHandle("table_catalog"));
        NullableValue schema = bindings.get(new InformationSchemaColumnHandle("table_schema"));
        NullableValue table = bindings.get(new InformationSchemaColumnHandle("table_name"));
        boolean isValid = true;
        if (catalog != null) {
            isValid = ((Slice)catalog.getValue()).toStringUtf8().equals("test_catalog");
        }
        if (schema != null) {
            isValid &= ((Slice)schema.getValue()).toStringUtf8().equals("test_schema");
        }
        if (table != null) {
            isValid &= ((Slice)table.getValue()).toStringUtf8().equals("test_view");
        }
        return isValid;
    }

    private static Set<ColumnHandle> testConstraintColumns() {
        return Set.of(new InformationSchemaColumnHandle("table_catalog"), new InformationSchemaColumnHandle("table_schema"), new InformationSchemaColumnHandle("table_name"));
    }

    private static ConnectorSession createNewSession(TransactionId transactionId) {
        return TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("information_schema").setClientCapabilities((Set)Arrays.stream(ClientCapabilities.values()).map(Enum::toString).collect(ImmutableSet.toImmutableSet())).setTransactionId(transactionId).build().toConnectorSession();
    }
}

