/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupByHashYieldAssertion;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.TopNRankingOperator;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTopNRankingOperator {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    private final TypeOperators typeOperators = new TypeOperators();
    private final JoinCompiler joinCompiler = new JoinCompiler(this.typeOperators);
    private final BlockTypeOperators blockTypeOperators = new BlockTypeOperators(this.typeOperators);

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testPartitioned() {
        for (boolean hashEnabled : Arrays.asList(true, false)) {
            DriverContext driverContext = this.newDriverContext();
            RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
            List<Page> input = rowPagesBuilder.row("a", 0.3).row("b", 0.2).row("c", 0.1).row("c", 0.91).pageBreak().row("a", 0.4).pageBreak().row("a", 0.5).row("a", 0.6).row("b", 0.7).row("b", 0.8).pageBreak().row("b", 0.9).build();
            TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(0, new PlanNodeId("test"), TopNRankingNode.RankingType.ROW_NUMBER, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10, Optional.empty(), this.joinCompiler, this.typeOperators, this.blockTypeOperators);
            MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{0.3, "a", 1L}).row(new Object[]{0.4, "a", 2L}).row(new Object[]{0.5, "a", 3L}).row(new Object[]{0.2, "b", 1L}).row(new Object[]{0.7, "b", 2L}).row(new Object[]{0.8, "b", 3L}).row(new Object[]{0.1, "c", 1L}).row(new Object[]{0.91, "c", 2L}).build();
            OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
        }
    }

    @Test
    public void testUnPartitioned() {
        for (boolean partial : Arrays.asList(true, false)) {
            DriverContext driverContext = this.newDriverContext();
            List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE}).row("a", 0.3).row("b", 0.2).row("c", 0.1).row("c", 0.91).pageBreak().row("a", 0.4).pageBreak().row("a", 0.5).row("a", 0.6).row("b", 0.7).row("b", 0.8).pageBreak().row("b", 0.9).build();
            TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(0, new PlanNodeId("test"), TopNRankingNode.RankingType.ROW_NUMBER, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, partial, Optional.empty(), 10, partial ? Optional.of(DataSize.ofBytes((long)1L)) : Optional.empty(), this.joinCompiler, this.typeOperators, this.blockTypeOperators);
            MaterializedResult expected = partial ? MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{0.1, "c"}).row(new Object[]{0.2, "b"}).row(new Object[]{0.3, "a"}).row(new Object[]{0.4, "a"}).row(new Object[]{0.5, "a"}).row(new Object[]{0.6, "a"}).row(new Object[]{0.7, "b"}).row(new Object[]{0.9, "b"}).build() : MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{0.1, "c", 1L}).row(new Object[]{0.2, "b", 2L}).row(new Object[]{0.3, "a", 3L}).build();
            OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
        }
    }

    @Test
    public void testPartialFlush() {
        for (boolean partial : Arrays.asList(true, false)) {
            DriverContext driverContext = this.newDriverContext();
            List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.91).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).pageBreak().row(2L, 0.9).build();
            TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(0, new PlanNodeId("test"), TopNRankingNode.RankingType.ROW_NUMBER, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, partial, Optional.empty(), 10, partial ? Optional.of(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.BYTE)) : Optional.empty(), this.joinCompiler, this.typeOperators, this.blockTypeOperators);
            TopNRankingOperator operator = (TopNRankingOperator)operatorFactory.createOperator(driverContext);
            for (Page inputPage : input) {
                operator.addInput(inputPage);
                if (partial) {
                    Assertions.assertThat((boolean)operator.needsInput()).isFalse();
                    Assertions.assertThat((Object)operator.getOutput()).isNotNull();
                    Assertions.assertThat((boolean)operator.isFinished()).isFalse();
                    Assertions.assertThatThrownBy(() -> operator.addInput(inputPage)).isInstanceOf(IllegalStateException.class);
                    Assertions.assertThat((Object)operator.getOutput()).isNull();
                    Assertions.assertThat((boolean)operator.needsInput()).isTrue();
                    continue;
                }
                Assertions.assertThat((boolean)operator.needsInput()).isTrue();
                Assertions.assertThat((Object)operator.getOutput()).isNull();
            }
        }
    }

    @Test
    public void testMemoryReservationYield() {
        BigintType type = BigintType.BIGINT;
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys((Type)type, 1000, 500);
        TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(0, new PlanNodeId("test"), TopNRankingNode.RankingType.ROW_NUMBER, (List)ImmutableList.of((Object)type), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)type), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10, Optional.empty(), this.joinCompiler, this.typeOperators, this.blockTypeOperators);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, (Type)type, (OperatorFactory)operatorFactory, operator -> ((TopNRankingOperator)operator).getGroupedTopNBuilder() == null ? 0 : ((GroupedTopNRowNumberBuilder)((TopNRankingOperator)operator).getGroupedTopNBuilder()).getGroupByHash().getCapacity(), 450000L);
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(3));
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x500000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assertions.assertThat((int)page.getChannelCount()).isEqualTo(2);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assertions.assertThat((byte)page.getBlock(1).getByte(i, 0)).isEqualTo((byte)1);
                ++count;
            }
        }
        Assertions.assertThat((int)count).isEqualTo(500000);
    }

    @Test
    public void testRankNullAndNan() {
        DriverContext driverContext = this.newDriverContext();
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
        List<Page> input = rowPagesBuilder.row("a", null).row("b", 0.2).row("b", Double.NaN).row("c", 0.1).row("c", 0.91).pageBreak().row("a", 0.4).pageBreak().row("a", 0.5).row("a", null).row("a", 0.6).row("b", 0.7).row("b", Double.NaN).build();
        TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(0, new PlanNodeId("test"), TopNRankingNode.RankingType.RANK, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST), 3, false, Optional.empty(), 10, Optional.empty(), this.joinCompiler, this.typeOperators, this.blockTypeOperators);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{null, "a", 1L}).row(new Object[]{null, "a", 1L}).row(new Object[]{0.4, "a", 3L}).row(new Object[]{Double.NaN, "b", 1L}).row(new Object[]{Double.NaN, "b", 1L}).row(new Object[]{0.2, "b", 3L}).row(new Object[]{0.1, "c", 1L}).row(new Object[]{0.91, "c", 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }
}

