/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.primitives.Longs;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.type.BlockTypeOperators;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestChecksumAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final BlockTypeOperators blockTypeOperators = new BlockTypeOperators();

    @Test
    public void testEmpty() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}), null, new Block[]{BlockAssertions.createBooleansBlock(new Boolean[0])});
    }

    @Test
    public void testBoolean() {
        ValueBlock block = BlockAssertions.createBooleansBlock(null, null, true, false, false);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN}), (Object)TestChecksumAggregation.expectedChecksum((Type)BooleanType.BOOLEAN, (Block)block), new Block[]{block});
    }

    @Test
    public void testLong() {
        ValueBlock block = BlockAssertions.createLongsBlock(null, 1L, 2L, 100L, null, Long.MAX_VALUE, Long.MIN_VALUE);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}), (Object)TestChecksumAggregation.expectedChecksum((Type)BigintType.BIGINT, (Block)block), new Block[]{block});
    }

    @Test
    public void testDouble() {
        ValueBlock block = BlockAssertions.createDoublesBlock(null, 2.0, null, 3.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}), (Object)TestChecksumAggregation.expectedChecksum((Type)DoubleType.DOUBLE, (Block)block), new Block[]{block});
    }

    @Test
    public void testString() {
        ValueBlock block = BlockAssertions.createStringsBlock("a", "a", null, "b", "c");
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}), (Object)TestChecksumAggregation.expectedChecksum((Type)VarcharType.VARCHAR, (Block)block), new Block[]{block});
    }

    @Test
    public void testShortDecimal() {
        ValueBlock block = BlockAssertions.createShortDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)2)}), (Object)TestChecksumAggregation.expectedChecksum((Type)shortDecimalType, (Block)block), new Block[]{block});
    }

    @Test
    public void testLongDecimal() {
        ValueBlock block = BlockAssertions.createLongDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)2)}), (Object)TestChecksumAggregation.expectedChecksum((Type)longDecimalType, (Block)block), new Block[]{block});
    }

    @Test
    public void testArray() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        ValueBlock block = BlockAssertions.createArrayBigintBlock(Arrays.asList(null, Arrays.asList(1L, 2L), Arrays.asList(3L, 4L), Arrays.asList(5L, 6L)));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "checksum", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType}), (Object)TestChecksumAggregation.expectedChecksum((Type)arrayType, (Block)block), new Block[]{block});
    }

    private static SqlVarbinary expectedChecksum(Type type, Block block) {
        BlockTypeOperators.BlockPositionXxHash64 xxHash64Operator = blockTypeOperators.getXxHash64Operator(type);
        long result = 0L;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                result += -7046029288634856825L;
                continue;
            }
            result += xxHash64Operator.xxHash64(block, i) * -7046029288634856825L;
        }
        return new SqlVarbinary(Longs.toByteArray((long)Long.reverseBytes(result)));
    }
}

