/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLongDecimalWithOverflowAndLongStateSerializer {
    private static final LongDecimalWithOverflowAndLongStateFactory STATE_FACTORY = new LongDecimalWithOverflowAndLongStateFactory();

    @Test
    public void testSerde() {
        this.testSerde(3L, 0L, 0L, 1L, 1);
        this.testSerde(3L, 5L, 0L, 1L, 2);
        this.testSerde(3L, 5L, 7L, 1L, 4);
        this.testSerde(3L, 0L, 0L, 2L, 3);
        this.testSerde(3L, 5L, 0L, 2L, 4);
        this.testSerde(3L, 5L, 7L, 2L, 4);
        this.testSerde(3L, 0L, 7L, 1L, 3);
        this.testSerde(3L, 0L, 7L, 2L, 3);
        this.testSerde(0L, 0L, 0L, 1L, 1);
        this.testSerde(0L, 5L, 0L, 1L, 2);
        this.testSerde(0L, 5L, 7L, 1L, 4);
        this.testSerde(0L, 0L, 0L, 2L, 3);
        this.testSerde(0L, 5L, 0L, 2L, 4);
        this.testSerde(0L, 5L, 7L, 2L, 4);
        this.testSerde(0L, 0L, 7L, 1L, 3);
        this.testSerde(0L, 0L, 7L, 2L, 3);
    }

    private void testSerde(long low, long high, long overflow, long count, int expectedLength) {
        LongDecimalWithOverflowAndLongState state = STATE_FACTORY.createSingleState();
        state.getDecimalArray()[0] = high;
        state.getDecimalArray()[1] = low;
        state.setOverflow(overflow);
        state.setLong(count);
        LongDecimalWithOverflowAndLongState outState = this.roundTrip(state, expectedLength);
        Assertions.assertThat((long)outState.getDecimalArray()[0]).isEqualTo(high);
        Assertions.assertThat((long)outState.getDecimalArray()[1]).isEqualTo(low);
        Assertions.assertThat((long)outState.getOverflow()).isEqualTo(overflow);
        Assertions.assertThat((long)outState.getLong()).isEqualTo(count);
    }

    @Test
    public void testNullSerde() {
        LongDecimalWithOverflowAndLongState state = STATE_FACTORY.createSingleState();
        LongDecimalWithOverflowAndLongState outState = this.roundTrip(state, 0);
        Assertions.assertThat((long)outState.getLong()).isEqualTo(0L);
    }

    private LongDecimalWithOverflowAndLongState roundTrip(LongDecimalWithOverflowAndLongState state, int expectedLength) {
        LongDecimalWithOverflowAndLongStateSerializer serializer = new LongDecimalWithOverflowAndLongStateSerializer();
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 1, 0);
        serializer.serialize(state, (BlockBuilder)out);
        Block serialized = out.build();
        Assertions.assertThat((int)serialized.getSliceLength(0)).isEqualTo(expectedLength * 8);
        LongDecimalWithOverflowAndLongState outState = STATE_FACTORY.createSingleState();
        serializer.deserialize(serialized, 0, outState);
        return outState;
    }
}

