/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.SqlIntervalDayTime;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.joda.time.chrono.ISOChronology;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDateTimeFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testToIso8601ForTimestampWithoutTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_iso8601", "TIMESTAMP '2001-08-22 03:04:05.321'")))).hasType((Type)VarcharType.createVarcharType((int)26)).isEqualTo("2001-08-22T03:04:05.321");
    }

    @Test
    public void testCurrentDate() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setStart(ZonedDateTime.of(2017, 4, 1, 12, 34, 56, 789, ZoneId.of("UTC")).toInstant()).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_date", session)))).matches("DATE '2017-04-02'");
    }

    @Test
    public void testCurrentDateTimezone() {
        TimeZoneKey kievTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"Europe/Kiev");
        TimeZoneKey bahiaBanderasTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Bahia_Banderas");
        TimeZoneKey montrealTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)"America/Montreal");
        long timeIncrement = TimeUnit.MINUTES.toMillis(53L);
        for (long millis = ISOChronology.getInstanceUTC().getDateTimeMillis(2000, 6, 15, 0, 0, 0, 0); millis < ISOChronology.getInstanceUTC().getDateTimeMillis(2016, 6, 15, 0, 0, 0, 0); millis += timeIncrement) {
            Instant instant = Instant.ofEpochMilli(millis);
            this.assertCurrentDateAtInstant(kievTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(bahiaBanderasTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(montrealTimeZoneKey, instant);
            this.assertCurrentDateAtInstant(TestingSession.DEFAULT_TIME_ZONE_KEY, instant);
        }
    }

    private void assertCurrentDateAtInstant(TimeZoneKey timeZoneKey, Instant instant) {
        long expectedDays = TestDateTimeFunctions.epochDaysInZone(timeZoneKey, instant);
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setStart(instant).setTimeZoneKey(timeZoneKey).build();
        long dateTimeCalculation = DateTimeFunctions.currentDate((ConnectorSession)connectorSession);
        Assertions.assertThat((long)dateTimeCalculation).isEqualTo(expectedDays);
    }

    private static long epochDaysInZone(TimeZoneKey timeZoneKey, Instant instant) {
        return LocalDate.from(instant.atZone(timeZoneKey.getZoneId())).toEpochDay();
    }

    @Test
    public void testFromUnixTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "980172245")))).matches("TIMESTAMP '2001-01-22 03:04:05.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "980172245.888")))).matches("TIMESTAMP '2001-01-22 03:04:05.888 Pacific/Apia'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "123456789123456789")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Millis overflow: 9223372036854775807");
    }

    @Test
    public void testFromUnixTimeNanos() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "1234567890123456789")))).matches("TIMESTAMP '2009-02-13 12:31:30.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "999999999")))).matches("TIMESTAMP '1969-12-31 13:00:00.999999999 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "-1234567890123456789")))).matches("TIMESTAMP '1930-11-17 12:58:29.876543211 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "-999999999")))).matches("TIMESTAMP '1969-12-31 12:59:59.000000001 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '1234'")))).matches("TIMESTAMP '1969-12-31 13:00:00.000001234 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '1234.0'")))).matches("TIMESTAMP '1969-12-31 13:00:00.000001234 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '1234.499'")))).matches("TIMESTAMP '1969-12-31 13:00:00.000001234 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '1234.500'")))).matches("TIMESTAMP '1969-12-31 13:00:00.000001235 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-1234'")))).matches("TIMESTAMP '1969-12-31 12:59:59.999998766 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-1234.0'")))).matches("TIMESTAMP '1969-12-31 12:59:59.999998766 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-1234.499'")))).matches("TIMESTAMP '1969-12-31 12:59:59.999998766 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-1234.500'")))).matches("TIMESTAMP '1969-12-31 12:59:59.999998765 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '12345678900123456789'")))).matches("TIMESTAMP '2361-03-22 08:15:00.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '12345678900123456789.000000'")))).matches("TIMESTAMP '2361-03-22 08:15:00.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '12345678900123456789.499'")))).matches("TIMESTAMP '2361-03-22 08:15:00.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '12345678900123456789.500'")))).matches("TIMESTAMP '2361-03-22 08:15:00.123456790 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-12345678900123456789'")))).matches("TIMESTAMP '1578-10-13 17:18:03.876543211 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-12345678900123456789.000000'")))).matches("TIMESTAMP '1578-10-13 17:18:03.876543211 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-12345678900123456789.499'")))).matches("TIMESTAMP '1578-10-13 17:18:03.876543211 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime_nanos", "DECIMAL '-12345678900123456789.500'")))).matches("TIMESTAMP '1578-10-13 17:18:03.876543210 Pacific/Apia'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime_nanos", "DECIMAL '123456789123456789000000000'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("long overflow");
    }

    @Test
    public void testFromUnixTimeWithOffset() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "980172245", "1", "10")))).matches("TIMESTAMP '2001-01-22 15:14:05.000 +01:10'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "0", "1", "10000")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "0", "10000", "0")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "0", "-100", "100")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "123456789123456789", "1", "1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Millis overflow: 9223372036854775807");
    }

    @Test
    public void testFromUnixTimeWithTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'Asia/Shanghai'")))).matches("TIMESTAMP '1970-01-01 10:00:00.000 Asia/Shanghai'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'Asia/Tokyo'")))).matches("TIMESTAMP '1970-01-01 11:00:00.000 Asia/Tokyo'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'Europe/Kiev'")))).matches("TIMESTAMP '1970-01-01 05:00:00.000 Europe/Kiev'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'America/New_York'")))).matches("TIMESTAMP '1969-12-31 21:00:00.000 America/New_York'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'America/Chicago'")))).matches("TIMESTAMP '1969-12-31 20:00:00.000 America/Chicago'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_unixtime", "7200", "'America/Los_Angeles'")))).matches("TIMESTAMP '1969-12-31 18:00:00.000 America/Los_Angeles'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_unixtime", "123456789123456789", "'Asia/Kolkata'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Millis overflow: 9223372036854775807");
    }

    @Test
    public void testDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date", "'2001-08-22'")))).matches("DATE '2001-08-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date", "TIMESTAMP '2001-08-22 03:04:05.321 +07:09'")))).matches("DATE '2001-08-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date", "TIMESTAMP '2001-08-22 03:04:05.321'")))).matches("DATE '2001-08-22'");
    }

    @Test
    public void testFromISO8601() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp", "'2001-08-22T03:04:05.321-11:00'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 -11:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp", "'2001-08-22T03:04:05.321+07:09'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 +07:09'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_date", "'2001-08-22'")))).matches("DATE '2001-08-22'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_iso8601_timestamp", "'115023-03-21T10:45:30.00Z'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("Millis overflow: 3567614928330000");
    }

    @Test
    public void testFromIso8601Nanos() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp_nanos", "'2001-08-22T12:34:56.123456789Z'")))).matches("TIMESTAMP '2001-08-22 12:34:56.123456789 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp_nanos", "'2001-08-22T07:34:56.123456789-05:00'")))).matches("TIMESTAMP '2001-08-22 07:34:56.123456789 -05:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp_nanos", "'2001-08-22T13:34:56.123456789+01:00'")))).matches("TIMESTAMP '2001-08-22 13:34:56.123456789 +01:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_iso8601_timestamp_nanos", "'2001-08-22T12:34:56.123Z'")))).matches("TIMESTAMP '2001-08-22 12:34:56.123000000 UTC'");
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)ZoneId.of("-0900").getId())).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("from_iso8601_timestamp_nanos('2001-08-22T03:34:56.123456789')", session)))).matches("TIMESTAMP '2001-08-22 03:34:56.123456789 -09:00'");
    }

    @Test
    public void testToIso8601() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_iso8601", "DATE '2001-08-22'")))).hasType((Type)VarcharType.createVarcharType((int)16)).isEqualTo("2001-08-22");
    }

    @Test
    public void testTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timezone()")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Pacific/Apia");
    }

    @Test
    public void testPartFunctions() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("millisecond", "INTERVAL '90061.234' SECOND")))).isEqualTo(234L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("second", "INTERVAL '90061.234' SECOND")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("minute", "INTERVAL '90061.234' SECOND")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hour", "INTERVAL '90061.234' SECOND")))).isEqualTo(1L);
    }

    @Test
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2001-08-22'")))).isEqualTo(2001L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("yow", "DATE '2001-08-22'")))).isEqualTo(2001L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2005-01-02'")))).isEqualTo(2004L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2008-12-28'")))).isEqualTo(2008L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2008-12-29'")))).isEqualTo(2009L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2009-12-31'")))).isEqualTo(2009L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("year_of_week", "DATE '2010-01-03'")))).isEqualTo(2009L);
    }

    @Test
    public void testLastDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "DATE '2001-08-22'")))).matches("DATE '2001-08-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "DATE '2019-08-01'")))).matches("DATE '2019-08-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "DATE '2019-08-31'")))).matches("DATE '2019-8-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("last_day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')")))).matches("DATE '2001-08-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 00:00:00.000'")))).matches("DATE '2019-8-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 17:00:00.000'")))).matches("DATE '2019-8-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 23:59:59.999'")))).matches("DATE '2019-8-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-31 23:59:59.999'")))).matches("DATE '2019-8-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2001-08-22 03:04:05.321 +07:09'")))).matches("DATE '2001-08-31'");
        ImmutableList.of((Object)"+05:45", (Object)"+00:00", (Object)"-05:45", (Object)"Asia/Tokyo", (Object)"Europe/London", (Object)"America/Los_Angeles", (Object)"America/Bahia_Banderas").forEach(timeZone -> {
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2018-12-31 17:00:00.000 " + timeZone + "'"))))).matches("DATE '2018-12-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2018-12-31 20:00:00.000 " + timeZone + "'"))))).matches("DATE '2018-12-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2018-12-31 23:59:59.999 " + timeZone + "'"))))).matches("DATE '2018-12-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-01-01 00:00:00.000 " + timeZone + "'"))))).matches("DATE '2019-1-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-01-01 00:00:00.001 " + timeZone + "'"))))).matches("DATE '2019-1-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-01-01 03:00:00.000 " + timeZone + "'"))))).matches("DATE '2019-1-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-01-01 06:00:00.000 " + timeZone + "'"))))).matches("DATE '2019-1-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 00:00:00.000 " + timeZone + "'"))))).matches("DATE '2019-8-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 17:00:00.000 " + timeZone + "'"))))).matches("DATE '2019-8-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-01 23:59:59.999 " + timeZone + "'"))))).matches("DATE '2019-8-31'");
            ((QueryAssertions.ExpressionAssert)((Object)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("last_day_of_month", "TIMESTAMP '2019-08-31 23:59:59.999 " + timeZone + "'"))))).matches("DATE '2019-8-31'");
        });
    }

    @Test
    public void testExtractFromInterval() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(second FROM INTERVAL '5' SECOND)")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(second FROM INTERVAL '65' SECOND)")))).isEqualTo(5L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(minute FROM INTERVAL '4' MINUTE)")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(minute FROM INTERVAL '64' MINUTE)")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(minute FROM INTERVAL '247' SECOND)")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(hour FROM INTERVAL '3' HOUR)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(hour FROM INTERVAL '27' HOUR)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(hour FROM INTERVAL '187' MINUTE)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(day FROM INTERVAL '2' DAY)")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(day FROM INTERVAL '55' HOUR)")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(month FROM INTERVAL '3' MONTH)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(month FROM INTERVAL '15' MONTH)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(year FROM INTERVAL '2' YEAR)")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(year FROM INTERVAL '29' MONTH)")))).isEqualTo(2L);
    }

    @Test
    public void testTruncateDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_trunc('day', DATE '2001-08-22')")))).matches("DATE '2001-08-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_trunc('week', DATE '2001-08-22')")))).matches("DATE '2001-08-20'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_trunc('month', DATE '2001-08-22')")))).matches("DATE '2001-08-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_trunc('quarter', DATE '2001-08-22')")))).matches("DATE '2001-07-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_trunc('year', DATE '2001-08-22')")))).matches("DATE '2001-01-01'");
    }

    @Test
    public void testAddFieldToDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'day'", "0", "DATE '2001-08-22'")))).matches("DATE '2001-08-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'day'", "3", "DATE '2001-08-22'")))).matches("DATE '2001-08-25'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'week'", "3", "DATE '2001-08-22'")))).matches("DATE '2001-09-12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'month'", "3", "DATE '2001-08-22'")))).matches("DATE '2001-11-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'quarter'", "3", "DATE '2001-08-22'")))).matches("DATE '2002-05-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_add", "'year'", "3", "DATE '2001-08-22'")))).matches("DATE '2004-08-22'");
    }

    @Test
    public void testDateDiffDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_diff", "'day'", "DATE '1960-05-03'", "DATE '2001-08-22'")))).isEqualTo(15086L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_diff", "'week'", "DATE '1960-05-03'", "DATE '2001-08-22'")))).isEqualTo(2155L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_diff", "'month'", "DATE '1960-05-03'", "DATE '2001-08-22'")))).isEqualTo(495L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_diff", "'quarter'", "DATE '1960-05-03'", "DATE '2001-08-22'")))).isEqualTo(165L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_diff", "'year'", "DATE '1960-05-03'", "DATE '2001-08-22'")))).isEqualTo(41L);
    }

    @Test
    public void testParseDatetime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_datetime", "'2020-08-18 03:04:05.678'", "'yyyy-MM-dd HH:mm:ss.SSS'")))).matches("TIMESTAMP '2020-08-18 03:04:05.678 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_datetime", "'1960/01/22 03:04'", "'yyyy/MM/dd HH:mm'")))).matches("TIMESTAMP '1960-01-22 03:04:00.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_datetime", "'1960/01/22 03:04 Asia/Oral'", "'yyyy/MM/dd HH:mm ZZZZZ'")))).matches("TIMESTAMP '1960-01-22 03:04:00.000 Asia/Oral'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_datetime", "'1960/01/22 03:04 +0500'", "'yyyy/MM/dd HH:mm Z'")))).matches("TIMESTAMP '1960-01-22 03:04:00.000 +05:00'");
    }

    @Test
    public void testDateFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%a'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Tue");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Jan");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%c'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%d'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("09");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%e'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("9");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%f'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("321000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%H'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%h'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%I'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%i'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("04");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%j'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("009");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%k'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%l'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%M'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("January");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%m'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%p'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("PM");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%r'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01:04:05 PM");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%S'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%s'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%T'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13:04:05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%v'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%W'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Tuesday");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%Y'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%y'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%%'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("%");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'foo'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%g'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("g");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%4'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%x %v'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001 02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321'", "'%Y\u5e74%m\u6708%d\u65e5'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001\u5e7401\u670809\u65e5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%a'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Tue");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%b'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Jan");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%c'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%d'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("09");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%e'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("9");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%f'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("321000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%H'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%h'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%I'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%i'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("04");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%j'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("009");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%k'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%l'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%M'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("January");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%m'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%p'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("PM");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%r'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01:04:05 PM");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%S'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%s'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%T'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("13:04:05");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%v'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%W'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("Tuesday");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%Y'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%y'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%%'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("%");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'foo'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%g'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("g");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%4'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%x %v'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001 02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'", "'%Y\u5e74%m\u6708%d\u65e5'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001\u5e7401\u670809\u65e5");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 13:04:05.32'", "'%f'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("320000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_format", "TIMESTAMP '2001-01-09 00:04:05.32'", "'%k'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%D'")::evaluate).hasMessage("%D not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%U'")::evaluate).hasMessage("%U not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%u'")::evaluate).hasMessage("%u not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%V'")::evaluate).hasMessage("%V not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%w'")::evaluate).hasMessage("%w not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_format", "DATE '2001-01-09'", "'%X'")::evaluate).hasMessage("%X not supported in date format string");
    }

    @Test
    public void testDateParse() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013'", "'%Y'")))).matches("TIMESTAMP '2013-01-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05'", "'%Y-%m'")))).matches("TIMESTAMP '2013-05-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17'", "'%Y-%m-%d'")))).matches("TIMESTAMP '2013-05-17 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17 12:35:10'", "'%Y-%m-%d %h:%i:%s'")))).matches("TIMESTAMP '2013-05-17 00:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17 12:35:10 PM'", "'%Y-%m-%d %h:%i:%s %p'")))).matches("TIMESTAMP '2013-05-17 12:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17 12:35:10 AM'", "'%Y-%m-%d %h:%i:%s %p'")))).matches("TIMESTAMP '2013-05-17 00:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17 00:35:10'", "'%Y-%m-%d %H:%i:%s'")))).matches("TIMESTAMP '2013-05-17 00:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013-05-17 23:35:10'", "'%Y-%m-%d %H:%i:%s'")))).matches("TIMESTAMP '2013-05-17 23:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'abc 2013-05-17 fff 23:35:10 xyz'", "'abc %Y-%m-%d fff %H:%i:%s xyz'")))).matches("TIMESTAMP '2013-05-17 23:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'2013 14'", "'%Y %y'")))).matches("TIMESTAMP '2014-01-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'1998 53'", "'%x %v'")))).matches("TIMESTAMP '1998-12-28 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'1.1'", "'%s.%f'")))).matches("TIMESTAMP '1970-01-01 00:00:01.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'1.01'", "'%s.%f'")))).matches("TIMESTAMP '1970-01-01 00:00:01.010'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'1.2006'", "'%s.%f'")))).matches("TIMESTAMP '1970-01-01 00:00:01.200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'59.123456789'", "'%s.%f'")))).matches("TIMESTAMP '1970-01-01 00:00:59.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'0'", "'%k'")))).matches("TIMESTAMP '1970-01-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'28-JAN-16 11.45.46.421000 PM'", "'%d-%b-%y %l.%i.%s.%f %p'")))).matches("TIMESTAMP '2016-01-28 23:45:46.421'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'11-DEC-70 11.12.13.456000 AM'", "'%d-%b-%y %l.%i.%s.%f %p'")))).matches("TIMESTAMP '1970-12-11 11:12:13.456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("date_parse", "'31-MAY-69 04.59.59.999000 AM'", "'%d-%b-%y %l.%i.%s.%f %p'")))).matches("TIMESTAMP '2069-05-31 04:59:59.999'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%D'")::evaluate).hasMessage("%D not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%U'")::evaluate).hasMessage("%U not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%u'")::evaluate).hasMessage("%u not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%V'")::evaluate).hasMessage("%V not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%w'")::evaluate).hasMessage("%w not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "''", "'%X'")::evaluate).hasMessage("%X not supported in date format string");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "'3.0123456789'", "'%s.%f'")::evaluate).hasMessage("Invalid format: \"3.0123456789\" is malformed at \"9\"");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("date_parse", "'1970-01-01'", "''")::evaluate).hasMessage("Both printing and parsing not supported");
    }

    @Test
    public void testLocale() {
        Session session = Session.builder((Session)this.assertions.getDefaultSession()).setLocale(Locale.KOREAN).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%a')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud654");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%W')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud654\uc694\uc77c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%p')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\uc624\ud6c4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%r')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("01:04:05 \uc624\ud6c4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%b')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1\uc6d4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_format(TIMESTAMP '2001-01-09 13:04:05.321', '%M')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1\uc6d4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2001-01-09 13:04:05.321', 'EEE')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud654");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2001-01-09 13:04:05.321', 'EEEE')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\ud654\uc694\uc77c");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2001-01-09 13:04:05.321', 'a')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("\uc624\ud6c4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2001-01-09 13:04:05.321', 'MMM')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1\uc6d4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("format_datetime(TIMESTAMP '2001-01-09 13:04:05.321', 'MMMM')", session)))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1\uc6d4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_parse('2013-05-17 12:35:10 \uc624\ud6c4', '%Y-%m-%d %h:%i:%s %p')", session)))).matches("TIMESTAMP '2013-05-17 12:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("date_parse('2013-05-17 12:35:10 \uc624\uc804', '%Y-%m-%d %h:%i:%s %p')", session)))).matches("TIMESTAMP '2013-05-17 00:35:10.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("parse_datetime('2013-05-17 12:35:10 \uc624\ud6c4', 'yyyy-MM-dd hh:mm:ss a')", session)))).matches("TIMESTAMP '2013-05-17 12:35:10.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("parse_datetime('2013-05-17 12:35:10 \uc624\uc804', 'yyyy-MM-dd hh:mm:ss aaa')", session)))).matches("TIMESTAMP '2013-05-17 00:35:10.000 Pacific/Apia'");
    }

    @Test
    public void testParseDuration() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 ns'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 us'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 ms'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1, 234));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 s'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 20, 34, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 m'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 20, 34, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 h'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(51, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234 d'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 ns'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 ms'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1, 235));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 s'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 m'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 20, 34, 34, 20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 h'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(51, 10, 34, 1, 200));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567 d'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234ns'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234us'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234ms'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1, 234));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234s'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 20, 34, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234m'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 20, 34, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234h'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(51, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234d'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(1234, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567ns'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567ms'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1, 235));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567s'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 0, 0, 1234, 567));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567m'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(0, 20, 34, 34, 20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567h'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(51, 10, 34, 1, 200));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("parse_duration", "'1234.567d'")))).hasType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME).isEqualTo(new SqlIntervalDayTime(1234, 13, 36, 28, 800));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_duration", "''")::evaluate).hasMessage("duration is empty");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_duration", "'1f'")::evaluate).hasMessage("Unknown time unit: f");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("parse_duration", "'abc'")::evaluate).hasMessage("duration is not a valid data duration string: abc");
    }

    @Test
    public void testIntervalDayToSecondToMilliseconds() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_milliseconds", "parse_duration('1ns')")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_milliseconds", "parse_duration('1ms')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_milliseconds", "parse_duration('1s')")))).isEqualTo(TimeUnit.SECONDS.toMillis(1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_milliseconds", "parse_duration('1h')")))).isEqualTo(TimeUnit.HOURS.toMillis(1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_milliseconds", "parse_duration('1d')")))).isEqualTo(TimeUnit.DAYS.toMillis(1L));
    }

    @Test
    public void testWithTimezone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'UTC'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 UTC'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'+13'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 +13:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'-14'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 -14:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'+00:45'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 +00:45'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'Asia/Shanghai'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 Asia/Shanghai'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'America/New_York'")))).matches("TIMESTAMP '2001-08-22 03:04:05.321 America/New_York'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-06-01 03:04:05.321'", "'America/Los_Angeles'")))).matches("TIMESTAMP '2001-06-01 03:04:05.321 America/Los_Angeles'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("with_timezone", "TIMESTAMP '2001-12-01 03:04:05.321'", "'America/Los_Angeles'")))).matches("TIMESTAMP '2001-12-01 03:04:05.321 America/Los_Angeles'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("with_timezone", "TIMESTAMP '2001-08-22 03:04:05.321'", "'invalidzoneid'")::evaluate).hasMessage("'invalidzoneid' is not a valid time zone");
    }
}

