/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.time;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExtract {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("hour(TIME '12:34:56.123456789012')")))).matches("BIGINT '12'");
    }

    @Test
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("minute(TIME '12:34:56.123456789012')")))).matches("BIGINT '34'");
    }

    @Test
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("second(TIME '12:34:56.123456789012')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(this.assertions.expression("EXTRACT(MILLISECOND FROM TIME '12:34:56')")::evaluate).isInstanceOf(ParsingException.class)).hasMessage("line 1:12: Invalid EXTRACT field: MILLISECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234567')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345678')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456789')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.1234567890')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.12345678901')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("millisecond(TIME '12:34:56.123456789012')")))).matches("BIGINT '123'");
    }

    @Test
    public void testUnsupported() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(YEAR FROM TIME '12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(MONTH FROM TIME '12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(DAY FROM TIME '12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_HOUR FROM TIME '12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.1234567890')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.12345678901')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("EXTRACT(TIMEZONE_MINUTE FROM TIME '12:34:56.123456789012')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }
}

