/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.operator.scalar.BitwiseFunctions;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JoniRegexpFunctions;
import io.trino.operator.scalar.JsonFunctions;
import io.trino.operator.scalar.JsonPath;
import io.trino.operator.scalar.MathFunctions;
import io.trino.operator.scalar.StringFunctions;
import io.trino.operator.scalar.timestamp.ExtractDay;
import io.trino.operator.scalar.timestamp.ExtractDayOfWeek;
import io.trino.operator.scalar.timestamp.ExtractDayOfYear;
import io.trino.operator.scalar.timestamp.ExtractHour;
import io.trino.operator.scalar.timestamp.ExtractMinute;
import io.trino.operator.scalar.timestamp.ExtractMonth;
import io.trino.operator.scalar.timestamp.ExtractQuarter;
import io.trino.operator.scalar.timestamp.ExtractSecond;
import io.trino.operator.scalar.timestamp.ExtractWeekOfYear;
import io.trino.operator.scalar.timestamp.ExtractYear;
import io.trino.operator.scalar.timestamp.ExtractYearOfWeek;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.Extract;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.type.JoniRegexp;
import io.trino.type.JsonType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePattern;
import io.trino.type.UnknownType;
import io.trino.util.StructuralTestUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExpressionCompiler {
    private static final Boolean[] booleanValues = new Boolean[]{true, false, null};
    private static final Integer[] smallInts = new Integer[]{9, 10, 11, -9, -10, -11, null};
    private static final Integer[] extremeInts = new Integer[]{101510, Integer.MAX_VALUE};
    private static final Integer[] intLefts = (Integer[])ObjectArrays.concat((Object[])smallInts, (Object[])extremeInts, Integer.class);
    private static final Integer[] intRights = new Integer[]{3, -3, 101510823, null};
    private static final Integer[] intMiddle = new Integer[]{9, -3, 88, null};
    private static final Double[] doubleLefts = new Double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_NORMAL, null};
    private static final Double[] doubleRights = new Double[]{3.0, -3.0, 3.1, -3.1, null};
    private static final Double[] doubleMiddle = new Double[]{9.0, -3.1, 88.0, null};
    private static final String[] stringLefts = new String[]{"hello", "foo", "mellow", "fellow", "", null};
    private static final String[] stringRights = new String[]{"hello", "foo", "bar", "baz", "", null};
    private static final Long[] longLefts = new Long[]{9L, 10L, 11L, -9L, -10L, -11L, null};
    private static final Long[] longRights = new Long[]{3L, -3L, 10151082135029369L, null};
    private static final BigDecimal[] decimalLefts = new BigDecimal[]{new BigDecimal("9.0"), new BigDecimal("10.0"), new BigDecimal("11.0"), new BigDecimal("-9.0"), new BigDecimal("-10.0"), new BigDecimal("-11.0"), new BigDecimal("9.1"), new BigDecimal("10.1"), new BigDecimal("11.1"), new BigDecimal("-9.1"), new BigDecimal("-10.1"), new BigDecimal("-11.1"), new BigDecimal("9223372036.5477"), new BigDecimal("-9223372036.5477"), null};
    private static final BigDecimal[] decimalRights = new BigDecimal[]{new BigDecimal("3.0"), new BigDecimal("-3.0"), new BigDecimal("3.1"), new BigDecimal("-3.1"), null};
    private static final BigDecimal[] decimalMiddle = new BigDecimal[]{new BigDecimal("9.0"), new BigDecimal("-3.1"), new BigDecimal("88.0"), null};
    private QueryAssertions assertions;

    @BeforeAll
    public void setup() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void tearDown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testUnaryOperators() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", "CAST(null AS boolean)")))).isEqualTo(true);
        for (Boolean bl : booleanValues) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(bl))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(bl == null ? null : bl);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT NULL").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl != null);
        }
        for (Comparable<Boolean> comparable : intLefts) {
            Long longValue = comparable == null ? null : Long.valueOf((long)((Integer)comparable).intValue() * 10000000000L);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)IntegerType.INTEGER).isEqualTo(comparable == null ? null : comparable);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("- a").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)IntegerType.INTEGER).isEqualTo(comparable == null ? null : Integer.valueOf(-((Integer)comparable).intValue()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(longValue))))).hasType((Type)BigintType.BIGINT).isEqualTo(comparable == null ? null : longValue);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("- a").binding("a", TestExpressionCompiler.toLiteral(longValue))))).isEqualTo(comparable == null ? null : Long.valueOf(-longValue.longValue()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable != null);
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(comparable == null ? null : comparable);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("- a").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(comparable == null ? null : Double.valueOf(-((Double)comparable).doubleValue()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable != null);
        }
        for (Comparable<Boolean> comparable : decimalLefts) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : TestExpressionCompiler.toSqlDecimal(comparable));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("- a").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : TestExpressionCompiler.toSqlDecimal(((BigDecimal)comparable).negate()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT NULL").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable != null);
        }
        for (String string : stringLefts) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(TestExpressionCompiler.toLiteral(string))))).hasType((Type)TestExpressionCompiler.varcharType(string)).isEqualTo(string == null ? null : string);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NULL").binding("a", TestExpressionCompiler.toLiteral(string))))).isEqualTo(string == null);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS NOT NULL").binding("a", TestExpressionCompiler.toLiteral(string))))).isEqualTo(string != null);
        }
    }

    @Test
    public void testBinaryOperatorsBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("nullif(a, true)").binding("a", "CAST(null AS boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        for (Boolean left : booleanValues) {
            for (Boolean right : booleanValues) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!left.equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("nullif(a, b)").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsIntegralIntegral() {
        for (Integer left : smallInts) {
            for (Integer right : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() == (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() != (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() > (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() < (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() >= (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((long)left.intValue() <= (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left == null || right == null ? null : Integer.valueOf(left + right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left == null || right == null ? null : Integer.valueOf(left - right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left == null || right == null ? null : Integer.valueOf(left * right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left == null || right == null ? null : Integer.valueOf(left / right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left == null || right == null ? null : Integer.valueOf(left % right));
                Long longLeft = left == null ? null : Long.valueOf((long)left.intValue() * 1000000000L);
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(longLeft)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(longLeft == null || right == null ? null : Long.valueOf(longLeft + (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(longLeft)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(longLeft == null || right == null ? null : Long.valueOf(longLeft - (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(longLeft)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(longLeft == null || right == null ? null : Long.valueOf(longLeft * (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(longLeft)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(longLeft == null || right == null ? null : Long.valueOf(longLeft / (long)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(longLeft)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(longLeft == null || right == null ? null : Long.valueOf(longLeft % (long)right.intValue()));
            }
        }
    }

    @Test
    public void testBinaryOperatorsIntegralDouble() {
        for (Integer left : intLefts) {
            for (Double right : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() == right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() != right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() > right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() < right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() >= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf((double)left.intValue() <= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("nullif(a, b)").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left == null ? null : Double.valueOf(left.doubleValue()), right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf((double)left.intValue() + right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf((double)left.intValue() - right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf((double)left.intValue() * right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf((double)left.intValue() / right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf((double)left.intValue() % right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDoubleIntegral() {
        for (Double left : doubleLefts) {
            for (Integer right : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left == (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left != (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left > (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left < (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left >= (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left <= (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).isEqualTo(!Objects.equals(left, right == null ? null : Double.valueOf(right.doubleValue())));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left + (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left - (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left * (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left / (double)right.intValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left % (double)right.intValue()));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDoubleDouble() {
        for (Double left : doubleLefts) {
            for (Double right : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left > right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left < right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left >= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left <= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left + right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left - right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left * right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left / right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left % right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDecimalBigint() {
        for (BigDecimal left : decimalLefts) {
            for (Long right : longRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.equals(new BigDecimal(right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!left.equals(new BigDecimal(right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) > 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) < 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) >= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) <= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).isEqualTo(TestExpressionCompiler.toSqlDecimal((BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right == null ? null : new BigDecimal(right)));
            }
        }
    }

    @Test
    public void testBinaryOperatorsBigintDecimal() {
        for (Long left : longLefts) {
            for (BigDecimal right : decimalRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!new BigDecimal(left).equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) > 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) < 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) >= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) <= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)BigintType.BIGINT).isEqualTo(left);
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left == null ? null : new BigDecimal(left), right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDecimalInteger() {
        for (BigDecimal left : decimalLefts) {
            for (Integer right : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.equals(new BigDecimal(right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!left.equals(new BigDecimal(right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) > 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) < 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) >= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(new BigDecimal(right)) <= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).isEqualTo(TestExpressionCompiler.toSqlDecimal((BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right == null ? null : new BigDecimal(right)));
            }
        }
    }

    @Test
    public void testBinaryOperatorsIntegerDecimal() {
        for (Integer left : intLefts) {
            for (BigDecimal right : decimalRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!new BigDecimal(left).equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) > 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) < 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) >= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(new BigDecimal(left).compareTo(right) <= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)IntegerType.INTEGER).isEqualTo(left);
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left == null ? null : new BigDecimal(left), right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDecimalDouble() {
        for (BigDecimal left : decimalLefts) {
            for (Double right : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() > right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() < right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() >= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() <= right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).isEqualTo(TestExpressionCompiler.toSqlDecimal((BigDecimal)BigDecimal.class.cast(TestExpressionCompiler.nullIf(left, right))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left == null ? null : Double.valueOf(left.doubleValue()), right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left.doubleValue() + right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left.doubleValue() - right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left.doubleValue() * right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left.doubleValue() / right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left.doubleValue() % right));
            }
        }
    }

    @Test
    public void testBinaryOperatorsDoubleDecimal() {
        for (Double left : doubleLefts) {
            for (BigDecimal right : decimalRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() == right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.doubleValue() != right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left > right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left < right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left >= right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left <= right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(TestExpressionCompiler.nullIf(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right == null ? null : Double.valueOf(right.doubleValue())));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a + b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left + right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a - b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left - right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a * b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left * right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a / b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left / right.doubleValue()));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a % b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(left == null || right == null ? null : Double.valueOf(left % right.doubleValue()));
            }
        }
    }

    @Test
    public void testBinaryOperatorsString() {
        for (String left : stringLefts) {
            for (String right : stringRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(!left.equals(right)));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) > 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a < b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) < 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) >= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <= b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(left == null || right == null ? null : Boolean.valueOf(left.compareTo(right) <= 0));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a || b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(left == null || right == null ? null : left + right);
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IS DISTINCT FROM b").binding("a", TestExpressionCompiler.toLiteral(left)).binding("b", TestExpressionCompiler.toLiteral(right))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(!Objects.equals(left, right));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", TestExpressionCompiler.toLiteral(left), TestExpressionCompiler.toLiteral(right))))).hasType((Type)TestExpressionCompiler.varcharType(left)).isEqualTo(TestExpressionCompiler.nullIf(left, right));
            }
        }
    }

    private static VarcharType varcharType(String ... values) {
        return TestExpressionCompiler.varcharType(Arrays.asList(values));
    }

    private static VarcharType varcharType(List<String> values) {
        if (values.stream().anyMatch(Objects::isNull)) {
            return VarcharType.VARCHAR;
        }
        return VarcharType.createVarcharType((int)values.stream().mapToInt(String::length).max().getAsInt());
    }

    private static Object nullIf(Object left, Object right) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return left;
        }
        if (left.equals(right)) {
            return null;
        }
        if ((left instanceof Double || right instanceof Double) && ((Number)left).doubleValue() == ((Number)right).doubleValue()) {
            return null;
        }
        return left;
    }

    @Test
    public void testTernaryOperatorsLongLong() {
        for (Integer first : intLefts) {
            for (Integer second : intLefts) {
                for (Integer third : intRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min <= value, (value, max) -> value <= max));
                }
            }
        }
    }

    @Test
    public void testTernaryOperatorsLongDouble() {
        for (Integer first : intLefts) {
            for (Double second : doubleLefts) {
                for (Integer third : intRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min <= (double)value.intValue(), (value, max) -> value <= max));
                }
            }
        }
    }

    @Test
    public void testTernaryOperatorsDoubleDouble() {
        for (Double first : doubleLefts) {
            for (Double second : doubleLefts) {
                for (Integer third : intRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min <= value, (value, max) -> value <= (double)max.intValue()));
                }
            }
        }
    }

    @Test
    public void testTernaryOperatorsString() {
        for (String first : stringLefts) {
            for (String second : stringLefts) {
                for (String third : stringRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min.compareTo((String)value) <= 0, (value, max) -> value.compareTo((String)max) <= 0));
                }
            }
        }
    }

    @Test
    public void testTernaryOperatorsLongDecimal() {
        for (Long first : longLefts) {
            for (BigDecimal second : decimalMiddle) {
                for (Long third : longRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min.compareTo(new BigDecimal((long)value)) <= 0, (value, max) -> value <= max));
                }
            }
        }
    }

    @Test
    public void testTernaryOperatorsDecimalDouble() {
        for (BigDecimal first : decimalLefts) {
            for (Double second : doubleMiddle) {
                for (BigDecimal third : decimalRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", TestExpressionCompiler.toLiteral(first)).binding("low", TestExpressionCompiler.toLiteral(second)).binding("high", TestExpressionCompiler.toLiteral(third))))).isEqualTo(TestExpressionCompiler.between(first, second, third, (min, value) -> min <= value.doubleValue(), (value, max) -> value.compareTo((BigDecimal)max) <= 0));
                }
            }
        }
    }

    private static <V, L, H> Boolean between(V value, L min, H max, BiPredicate<L, V> greaterThanOrEquals, BiPredicate<V, H> lessThanOrEquals) {
        Boolean lessThanOrEqualToMax;
        if (value == null) {
            return null;
        }
        Boolean greaterOrEqualToMin = min == null ? null : Boolean.valueOf(greaterThanOrEquals.test(min, value));
        Boolean bl = lessThanOrEqualToMax = max == null ? null : Boolean.valueOf(lessThanOrEquals.test(value, max));
        if (greaterOrEqualToMin == null) {
            return Objects.equals(lessThanOrEqualToMax, Boolean.FALSE) ? Boolean.valueOf(false) : null;
        }
        if (lessThanOrEqualToMax == null) {
            return Objects.equals(greaterOrEqualToMin, Boolean.FALSE) ? Boolean.valueOf(false) : null;
        }
        return greaterOrEqualToMin != false && lessThanOrEqualToMax != false;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCast() {
        void var4_15;
        void var4_13;
        void var4_11;
        void var4_9;
        for (Boolean bl : booleanValues) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS boolean)").binding("a", TestExpressionCompiler.toLiteral(bl))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(bl == null ? null : Boolean.valueOf(bl != false));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS integer)").binding("a", TestExpressionCompiler.toLiteral(bl))))).hasType((Type)IntegerType.INTEGER).isEqualTo(bl == null ? null : Integer.valueOf(bl != false ? 1 : 0));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS bigint)").binding("a", TestExpressionCompiler.toLiteral(bl))))).hasType((Type)BigintType.BIGINT).isEqualTo(bl == null ? null : Long.valueOf(bl != false ? 1L : 0L));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS double)").binding("a", TestExpressionCompiler.toLiteral(bl))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(bl == null ? null : Double.valueOf(bl != false ? 1.0 : 0.0));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", TestExpressionCompiler.toLiteral(bl))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(bl == null ? null : (bl != false ? "true" : "false"));
        }
        for (Comparable<Boolean> comparable : intLefts) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS boolean)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(comparable == null ? null : Boolean.valueOf((long)((Integer)comparable).intValue() != 0L));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS integer)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)IntegerType.INTEGER).isEqualTo(comparable == null ? null : comparable);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS bigint)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)BigintType.BIGINT).isEqualTo(comparable == null ? null : Long.valueOf(((Integer)comparable).intValue()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS double)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(comparable == null ? null : Double.valueOf(((Integer)comparable).doubleValue()));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(comparable == null ? null : String.valueOf(comparable));
        }
        DecimalFormat doubleFormat = new DecimalFormat("0.0###################E0");
        Object[] objectArray = doubleLefts;
        int n = objectArray.length;
        boolean bl = false;
        while (var4_9 < n) {
            Double d = objectArray[var4_9];
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS boolean)").binding("a", TestExpressionCompiler.toLiteral(d))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(d == null ? null : Boolean.valueOf(d != 0.0));
            if (d == null || d >= -9.223372036854776E18 && d < 9.223372036854776E18) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS bigint)").binding("a", TestExpressionCompiler.toLiteral(d))))).hasType((Type)BigintType.BIGINT).isEqualTo(d == null ? null : Long.valueOf(d.longValue()));
            }
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS double)").binding("a", TestExpressionCompiler.toLiteral(d))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(d == null ? null : d);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", TestExpressionCompiler.toLiteral(d))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(d == null ? null : doubleFormat.format(d));
            ++var4_9;
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS boolean)").binding("a", "'true'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'true'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'tRuE'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'false'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'fAlSe'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'t'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'T'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'f'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'F'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'1'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS BOOLEAN)").binding("a", "'0'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        objectArray = intLefts;
        n = objectArray.length;
        boolean bl2 = false;
        while (var4_11 < n) {
            Number number = objectArray[var4_11];
            if (number != null) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS integer)").binding("a", TestExpressionCompiler.toLiteral(String.valueOf(number)))))).hasType((Type)IntegerType.INTEGER).isEqualTo(number == null ? (Number)null : (Number)number);
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS bigint)").binding("a", TestExpressionCompiler.toLiteral(String.valueOf(number)))))).hasType((Type)BigintType.BIGINT).isEqualTo(number == null ? null : Long.valueOf(((Integer)number).intValue()));
            }
            ++var4_11;
        }
        objectArray = doubleLefts;
        n = objectArray.length;
        boolean bl3 = false;
        while (var4_13 < n) {
            Number number = objectArray[var4_13];
            if (number != null) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS double)").binding("a", TestExpressionCompiler.toLiteral(String.valueOf(number)))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(number == null ? (Number)null : (Number)number);
            }
            ++var4_13;
        }
        objectArray = stringLefts;
        n = objectArray.length;
        boolean bl4 = false;
        while (var4_15 < n) {
            Object object = objectArray[var4_15];
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", TestExpressionCompiler.toLiteral((String)object))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(object == null ? null : object);
            ++var4_15;
        }
    }

    @Test
    public void testTryCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS integer)").binding("a", "null")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS integer)").binding("a", "'123'")))).hasType((Type)IntegerType.INTEGER).isEqualTo(123);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS bigint)").binding("a", "null")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS bigint)").binding("a", "'123'")))).hasType((Type)BigintType.BIGINT).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS varchar)").binding("a", "'foo'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS bigint)").binding("a", "'foo'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS integer)").binding("a", "'foo'")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS timestamp)").binding("a", "'2001-08-22'")))).hasType((Type)TimestampType.TIMESTAMP_MILLIS).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)3, (int)2001, (int)8, (int)22, (int)0, (int)0, (int)0, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS bigint)").binding("a", "'hello'")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a as bigint)").binding("a", "CAST(null AS varchar)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a / 13 AS bigint)").binding("a", "BIGINT '1234'")))).hasType((Type)BigintType.BIGINT).isEqualTo(94L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "try_CAST('123' as bigint)", "456")))).hasType((Type)BigintType.BIGINT).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "try_CAST('foo' as bigint)", "456")))).hasType((Type)BigintType.BIGINT).isEqualTo(456L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(try_CAST(a AS varchar) as bigint)").binding("a", "123")))).hasType((Type)BigintType.BIGINT).isEqualTo(123L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("try_CAST(a AS varchar) || try_CAST(b as varchar)").binding("a", "'foo'").binding("b", "'bar'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foobar");
    }

    @Test
    public void testAnd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "true").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "true").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "false").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "false").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "true").binding("b", "CAST(null as boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "false").binding("b", "CAST(null as boolean)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "CAST(null as boolean)").binding("b", "true")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "CAST(null as boolean)").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "CAST(null as boolean)").binding("b", "CAST(null as boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "true").binding("b", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "false").binding("b", "null")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "null").binding("b", "true")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "null").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a AND b").binding("a", "null").binding("b", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testOr() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "true").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "true").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "false").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "false").binding("b", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "true").binding("b", "CAST(null as boolean)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "false").binding("b", "CAST(null as boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "CAST(null as boolean)").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "CAST(null as boolean)").binding("b", "false")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "CAST(null as boolean)").binding("b", "CAST(null as boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "true").binding("b", "null")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "false").binding("b", "null")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "null").binding("b", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "null").binding("b", "false")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a OR b").binding("a", "null").binding("b", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testNot() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("NOT a").binding("a", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("NOT a").binding("a", "false")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("NOT a").binding("a", "CAST(null as boolean)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("NOT a").binding("a", "null")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testIf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("if(a AND b, BIGINT '1', 0)").binding("a", "null").binding("b", "true")))).hasType((Type)BigintType.BIGINT).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("if(a AND b, 1, 0)").binding("a", "null").binding("b", "true")))).hasType((Type)IntegerType.INTEGER).isEqualTo(0);
        for (Boolean condition : booleanValues) {
            for (String trueValue : stringLefts) {
                for (String falseValue : stringRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("if(a, b, c)").binding("a", TestExpressionCompiler.toLiteral(condition)).binding("b", TestExpressionCompiler.toLiteral(trueValue)).binding("c", TestExpressionCompiler.toLiteral(falseValue))))).hasType((Type)TestExpressionCompiler.varcharType(trueValue, falseValue)).isEqualTo(condition != null && condition != false ? trueValue : falseValue);
                }
            }
        }
    }

    @Test
    public void testSimpleCase() {
        String expected;
        for (Double d : doubleLefts) {
            for (Double d2 : doubleMiddle) {
                for (Double d3 : doubleRights) {
                    expected = d == null ? "else" : (d2 != null && d.doubleValue() == d2.doubleValue() ? "first" : (d3 != null && d.doubleValue() == d3.doubleValue() ? "second" : "else"));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case a when c1 then 'first' when c2 then 'second' else 'else' end").binding("a", TestExpressionCompiler.toLiteral(d)).binding("c1", TestExpressionCompiler.toLiteral(d2)).binding("c2", TestExpressionCompiler.toLiteral(d3))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        for (Number number : intLefts) {
            for (Number number2 : intMiddle) {
                for (Number number3 : intRights) {
                    expected = number == null ? null : (number2 != null && ((Integer)number2).equals(number) ? "first" : (number3 != null && ((Integer)number3).equals(number) ? "second" : null));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case a when c1 then 'first' when c2 then 'second' end").binding("a", TestExpressionCompiler.toLiteral((Integer)number)).binding("c1", TestExpressionCompiler.toLiteral((Integer)number2)).binding("c2", TestExpressionCompiler.toLiteral((Integer)number3))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        for (Number number : decimalLefts) {
            for (Number number4 : decimalMiddle) {
                for (Number number5 : decimalRights) {
                    expected = number == null ? null : (number4 != null && ((BigDecimal)number4).equals(number) ? "first" : (number5 != null && ((BigDecimal)number5).equals(number) ? "second" : null));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case a when c1 then 'first' when c2 then 'second' end").binding("a", TestExpressionCompiler.toLiteral((BigDecimal)number)).binding("c1", TestExpressionCompiler.toLiteral((BigDecimal)number4)).binding("c2", TestExpressionCompiler.toLiteral((BigDecimal)number5))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE a WHEN b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(1 AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("matched");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE a WHEN b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(2 AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("not_matched");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE a WHEN b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(null AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("not_matched");
    }

    @Test
    public void testSearchCaseSingle() {
        String expected;
        for (Double value : doubleLefts) {
            for (Integer n : intLefts) {
                for (Double d : doubleRights) {
                    expected = value == null ? "else" : (n != null && value == (double)n.intValue() ? "first" : (d != null && value.doubleValue() == d.doubleValue() ? "second" : "else"));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case when v = c1 then 'first' when v = c2 then 'second' else 'else' end").binding("v", TestExpressionCompiler.toLiteral(value)).binding("c1", TestExpressionCompiler.toLiteral(n)).binding("c2", TestExpressionCompiler.toLiteral(d))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        for (Double value : doubleLefts) {
            for (Number number : longLefts) {
                for (Number number2 : decimalRights) {
                    expected = value == null ? "else" : (number != null && value == (double)((Long)number).longValue() ? "first" : (number2 != null && value.doubleValue() == ((BigDecimal)number2).doubleValue() ? "second" : "else"));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case when v = c1 then 'first' when v = c2 then 'second' else 'else' end").binding("v", TestExpressionCompiler.toLiteral(value)).binding("c1", TestExpressionCompiler.toLiteral((Long)number)).binding("c2", TestExpressionCompiler.toLiteral((BigDecimal)number2))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE WHEN a = b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(1 AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("matched");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE WHEN a = b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(2 AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("not_matched");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CASE WHEN a = b THEN 'matched' ELSE 'not_matched' END").binding("a", "ARRAY[CAST(null AS BIGINT)]").binding("b", "ARRAY[CAST(1 AS BIGINT)]")))).hasType((Type)VarcharType.createVarcharType((int)11)).isEqualTo("not_matched");
    }

    @Test
    public void testSearchCaseMultiple() {
        String expected;
        for (Double d : doubleLefts) {
            for (Integer n : intLefts) {
                for (Double secondTest : doubleRights) {
                    expected = d == null ? null : (n != null && d == (double)n.intValue() ? "first" : (secondTest != null && d.doubleValue() == secondTest.doubleValue() ? "second" : null));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case when v = c1 then 'first' when v = c2 then 'second' end").binding("v", TestExpressionCompiler.toLiteral(d)).binding("c1", TestExpressionCompiler.toLiteral(n)).binding("c2", TestExpressionCompiler.toLiteral(secondTest))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
        for (Number number : decimalLefts) {
            for (Number number2 : longLefts) {
                for (Double secondTest : doubleRights) {
                    expected = number == null ? null : (number2 != null && ((BigDecimal)number).doubleValue() == (double)((Long)number2).longValue() ? "first" : (secondTest != null && ((BigDecimal)number).doubleValue() == secondTest.doubleValue() ? "second" : null));
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("case when v = c1 then 'first' when v = c2 then 'second' end").binding("v", TestExpressionCompiler.toLiteral((BigDecimal)number)).binding("c1", TestExpressionCompiler.toLiteral((Long)number2)).binding("c2", TestExpressionCompiler.toLiteral(secondTest))))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo(expected);
                }
            }
        }
    }

    @Test
    public void testIn() {
        Object testValues;
        for (Boolean bl : booleanValues) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (true)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null ? null : Boolean.valueOf(bl == Boolean.TRUE));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, true)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (true, null)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null ? null : (bl == Boolean.TRUE ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (false)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null ? null : Boolean.valueOf(bl == Boolean.FALSE));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, false)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isEqualTo(bl == null ? null : (bl == Boolean.FALSE ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null)").binding("a", TestExpressionCompiler.toLiteral(bl))))).isNull((Type)BooleanType.BOOLEAN);
        }
        for (Comparable<Boolean> comparable : intLefts) {
            testValues = Arrays.asList(33, 9, -9, -33);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33, 9, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 33, 9, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (CAST(null AS BIGINT), 33, 9, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33, null, 9, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33, CAST(null AS BIGINT), 9, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33, 9.0E0, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 33, 9.0E0, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33.0E0, null, 9.0E0, -9, -33)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
        }
        for (Comparable<Boolean> comparable : doubleLefts) {
            testValues = Arrays.asList(33.0, 9.0, -9.0, -33.0);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33.0E0, 9.0E0, -9.0E0, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 33.0E0, 9.0E0, -9.0E0, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33.0E0, null, 9.0E0, -9.0E0, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33.0E0, 9, -9, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 33.0E0, 9, -9, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (33.0E0, null, 9, -9, -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            List<Double> cosines = Arrays.asList(33.0, Math.cos(9.0), Math.cos(-9.0), -33.0);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cos(a) IN (33.0E0, cos(9.0E0), cos(-9.0E0), -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(cosines.contains(Math.cos((Double)comparable))));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cos(a) IN (null, 33.0E0, cos(9.0E0), cos(-9.0E0), -33.0E0)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (cosines.contains(Math.cos((Double)comparable)) ? Boolean.valueOf(true) : null));
        }
        for (Comparable<Boolean> comparable : decimalLefts) {
            testValues = ImmutableList.of((Object)new BigDecimal("9.0"), (Object)new BigDecimal("10.0"), (Object)new BigDecimal("-11.0"), (Object)new BigDecimal("9223372036.5477"));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (9.0, 10.0, -11.0, 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 9.0, 10.0, -11.0, 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (CAST(null AS DECIMAL(1,0)), 9.0, 10.0, -11.0, 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (9.0, CAST(null AS DECIMAL(1,0)), 10.0, -11.0, 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (9.0, null, 10.0, -11.0, 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (9.0, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : Boolean.valueOf(testValues.contains(comparable)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 9.0, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 9, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (CAST(9.0 as DOUBLE), null, 10.0, CAST(-11.0 as DOUBLE), 9223372036.5477)").binding("a", TestExpressionCompiler.toLiteral(comparable))))).isEqualTo(comparable == null ? null : (testValues.contains(comparable) ? Boolean.valueOf(true) : null));
        }
        for (String string : stringLefts) {
            testValues = Arrays.asList("what?", "foo", "mellow", "end");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN ('what?', 'foo', 'mellow', 'end')").binding("a", TestExpressionCompiler.toLiteral(string))))).isEqualTo(string == null ? null : Boolean.valueOf(testValues.contains(string)));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, 'what?', 'foo', 'mellow', 'end')").binding("a", TestExpressionCompiler.toLiteral(string))))).isEqualTo(string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN ('what?', null, 'foo', 'mellow', 'end')").binding("a", TestExpressionCompiler.toLiteral(string))))).isEqualTo(string == null ? null : (testValues.contains(string) ? Boolean.valueOf(true) : null));
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (100, 101, if(rand()>=0, 1), if(rand()<0, 1))").binding("a", "1")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (100, 101, if(rand()<0, 1), if(rand()>=0, 1))").binding("a", "1")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (100, 101, if(rand()>=0, 1), if(rand()<0, 1))").binding("a", "2")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (100, 101, if(rand()<0, 1), if(rand()>=0, 1))").binding("a", "2")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testHugeIn() {
        String intValues = IntStream.range(2000, 7000).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (1234, " + intValues + ")").binding("a", "1234")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + intValues + ")").binding("a", "1234")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String longValues = LongStream.range(0x80000000L, 2147488647L).mapToObj(Long::toString).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (1234, " + longValues + ")").binding("a", "BIGINT '1234'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + longValues + ")").binding("a", "BIGINT '1234'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String doubleValues = IntStream.range(2000, 7000).asDoubleStream().mapToObj(TestExpressionCompiler::formatDoubleToScientificNotation).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (12.34E0, " + doubleValues + ")").binding("a", "12.34E0")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + doubleValues + ")").binding("a", "12.34E0")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String stringValues = IntStream.range(2000, 7000).mapToObj(i -> String.format("'%s'", i)).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN ('hello', " + stringValues + ")").binding("a", "'hello'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + stringValues + ")").binding("a", "'hello'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String timestampValues = IntStream.range(0, 2000).mapToObj(i -> String.format("TIMESTAMP '1970-01-01 01:01:0%s.%s+01:00'", i / 1000, i % 1000)).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + timestampValues + ")").binding("a", "TIMESTAMP '1970-01-01 00:01:00.999 UTC'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (TIMESTAMP '1970-01-01 01:01:00.0+02:00')").binding("a", "TIMESTAMP '1970-01-01 00:01:00.999'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String shortDecimalValues = IntStream.range(2000, 7000).mapToObj(value -> String.format("decimal '%s'", value)).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (1234, " + shortDecimalValues + ")").binding("a", "CAST(1234 AS decimal(14))")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + shortDecimalValues + ")").binding("a", "CAST(1234 AS decimal(14))")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        String longDecimalValues = IntStream.range(2000, 7000).mapToObj(value -> String.format("decimal '123456789012345678901234567890%s'", value)).collect(Collectors.joining(", "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (1234, " + longDecimalValues + ")").binding("a", "CAST(1234 AS decimal(28))")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (" + longDecimalValues + ")").binding("a", "CAST(1234 AS decimal(28))")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
    }

    @Test
    public void testInComplexTypes() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[1])").binding("a", "ARRAY[1]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[2])").binding("a", "ARRAY[1]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[2], ARRAY[1])").binding("a", "ARRAY[1]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null)").binding("a", "ARRAY[1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, ARRAY[1])").binding("a", "ARRAY[1]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[2, null], ARRAY[1, null])").binding("a", "ARRAY[1, 2, null]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[2, null], null)").binding("a", "ARRAY[1, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[null])").binding("a", "ARRAY[null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[null])").binding("a", "ARRAY[1]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[1])").binding("a", "ARRAY[null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[1, null])").binding("a", "ARRAY[1, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[2, null])").binding("a", "ARRAY[1, null]")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[1, null], ARRAY[2, null])").binding("a", "ARRAY[1, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ARRAY[1, null], ARRAY[2, null], ARRAY[1, null])").binding("a", "ARRAY[1, null]")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(1))").binding("a", "ROW(1)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(2))").binding("a", "ROW(1)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(2), ROW(1), ROW(2))").binding("a", "ROW(1)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null)").binding("a", "ROW(1)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, ROW(1))").binding("a", "ROW(1)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(2, null), null)").binding("a", "ROW(1, null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(null))").binding("a", "ROW(null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(null))").binding("a", "ROW(1)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(1))").binding("a", "ROW(null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(1, null))").binding("a", "ROW(1, null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(2, null))").binding("a", "ROW(1, null)")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(1, null), ROW(2, null))").binding("a", "ROW(1, null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (ROW(1, null), ROW(2, null), ROW(1, null))").binding("a", "ROW(1, null)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1], ARRAY[1]))").binding("a", "MAP(ARRAY[1], ARRAY[1])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null)").binding("a", "MAP(ARRAY[1], ARRAY[1])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (null, MAP(ARRAY[1], ARRAY[1]))").binding("a", "MAP(ARRAY[1], ARRAY[1])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1], ARRAY[1])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[2, null]), null)").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 3], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1], ARRAY[null]))").binding("a", "MAP(ARRAY[1], ARRAY[null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1], ARRAY[null]))").binding("a", "MAP(ARRAY[1], ARRAY[1])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1], ARRAY[1]))").binding("a", "MAP(ARRAY[1], ARRAY[null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 3], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[2, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a IN (MAP(ARRAY[1, 2], ARRAY[1, null]), MAP(ARRAY[1, 2], ARRAY[2, null]), MAP(ARRAY[1, 2], ARRAY[1, null]))").binding("a", "MAP(ARRAY[1, 2], ARRAY[1, null])")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testFunctionCall() {
        for (Integer n : intLefts) {
            for (Integer n2 : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("bitwise_and", TestExpressionCompiler.toLiteral(n), TestExpressionCompiler.toLiteral(n2))))).hasType((Type)BigintType.BIGINT).isEqualTo(n == null || n2 == null ? null : Long.valueOf(BitwiseFunctions.bitwiseAnd((long)n.intValue(), (long)n2.intValue())));
            }
        }
        for (Integer n : intLefts) {
            for (Number number : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", TestExpressionCompiler.toLiteral(n), TestExpressionCompiler.toLiteral((Double)number))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(n == null || number == null ? null : Double.valueOf(MathFunctions.mod((double)n.intValue(), (double)((Double)number))));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number2 : intRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", TestExpressionCompiler.toLiteral((Double)number), TestExpressionCompiler.toLiteral((Integer)number2))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(number == null || number2 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((Integer)number2).intValue())));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number3 : doubleRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", TestExpressionCompiler.toLiteral((Double)number), TestExpressionCompiler.toLiteral((Double)number3))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(number == null || number3 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((Double)number3))));
            }
        }
        for (Number number : doubleLefts) {
            for (Number number4 : decimalRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("mod", TestExpressionCompiler.toLiteral((Double)number), TestExpressionCompiler.toLiteral((BigDecimal)number4))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(number == null || number4 == null ? null : Double.valueOf(MathFunctions.mod((double)((Double)number), (double)((BigDecimal)number4).doubleValue())));
            }
        }
        for (Number number : decimalLefts) {
            for (Number number5 : longRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("power", TestExpressionCompiler.toLiteral((BigDecimal)number), TestExpressionCompiler.toLiteral((Long)number5))))).hasType((Type)DoubleType.DOUBLE).isEqualTo(number == null || number5 == null ? null : Double.valueOf(MathFunctions.power((double)((BigDecimal)number).doubleValue(), (double)((Long)number5).longValue())));
            }
        }
        for (String string : stringLefts) {
            for (Number number : intLefts) {
                for (Integer length : intRights) {
                    ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("substr", TestExpressionCompiler.toLiteral(string), TestExpressionCompiler.toLiteral((Integer)number), TestExpressionCompiler.toLiteral(length))))).hasType((Type)(string != null ? VarcharType.createVarcharType((int)string.length()) : VarcharType.VARCHAR)).isEqualTo(string == null || number == null || length == null ? null : TestExpressionCompiler.toString(StringFunctions.substring((Slice)Slices.utf8Slice((String)string), (long)((Integer)number).intValue(), (long)length.intValue())));
                }
            }
        }
    }

    @Test
    public void testFunctionCallRegexp() {
        for (String value : stringLefts) {
            for (String pattern : stringRights) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_like", TestExpressionCompiler.toLiteral(value), TestExpressionCompiler.toLiteral(pattern))))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(value == null || pattern == null ? null : Boolean.valueOf(JoniRegexpFunctions.regexpLike((Slice)Slices.utf8Slice((String)value), (JoniRegexp)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern)))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_replace", TestExpressionCompiler.toLiteral(value), TestExpressionCompiler.toLiteral(pattern))))).hasType((Type)(value == null ? VarcharType.VARCHAR : VarcharType.createVarcharType((int)value.length()))).isEqualTo(value == null || pattern == null ? null : JoniRegexpFunctions.regexpReplace((Slice)Slices.utf8Slice((String)value), (JoniRegexp)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern))).toStringUtf8());
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("regexp_extract", TestExpressionCompiler.toLiteral(value), TestExpressionCompiler.toLiteral(pattern))))).hasType((Type)(value == null ? VarcharType.VARCHAR : VarcharType.createVarcharType((int)value.length()))).isEqualTo(value == null || pattern == null ? null : TestExpressionCompiler.toString(JoniRegexpFunctions.regexpExtract((Slice)Slices.utf8Slice((String)value), (JoniRegexp)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)pattern)))));
            }
        }
    }

    @Test
    public void testFunctionCallJson() {
        String[] jsonValues = new String[]{"{}", "{\"fuu\": {\"bar\": 1}}", "{\"fuu\": null}", "{\"fuu\": 1}", "{\"fuu\": 1, \"bar\": \"abc\"}", null};
        String[] jsonPatterns = new String[]{"$", "$.fuu", "$.fuu[0]", "$.bar", null};
        for (String value : jsonValues) {
            for (String pattern : jsonPatterns) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_extract", TestExpressionCompiler.toLiteral(value), TestExpressionCompiler.toLiteral(pattern))))).hasType((Type)JsonType.JSON).isEqualTo(value == null || pattern == null ? null : TestExpressionCompiler.toString(JsonFunctions.jsonExtract((Slice)Slices.utf8Slice((String)value), (JsonPath)new JsonPath(pattern))));
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_extract_scalar", TestExpressionCompiler.toLiteral(value), TestExpressionCompiler.toLiteral(pattern))))).hasType((Type)(value == null ? VarcharType.createUnboundedVarcharType() : VarcharType.createVarcharType((int)value.length()))).isEqualTo(value == null || pattern == null ? null : TestExpressionCompiler.toString(JsonFunctions.jsonExtractScalar((Slice)Slices.utf8Slice((String)value), (JsonPath)new JsonPath(pattern))));
            }
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, 2, 3]'", "2")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[1, 2, 3]'", "BIGINT '2'")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[2.5E0]'", "2.5E0")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[false, true]'", "true")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'[5]'", "3")))).hasType((Type)BooleanType.BOOLEAN).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_contains", "'['", "9")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("json_array_length", "'['")))).isNull((Type)BigintType.BIGINT);
    }

    @Test
    public void testFunctionWithSessionCall() {
        Session session = this.assertions.getDefaultSession();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("now()")))).hasType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).isEqualTo(SqlTimestampWithTimeZone.fromInstant((int)3, (Instant)session.getStart(), (ZoneId)session.getTimeZoneKey().getZoneId()));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("current_timestamp")))).hasType((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).isEqualTo(SqlTimestampWithTimeZone.fromInstant((int)3, (Instant)session.getStart(), (ZoneId)session.getTimeZoneKey().getZoneId()));
    }

    @Test
    public void testExtract() {
        DateTime[] dateTimeValues;
        for (DateTime left : dateTimeValues = new DateTime[]{new DateTime(2001, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1960, 1, 22, 3, 4, 5, 321, DateTimeZone.UTC), new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC), null}) {
            for (Extract.Field field : Extract.Field.values()) {
                Long expected;
                Long micros;
                if (field == Extract.Field.TIMEZONE_MINUTE || field == Extract.Field.TIMEZONE_HOUR) continue;
                if (left != null) {
                    micros = left.getMillis() * 1000L;
                    expected = TestExpressionCompiler.callExtractFunction(micros, field);
                } else {
                    micros = null;
                    expected = null;
                }
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("extract(%s from from_unixtime(CAST(a as double) / 1000000, 'UTC'))".formatted(field)).binding("a", TestExpressionCompiler.toLiteral(micros))))).isEqualTo(expected);
            }
        }
    }

    private static long callExtractFunction(long value, Extract.Field field) {
        return switch (field) {
            default -> throw new MatchException(null, null);
            case Extract.Field.YEAR -> ExtractYear.extract((long)value);
            case Extract.Field.QUARTER -> ExtractQuarter.extract((long)value);
            case Extract.Field.MONTH -> ExtractMonth.extract((long)value);
            case Extract.Field.WEEK -> ExtractWeekOfYear.extract((long)value);
            case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> ExtractDay.extract((long)value);
            case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> ExtractDayOfWeek.extract((long)value);
            case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> ExtractYearOfWeek.extract((long)value);
            case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> ExtractDayOfYear.extract((long)value);
            case Extract.Field.HOUR -> ExtractHour.extract((long)value);
            case Extract.Field.MINUTE -> ExtractMinute.extract((long)value);
            case Extract.Field.SECOND -> ExtractSecond.extract((long)value);
            case Extract.Field.TIMEZONE_MINUTE, Extract.Field.TIMEZONE_HOUR -> throw new AssertionError((Object)("Unhandled field: " + String.valueOf(field)));
        };
    }

    @Test
    public void testLike() {
        for (String value : stringLefts) {
            for (String pattern : stringLefts) {
                ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE b").binding("a", TestExpressionCompiler.toLiteral(value)).binding("b", TestExpressionCompiler.toLiteral(pattern))))).isEqualTo(value == null || pattern == null ? null : Boolean.valueOf(LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)value), (LikePattern)LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern), (Slice)Slices.utf8Slice((String)"\\")))));
            }
        }
    }

    @Test
    public void testCoalesce() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9", "1")))).hasType((Type)IntegerType.INTEGER).isEqualTo(9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9", "null")))).hasType((Type)IntegerType.INTEGER).isEqualTo(9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9", "BIGINT '1'")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "BIGINT '9'", "null")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9", "CAST(null as bigint)")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9", "1")))).hasType((Type)IntegerType.INTEGER).isEqualTo(9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9", "null")))).hasType((Type)IntegerType.INTEGER).isEqualTo(9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9", "BIGINT '1'")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9", "CAST (null AS BIGINT)")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9", "CAST(null as bigint)")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9", "1")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9", "null")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9", "CAST(null as bigint)")))).hasType((Type)BigintType.BIGINT).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9.0E0", "1.0E0")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9.0E0", "1")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9.0E0", "null")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "9.0E0", "CAST(null as double)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9.0E0", "1")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9.0E0", "null")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9.0E0", "CAST(null as double)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "9.0E0", "CAST(null as bigint)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9.0E0", "1")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9.0E0", "null")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "9.0E0", "CAST(null as bigint)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as double)", "9.0E0", "CAST(null as double)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(9.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "'foo'", "'banana'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "'foo'", "null")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "'foo'", "CAST(null as varchar)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "'foo'", "'banana'")))).hasType((Type)VarcharType.createVarcharType((int)6)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "'foo'", "null")))).hasType((Type)VarcharType.createVarcharType((int)3)).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "null", "'foo'", "CAST(null as varchar)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as varchar)", "'foo'", "'bar'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as varchar)", "'foo'", "null")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as varchar)", "'foo'", "CAST(null as varchar)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("foo");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "CAST(null as bigint)", "null", "CAST(null as bigint)")))).isNull((Type)BigintType.BIGINT);
    }

    @Test
    public void testNullif() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "NULL", "NULL")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "NULL", "2")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "2", "NULL")))).hasType((Type)IntegerType.INTEGER).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "BIGINT '2'", "NULL")))).hasType((Type)BigintType.BIGINT).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "ARRAY[CAST(1 AS BIGINT)]", "ARRAY[CAST(1 AS BIGINT)]")))).isNull((Type)new ArrayType((Type)BigintType.BIGINT));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "ARRAY[CAST(1 AS BIGINT)]", "ARRAY[CAST(NULL AS BIGINT)]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(ImmutableList.of((Object)1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "ARRAY[CAST(NULL AS BIGINT)]", "ARRAY[CAST(NULL AS BIGINT)]")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Collections.singletonList(null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "map(array[1], array[smallint '1'])", "map(array[1], array[integer '1'])")))).isNull((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)SmallintType.SMALLINT));
    }

    private static String formatDoubleToScientificNotation(Double value) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        formatter.applyPattern("0.##############E0");
        return formatter.format(value);
    }

    private static SqlDecimal toSqlDecimal(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        return new SqlDecimal(decimal.unscaledValue(), decimal.precision(), decimal.scale());
    }

    private static Type getDecimalType(BigDecimal decimal) {
        if (decimal == null) {
            return DecimalType.createDecimalType((int)1, (int)0);
        }
        return DecimalType.createDecimalType((int)decimal.precision(), (int)decimal.scale());
    }

    private static String toLiteral(Boolean value) {
        return TestExpressionCompiler.toLiteral(value, (Type)BooleanType.BOOLEAN);
    }

    private static String toLiteral(Long value) {
        return TestExpressionCompiler.toLiteral(value, (Type)BigintType.BIGINT);
    }

    private static String toLiteral(BigDecimal value) {
        return TestExpressionCompiler.toLiteral(value, TestExpressionCompiler.getDecimalType(value));
    }

    private static String toLiteral(Double value) {
        return TestExpressionCompiler.toLiteral(value, (Type)DoubleType.DOUBLE);
    }

    private static String toLiteral(String value) {
        return TestExpressionCompiler.toLiteral(value, (Type)VarcharType.VARCHAR);
    }

    private static String toLiteral(Integer value) {
        return TestExpressionCompiler.toLiteral(value, (Type)IntegerType.INTEGER);
    }

    private static String toLiteral(Object value, Type type) {
        if (value == null) {
            value = "CAST(null AS %s)".formatted(type);
        } else if (type.equals((Object)VarcharType.VARCHAR)) {
            value = "'%s'".formatted(value);
        } else if (type.equals((Object)BigintType.BIGINT)) {
            value = "BIGINT '%s'".formatted(value);
        } else if (type.equals((Object)DoubleType.DOUBLE)) {
            value = "DOUBLE '%s'".formatted(value);
        }
        return String.valueOf(value);
    }

    private static String toString(Slice value) {
        return value == null ? null : value.toStringUtf8();
    }
}

