/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.operator.scalar.JsonFunctions;
import io.trino.operator.scalar.Re2JCastToRegexpFunction;
import io.trino.operator.scalar.StringFunctions;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatter;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.CodePointsType;
import io.trino.type.JoniRegexpType;
import io.trino.type.JsonPathType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePatternType;
import io.trino.type.Re2JRegexp;
import io.trino.type.Re2JRegexpType;
import io.trino.type.UnknownType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLiteralEncoder {
    private final LiteralEncoder encoder = new LiteralEncoder(TestingPlannerContext.PLANNER_CONTEXT);
    private final ResolvedFunction literalFunction = new ResolvedFunction(new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"$literal$"), (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)VarbinaryType.VARBINARY)), GlobalSystemConnector.CATALOG_HANDLE, new LiteralFunction(TestingPlannerContext.PLANNER_CONTEXT.getBlockEncodingSerde()).getFunctionMetadata().getFunctionId(), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of((Object)false)), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());
    private final ResolvedFunction base64Function = new ResolvedFunction(new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"from_base64"), (Type)VarbinaryType.VARBINARY, (List)ImmutableList.of((Object)VarcharType.VARCHAR)), GlobalSystemConnector.CATALOG_HANDLE, FunctionId.toFunctionId((String)"from_base64", (Signature)Signature.builder().returnType((Type)VarbinaryType.VARBINARY).argumentType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build()), FunctionKind.SCALAR, true, new FunctionNullability(false, (List)ImmutableList.of((Object)false)), (Map)ImmutableMap.of(), (Set)ImmutableSet.of());

    @Test
    public void testEncodeUnknown() {
        this.assertEncode(null, (Type)UnknownType.UNKNOWN, "null");
    }

    @Test
    public void testEncodeBigint() {
        this.assertEncode(null, (Type)BigintType.BIGINT, "CAST(null AS bigint)");
        this.assertEncode(123L, (Type)BigintType.BIGINT, "BIGINT '123'");
    }

    @Test
    public void testEncodeDecimal() {
        this.assertEncode(123L, (Type)DecimalType.createDecimalType((int)7, (int)1), "CAST(DECIMAL '12.3' AS decimal(7, 1))");
    }

    @Test
    public void testEncodeChar() {
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)CharType.createCharType((int)5), "CAST('hello' AS char(5))");
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)CharType.createCharType((int)13), "CAST('hello' AS char(13))");
    }

    @Test
    public void testEncodeVarchar() {
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.createVarcharType((int)5), "'hello'");
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.createVarcharType((int)13), "CAST('hello' AS varchar(13))");
        this.assertEncode(Slices.utf8Slice((String)"hello"), (Type)VarcharType.VARCHAR, "VARCHAR 'hello'");
    }

    @Test
    public void testEncodeVarbinary() {
        this.assertEncodeCaseInsensitively(Slices.utf8Slice((String)"hello"), (Type)VarbinaryType.VARBINARY, this.literalVarbinary("hello".getBytes(StandardCharsets.UTF_8)));
        this.assertEncodeCaseInsensitively(Slices.utf8Slice((String)"hello"), (Type)VarbinaryType.VARBINARY, this.literalVarbinary("hello".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testEncodeTimestamp() {
        for (int precision = 0; precision <= 12; ++precision) {
            this.assertEncode(null, (Type)TimestampType.createTimestampType((int)precision), String.format("CAST(null AS timestamp(%s))", precision));
        }
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)0), "TIMESTAMP '2020-10-26 11:02:18'");
        this.assertEncode(1603710138100000L, (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '2020-10-26 11:02:18.1'");
        this.assertEncode(1603710138120000L, (Type)TimestampType.createTimestampType((int)2), "TIMESTAMP '2020-10-26 11:02:18.12'");
        this.assertEncode(1603710138123000L, (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2020-10-26 11:02:18.123'");
        this.assertEncode(1603710138123400L, (Type)TimestampType.createTimestampType((int)4), "TIMESTAMP '2020-10-26 11:02:18.1234'");
        this.assertEncode(1603710138123450L, (Type)TimestampType.createTimestampType((int)5), "TIMESTAMP '2020-10-26 11:02:18.12345'");
        this.assertEncode(1603710138123456L, (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2020-10-26 11:02:18.123456'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 100000), (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-10-26 11:02:18.1234561'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 120000), (Type)TimestampType.createTimestampType((int)8), "TIMESTAMP '2020-10-26 11:02:18.12345612'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 123000), (Type)TimestampType.createTimestampType((int)9), "TIMESTAMP '2020-10-26 11:02:18.123456123'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 123400), (Type)TimestampType.createTimestampType((int)10), "TIMESTAMP '2020-10-26 11:02:18.1234561234'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 123450), (Type)TimestampType.createTimestampType((int)11), "TIMESTAMP '2020-10-26 11:02:18.12345612345'");
        this.assertEncode(new LongTimestamp(1603710138123456L, 123456), (Type)TimestampType.createTimestampType((int)12), "TIMESTAMP '2020-10-26 11:02:18.123456123456'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '2020-10-26 11:02:18.0'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)2), "TIMESTAMP '2020-10-26 11:02:18.00'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2020-10-26 11:02:18.000'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)4), "TIMESTAMP '2020-10-26 11:02:18.0000'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)5), "TIMESTAMP '2020-10-26 11:02:18.00000'");
        this.assertEncode(1603710138000000L, (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '2020-10-26 11:02:18.000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)7), "TIMESTAMP '2020-10-26 11:02:18.0000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)8), "TIMESTAMP '2020-10-26 11:02:18.00000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)9), "TIMESTAMP '2020-10-26 11:02:18.000000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)10), "TIMESTAMP '2020-10-26 11:02:18.0000000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)11), "TIMESTAMP '2020-10-26 11:02:18.00000000000'");
        this.assertEncode(new LongTimestamp(1603710138000000L, 0), (Type)TimestampType.createTimestampType((int)12), "TIMESTAMP '2020-10-26 11:02:18.000000000000'");
    }

    @Test
    public void testEncodeTimestampWithTimeZone() {
        for (int precision = 0; precision <= 12; ++precision) {
            this.assertEncode(null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), String.format("CAST(null AS timestamp(%s) with time zone)", precision));
        }
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), "TIMESTAMP '2020-10-26 11:02:18 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138100L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1), "TIMESTAMP '2020-10-26 11:02:18.1 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138120L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2), "TIMESTAMP '2020-10-26 11:02:18.12 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138123L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "TIMESTAMP '2020-10-26 11:02:18.123 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)100000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4), "TIMESTAMP '2020-10-26 11:02:18.1231 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)120000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5), "TIMESTAMP '2020-10-26 11:02:18.12312 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123000000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "TIMESTAMP '2020-10-26 11:02:18.123123 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123400000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7), "TIMESTAMP '2020-10-26 11:02:18.1231234 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123450000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8), "TIMESTAMP '2020-10-26 11:02:18.12312345 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456000, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "TIMESTAMP '2020-10-26 11:02:18.123123456 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456700, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10), "TIMESTAMP '2020-10-26 11:02:18.1231234567 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456780, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11), "TIMESTAMP '2020-10-26 11:02:18.12312345678 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456789, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "TIMESTAMP '2020-10-26 11:02:18.123123456789 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1), "TIMESTAMP '2020-10-26 11:02:18.0 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2), "TIMESTAMP '2020-10-26 11:02:18.00 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "TIMESTAMP '2020-10-26 11:02:18.000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4), "TIMESTAMP '2020-10-26 11:02:18.0000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5), "TIMESTAMP '2020-10-26 11:02:18.00000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "TIMESTAMP '2020-10-26 11:02:18.000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7), "TIMESTAMP '2020-10-26 11:02:18.0000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8), "TIMESTAMP '2020-10-26 11:02:18.00000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "TIMESTAMP '2020-10-26 11:02:18.000000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10), "TIMESTAMP '2020-10-26 11:02:18.0000000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11), "TIMESTAMP '2020-10-26 11:02:18.00000000000 UTC'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138000L, (int)0, (TimeZoneKey)TimeZoneKey.UTC_KEY), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "TIMESTAMP '2020-10-26 11:02:18.000000000000 UTC'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), "TIMESTAMP '2020-10-26 12:02:18 Europe/Warsaw'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1603710138123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "TIMESTAMP '2020-10-26 12:02:18.123 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "TIMESTAMP '2020-10-26 12:02:18.123123 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "TIMESTAMP '2020-10-26 12:02:18.123123456 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603710138123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "TIMESTAMP '2020-10-26 12:02:18.123123456789 Europe/Warsaw'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1585445478000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), "TIMESTAMP '2020-03-29 03:31:18 Europe/Warsaw'");
        this.assertEncode(DateTimeEncoding.packDateTimeWithZone((long)1585445478123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "TIMESTAMP '2020-03-29 03:31:18.123 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "TIMESTAMP '2020-03-29 03:31:18.123123 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "TIMESTAMP '2020-03-29 03:31:18.123123456 Europe/Warsaw'");
        this.assertEncode(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1585445478123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "TIMESTAMP '2020-03-29 03:31:18.123123456789 Europe/Warsaw'");
        this.assertRoundTrip(DateTimeEncoding.packDateTimeWithZone((long)1603589478000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0), Long::equals);
        this.assertRoundTrip(DateTimeEncoding.packDateTimeWithZone((long)1603589478123L, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), Long::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123000000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), LongTimestampWithTimeZone::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123456000, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), LongTimestampWithTimeZone::equals);
        this.assertRoundTrip(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)1603589478123L, (int)123456789, (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw")), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), LongTimestampWithTimeZone::equals);
    }

    @Test
    public void testEncodeRegex() {
        this.assertRoundTrip(JoniRegexpCasts.castVarcharToJoniRegexp((Slice)Slices.utf8Slice((String)"[a-z]")), (Type)JoniRegexpType.JONI_REGEXP, (left, right) -> left.pattern().equals((Object)right.pattern()));
        this.assertRoundTrip(TestLiteralEncoder.castVarcharToRe2JRegexp(Slices.utf8Slice((String)"[a-z]")), TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(Re2JRegexpType.RE2J_REGEXP_SIGNATURE), (left, right) -> left.pattern().equals(right.pattern()));
    }

    @Test
    public void testEncodeLikePattern() {
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc_")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc%")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
        this.assertRoundTrip(LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"a_b%cX%X_"), (Slice)Slices.utf8Slice((String)"/")), (Type)LikePatternType.LIKE_PATTERN, (left, right) -> left.getPattern().equals(right.getPattern()));
    }

    @Test
    public void testEncodeJsonPath() {
        this.assertRoundTrip(JsonFunctions.castVarcharToJsonPath((Slice)Slices.utf8Slice((String)"$.foo")), (Type)JsonPathType.JSON_PATH, (left, right) -> left.pattern().equals(right.pattern()));
    }

    @Test
    public void testEncodeCodePoints() {
        this.assertRoundTrip(StringFunctions.castVarcharToCodePoints((Slice)Slices.utf8Slice((String)"hello")), (Type)CodePointsType.CODE_POINTS, Arrays::equals);
    }

    private void assertEncode(Object value, Type type, String expected) {
        Expression expression = this.encoder.toExpression(value, type);
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Assertions.assertThat((Object)this.getExpressionValue(expression)).isEqualTo(value);
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)expression)).isEqualTo(expected);
    }

    @Deprecated
    private void assertEncodeCaseInsensitively(Object value, Type type, String expected) {
        Expression expression = this.encoder.toExpression(value, type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ExpressionUtils.isEffectivelyLiteral((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression)).describedAs("isEffectivelyLiteral returned false for: " + String.valueOf(expression), new Object[0])).isTrue();
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Assertions.assertThat((Object)this.getExpressionValue(expression)).isEqualTo(value);
        io.airlift.testing.Assertions.assertEqualsIgnoreCase((String)SqlFormatter.formatSql((Node)expression), (String)expected);
    }

    private <T> void assertRoundTrip(T value, Type type, BiPredicate<T, T> predicate) {
        Expression expression = this.encoder.toExpression(value, type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)ExpressionUtils.isEffectivelyLiteral((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)SessionTestUtils.TEST_SESSION, (Expression)expression)).describedAs("isEffectivelyLiteral returned false for: " + String.valueOf(expression), new Object[0])).isTrue();
        Assertions.assertThat((Object)this.getExpressionType(expression)).isEqualTo((Object)type);
        Object decodedValue = this.getExpressionValue(expression);
        Assertions.assertThat((boolean)predicate.test(value, decodedValue)).isTrue();
    }

    private Object getExpressionValue(Expression expression) {
        return new ExpressionInterpreter(expression, TestingPlannerContext.PLANNER_CONTEXT, SessionTestUtils.TEST_SESSION, this.getExpressionTypes(expression)).evaluate();
    }

    private Type getExpressionType(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression);
        Type expressionType = expressionTypes.get(NodeRef.of((Node)expression));
        Verify.verify((expressionType != null ? 1 : 0) != 0, (String)"No type found", (Object[])new Object[0]);
        return expressionType;
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (Map)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> ExpressionUtils.getExpressionTypes((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (Session)transactionSession, (Expression)expression, (TypeProvider)TypeProvider.empty()));
    }

    private String literalVarbinary(byte[] value) {
        return "%s(%s('%s'))".formatted(TestLiteralEncoder.serializeResolvedFunction(this.literalFunction), TestLiteralEncoder.serializeResolvedFunction(this.base64Function), Base64.getEncoder().encodeToString(value));
    }

    private static String serializeResolvedFunction(ResolvedFunction function) {
        CatalogSchemaFunctionName name = function.toCatalogSchemaFunctionName();
        return "%s.\"%s\".\"%s\"".formatted(name.getCatalogName(), name.getSchemaName(), name.getFunctionName());
    }

    private static Re2JRegexp castVarcharToRe2JRegexp(Slice value) {
        return Re2JCastToRegexpFunction.castToRegexp((int)Integer.MAX_VALUE, (int)5, (boolean)false, (long)Integer.MAX_VALUE, (Slice)value);
    }
}

