/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.tree.FunctionCall;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableScanNodePartitioning
extends BasePlanTest {
    public static final String TEST_SCHEMA = "test_schema";
    public static final Session ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").setSystemProperty("use_table_scan_node_partitioning", "true").setSystemProperty("task_concurrency", "2").build();
    public static final Session DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").setSystemProperty("use_table_scan_node_partitioning", "false").setSystemProperty("task_concurrency", "2").build();
    public static final int BUCKET_COUNT = 10;
    public static final String PARTITIONED_TABLE = "partitioned_table";
    public static final String SINGLE_BUCKET_TABLE = "single_bucket_table";
    public static final String FIXED_PARTITIONED_TABLE = "fixed_partitioned_table";
    public static final String UNPARTITIONED_TABLE = "unpartitioned_table";
    public static final ConnectorPartitioningHandle PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    public static final ConnectorPartitioningHandle SINGLE_BUCKET_HANDLE = new ConnectorPartitioningHandle(){};
    public static final ConnectorPartitioningHandle FIXED_PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    public static final String COLUMN_A = "column_a";
    public static final String COLUMN_B = "column_b";
    public static final ColumnHandle COLUMN_HANDLE_A = new MockConnectorColumnHandle("column_a", (Type)BigintType.BIGINT);
    public static final ColumnHandle COLUMN_HANDLE_B = new MockConnectorColumnHandle("column_b", (Type)VarcharType.VARCHAR);

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema(TEST_SCHEMA).setSystemProperty("task_concurrency", "2");
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)sessionBuilder.build()).withNodeCountForStats(10).build();
        queryRunner.createCatalog("test_catalog", (ConnectorFactory)TestTableScanNodePartitioning.createMockFactory(), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testEnablePlanWithTableNodePartitioning() {
        this.assertTableScanPlannedWithPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, PARTITIONED_TABLE, PARTITIONING_HANDLE);
    }

    @Test
    public void testDisablePlanWithTableNodePartitioning() {
        this.assertTableScanPlannedWithoutPartitioning(DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, PARTITIONED_TABLE);
    }

    @Test
    public void testTableScanWithoutConnectorPartitioning() {
        this.assertTableScanPlannedWithoutPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, UNPARTITIONED_TABLE);
    }

    @Test
    public void testTableScanWithFixedConnectorPartitioning() {
        this.assertTableScanPlannedWithPartitioning(DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, FIXED_PARTITIONED_TABLE, FIXED_PARTITIONING_HANDLE);
    }

    @Test
    public void testTableScanWithInsufficientBucketToTaskRatio() {
        this.assertTableScanPlannedWithoutPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, SINGLE_BUCKET_TABLE);
    }

    void assertTableScanPlannedWithPartitioning(Session session, String table, ConnectorPartitioningHandle expectedPartitioning) {
        String query = "SELECT count(column_b) FROM " + table + " GROUP BY column_a";
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"COUNT_PART"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT_PART", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"B"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan(table, (Map<String, String>)ImmutableMap.of((Object)"A", (Object)COLUMN_A, (Object)"B", (Object)COLUMN_B)))))));
        SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
        Assertions.assertThat((List)subPlan.getAllFragments()).hasSize(1);
        Assertions.assertThat((Object)((PlanFragment)subPlan.getAllFragments().get(0)).getPartitioning().getConnectorHandle()).isEqualTo((Object)expectedPartitioning);
    }

    void assertTableScanPlannedWithoutPartitioning(Session session, String table) {
        String query = "SELECT count(column_b) FROM " + table + " GROUP BY column_a";
        this.assertDistributedPlan("SELECT count(column_b) FROM " + table + " GROUP BY column_a", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"COUNT_PART"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT_PART", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"B"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan(table, (Map<String, String>)ImmutableMap.of((Object)"A", (Object)COLUMN_A, (Object)"B", (Object)COLUMN_B))))))));
        SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
        Assertions.assertThat((List)subPlan.getAllFragments()).hasSize(2);
        Assertions.assertThat((Object)((PlanFragment)subPlan.getAllFragments().get(1)).getPartitioning().getConnectorHandle()).isEqualTo((Object)SystemPartitioningHandle.SOURCE_DISTRIBUTION.getConnectorHandle());
    }

    public static MockConnectorFactory createMockFactory() {
        return MockConnectorFactory.builder().withPartitionProvider(new TestPartitioningProvider((InternalNodeManager)new InMemoryNodeManager(new InternalNode[0]))).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata(COLUMN_A, (Type)BigintType.BIGINT), (Object)new ColumnMetadata(COLUMN_B, (Type)VarcharType.VARCHAR))).withGetTableProperties((session, tableHandle) -> {
            String tableName = ((MockConnectorTableHandle)tableHandle).getTableName().getTableName();
            if (tableName.equals(PARTITIONED_TABLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(PARTITIONING_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), (List)ImmutableList.of());
            }
            if (tableName.equals(SINGLE_BUCKET_TABLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(SINGLE_BUCKET_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), (List)ImmutableList.of());
            }
            if (tableName.equals(FIXED_PARTITIONED_TABLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(FIXED_PARTITIONING_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), (List)ImmutableList.of());
            }
            return new ConnectorTableProperties();
        }).build();
    }

    public static class TestPartitioningProvider
    implements ConnectorNodePartitioningProvider {
        private final InternalNodeManager nodeManager;

        public TestPartitioningProvider(InternalNodeManager nodeManager) {
            this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        }

        public Optional<ConnectorBucketNodeMap> getBucketNodeMapping(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
            if (partitioningHandle.equals((Object)PARTITIONING_HANDLE)) {
                return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((int)10));
            }
            if (partitioningHandle.equals((Object)SINGLE_BUCKET_HANDLE)) {
                return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((int)1));
            }
            if (partitioningHandle.equals((Object)FIXED_PARTITIONING_HANDLE)) {
                return Optional.of(ConnectorBucketNodeMap.createBucketNodeMap((List)ImmutableList.of((Object)this.nodeManager.getCurrentNode())));
            }
            throw new IllegalArgumentException();
        }

        public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
            throw new UnsupportedOperationException();
        }

        public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
            throw new UnsupportedOperationException();
        }
    }
}

