/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.MetadataManager;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestWindowClause
extends BasePlanTest {
    @Test
    public void testPreprojectExpression() {
        String sql = "SELECT max(b) OVER w FROM (VALUES (1, 1)) t(a, b) WINDOW w AS (PARTITION BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addFunction("max_result", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"b"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("a + 1")), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b"))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testPreprojectExpressions() {
        String sql = "SELECT max(b) OVER w3 FROM (VALUES (1, 1, 1)) t(a, b, c) WINDOW w1 AS (PARTITION BY a + 1), w2 AS (w1 ORDER BY b + 2), w3 AS (w2 RANGE c + 3 PRECEDING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"expr_a"), (List<String>)ImmutableList.of((Object)"expr_b"), (Map<String, SortOrder>)ImmutableMap.of((Object)"expr_b", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"b")), MetadataManager.createTestMetadataManager().resolveBuiltinFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})), PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.PRECEDING, Optional.of("frame_start"), Optional.of("expr_b"), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("expr_b"), (Object)new SymbolReference("expr_c"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr_a", (Object)PlanMatchPattern.expression("a + 1"), (Object)"expr_b", (Object)PlanMatchPattern.expression("b + 2"), (Object)"expr_c", (Object)PlanMatchPattern.expression("c + 3")), PlanMatchPattern.anyTree(PlanMatchPattern.values("a", "b", "c")))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowFunctionsInSelectAndOrderBy() {
        String sql = "SELECT array_agg(a) OVER (w ORDER BY a + 1), -a a FROM (VALUES 1, 2, 3) t(a) WINDOW w AS () ORDER BY max(a) OVER (w ORDER BY a + 1)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("max_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"order_by_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("max_result", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"minus_a"))), PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"order_by_window_sortkey", (Object)PlanMatchPattern.expression("minus_a + 1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"minus_a", (Object)PlanMatchPattern.expression("-a")), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"select_window_sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"select_window_sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"select_window_sortkey", (Object)PlanMatchPattern.expression("a + 1")), PlanMatchPattern.anyTree(PlanMatchPattern.values("a"))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testWindowWithFrameCoercions() {
        String sql = "SELECT a old_a, 2e0 a FROM (VALUES -100, -99, -98) t(a) WINDOW w AS (ORDER BY a + 1) ORDER BY count(*) OVER (w RANGE BETWEEN CURRENT ROW AND a + 1e0 FOLLOWING)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("count_result", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"sortkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"sortkey", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("count_result", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of()), MetadataManager.createTestMetadataManager().resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[0])), PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.FOLLOWING, Optional.of("frame_bound"), Optional.of("coerced_sortkey"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_bound", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("coerced_sortkey"), (Object)new SymbolReference("frame_offset"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"coerced_sortkey", (Object)PlanMatchPattern.expression("CAST(sortkey AS double)")), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sortkey", (Object)PlanMatchPattern.expression("a + 1"), (Object)"frame_offset", (Object)PlanMatchPattern.expression("new_a + 1E0")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_a", (Object)PlanMatchPattern.expression("2E0")), PlanMatchPattern.project(PlanMatchPattern.project(PlanMatchPattern.values("a")))))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

