/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.cost.CostComparator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestReorderJoins {
    private RuleTester tester;

    @BeforeAll
    public void setUp() {
        this.tester = RuleTester.builder().addSessionProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).addSessionProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.AUTOMATIC.name()).withNodeCountForStats(4).build();
    }

    @AfterAll
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test
    public void testKeepsOutputSymbols() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(5000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0), (Object)new Symbol("A2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1"), p.symbol("A2")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A2")), (List<Symbol>)ImmutableList.of(), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0, (Object)"A2", (Object)1))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))).withExactOutputs("A2"));
    }

    @Test
    public void testReplicatesAndFlipsWhenOneTableMuchSmaller() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        this.assertReorderJoins().setSystemProperty("join_max_broadcast_table_size", "1PB").overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(arg_0 -> TestReorderJoins.lambda$testReplicatesAndFlipsWhenOneTableMuchSmaller$2((Type)symbolType, arg_0)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testRepartitionsWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(arg_0 -> TestReorderJoins.lambda$testRepartitionsWhenRequiredBySession$4((Type)symbolType, arg_0)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    @Test
    public void testRepartitionsWhenBothTablesEqual() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatesUnrestrictedWhenRequiredBySession() {
        this.assertReorderJoins().setSystemProperty("join_max_broadcast_table_size", "1kB").setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.BROADCAST.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicatedScalarJoinEvenWhereSessionRequiresRepartitioned() {
        PlanMatchPattern expectedPlan = PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        PlanNodeStatsEstimate valuesA = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        PlanNodeStatsEstimate valuesB = PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).matches(expectedPlan);
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).overrideStats("valuesA", valuesA).overrideStats("valuesB", valuesB).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B1"), p.symbol("A1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), Optional.empty())).matches(expectedPlan);
    }

    @Test
    public void testDoesNotFireForCrossJoin() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())).doesNotFire();
    }

    @Test
    public void testDoesNotFireWithNoStats() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.unknown()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.empty())).doesNotFire();
    }

    @Test
    public void testDoesNotFireForNonDeterministicFilter() {
        this.assertReorderJoins().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)p.symbol("A1").toSymbolReference(), (Expression)new TestingFunctionResolution().functionCallBuilder("random").build())))).doesNotFire();
    }

    @Test
    public void testPredicatesPushedDown() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1"), p.symbol("B2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("C1", "B2").left(PlanMatchPattern.values("C1")).right(PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("A1", "B1").left(PlanMatchPattern.values("A1")).right(PlanMatchPattern.values("B1", "B2"))))));
    }

    @Test
    public void testPushesProjectionsThroughJoin() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("P1"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)p.symbol("B1").toSymbolReference()), (Symbol)p.symbol("P2"), (Expression)p.symbol("A1").toSymbolReference()), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("P1"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("P1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("P2").toSymbolReference(), (Expression)p.symbol("C1").toSymbolReference())))).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("C1", "P1").left(PlanMatchPattern.values("C1")).right(PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("P2", "P1").left(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P2", (Object)PlanMatchPattern.expression("A1")), PlanMatchPattern.values("A1"))).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P1", (Object)PlanMatchPattern.expression("-(B1)")), PlanMatchPattern.values("B1")))))));
    }

    @Test
    public void testDoesNotPushProjectionThroughJoinIfTooExpensive() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(5.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 5.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(1000.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("P1"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)p.symbol("B1").toSymbolReference())), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), Optional.empty())), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("P1"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("P1")), (List<Symbol>)ImmutableList.of(), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("C1", "P1").left(PlanMatchPattern.values("C1")).right(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"P1", (Object)PlanMatchPattern.expression("-(B1)")), PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("A1", "B1").left(PlanMatchPattern.values("A1")).right(PlanMatchPattern.values("B1")))))));
    }

    @Test
    public void testSmallerJoinFirst() {
        this.assertReorderJoins().overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount(40.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0), (Object)new Symbol("B2"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 100.0, 10.0))).build()).overrideStats("valuesC", PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("C1"), (Object)new SymbolStatsEstimate(99.0, 199.0, 0.0, 100.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, p.symbol("A1")), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, p.symbol("B1"), p.symbol("B2")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1"), p.symbol("B1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of((Object)p.symbol("B1"), (Object)p.symbol("B2")), Optional.empty()), (PlanNode)p.values(new PlanNodeId("valuesC"), 2, p.symbol("C1")), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("B2"), p.symbol("C1"))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<Symbol>)ImmutableList.of(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)p.symbol("A1").toSymbolReference(), (Expression)p.symbol("B1").toSymbolReference())))).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").left(PlanMatchPattern.values("A1")).right(PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.equiCriteria("C1", "B2").left(PlanMatchPattern.values("C1")).right(PlanMatchPattern.values("B1", "B2"))))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(arg_0 -> TestReorderJoins.lambda$testReplicatesWhenNotRestricted$28((Type)symbolType, aRows, bRows, arg_0)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(arg_0 -> TestReorderJoins.lambda$testReplicatesWhenNotRestricted$30((Type)symbolType, aRows, bRows, arg_0)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("A1", "B1").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReorderAndReplicate() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10;
        int bRows = 10000;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertReorderJoins().setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "10MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(arg_0 -> TestReorderJoins.lambda$testReorderAndReplicate$32((Type)symbolType, aRows, bRows, arg_0)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("B1", "A1").distributionType(JoinNode.DistributionType.REPLICATED).left(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))).right(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)))));
    }

    private RuleBuilder assertReorderJoins() {
        return this.tester.assertThat((Rule<?>)new ReorderJoins(TestingPlannerContext.PLANNER_CONTEXT, new CostComparator(1.0, 1.0, 1.0), TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT)));
    }

    private static /* synthetic */ PlanNode lambda$testReorderAndReplicate$32(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesWhenNotRestricted$30(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesWhenNotRestricted$28(Type symbolType, int aRows, int bRows, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testRepartitionsWhenRequiredBySession$4(Type symbolType, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }

    private static /* synthetic */ PlanNode lambda$testReplicatesAndFlipsWhenOneTableMuchSmaller$2(Type symbolType, PlanBuilder p) {
        Symbol a1 = p.symbol("A1", symbolType);
        Symbol b1 = p.symbol("B1", symbolType);
        return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), 2, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), 2, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1), (List<Symbol>)ImmutableList.of((Object)b1), Optional.empty());
    }
}

