/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSetDigestFunctions {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCardinalityForBigintSetDigest() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT cardinality(make_set_digest(value)) FROM (VALUES 1, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5) T(value)")))).matches("VALUES CAST(5 AS BIGINT)");
    }

    @Test
    public void testCardinalityForVarcharSetDigest() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT cardinality(make_set_digest(value)) FROM (VALUES 'trino', 'sql', 'everything', 'sql', 'trino') T(value)")))).matches("VALUES CAST(3 AS BIGINT)");
    }

    @Test
    public void testCardinalityForDateSetDigest() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT cardinality(make_set_digest(value)) FROM (VALUES DATE '2001-08-22', DATE '2001-08-22', DATE '2001-08-23') T(value)")))).matches("VALUES CAST(2 AS BIGINT)");
    }

    @Test
    public void testExactIntersectionCardinality() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT intersection_cardinality(make_set_digest(v1), make_set_digest(v2)) FROM (VALUES (1, 1), (NULL, 2), (2, 3), (3, 4)) T(v1, v2)")))).matches("VALUES CAST(3 AS BIGINT)");
    }

    @Test
    public void testJaccardIndex() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT jaccard_index(make_set_digest(v1), make_set_digest(v2)) FROM (VALUES (1, 1), (NULL,2), (2, 3), (NULL, 4)) T(v1, v2)")))).matches("VALUES CAST(0.5 AS DOUBLE)");
    }

    @Test
    public void hashCounts() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT hash_counts(make_set_digest(value)) FROM (VALUES 1, 1, 1, 2, 2) T(value)")))).matches("VALUES map(cast(ARRAY[19144387141682250, -2447670524089286488] AS array(bigint)), cast(ARRAY[3, 2] AS array(smallint)))");
    }
}

