/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.DecimalOperators;
import io.trino.type.TestMapOperators;
import io.trino.type.UnknownType;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDecimalOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestMapOperators.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '137.7'", "DECIMAL '17.1'")))).isEqualTo(SqlDecimal.decimal((String)"0154.8", (DecimalType)DecimalType.createDecimalType((int)5, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-1'", "DECIMAL '-2'")))).isEqualTo(SqlDecimal.decimal((String)"-03", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '1'", "DECIMAL '2'")))).isEqualTo(SqlDecimal.decimal((String)"03", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '.1234567890123456'", "DECIMAL '.1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"0.2469135780246912", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-.1234567890123456'", "DECIMAL '-.1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"-0.2469135780246912", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '1234567890123456'", "DECIMAL '1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"02469135780246912", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '123456789012345678'", "DECIMAL '123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"0246913578024691356", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '.123456789012345678'", "DECIMAL '.123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"0.246913578024691356", (DecimalType)DecimalType.createDecimalType((int)19, (int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '1234567890123456789'", "DECIMAL '1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"24691357802469135780246913578024691356", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '12345678901234567890'", "DECIMAL '-12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-12345678901234567890'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-12345678901234567890'", "DECIMAL '-12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '12345678901234567890'", "DECIMAL '-12345678901234567891'")))).isEqualTo(SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-12345678901234567891'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-12345678901234567890'", "DECIMAL '12345678901234567891'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '12345678901234567891'", "DECIMAL '-12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '999999999999999999'", "DECIMAL '999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"1999999999999999998", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '999999999999999999'", "DECIMAL '.999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0999999999999999999.999999999999999999", (DecimalType)DecimalType.createDecimalType((int)37, (int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '123456789012345678901234567890'", "DECIMAL '.12345678'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '.123456789012345678901234567890'", "DECIMAL '12345678'")))).isEqualTo(SqlDecimal.decimal((String)"12345678.123456789012345678901234567890", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '.12345678'", "DECIMAL '123456789012345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678901234567890.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '12345678'", "DECIMAL '.123456789012345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"12345678.123456789012345678901234567890", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '.1'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '1'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '-99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '17014000000000000000000000000000000000'", "DECIMAL '-7014000000000000000000000000000000000.1'")))).isEqualTo(SqlDecimal.decimal((String)"9999999999999999999999999999999999999.9", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DECIMAL '17015000000000000000000000000000000000'", "DECIMAL '-7015000000000000000000000000000000000.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '107.7'", "DECIMAL '17.1'")))).isEqualTo(SqlDecimal.decimal((String)"0090.6", (DecimalType)DecimalType.createDecimalType((int)5, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-1'", "DECIMAL '-2'")))).isEqualTo(SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '1'", "DECIMAL '2'")))).isEqualTo(SqlDecimal.decimal((String)"-01", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.1234567890123456'", "DECIMAL '.1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-.1234567890123456'", "DECIMAL '-.1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '1234567890123456'", "DECIMAL '1234567890123456'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '1234567890123456789'", "DECIMAL '1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.1234567890123456789'", "DECIMAL '.1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678901234567890'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-12345678901234567890'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678901234567890'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-12345678901234567890'", "DECIMAL '-12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-12345678901234567890'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-024691357802469135780", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678901234567890'", "DECIMAL '12345678901234567891'")))).isEqualTo(SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-12345678901234567891'", "DECIMAL '-12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-12345678901234567890'", "DECIMAL '-12345678901234567891'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678901234567891'", "DECIMAL '12345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)21)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '999999999999999999'", "DECIMAL '999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '999999999999999999'", "DECIMAL '.999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0999999999999999998.000000000000000001", (DecimalType)DecimalType.createDecimalType((int)37, (int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '123456789012345678901234567890'", "DECIMAL '.00000001'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345678901234567889.99999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.000000000000000000000000000001'", "DECIMAL '87654321'")))).isEqualTo(SqlDecimal.decimal((String)"-87654320.999999999999999999999999999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.00000001'", "DECIMAL '123456789012345678901234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678901234567889.99999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '12345678'", "DECIMAL '.000000000000000000000000000001'")))).isEqualTo(SqlDecimal.decimal((String)"12345677.999999999999999999999999999999", (DecimalType)DecimalType.createDecimalType((int)38, (int)30)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.1'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-1'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '99999999999999999999999999999999999999'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '17014000000000000000000000000000000000'", "DECIMAL '7014000000000000000000000000000000000.1'")))).isEqualTo(SqlDecimal.decimal((String)"9999999999999999999999999999999999999.9", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '17015000000000000000000000000000000000'", "DECIMAL '7015000000000000000000000000000000000.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '0'", "DECIMAL '1'")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '0'", "DECIMAL '-1'")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '1'", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-1'", "DECIMAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"036", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-036", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-12'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"-036", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '1234567890123456'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"03703703670370368", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890123456'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.3703703670370368", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890123456'", "DECIMAL '.3'")))).isEqualTo(SqlDecimal.decimal((String)".03703703670370368", (DecimalType)DecimalType.createDecimalType((int)17, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(18,0))", "CAST(1 AS DECIMAL(18,0))")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(18,0))", "CAST(-1 AS DECIMAL(18,0))")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(1 AS DECIMAL(18,0))", "CAST(0 AS DECIMAL(18,0))")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(-1 AS DECIMAL(18,0))", "CAST(0 AS DECIMAL(18,0))")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12345678901234567'", "DECIMAL '123456789012345670'")))).isEqualTo(SqlDecimal.decimal((String)"01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-12345678901234567'", "DECIMAL '123456789012345670'")))).isEqualTo(SqlDecimal.decimal((String)"-01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-12345678901234567'", "DECIMAL '-123456789012345670'")))).isEqualTo(SqlDecimal.decimal((String)"01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.12345678901234567'", "DECIMAL '.123456789012345670'")))).isEqualTo(SqlDecimal.decimal((String)".01524157875323883455265967556774890", (DecimalType)DecimalType.createDecimalType((int)35, (int)35)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(38,0))", "1")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(38,0))", "-1")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(1 AS DECIMAL(38,0))", "0")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(-1 AS DECIMAL(38,0))", "0")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '1234567890123456789.0123456789012345678'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"3703703670370370367.0370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.12345678901234567890123456789012345678'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)".37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "0", "CAST(1 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "0", "CAST(-1 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "1", "CAST(0 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "-1", "CAST(0 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '3'", "DECIMAL '12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '3'", "DECIMAL '1234567890123456789.0123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"3703703670370370367.0370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '3'", "DECIMAL '.12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)".37037036703703703670370370367037037034", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(38,0))", "CAST(1 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(0 AS DECIMAL(38,0))", "CAST(-1 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(1 AS DECIMAL(38,0))", "CAST(0 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(-1 AS DECIMAL(38,0))", "CAST(0 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(3 AS DECIMAL(38,0))", "CAST(2 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000006", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "CAST(3 AS DECIMAL(38,0))", "CAST(DECIMAL '0.2' AS DECIMAL(38,1))")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000000000000000000.6", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890123456789'", "DECIMAL '.1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)".01524157875323883675019051998750190521", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890123456789'", "DECIMAL '.12345678901234567890'")::evaluate).hasMessage("line 1:8: DECIMAL scale must be in range [0, precision (38)]: 39");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1'", "DECIMAL '.12345678901234567890123456789012345678'")::evaluate).hasMessage("line 1:8: DECIMAL scale must be in range [0, precision (38)]: 39");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '9'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.12345678901234567890123456789012345678'", "DECIMAL '9'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '-9'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.12345678901234567890123456789012345678'", "DECIMAL '-9'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyLongShortLong((Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"), (long)9L)).hasMessage("Decimal overflow");
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyShortLongLong((long)9L, (Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"))).hasMessage("Decimal overflow");
        Assertions.assertThatThrownBy(() -> DecimalOperators.multiplyLongLongLong((Int128)Int128.valueOf((String)"12345678901234567890123456789012345678"), (Int128)Int128.valueOf((String)"9"))).hasMessage("Decimal overflow");
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1.0'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1.0'", "DECIMAL '0.1'")))).isEqualTo(SqlDecimal.decimal((String)"10.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1.0'", "DECIMAL '9.0'")))).isEqualTo(SqlDecimal.decimal((String)"00.1", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '500.00'", "DECIMAL '0.1'")))).isEqualTo(SqlDecimal.decimal((String)"5000.00", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '100.00'", "DECIMAL '0.3'")))).isEqualTo(SqlDecimal.decimal((String)"0333.33", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '100.00'", "DECIMAL '0.30'")))).isEqualTo(SqlDecimal.decimal((String)"00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '100.00'", "DECIMAL '-0.30'")))).isEqualTo(SqlDecimal.decimal((String)"-00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-100.00'", "DECIMAL '0.30'")))).isEqualTo(SqlDecimal.decimal((String)"-00333.33", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '200.00'", "DECIMAL '0.3'")))).isEqualTo(SqlDecimal.decimal((String)"0666.67", (DecimalType)DecimalType.createDecimalType((int)6, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '200.00000'", "DECIMAL '0.3'")))).isEqualTo(SqlDecimal.decimal((String)"0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '200.00000'", "DECIMAL '-0.3'")))).isEqualTo(SqlDecimal.decimal((String)"-0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-200.00000'", "DECIMAL '0.3'")))).isEqualTo(SqlDecimal.decimal((String)"-0666.66667", (DecimalType)DecimalType.createDecimalType((int)9, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '999999999999999999'", "DECIMAL '1'")))).isEqualTo(SqlDecimal.decimal((String)"999999999999999999", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9'", "DECIMAL '000000000000000003'")))).isEqualTo(SqlDecimal.decimal((String)"3", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9.0'", "DECIMAL '3.0'")))).isEqualTo(SqlDecimal.decimal((String)"03.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '999999999999999999'", "DECIMAL '500000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000002", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-1'", "DECIMAL '999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9'", "DECIMAL '5'")))).isEqualTo(SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '7'", "DECIMAL '5'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9'", "DECIMAL '5'")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-7'", "DECIMAL '5'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9'", "DECIMAL '-5'")))).isEqualTo(SqlDecimal.decimal((String)"2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-7'", "DECIMAL '-5'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9'", "DECIMAL '-5'")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '7'", "DECIMAL '-5'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-1'", "DECIMAL '2'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '-2'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-1'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '10'", "DECIMAL '.000000001'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-10'", "DECIMAL '.000000001'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '10'", "DECIMAL '-.000000001'")))).isEqualTo(SqlDecimal.decimal((String)"-10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-10'", "DECIMAL '-.000000001'")))).isEqualTo(SqlDecimal.decimal((String)"10000000000.000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '200000000000000000000000000000000000'", "DECIMAL '0.30'")))).isEqualTo(SqlDecimal.decimal((String)"666666666666666666666666666666666666.67", (DecimalType)DecimalType.createDecimalType((int)38, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '200000000000000000000000000000000000'", "DECIMAL '-0.30'")))).isEqualTo(SqlDecimal.decimal((String)"-666666666666666666666666666666666666.67", (DecimalType)DecimalType.createDecimalType((int)38, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-.20000000000000000000000000000000000000'", "DECIMAL '0.30'")))).isEqualTo(SqlDecimal.decimal((String)"-.66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-.20000000000000000000000000000000000000'", "DECIMAL '-0.30'")))).isEqualTo(SqlDecimal.decimal((String)".66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '.20000000000000000000000000000000000000'", "DECIMAL '0.30'")))).isEqualTo(SqlDecimal.decimal((String)".66666666666666666666666666666666666667", (DecimalType)DecimalType.createDecimalType((int)38, (int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '500000000000000000000000000000000075'", "DECIMAL '50'")))).isEqualTo(SqlDecimal.decimal((String)"010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '500000000000000000000000000000000070'", "DECIMAL '50'")))).isEqualTo(SqlDecimal.decimal((String)"010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-500000000000000000000000000000000075'", "DECIMAL '50'")))).isEqualTo(SqlDecimal.decimal((String)"-010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-500000000000000000000000000000000070'", "DECIMAL '50'")))).isEqualTo(SqlDecimal.decimal((String)"-010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '500000000000000000000000000000000075'", "DECIMAL '-50'")))).isEqualTo(SqlDecimal.decimal((String)"-010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '500000000000000000000000000000000070'", "DECIMAL '-50'")))).isEqualTo(SqlDecimal.decimal((String)"-010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-500000000000000000000000000000000075'", "DECIMAL '-50'")))).isEqualTo(SqlDecimal.decimal((String)"010000000000000000000000000000000002", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-500000000000000000000000000000000070'", "DECIMAL '-50'")))).isEqualTo(SqlDecimal.decimal((String)"010000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "CAST(-1 AS DECIMAL(19,0))", "DECIMAL '2'")))).isEqualTo(SqlDecimal.decimal((String)"-0000000000000000001", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "CAST(1 AS DECIMAL(19,0))", "DECIMAL '-2'")))).isEqualTo(SqlDecimal.decimal((String)"-0000000000000000001", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "CAST(-1 AS DECIMAL(19,0))", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '0.1'", "DECIMAL '.0000000000000000001'")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-0.1'", "DECIMAL '.0000000000000000001'")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '0.1'", "DECIMAL '-.0000000000000000001'")))).isEqualTo(SqlDecimal.decimal((String)"-1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-0.1'", "DECIMAL '-.0000000000000000001'")))).isEqualTo(SqlDecimal.decimal((String)"1000000000000000000.0000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9'", "DECIMAL '000000000000000003.0'")))).isEqualTo(SqlDecimal.decimal((String)"03.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-1'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '-99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-1'", "DECIMAL '-99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '11111111111111111111111111111111111111'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '11111111111111111111111111111111111111'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '-11111111111111111111111111111111111111'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '-11111111111111111111111111111111111111'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000009", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '11111111111111111111111111111111111111'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-11111111111111111111111111111111111111'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '11111111111111111111111111111111111111'", "DECIMAL '-99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-11111111111111111111111111111111111111'", "DECIMAL '-99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '99999999999999999999999999999999999998'", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9999999999999999999999999999999999999.8'", "DECIMAL '9999999999999999999999999999999999999.9'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000000000000000001.0", (DecimalType)DecimalType.createDecimalType((int)38, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9999999999999999999999.9'", "DECIMAL '1111111111111111111111.100'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000009.000", (DecimalType)DecimalType.createDecimalType((int)28, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "CAST('1635619.3155' AS DECIMAL(38,4))", "CAST('47497517.7405' AS DECIMAL(38,4))")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000000000000000.0344", (DecimalType)DecimalType.createDecimalType((int)38, (int)4)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '.12345678901234567890123456789012345678'", "DECIMAL '.1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '12345678901234567890123456789012345678'", "DECIMAL '.12345678901234567890123456789012345678'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '.12345678901234567890123456789012345678'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1.000000000000000000000000000000000000'", "DECIMAL '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1.000000000000000000000000000000000000'", "DECIMAL '0.0000000000000000000000000000000000000'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '1'", "DECIMAL '0.0000000000000000000000000000000000000'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "CAST(1000 AS DECIMAL(38,8))", "CAST(25 AS DECIMAL(38,8))")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000000000000000040.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)));
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '10'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '10.0'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '10.0'", "DECIMAL '3.000'")))).isEqualTo(SqlDecimal.decimal((String)"1.000", (DecimalType)DecimalType.createDecimalType((int)4, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "DECIMAL '3.0000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.00000000000000000'", "DECIMAL '3.00000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.00000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "CAST(3 AS DECIMAL(17,0))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '.1'", "DECIMAL '.03'")))).isEqualTo(SqlDecimal.decimal((String)".01", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '.0001'", "DECIMAL '.03'")))).isEqualTo(SqlDecimal.decimal((String)".0001", (DecimalType)DecimalType.createDecimalType((int)4, (int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-10'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '10'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-10'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "CAST(3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "CAST(-3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "CAST(3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.00000000000000000'", "CAST(3 AS DECIMAL(38,17))")))).isEqualTo(SqlDecimal.decimal((String)"1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7.00000000000000000'", "CAST(3 AS DECIMAL(38,17))")))).isEqualTo(SqlDecimal.decimal((String)"-1.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.0000000000000000'", "CAST(-3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7.0000000000000000'", "CAST(-3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"-1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.00000000000000000'", "CAST(3 AS DECIMAL(38,17))")))).isEqualTo(SqlDecimal.decimal((String)"0.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.00000000000000000'", "CAST(3 AS DECIMAL(38,17))")))).isEqualTo(SqlDecimal.decimal((String)"0.00000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.0000000000000000'", "CAST(-3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.0000000000000000'", "CAST(-3 AS DECIMAL(38,16))")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0'", "DECIMAL '-3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.00000000000000000'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '.01'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)".0100000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7'", "DECIMAL '-3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7'", "DECIMAL '-3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"-1.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9'", "DECIMAL '3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9'", "DECIMAL '-3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9'", "DECIMAL '-3.0000000000000000000000000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0.0000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)37)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '99999999999999999999999999999999999997'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '99999999999999999999999999999999999997'", "DECIMAL '3.0000000000000000'")))).isEqualTo(SqlDecimal.decimal((String)"1.0000000000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-99999999999999999999999999999999999997'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '99999999999999999999999999999999999997'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-99999999999999999999999999999999999997'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '99999999999999999999999999999999999999'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-99999999999999999999999999999999999999'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0.000000000000000000000000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)".000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '0.000000000000000000000000000000000000'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)".000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)36, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.000000000000000000000000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7.000000000000000000000000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"-1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '7.000000000000000000000000000000000000'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-7.000000000000000000000000000000000000'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-1.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.000000000000000000000000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.000000000000000000000000000000000000'", "DECIMAL '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.000000000000000000000000000000000000'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.000000000000000000000000000000000000'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0.000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)37, (int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(0 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(0 AS DECIMAL(38,0))", "CAST(-3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(7 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(7 AS DECIMAL(34,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)34)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(7 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(34,0))")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)34)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(-7 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(7 AS DECIMAL(38,0))", "CAST(-3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(-7 AS DECIMAL(38,0))", "CAST(-3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000000000000000000000001", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(9 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(-9 AS DECIMAL(38,0))", "CAST(3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(9 AS DECIMAL(38,0))", "CAST(-3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "CAST(-9 AS DECIMAL(38,0))", "CAST(-3 AS DECIMAL(38,0))")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000000000000000000000", (DecimalType)DecimalType.createDecimalType((int)38)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1'", "DECIMAL '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1.000000000000000000000000000000000000'", "DECIMAL '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1.000000000000000000000000000000000000'", "DECIMAL '0.0000000000000000000000000000000000000'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1'", "DECIMAL '0.0000000000000000000000000000000000000'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "DECIMAL '1'", "CAST(0 AS DECIMAL(38,0))")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '1'")))).isEqualTo(SqlDecimal.decimal((String)"-1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '-1'")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '123456.00000010' ")))).isEqualTo(SqlDecimal.decimal((String)"-123456.00000010", (DecimalType)DecimalType.createDecimalType((int)14, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '1234567.00500010734' ")))).isEqualTo(SqlDecimal.decimal((String)"-1234567.00500010734", (DecimalType)DecimalType.createDecimalType((int)18, (int)11)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '-1234567.00500010734' ")))).isEqualTo(SqlDecimal.decimal((String)"1234567.00500010734", (DecimalType)DecimalType.createDecimalType((int)18, (int)11)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '0' ")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '0.00000000000000000000' ")))).isEqualTo(SqlDecimal.decimal((String)".00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"-12345678901234567890123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '-12345678901234567890123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567890123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "DECIMAL '123456789012345678.90123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"-123456789012345678.90123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)20)));
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '0037'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '37.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-0.000'", "DECIMAL '0.00000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '38'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '38.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0'", "DECIMAL '38'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-37.000'", "DECIMAL '37.000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-123456789123456789'", "DECIMAL '-123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-123456789123456789'", "DECIMAL '123456789123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '037.0'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-0.000'", "DECIMAL '0.000000000000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-37'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0000000000000000'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0000000000000000'", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '037.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-0.000000000000000000000000000000000'", "DECIMAL '0.000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000038.0000000000000000000000'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-00000000037.0000000000000000000000'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37.0000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000036.0000000000000000000000'", "DECIMAL '37.0000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '0037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '0.0000000000000000000000000000000'", "DECIMAL '-0.000000000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '00000000038.0000000000000000000000'", "DECIMAL '000000000037.00000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DECIMAL '-00000000038.0000000000000000000000'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '0037'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37.0'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '0'").binding("b", "DECIMAL '-0.00'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '-37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '38.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37.0'").binding("b", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '-37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '-999999999999999999'").binding("b", "DECIMAL '-999999999999999999'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '-999999999999999999'").binding("b", "DECIMAL '999999999999999998'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '0'").binding("b", "DECIMAL '-0.0000000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '-000000000037.00000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '38.0000000000000000'").binding("b", "DECIMAL '00000000038.0000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '-987654321987654321'").binding("b", "DECIMAL '-987654321987654321.00000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '037.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '0.0000000000000000000000000000'").binding("b", "DECIMAL '-0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000038.0000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000000037.00000000000000000000'").binding("b", "DECIMAL '-37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '-00000000000037.00000000000000000000'").binding("b", "DECIMAL '-37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '0037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '0.00000000000000000000000000000000000'").binding("b", "DECIMAL '-0.000000000000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000038.0000000000000000000000'").binding("b", "DECIMAL '000000000037.00000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "DECIMAL '00000000000037.00000000000000000000'").binding("b", "DECIMAL '-00000000000037.00000000000000000000'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '0037'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '37.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '0037.0'", "DECIMAL '00036.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '0038.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '0037.0'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-100'", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '1'", "DECIMAL '10000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '1.0000000000000000'", "DECIMAL '10000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-123456789123456789'", "DECIMAL '-123456789123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-123456789123456789'", "DECIMAL '123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '037.0'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '037.0'", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '37.00000000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '037.0'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-100'", "DECIMAL '20.00000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '38.0000000000000000'", "DECIMAL '00000000038.0000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-987654321987654321'", "DECIMAL '-987654321987654321.00000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '037.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '036.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000001'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '038.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-00000000000100.000000000000'", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-00000000000037.00000000000000000000'", "DECIMAL '-37.0000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '00000037.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '00000036.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '38.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '000000000037.00000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DECIMAL '-00000000000100.000000000000'", "DECIMAL '0000000020.0000000000000'")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '0037'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '0037.0'").binding("b", "DECIMAL '00038.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '0036.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '0037.0'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '100'").binding("b", "DECIMAL '-20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '10000000000000000'").binding("b", "DECIMAL '1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '10000000000000000'").binding("b", "DECIMAL '1.0000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '-123456789123456788'").binding("b", "DECIMAL '-123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '-123456789123456789'").binding("b", "DECIMAL '123456789123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '36.00000000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '100'").binding("b", "DECIMAL '-0000000020.00000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '38.0000000000000000'").binding("b", "DECIMAL '00000000038.0000000000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '-987654321987654320'").binding("b", "DECIMAL '-987654321987654321.00000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '037.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '038.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000001'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '036.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '0000000000100.000000000000'").binding("b", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000002'").binding("b", "DECIMAL '37.0000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '-00000000000037.00000000000000000000'").binding("b", "DECIMAL '-37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '00000037.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '00000038.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '36.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '000000000036.9999999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DECIMAL '000000000000100.0000000000000000000000'").binding("b", "DECIMAL '-0000000020.00000000000000000000000'")))).isEqualTo(true);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '36'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '000036.99999'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '0037'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '37.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '0038.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '0037.0'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-100'", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-123456789123456789'", "DECIMAL '-123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-123456789123456789'", "DECIMAL '123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '037.0'", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '037.0'", "DECIMAL '00000000036.9999999999999999999'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '037.0'", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '37.00000000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '037.0'", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-100'", "DECIMAL '20.00000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '38.0000000000000000'", "DECIMAL '00000000038.0000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-987654321987654321'", "DECIMAL '-987654321987654321.00000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '036.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '000036.99999999'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '037.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000001'", "DECIMAL '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '038.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-00000000000100.000000000000'", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-00000000000037.00000000000000000000'", "DECIMAL '-37.0000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '00000036.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '37.0000000000000000000000000'", "DECIMAL '00000037.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '38.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '00000000037.0000000000000000000000'", "DECIMAL '000000000037.00000000000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DECIMAL '-00000000000100.000000000000'", "DECIMAL '0000000020.0000000000000'")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '38'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '000038.00001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '0037'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0'").binding("b", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '0036.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '0037.0'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '100'").binding("b", "DECIMAL '-20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '-123456789123456789'").binding("b", "DECIMAL '-123456789123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '-123456789123456789'").binding("b", "DECIMAL '123456789123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000038.0000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000037.0000000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000037.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '36.9999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37'").binding("b", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '037.0'").binding("b", "DECIMAL '00000000036.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '100'").binding("b", "DECIMAL '-0000000020.00000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '38.0000000000000000'").binding("b", "DECIMAL '00000000038.0000000000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '-987654321987654321'").binding("b", "DECIMAL '-987654321987654321.00000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '038.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '000037.00000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '037.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000001'").binding("b", "DECIMAL '36'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '036.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '0000000000100.000000000000'").binding("b", "DECIMAL '20'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '37.0000000000000001'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '-00000000000037.00000000000000000000'").binding("b", "DECIMAL '-37.0000000000000001'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '00000038.0000000000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '37.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '37.0000000000000000000000000'").binding("b", "DECIMAL '00000037.0000000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '36.0000000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '00000000037.0000000000000000000000'").binding("b", "DECIMAL '000000000036.9999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DECIMAL '000000000000100.0000000000000000000000'").binding("b", "DECIMAL '-0000000020.00000000000000000000000'")))).isEqualTo(true);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333'").binding("low", "DECIMAL '-111111111111111111'").binding("high", "DECIMAL '999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333'").binding("low", "DECIMAL '-111111111111111111'").binding("high", "DECIMAL '9999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1'").binding("low", "DECIMAL '-5.00000000000000000000'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6'").binding("low", "DECIMAL '-5.00000000000000000000'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6'").binding("low", "DECIMAL '-5.00000000000000000000'").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333'").binding("low", "DECIMAL '-1111111111111111111'").binding("high", "DECIMAL '9999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333.3'").binding("low", "DECIMAL '-111111111111111111'").binding("high", "DECIMAL '999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000' ")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000' ")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6.00000000000000000000'").binding("low", "DECIMAL '-5'").binding("high", "DECIMAL '5.00000000000000000000' ")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333.3'").binding("low", "DECIMAL '-111111111111111111'").binding("high", "DECIMAL '9999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '333333333333333333.3'").binding("low", "DECIMAL '-111111111111111111.1'").binding("high", "DECIMAL '999999999999999999'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '1.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '-6.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DECIMAL '6.00000000000000000000'").binding("low", "DECIMAL '-5.00000000000000000000' ").binding("high", "DECIMAL '5.00000000000000000000'")))).isEqualTo(false);
    }

    @Test
    public void testAddDecimalBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '123456789012345678'", "123456789012345678")))).isEqualTo(SqlDecimal.decimal((String)"00246913578024691356", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '.123456789012345678'", "123456789012345678")))).isEqualTo(SqlDecimal.decimal((String)"00123456789012345678.123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DECIMAL '-1234567890123456789'", "1234567890123456789")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "123456789012345678", "DECIMAL '123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"00246913578024691356", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "123456789012345678", "DECIMAL '.123456789012345678'")))).isEqualTo(SqlDecimal.decimal((String)"00123456789012345678.123456789012345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "1234567890123456789", "DECIMAL '-1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
    }

    @Test
    public void testSubtractDecimalBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '1234567890123456789'", "1234567890123456789")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '.1234567890123456789'", "1234567890123456789")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456788.8765432109876543211", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DECIMAL '-1234567890123456789'", "1234567890123456789")))).isEqualTo(SqlDecimal.decimal((String)"-02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "1234567890123456789", "DECIMAL '1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "1234567890123456789", "DECIMAL '.1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456788.8765432109876543211", (DecimalType)DecimalType.createDecimalType((int)38, (int)19)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "-1234567890123456789", "DECIMAL '1234567890123456789'")))).isEqualTo(SqlDecimal.decimal((String)"-02469135780246913578", (DecimalType)DecimalType.createDecimalType((int)20)));
    }

    @Test
    public void testMultiplyDecimalBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '12345678901234567'", "12345678901234567")))).isEqualTo(SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-12345678901234567'", "12345678901234567")))).isEqualTo(SqlDecimal.decimal((String)"-000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-12345678901234567'", "-12345678901234567")))).isEqualTo(SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.3703703670", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '.1234567890'", "BIGINT '0'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "DECIMAL '-.1234567890'", "BIGINT '0'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "12345678901234567", "DECIMAL '12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "12345678901234567", "DECIMAL '-12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"-000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "-12345678901234567", "DECIMAL '-12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"000152415787532388345526596755677489", (DecimalType)DecimalType.createDecimalType((int)36)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "BIGINT '3'", "DECIMAL '.1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.3703703670", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "BIGINT '3'", "DECIMAL '.0000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "BIGINT '-3'", "DECIMAL '.0000000000'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)10)));
    }

    @Test
    public void testDivideDecimalBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '3.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '-9'", "DECIMAL '3.0'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '-3.0'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '-9'", "DECIMAL '-3.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '000000000000000003.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000003.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '18'", "DECIMAL '0.01'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000001800.00", (DecimalType)DecimalType.createDecimalType((int)23, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '00000000000000000.1'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000090.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '300.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '-9'", "DECIMAL '300.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '9'", "DECIMAL '-300.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "BIGINT '-9'", "DECIMAL '-300.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000.0", (DecimalType)DecimalType.createDecimalType((int)21, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9.0'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9.0'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9.0'", "BIGINT '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9.0'", "BIGINT '-3'")))).isEqualTo(SqlDecimal.decimal((String)"3.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '0.018'", "BIGINT '9'")))).isEqualTo(SqlDecimal.decimal((String)".002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-0.018'", "BIGINT '9'")))).isEqualTo(SqlDecimal.decimal((String)"-.002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '0.018'", "BIGINT '-9'")))).isEqualTo(SqlDecimal.decimal((String)"-.002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-0.018'", "BIGINT '-9'")))).isEqualTo(SqlDecimal.decimal((String)".002", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '.999'", "BIGINT '9'")))).isEqualTo(SqlDecimal.decimal((String)".111", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9.0'", "BIGINT '300'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9.0'", "BIGINT '300'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '9.0'", "BIGINT '-300'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "DECIMAL '-9.0'", "BIGINT '-300'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
    }

    @Test
    public void testModulusDecimalBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '13'", "DECIMAL '9.0'")))).isEqualTo(SqlDecimal.decimal((String)"4.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '18'", "DECIMAL '0.01'")))).isEqualTo(SqlDecimal.decimal((String)".00", (DecimalType)DecimalType.createDecimalType((int)2, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '9'", "DECIMAL '.1'")))).isEqualTo(SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '-9'", "DECIMAL '.1'")))).isEqualTo(SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '9'", "DECIMAL '-.1'")))).isEqualTo(SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "BIGINT '-9'", "DECIMAL '-.1'")))).isEqualTo(SqlDecimal.decimal((String)".0", (DecimalType)DecimalType.createDecimalType((int)1, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '13.0'", "BIGINT '9'")))).isEqualTo(SqlDecimal.decimal((String)"04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-13.0'", "BIGINT '9'")))).isEqualTo(SqlDecimal.decimal((String)"-04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '13.0'", "BIGINT '-9'")))).isEqualTo(SqlDecimal.decimal((String)"04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-13.0'", "BIGINT '-9'")))).isEqualTo(SqlDecimal.decimal((String)"-04.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '18.00'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.0'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.0'", "BIGINT '3'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '9.0'", "BIGINT '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '-9.0'", "BIGINT '-3'")))).isEqualTo(SqlDecimal.decimal((String)"0.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "DECIMAL '5.128'", "BIGINT '2'")))).isEqualTo(SqlDecimal.decimal((String)"1.128", (DecimalType)DecimalType.createDecimalType((int)4, (int)3)));
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL)", "CAST(NULL AS DECIMAL)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '37'", "DECIMAL '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "37", "38")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "37")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "37", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '-2'", "DECIMAL '-3'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '-2'", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(2,0))", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '-2'", "DECIMAL '-2'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(1,0))", "DECIMAL '-2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '12345678901234567.8902345678901234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '12345678901234567.89012345678901234567'", "CAST(NULL AS DECIMAL(36,1))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(36,1))", "CAST(NULL AS DECIMAL(27,3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '-12345678901234567.89012345678901234567'", "DECIMAL '-12345678901234567.89012345678901234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(36,1))", "DECIMAL '12345678901234567.89012345678901234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '-3'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '12345678901234567.89012345678901234567'", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(36,1))", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '00000000000000007.80000000000000000000'", "DECIMAL '7.8'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS DECIMAL(36,1))", "DECIMAL '7.8'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "DECIMAL '-2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '-2'", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "DECIMAL '12345678901234567.89012345678901234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "DECIMAL '12345678901234567.89012345678901234567'", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1.23, 4.56]", "ARRAY [1.23, 4.56]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1.23, NULL]", "ARRAY [1.23, 4.56]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1.23, NULL]", "ARRAY [NULL, 4.56]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1234567890.123456789, 9876543210.987654321]", "ARRAY [1234567890.123456789, 9876543210.987654321]")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1234567890.123456789, NULL]", "ARRAY [1234567890.123456789, 9876543210.987654321]")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY [1234567890.123456789, NULL]", "ARRAY [NULL, 9876543210.987654321]")))).isEqualTo(true);
    }

    @Test
    public void testNullIf() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '-2'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '-2'", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '-2'", "DECIMAL '-2'")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "CAST(NULL AS DECIMAL(1, 0))", "DECIMAL '-2'")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "CAST(NULL AS DECIMAL(1, 0))", "CAST(NULL AS DECIMAL(1,0))")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '12345678901234567.8902345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "CAST(NULL AS DECIMAL(36,1))")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '12345678901234567.89012345678901234567'")))).isNull((Type)DecimalType.createDecimalType((int)37, (int)20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "CAST(NULL AS DECIMAL(38, 0))", "DECIMAL '12345678901234567.89012345678901234567'")))).isNull((Type)DecimalType.createDecimalType((int)38, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "CAST(NULL AS DECIMAL(38, 0))", "CAST(NULL AS DECIMAL(38,0))")))).isNull((Type)DecimalType.createDecimalType((int)38, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '-3'")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "CAST(NULL AS DECIMAL(1,0))")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "DECIMAL '12345678901234567.89012345678901234567'")))).isNull((Type)DecimalType.createDecimalType((int)37, (int)20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "CAST(NULL AS DECIMAL(1, 0))", "DECIMAL '12345678901234567.89012345678901234567'")))).isNull((Type)DecimalType.createDecimalType((int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "NULL", "NULL")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "NULL", "DECIMAL '-2'")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '-2'", "NULL")))).isEqualTo(SqlDecimal.decimal((String)"-2", (DecimalType)DecimalType.createDecimalType((int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "NULL", "DECIMAL '12345678901234567.89012345678901234567'")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("nullif", "DECIMAL '12345678901234567.89012345678901234567'", "NULL")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567.89012345678901234567", (DecimalType)DecimalType.createDecimalType((int)37, (int)20)));
    }

    @Test
    public void testCoalesce() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "2.1", "null", "cast(null as decimal(5,3))")))).isEqualTo(SqlDecimal.decimal((String)"02.100", (DecimalType)DecimalType.createDecimalType((int)5, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "cast(null as decimal(17, 3))", "null", "cast(null as decimal(12,3))")))).isNull((Type)DecimalType.createDecimalType((int)17, (int)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "3", "2.1", "null", "cast(null as decimal(6,3))")))).isEqualTo(SqlDecimal.decimal((String)"0000000003.000", (DecimalType)DecimalType.createDecimalType((int)13, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("coalesce", "cast(null as decimal(17, 3))", "null", "cast(null as decimal(12,3))")))).isNull((Type)DecimalType.createDecimalType((int)17, (int)3));
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as DECIMAL)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as DECIMAL(37,3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "DECIMAL '.999'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "DECIMAL '18'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "DECIMAL '9.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "DECIMAL '12345678901234567.89012345678901234567'")))).isEqualTo(false);
    }
}

