/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import io.trino.type.BlockTypeOperators;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRealType
extends AbstractTestType {
    public TestRealType() {
        super((Type)RealType.REAL, Float.class, TestRealType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = RealType.REAL.createBlockBuilder(null, 30);
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(11.11f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(22.22f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(33.33f));
        RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(44.44f));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        int bits = ((Long)value).intValue();
        float greaterValue = Float.intBitsToFloat(bits) + 0.1f;
        return (long)Float.floatToRawIntBits(greaterValue);
    }

    @Test
    public void testNaNHash() {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 5);
        RealType.REAL.writeFloat((BlockBuilder)blockBuilder, Float.NaN);
        RealType.REAL.writeInt((BlockBuilder)blockBuilder, Float.floatToIntBits(Float.NaN));
        RealType.REAL.writeInt((BlockBuilder)blockBuilder, Float.floatToRawIntBits(Float.NaN));
        RealType.REAL.writeInt((BlockBuilder)blockBuilder, -4194304);
        RealType.REAL.writeInt((BlockBuilder)blockBuilder, 2143289344);
        Block block = blockBuilder.build();
        BlockTypeOperators.BlockPositionHashCode hashCodeOperator = this.blockTypeOperators.getHashCodeOperator((Type)RealType.REAL);
        Assertions.assertThat((long)hashCodeOperator.hashCode(block, 0)).isEqualTo(hashCodeOperator.hashCode(block, 1));
        Assertions.assertThat((long)hashCodeOperator.hashCode(block, 0)).isEqualTo(hashCodeOperator.hashCode(block, 2));
        Assertions.assertThat((long)hashCodeOperator.hashCode(block, 0)).isEqualTo(hashCodeOperator.hashCode(block, 3));
        Assertions.assertThat((long)hashCodeOperator.hashCode(block, 0)).isEqualTo(hashCodeOperator.hashCode(block, 4));
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

