/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogManagerConfig;
import io.trino.connector.CatalogServiceProviderModule;
import io.trino.connector.DefaultCatalogFactory;
import io.trino.connector.DynamicCatalogManagerModule;
import io.trino.connector.LazyCatalogFactory;
import io.trino.connector.StaticCatalogManagerModule;

public class CatalogManagerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(DefaultCatalogFactory.class).in(Scopes.SINGLETON);
        binder.bind(LazyCatalogFactory.class).in(Scopes.SINGLETON);
        binder.bind(CatalogFactory.class).to(LazyCatalogFactory.class).in(Scopes.SINGLETON);
        CatalogManagerConfig config = (CatalogManagerConfig)this.buildConfigObject(CatalogManagerConfig.class);
        switch (config.getCatalogMangerKind()) {
            case STATIC: {
                this.install(new StaticCatalogManagerModule());
                break;
            }
            case DYNAMIC: {
                this.install((Module)new DynamicCatalogManagerModule());
            }
        }
        this.install(new CatalogServiceProviderModule());
    }
}

