/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.connector.system.GlobalSystemTransactionHandle;
import io.trino.operator.table.SequenceFunction;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class GlobalSystemConnector
implements InternalConnector {
    public static final String NAME = "system";
    public static final CatalogHandle CATALOG_HANDLE = CatalogHandle.createRootCatalogHandle((String)"system", (CatalogHandle.CatalogVersion)new CatalogHandle.CatalogVersion("system"));
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;
    private final Set<ConnectorTableFunction> tableFunctions;

    @Inject
    public GlobalSystemConnector(Set<SystemTable> systemTables, Set<Procedure> procedures, Set<ConnectorTableFunction> tableFunctions) {
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.tableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tableFunctions, "tableFunctions is null"));
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new GlobalSystemTransactionHandle(transactionId);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return new ConnectorMetadata(this){};
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.tableFunctions;
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(this){

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle functionHandle) {
                if (functionHandle instanceof SequenceFunction.SequenceFunctionHandle) {
                    SequenceFunction.SequenceFunctionHandle sequenceFunctionHandle = (SequenceFunction.SequenceFunctionHandle)functionHandle;
                    return SequenceFunction.getSequenceFunctionSplitSource(sequenceFunctionHandle);
                }
                throw new UnsupportedOperationException();
            }
        };
    }
}

