/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.Identity;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.StringLiteral;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Objects;

public class SetSessionAuthorizationTask
implements DataDefinitionTask<SetSessionAuthorization> {
    private final AccessControl accessControl;
    private final TransactionManager transactionManager;

    @Inject
    public SetSessionAuthorizationTask(AccessControl accessControl, TransactionManager transactionManager) {
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    @Override
    public String getName() {
        return "SET SESSION AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetSessionAuthorization statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        String user;
        Session session = stateMachine.getSession();
        if (!session.getClientCapabilities().contains(ClientCapabilities.SESSION_AUTHORIZATION.toString())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SET SESSION AUTHORIZATION not supported by client");
        }
        Identity originalIdentity = session.getOriginalIdentity();
        session.getTransactionId().ifPresent(transactionId -> {
            if (!this.transactionManager.getTransactionInfo((TransactionId)transactionId).isAutoCommitContext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Can't set authorization user in the middle of a transaction");
            }
        });
        Expression userExpression = statement.getUser();
        if (userExpression instanceof Identifier) {
            Identifier identifier = (Identifier)userExpression;
            user = identifier.getValue();
        } else if (userExpression instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)userExpression;
            user = stringLiteral.getValue();
        } else {
            throw new IllegalArgumentException("Unsupported user expression: " + userExpression.getClass().getName());
        }
        Preconditions.checkState((user != null && !user.isEmpty() ? 1 : 0) != 0, (Object)"Authorization user cannot be null or empty");
        if (!originalIdentity.getUser().equals(user)) {
            this.accessControl.checkCanSetUser(originalIdentity.getPrincipal(), user);
            this.accessControl.checkCanImpersonateUser(originalIdentity, user);
        }
        stateMachine.setSetAuthorizationUser(user);
        return Futures.immediateFuture(null);
    }
}

