/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.execution.QueryManagerConfig;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.SelectionContext;
import io.trino.spi.resourcegroups.SelectionCriteria;
import java.util.Optional;

public class LegacyResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager<VoidContext> {
    private static final ResourceGroupId GLOBAL = new ResourceGroupId("global");
    private final int hardConcurrencyLimit;
    private final int maxQueued;

    @Inject
    public LegacyResourceGroupConfigurationManager(QueryManagerConfig config) {
        this.hardConcurrencyLimit = config.getMaxConcurrentQueries();
        this.maxQueued = config.getMaxQueuedQueries();
    }

    public void configure(ResourceGroup group, SelectionContext<VoidContext> criteria) {
        Preconditions.checkArgument((boolean)group.getId().equals((Object)GLOBAL), (String)"Unexpected resource group: %s", (Object)group.getId());
        group.setMaxQueuedQueries(this.maxQueued);
        group.setHardConcurrencyLimit(this.hardConcurrencyLimit);
    }

    public Optional<SelectionContext<VoidContext>> match(SelectionCriteria criteria) {
        return Optional.of(new SelectionContext(GLOBAL, (Object)VoidContext.NONE));
    }

    public SelectionContext<VoidContext> parentGroupContext(SelectionContext<VoidContext> context) {
        return new SelectionContext((ResourceGroupId)context.getResourceGroupId().getParent().orElseThrow(() -> new IllegalArgumentException("Group has no parent group: " + String.valueOf(context.getResourceGroupId()))), (Object)VoidContext.NONE);
    }

    static enum VoidContext {
        NONE;

    }
}

