/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.primitives.ImmutableLongArray;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.OutputDataSizeEstimate;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputDataSizeEstimatorFactory;
import java.util.Optional;
import java.util.function.Function;

public class ByTaskProgressOutputDataSizeEstimator
implements OutputDataSizeEstimator {
    private final double minSourceStageProgress;

    private ByTaskProgressOutputDataSizeEstimator(double minSourceStageProgress) {
        this.minSourceStageProgress = minSourceStageProgress;
    }

    @Override
    public Optional<OutputDataSizeEstimator.OutputDataSizeEstimateResult> getEstimatedOutputDataSize(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        if (!stageExecution.isNoMorePartitions()) {
            return Optional.empty();
        }
        int allPartitionsCount = stageExecution.getPartitionsCount();
        int remainingPartitionsCount = stageExecution.getRemainingPartitionsCount();
        if (remainingPartitionsCount == allPartitionsCount) {
            return Optional.empty();
        }
        double progress = (double)(allPartitionsCount - remainingPartitionsCount) / (double)allPartitionsCount;
        if (progress < this.minSourceStageProgress) {
            return Optional.empty();
        }
        long[] currentOutputDataSize = stageExecution.currentOutputDataSize();
        ImmutableLongArray.Builder estimateBuilder = ImmutableLongArray.builder((int)currentOutputDataSize.length);
        for (long partitionSize : currentOutputDataSize) {
            estimateBuilder.add((long)((double)partitionSize / progress));
        }
        return Optional.of(new OutputDataSizeEstimator.OutputDataSizeEstimateResult(new OutputDataSizeEstimate(estimateBuilder.build()), OutputDataSizeEstimator.OutputDataSizeEstimateStatus.ESTIMATED_BY_PROGRESS));
    }

    public static class Factory
    implements OutputDataSizeEstimatorFactory {
        @Override
        public OutputDataSizeEstimator create(Session session) {
            return new ByTaskProgressOutputDataSizeEstimator(SystemSessionProperties.getFaultTolerantExecutionMinSourceStageProgress(session));
        }
    }
}

