/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRankBuilder;
import io.trino.operator.GroupedTopNRowNumberBuilder;
import io.trino.operator.NoChannelGroupByHash;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.operator.SimplePageWithPositionEqualsAndHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TopNRankingOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localMemoryContext;
    private final int[] outputChannels;
    private final Supplier<GroupedTopNBuilder> groupedTopNBuilderSupplier;
    private final boolean partial;
    private final long maxFlushableBytes;
    private GroupedTopNBuilder groupedTopNBuilder;
    private boolean finishing;
    private Work<?> unfinishedWork;
    private Iterator<Page> outputIterator;

    public TopNRankingOperator(OperatorContext operatorContext, TopNRankingNode.RankingType rankingType, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int maxRankingPerPartition, boolean generateRanking, Optional<Integer> hashChannel, int expectedPositions, Optional<DataSize> maxPartialMemory, JoinCompiler joinCompiler, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators) {
        int[] groupByChannels;
        Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localMemoryContext = operatorContext.localUserMemoryContext();
        ImmutableList.Builder outputChannelsBuilder = ImmutableList.builder();
        for (int channel : Objects.requireNonNull(outputChannels, "outputChannels is null")) {
            outputChannelsBuilder.add((Object)channel);
        }
        if (generateRanking) {
            outputChannelsBuilder.add((Object)outputChannels.size());
        }
        this.outputChannels = Ints.toArray((Collection)outputChannelsBuilder.build());
        this.partial = !generateRanking;
        Preconditions.checkArgument((maxRankingPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRankingPerPartition must be > 0");
        Preconditions.checkArgument((maxPartialMemory.isEmpty() || !generateRanking ? 1 : 0) != 0, (Object)"no partial memory on final TopN");
        this.maxFlushableBytes = maxPartialMemory.map(DataSize::toBytes).orElse(Long.MAX_VALUE);
        if (hashChannel.isPresent()) {
            groupByChannels = new int[partitionChannels.size() + 1];
            for (int i = 0; i < partitionChannels.size(); ++i) {
                groupByChannels[i] = partitionChannels.get(i);
            }
            groupByChannels[partitionChannels.size()] = hashChannel.get();
        } else {
            groupByChannels = Ints.toArray(partitionChannels);
        }
        this.groupedTopNBuilderSupplier = TopNRankingOperator.getGroupedTopNBuilderSupplier(rankingType, (List<Type>)ImmutableList.copyOf(sourceTypes), sortChannels, sortOrders, maxRankingPerPartition, generateRanking, typeOperators, blockTypeOperators, groupByChannels, TopNRankingOperator.getGroupByHashSupplier(expectedPositions, partitionTypes, hashChannel.isPresent(), operatorContext.getSession(), joinCompiler, this::updateMemoryReservation));
    }

    private static Supplier<GroupByHash> getGroupByHashSupplier(int expectedPositions, List<Type> partitionTypes, boolean hasPrecomputedHash, Session session, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        if (partitionTypes.isEmpty()) {
            return Suppliers.ofInstance((Object)new NoChannelGroupByHash());
        }
        Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
        return () -> GroupByHash.createGroupByHash(session, partitionTypes, hasPrecomputedHash, expectedPositions, joinCompiler, updateMemory);
    }

    private static Supplier<GroupedTopNBuilder> getGroupedTopNBuilderSupplier(TopNRankingNode.RankingType rankingType, List<Type> sourceTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, int maxRankingPerPartition, boolean generateRanking, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators, int[] groupByChannels, Supplier<GroupByHash> groupByHashSupplier) {
        if (rankingType == TopNRankingNode.RankingType.ROW_NUMBER) {
            SimplePageWithPositionComparator comparator = new SimplePageWithPositionComparator(sourceTypes, sortChannels, sortOrders, typeOperators);
            return () -> new GroupedTopNRowNumberBuilder(sourceTypes, comparator, maxRankingPerPartition, generateRanking, groupByChannels, (GroupByHash)groupByHashSupplier.get());
        }
        if (rankingType == TopNRankingNode.RankingType.RANK) {
            SimplePageWithPositionComparator comparator = new SimplePageWithPositionComparator(sourceTypes, sortChannels, sortOrders, typeOperators);
            SimplePageWithPositionEqualsAndHash equalsAndHash = new SimplePageWithPositionEqualsAndHash((List<Type>)ImmutableList.copyOf(sourceTypes), sortChannels, blockTypeOperators);
            return () -> new GroupedTopNRankBuilder(sourceTypes, comparator, equalsAndHash, maxRankingPerPartition, generateRanking, groupByChannels, (GroupByHash)groupByHashSupplier.get());
        }
        if (rankingType == TopNRankingNode.RankingType.DENSE_RANK) {
            throw new UnsupportedOperationException();
        }
        throw new AssertionError((Object)("Unknown ranking type: " + String.valueOf((Object)rankingType)));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputIterator == null && this.groupedTopNBuilder == null && this.unfinishedWork == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && !this.isBuilderFull() && this.unfinishedWork == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((this.unfinishedWork == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when unfinished work is not empty");
        Preconditions.checkState((this.outputIterator == null ? 1 : 0) != 0, (Object)"Cannot add input with the operator when flushing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isBuilderFull() ? 1 : 0) != 0, (Object)"TopN buffer is already full");
        if (this.groupedTopNBuilder == null) {
            this.groupedTopNBuilder = (GroupedTopNBuilder)this.groupedTopNBuilderSupplier.get();
        }
        this.unfinishedWork = this.groupedTopNBuilder.processPage(page);
        if (this.unfinishedWork.process()) {
            this.unfinishedWork = null;
        }
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null) {
            boolean finished = this.unfinishedWork.process();
            this.updateMemoryReservation();
            if (!finished) {
                return null;
            }
            this.unfinishedWork = null;
        }
        if (!(this.finishing || this.partial && this.isBuilderFull() || this.outputIterator != null)) {
            return null;
        }
        if (this.outputIterator == null && this.groupedTopNBuilder != null) {
            this.outputIterator = this.groupedTopNBuilder.buildResult();
        }
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            this.closeGroupedTopNBuilder();
            return null;
        }
        Page output = this.outputIterator.next().getColumns(this.outputChannels);
        this.updateMemoryReservation();
        return output;
    }

    @Override
    public void close() {
        this.closeGroupedTopNBuilder();
    }

    private void closeGroupedTopNBuilder() {
        this.outputIterator = null;
        this.groupedTopNBuilder = null;
        this.localMemoryContext.setBytes(0L);
    }

    private boolean updateMemoryReservation() {
        if (this.groupedTopNBuilder == null) {
            this.localMemoryContext.setBytes(0L);
            return true;
        }
        this.localMemoryContext.setBytes(this.groupedTopNBuilder.getEstimatedSizeInBytes());
        if (this.partial) {
            return true;
        }
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    private boolean isBuilderFull() {
        return this.groupedTopNBuilder != null && this.groupedTopNBuilder.getEstimatedSizeInBytes() >= this.maxFlushableBytes;
    }

    @VisibleForTesting
    GroupedTopNBuilder getGroupedTopNBuilder() {
        return this.groupedTopNBuilder;
    }

    public static class TopNRankingOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final TopNRankingNode.RankingType rankingType;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrder;
        private final int maxRowCountPerPartition;
        private final boolean partial;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private final boolean generateRanking;
        private boolean closed;
        private final JoinCompiler joinCompiler;
        private final TypeOperators typeOperators;
        private final BlockTypeOperators blockTypeOperators;
        private final Optional<DataSize> maxPartialMemory;

        public TopNRankingOperatorFactory(int operatorId, PlanNodeId planNodeId, TopNRankingNode.RankingType rankingType, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, List<Integer> sortChannels, List<SortOrder> sortOrder, int maxRowCountPerPartition, boolean partial, Optional<Integer> hashChannel, int expectedPositions, Optional<DataSize> maxPartialMemory, JoinCompiler joinCompiler, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rankingType = Objects.requireNonNull(rankingType, "rankingType is null");
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels));
            this.sortOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrder));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.partial = partial;
            Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
            this.maxRowCountPerPartition = maxRowCountPerPartition;
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions must be > 0");
            this.generateRanking = !partial;
            this.expectedPositions = expectedPositions;
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
            this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TopNRankingOperator.class.getSimpleName());
            return new TopNRankingOperator(operatorContext, this.rankingType, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.generateRanking, this.hashChannel, this.expectedPositions, this.maxPartialMemory, this.joinCompiler, this.typeOperators, this.blockTypeOperators);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TopNRankingOperatorFactory(this.operatorId, this.planNodeId, this.rankingType, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.sortChannels, this.sortOrder, this.maxRowCountPerPartition, this.partial, this.hashChannel, this.expectedPositions, this.maxPartialMemory, this.joinCompiler, this.typeOperators, this.blockTypeOperators);
        }
    }
}

