/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class TryCastFunction
extends SqlScalarFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();

    public TryCastFunction() {
        super(FunctionMetadata.scalarBuilder((String)"TRY_CAST").signature(Signature.builder().castableToTypeParameter("F", new TypeSignature("T", new TypeSignatureParameter[0])).typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("F", new TypeSignatureParameter[0])).build()).nullable().hidden().noDescription().build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addCastSignature(new TypeSignature("F", new TypeSignatureParameter[0]), new TypeSignature("T", new TypeSignatureParameter[0])).build();
    }

    @Override
    public SpecializedSqlScalarFunction specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type fromType = boundSignature.getArgumentType(0);
        Type toType = boundSignature.getReturnType();
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        InvocationConvention invocationConvention = new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, false);
        MethodHandle coercion = functionDependencies.getCastImplementation(fromType, toType, invocationConvention).getMethodHandle();
        coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
        MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
        MethodHandle tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), tryCastHandle);
    }
}

