/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.table.json.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.json.JsonPathInvocationContext;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.operator.table.json.JsonTableColumn;
import io.trino.operator.table.json.JsonTableOrdinalityColumn;
import io.trino.operator.table.json.JsonTablePlanCross;
import io.trino.operator.table.json.JsonTablePlanLeaf;
import io.trino.operator.table.json.JsonTablePlanNode;
import io.trino.operator.table.json.JsonTablePlanSingle;
import io.trino.operator.table.json.JsonTablePlanUnion;
import io.trino.operator.table.json.JsonTableQueryColumn;
import io.trino.operator.table.json.JsonTableValueColumn;
import io.trino.operator.table.json.execution.Column;
import io.trino.operator.table.json.execution.FragmentCross;
import io.trino.operator.table.json.execution.FragmentLeaf;
import io.trino.operator.table.json.execution.FragmentSingle;
import io.trino.operator.table.json.execution.FragmentUnion;
import io.trino.operator.table.json.execution.JsonTableProcessingFragment;
import io.trino.operator.table.json.execution.OrdinalityColumn;
import io.trino.operator.table.json.execution.QueryColumn;
import io.trino.operator.table.json.execution.ValueColumn;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ExecutionPlanner {
    private ExecutionPlanner() {
    }

    public static JsonTableProcessingFragment getExecutionPlan(JsonTablePlanNode plan, Object[] newRow, boolean errorOnError, Type[] outputTypes, ConnectorSession session, Metadata metadata, TypeManager typeManager, FunctionManager functionManager) {
        if (plan instanceof JsonTablePlanLeaf) {
            JsonTablePlanLeaf planLeaf = (JsonTablePlanLeaf)plan;
            return new FragmentLeaf(planLeaf.path(), (List)planLeaf.columns().stream().map(column -> ExecutionPlanner.getColumn(column, outputTypes, session, functionManager)).collect(ImmutableList.toImmutableList()), errorOnError, newRow, session, metadata, typeManager, functionManager);
        }
        if (plan instanceof JsonTablePlanSingle) {
            JsonTablePlanSingle planSingle = (JsonTablePlanSingle)plan;
            return new FragmentSingle(planSingle.path(), (List)planSingle.columns().stream().map(column -> ExecutionPlanner.getColumn(column, outputTypes, session, functionManager)).collect(ImmutableList.toImmutableList()), errorOnError, planSingle.outer(), ExecutionPlanner.getExecutionPlan(planSingle.child(), newRow, errorOnError, outputTypes, session, metadata, typeManager, functionManager), newRow, session, metadata, typeManager, functionManager);
        }
        if (plan instanceof JsonTablePlanCross) {
            JsonTablePlanCross planCross = (JsonTablePlanCross)plan;
            return new FragmentCross((List)planCross.siblings().stream().map(sibling -> ExecutionPlanner.getExecutionPlan(sibling, newRow, errorOnError, outputTypes, session, metadata, typeManager, functionManager)).collect(ImmutableList.toImmutableList()));
        }
        JsonTablePlanUnion planUnion = (JsonTablePlanUnion)plan;
        return new FragmentUnion((List)planUnion.siblings().stream().map(sibling -> ExecutionPlanner.getExecutionPlan(sibling, newRow, errorOnError, outputTypes, session, metadata, typeManager, functionManager)).collect(ImmutableList.toImmutableList()), newRow);
    }

    private static Column getColumn(JsonTableColumn column, Type[] outputTypes, ConnectorSession session, FunctionManager functionManager) {
        if (column instanceof JsonTableValueColumn) {
            JsonPathInvocationContext context;
            JsonTableValueColumn valueColumn = (JsonTableValueColumn)column;
            ScalarFunctionImplementation implementation = functionManager.getScalarFunctionImplementation(valueColumn.function(), new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, true));
            Preconditions.checkArgument((boolean)implementation.getInstanceFactory().isPresent(), (Object)"instance factory is missing");
            try {
                context = ((MethodHandle)implementation.getInstanceFactory().get()).invoke();
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            return new ValueColumn(valueColumn.outputIndex(), implementation.getMethodHandle().bindTo(context).bindTo(session), valueColumn.path(), valueColumn.emptyBehavior(), valueColumn.emptyDefaultInput(), valueColumn.errorBehavior(), valueColumn.errorDefaultInput(), outputTypes[valueColumn.outputIndex()]);
        }
        if (column instanceof JsonTableQueryColumn) {
            JsonPathInvocationContext context;
            JsonTableQueryColumn queryColumn = (JsonTableQueryColumn)column;
            ScalarFunctionImplementation implementation = functionManager.getScalarFunctionImplementation(queryColumn.function(), new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, true));
            Preconditions.checkArgument((boolean)implementation.getInstanceFactory().isPresent(), (Object)"instance factory is missing");
            try {
                context = ((MethodHandle)implementation.getInstanceFactory().get()).invoke();
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            return new QueryColumn(queryColumn.outputIndex(), implementation.getMethodHandle().bindTo(context).bindTo(session), queryColumn.path(), queryColumn.wrapperBehavior(), queryColumn.emptyBehavior(), queryColumn.errorBehavior());
        }
        return new OrdinalityColumn(((JsonTableOrdinalityColumn)column).outputIndex());
    }
}

