/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.jsonpath.PathNodeRef;
import io.trino.sql.jsonpath.PathParser;
import io.trino.sql.jsonpath.tree.AbsMethod;
import io.trino.sql.jsonpath.tree.ArithmeticBinary;
import io.trino.sql.jsonpath.tree.ArithmeticUnary;
import io.trino.sql.jsonpath.tree.ArrayAccessor;
import io.trino.sql.jsonpath.tree.CeilingMethod;
import io.trino.sql.jsonpath.tree.ComparisonPredicate;
import io.trino.sql.jsonpath.tree.ConjunctionPredicate;
import io.trino.sql.jsonpath.tree.ContextVariable;
import io.trino.sql.jsonpath.tree.DatetimeMethod;
import io.trino.sql.jsonpath.tree.DescendantMemberAccessor;
import io.trino.sql.jsonpath.tree.DisjunctionPredicate;
import io.trino.sql.jsonpath.tree.DoubleMethod;
import io.trino.sql.jsonpath.tree.ExistsPredicate;
import io.trino.sql.jsonpath.tree.Filter;
import io.trino.sql.jsonpath.tree.FloorMethod;
import io.trino.sql.jsonpath.tree.IsUnknownPredicate;
import io.trino.sql.jsonpath.tree.JsonNullLiteral;
import io.trino.sql.jsonpath.tree.JsonPath;
import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.KeyValueMethod;
import io.trino.sql.jsonpath.tree.LastIndexVariable;
import io.trino.sql.jsonpath.tree.LikeRegexPredicate;
import io.trino.sql.jsonpath.tree.MemberAccessor;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.NegationPredicate;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.PredicateCurrentItemVariable;
import io.trino.sql.jsonpath.tree.SizeMethod;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.jsonpath.tree.StartsWithPredicate;
import io.trino.sql.jsonpath.tree.TypeMethod;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.Json2016Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JsonPathAnalyzer {
    private static final Type TYPE_METHOD_RESULT_TYPE = VarcharType.createVarcharType((int)27);
    private final Metadata metadata;
    private final Session session;
    private final ExpressionAnalyzer literalAnalyzer;
    private final Map<PathNodeRef<PathNode>, Type> types = new LinkedHashMap<PathNodeRef<PathNode>, Type>();
    private final Set<PathNodeRef<PathNode>> jsonParameters = new LinkedHashSet<PathNodeRef<PathNode>>();

    public JsonPathAnalyzer(Metadata metadata, Session session, ExpressionAnalyzer literalAnalyzer) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.literalAnalyzer = Objects.requireNonNull(literalAnalyzer, "literalAnalyzer is null");
    }

    public JsonPathAnalysis analyzeJsonPath(StringLiteral path, Map<String, Type> parameterTypes) {
        PathParser.Location pathStart = ExpressionTreeUtils.extractLocation((Node)path).map(location -> new PathParser.Location(location.getLineNumber(), location.getColumnNumber())).orElseThrow(() -> new IllegalStateException("missing NodeLocation in path"));
        PathNode root = PathParser.withRelativeErrorLocation((PathParser.Location)pathStart).parseJsonPath(path.getValue());
        new Visitor(parameterTypes, (Node)path).process(root);
        return new JsonPathAnalysis((JsonPath)root, this.types, this.jsonParameters);
    }

    public JsonPathAnalysis analyzeImplicitJsonPath(String path, NodeLocation location) {
        PathNode root = PathParser.withFixedErrorLocation((PathParser.Location)new PathParser.Location(location.getLineNumber(), location.getColumnNumber())).parseJsonPath(path);
        new Visitor((Map<String, Type>)ImmutableMap.of(), (Node)new StringLiteral(path)).process(root);
        return new JsonPathAnalysis((JsonPath)root, this.types, this.jsonParameters);
    }

    private class Visitor
    extends JsonPathTreeVisitor<Type, Void> {
        private final Map<String, Type> parameterTypes;
        private final Node pathNode;

        public Visitor(Map<String, Type> parameterTypes, Node pathNode) {
            this.parameterTypes = ImmutableMap.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
            this.pathNode = Objects.requireNonNull(pathNode, "pathNode is null");
        }

        protected Type visitPathNode(PathNode node, Void context) {
            throw new UnsupportedOperationException("not supported JSON path node: " + node.getClass().getSimpleName());
        }

        protected Type visitAbsMethod(AbsMethod node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null) {
                Type resultType;
                try {
                    resultType = JsonPathAnalyzer.this.metadata.resolveBuiltinFunction("abs", TypeSignatureProvider.fromTypes(sourceType)).getSignature().getReturnType();
                }
                catch (TrinoException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, e, "cannot perform JSON path abs() method with %s argument: %s", sourceType.getDisplayName(), e.getMessage());
                }
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), resultType);
                return resultType;
            }
            return null;
        }

        protected Type visitArithmeticBinary(ArithmeticBinary node, Void context) {
            Type leftType = (Type)this.process(node.getLeft());
            Type rightType = (Type)this.process(node.getRight());
            if (leftType != null && rightType != null) {
                BoundSignature signature;
                try {
                    signature = JsonPathAnalyzer.this.metadata.resolveOperator(OperatorType.valueOf((String)node.getOperator().name()), (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType)).getSignature();
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, (Throwable)((Object)e), "invalid operand types (%s and %s) in JSON path arithmetic binary expression: %s", leftType.getDisplayName(), rightType.getDisplayName(), e.getMessage());
                }
                Type resultType = signature.getReturnType();
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), resultType);
                return resultType;
            }
            return null;
        }

        protected Type visitArithmeticUnary(ArithmeticUnary node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null) {
                Type resultType;
                if (node.getSign() == ArithmeticUnary.Sign.PLUS) {
                    if (!ExpressionAnalyzer.isNumericType(sourceType)) {
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, "Invalid operand type (%s) in JSON path arithmetic unary expression", sourceType.getDisplayName());
                    }
                    JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), sourceType);
                    return sourceType;
                }
                try {
                    resultType = JsonPathAnalyzer.this.metadata.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)sourceType)).getSignature().getReturnType();
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, (Throwable)((Object)e), "invalid operand type (%s) in JSON path arithmetic unary expression: %s", sourceType.getDisplayName(), e.getMessage());
                }
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), resultType);
                return resultType;
            }
            return null;
        }

        protected Type visitArrayAccessor(ArrayAccessor node, Void context) {
            this.process(node.getBase());
            for (ArrayAccessor.Subscript subscript : node.getSubscripts()) {
                this.process(subscript.getFrom());
                subscript.getTo().ifPresent(arg_0 -> ((Visitor)this).process(arg_0));
            }
            return null;
        }

        protected Type visitCeilingMethod(CeilingMethod node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null) {
                Type resultType;
                try {
                    resultType = JsonPathAnalyzer.this.metadata.resolveBuiltinFunction("ceiling", TypeSignatureProvider.fromTypes(sourceType)).getSignature().getReturnType();
                }
                catch (TrinoException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, e, "cannot perform JSON path ceiling() method with %s argument: %s", sourceType.getDisplayName(), e.getMessage());
                }
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), resultType);
                return resultType;
            }
            return null;
        }

        protected Type visitContextVariable(ContextVariable node, Void context) {
            return null;
        }

        protected Type visitDatetimeMethod(DatetimeMethod node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null && !ExpressionAnalyzer.isCharacterStringType(sourceType)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, "JSON path datetime() method requires character string argument (found %s)", sourceType.getDisplayName());
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, this.pathNode, "datetime method in JSON path is not yet supported", new Object[0]);
        }

        protected Type visitDescendantMemberAccessor(DescendantMemberAccessor node, Void context) {
            this.process(node.getBase());
            return null;
        }

        protected Type visitDoubleMethod(DoubleMethod node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null) {
                if (!ExpressionAnalyzer.isStringType(sourceType) && !ExpressionAnalyzer.isNumericType(sourceType)) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, "cannot perform JSON path double() method with %s argument", sourceType.getDisplayName());
                }
                try {
                    JsonPathAnalyzer.this.metadata.getCoercion(sourceType, (Type)DoubleType.DOUBLE);
                }
                catch (OperatorNotFoundException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, (Throwable)((Object)e), "cannot perform JSON path double() method with %s argument: %s", sourceType.getDisplayName(), e.getMessage());
                }
            }
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)DoubleType.DOUBLE);
            return DoubleType.DOUBLE;
        }

        protected Type visitFilter(Filter node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            Type predicateType = (Type)this.process((PathNode)node.getPredicate());
            Objects.requireNonNull(predicateType, "missing type of predicate expression");
            Preconditions.checkState((boolean)predicateType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + predicateType.getDisplayName()));
            if (sourceType != null) {
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), sourceType);
                return sourceType;
            }
            return null;
        }

        protected Type visitFloorMethod(FloorMethod node, Void context) {
            Type sourceType = (Type)this.process(node.getBase());
            if (sourceType != null) {
                Type resultType;
                try {
                    resultType = JsonPathAnalyzer.this.metadata.resolveBuiltinFunction("floor", TypeSignatureProvider.fromTypes(sourceType)).getSignature().getReturnType();
                }
                catch (TrinoException e) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, e, "cannot perform JSON path floor() method with %s argument: %s", sourceType.getDisplayName(), e.getMessage());
                }
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), resultType);
                return resultType;
            }
            return null;
        }

        protected Type visitJsonNullLiteral(JsonNullLiteral node, Void context) {
            return null;
        }

        protected Type visitJsonPath(JsonPath node, Void context) {
            Type type = (Type)this.process(node.getRoot());
            if (type != null) {
                JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), type);
            }
            return type;
        }

        protected Type visitKeyValueMethod(KeyValueMethod node, Void context) {
            this.process(node.getBase());
            return null;
        }

        protected Type visitLastIndexVariable(LastIndexVariable node, Void context) {
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)IntegerType.INTEGER);
            return IntegerType.INTEGER;
        }

        protected Type visitMemberAccessor(MemberAccessor node, Void context) {
            this.process(node.getBase());
            return null;
        }

        protected Type visitNamedVariable(NamedVariable node, Void context) {
            Type parameterType = this.parameterTypes.get(node.getName());
            if (parameterType == null) {
                Optional<String> similarName = this.parameterTypes.keySet().stream().filter(name -> name.equalsIgnoreCase(node.getName())).findFirst();
                if (similarName.isPresent()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, "no value passed for parameter %s. Try quoting \"%s\" in the PASSING clause to match case", node.getName(), node.getName());
                }
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PATH, this.pathNode, "no value passed for parameter %s", node.getName());
            }
            if (parameterType.equals((Object)Json2016Type.JSON_2016)) {
                JsonPathAnalyzer.this.jsonParameters.add((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node));
                return null;
            }
            return null;
        }

        protected Type visitPredicateCurrentItemVariable(PredicateCurrentItemVariable node, Void context) {
            return null;
        }

        protected Type visitSizeMethod(SizeMethod node, Void context) {
            this.process(node.getBase());
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)IntegerType.INTEGER);
            return IntegerType.INTEGER;
        }

        protected Type visitSqlValueLiteral(SqlValueLiteral node, Void context) {
            Type type = JsonPathAnalyzer.this.literalAnalyzer.analyze((Expression)node.getValue(), Scope.create());
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), type);
            return type;
        }

        protected Type visitTypeMethod(TypeMethod node, Void context) {
            this.process(node.getBase());
            Type type = TYPE_METHOD_RESULT_TYPE;
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), type);
            return type;
        }

        protected Type visitComparisonPredicate(ComparisonPredicate node, Void context) {
            this.process(node.getLeft());
            this.process(node.getRight());
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitConjunctionPredicate(ConjunctionPredicate node, Void context) {
            Type leftType = (Type)this.process((PathNode)node.getLeft());
            Objects.requireNonNull(leftType, "missing type of predicate expression");
            Preconditions.checkState((boolean)leftType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + leftType.getDisplayName()));
            Type rightType = (Type)this.process((PathNode)node.getRight());
            Objects.requireNonNull(rightType, "missing type of predicate expression");
            Preconditions.checkState((boolean)rightType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + rightType.getDisplayName()));
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitDisjunctionPredicate(DisjunctionPredicate node, Void context) {
            Type leftType = (Type)this.process((PathNode)node.getLeft());
            Objects.requireNonNull(leftType, "missing type of predicate expression");
            Preconditions.checkState((boolean)leftType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + leftType.getDisplayName()));
            Type rightType = (Type)this.process((PathNode)node.getRight());
            Objects.requireNonNull(rightType, "missing type of predicate expression");
            Preconditions.checkState((boolean)rightType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + rightType.getDisplayName()));
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitExistsPredicate(ExistsPredicate node, Void context) {
            this.process(node.getPath());
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitLikeRegexPredicate(LikeRegexPredicate node, Void context) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, this.pathNode, "like_regex predicate in JSON path is not yet supported", new Object[0]);
        }

        protected Type visitNegationPredicate(NegationPredicate node, Void context) {
            Type predicateType = (Type)this.process((PathNode)node.getPredicate());
            Objects.requireNonNull(predicateType, "missing type of predicate expression");
            Preconditions.checkState((boolean)predicateType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + predicateType.getDisplayName()));
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitStartsWithPredicate(StartsWithPredicate node, Void context) {
            this.process(node.getWhole());
            this.process(node.getInitial());
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitIsUnknownPredicate(IsUnknownPredicate node, Void context) {
            Type predicateType = (Type)this.process((PathNode)node.getPredicate());
            Objects.requireNonNull(predicateType, "missing type of predicate expression");
            Preconditions.checkState((boolean)predicateType.equals((Object)BooleanType.BOOLEAN), (Object)("invalid type of predicate expression: " + predicateType.getDisplayName()));
            JsonPathAnalyzer.this.types.put((PathNodeRef<PathNode>)PathNodeRef.of((PathNode)node), (Type)BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }
    }

    public static class JsonPathAnalysis {
        private final JsonPath path;
        private final Map<PathNodeRef<PathNode>, Type> types;
        private final Set<PathNodeRef<PathNode>> jsonParameters;

        public JsonPathAnalysis(JsonPath path, Map<PathNodeRef<PathNode>, Type> types, Set<PathNodeRef<PathNode>> jsonParameters) {
            this.path = Objects.requireNonNull(path, "path is null");
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.jsonParameters = ImmutableSet.copyOf((Collection)Objects.requireNonNull(jsonParameters, "jsonParameters is null"));
        }

        public JsonPath getPath() {
            return this.path;
        }

        public Type getType(PathNode pathNode) {
            return this.types.get(PathNodeRef.of((PathNode)pathNode));
        }

        public Map<PathNodeRef<PathNode>, Type> getTypes() {
            return this.types;
        }

        public Set<PathNodeRef<PathNode>> getJsonParameters() {
            return this.jsonParameters;
        }
    }
}

