/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.planprinter.IoPlanPrinter;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Statement;
import io.trino.util.StatementUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final PlannerContext plannerContext;
    private final AnalyzerFactory analyzerFactory;
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final NodeVersion version;

    QueryExplainer(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, PlannerContext plannerContext, AnalyzerFactory analyzerFactory, StatementAnalyzerFactory statementAnalyzerFactory, StatsCalculator statsCalculator, CostCalculator costCalculator, NodeVersion version) {
        this.planOptimizers = Objects.requireNonNull(planOptimizersFactory.get(), "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.version = Objects.requireNonNull(version, "version is null");
    }

    public void validate(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        this.analyze(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts(), session, 0, false, Optional.of(this.version));
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.textDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), session, false, this.version);
            case ExplainType.Type.IO -> IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext, session);
            default -> throw new IllegalArgumentException("Unhandled plan type: " + String.valueOf(planType));
        };
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.graphvizDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector));
            default -> throw new IllegalArgumentException("Unhandled plan type: " + String.valueOf(planType));
        };
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.IO -> IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext, session);
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.jsonLogicalPlan(plan.getRoot(), session, plan.getTypes(), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts());
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.jsonDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), session);
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
        };
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.plannerContext, new TypeAnalyzer(this.plannerContext, this.statementAnalyzerFactory), this.statsCalculator, this.costCalculator, warningCollector, planOptimizersStatsCollector);
        return logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
    }

    private Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Analyzer analyzer = this.analyzerFactory.createAnalyzer(session, parameters, ParameterExtractor.bindParameters(statement, parameters), warningCollector, planOptimizersStatsCollector);
        return analyzer.analyze(statement, QueryType.EXPLAIN);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
        return this.planFragmenter.createSubPlans(session, plan, false, warningCollector);
    }

    private static <T extends Statement> Optional<String> explainDataDefinition(T statement, List<Expression> parameters) {
        if (!StatementUtils.isDataDefinitionStatement(statement.getClass())) {
            return Optional.empty();
        }
        if (statement instanceof CreateCatalog) {
            return Optional.of("CREATE CATALOG " + String.valueOf(((CreateCatalog)statement).getCatalogName()));
        }
        if (statement instanceof DropCatalog) {
            return Optional.of("DROP CATALOG " + String.valueOf(((DropCatalog)statement).getCatalogName()));
        }
        if (statement instanceof CreateSchema) {
            return Optional.of("CREATE SCHEMA " + String.valueOf(((CreateSchema)statement).getSchemaName()));
        }
        if (statement instanceof DropSchema) {
            return Optional.of("DROP SCHEMA " + String.valueOf(((DropSchema)statement).getSchemaName()));
        }
        if (statement instanceof CreateTable) {
            return Optional.of("CREATE TABLE " + String.valueOf(((CreateTable)statement).getName()));
        }
        if (statement instanceof CreateView) {
            return Optional.of("CREATE VIEW " + String.valueOf(((CreateView)statement).getName()));
        }
        if (statement instanceof CreateMaterializedView) {
            return Optional.of("CREATE MATERIALIZED VIEW " + String.valueOf(((CreateMaterializedView)statement).getName()));
        }
        if (statement instanceof Prepare) {
            return Optional.of("PREPARE " + String.valueOf(((Prepare)statement).getName()));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SqlFormatter.formatSql(statement));
        if (!parameters.isEmpty()) {
            builder.append("\n").append("Parameters: ").append(parameters);
        }
        return Optional.of(builder.toString());
    }
}

