/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.Session;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.NullLiteral;
import io.trino.type.TypeCoercion;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.zone.ZoneOffsetTransition;
import java.util.Objects;
import java.util.Optional;

public class UnwrapCastInComparison
extends ExpressionRewriteRuleSet {
    public UnwrapCastInComparison(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        super(UnwrapCastInComparison.createRewrite(plannerContext, typeAnalyzer));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        return (expression, context) -> UnwrapCastInComparison.unwrapCasts(context.getSession(), plannerContext, typeAnalyzer, context.getSymbolAllocator().getTypes(), expression);
    }

    public static Expression unwrapCasts(Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(plannerContext, typeAnalyzer, session, types), (Expression)expression);
    }

    private static Object withTimeZone(TimestampWithTimeZoneType type, Object value, TimeZoneKey newZone) {
        if (type.isShort()) {
            return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)((Long)value)), (TimeZoneKey)newZone);
        }
        LongTimestampWithTimeZone longTimestampWithTimeZone = (LongTimestampWithTimeZone)value;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)longTimestampWithTimeZone.getEpochMillis(), (int)longTimestampWithTimeZone.getPicosOfMilli(), (TimeZoneKey)newZone);
    }

    private static TimeZoneKey getTimeZone(TimestampWithTimeZoneType type, Object value) {
        if (type.isShort()) {
            return DateTimeEncoding.unpackZoneKey((long)((Long)value));
        }
        return TimeZoneKey.getTimeZoneKey((short)((LongTimestampWithTimeZone)value).getTimeZoneKey());
    }

    @VisibleForTesting
    static boolean isTimestampToTimestampWithTimeZoneInjectiveAt(ZoneId zone, Instant instant) {
        ZoneOffsetTransition transition = zone.getRules().previousTransition(instant.plusNanos(1L));
        return transition == null || transition.getDuration().isNegative() || transition.getDateTimeAfter().minusNanos(1L).atZone(zone).toInstant().isBefore(instant);
    }

    private static Instant getInstantWithTruncation(TimestampWithTimeZoneType type, Object value) {
        if (type.isShort()) {
            return Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)((Long)value)));
        }
        LongTimestampWithTimeZone longTimestampWithTimeZone = (LongTimestampWithTimeZone)value;
        return Instant.ofEpochMilli(longTimestampWithTimeZone.getEpochMillis()).plus((long)(longTimestampWithTimeZone.getPicosOfMilli() / 1000), ChronoUnit.NANOS);
    }

    public static Expression falseIfNotNull(Expression argument) {
        return ExpressionUtils.and(new Expression[]{new IsNullPredicate(argument), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN), false, true)});
    }

    public static Expression trueIfNotNull(Expression argument) {
        return ExpressionUtils.or(new Expression[]{new IsNotNullPredicate(argument), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN), false, true)});
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final PlannerContext plannerContext;
        private final TypeAnalyzer typeAnalyzer;
        private final Session session;
        private final TypeProvider types;
        private final InterpretedFunctionInvoker functionInvoker;
        private final LiteralEncoder literalEncoder;

        public Visitor(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, Session session, TypeProvider types) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
            this.literalEncoder = new LiteralEncoder(plannerContext);
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ComparisonExpression expression = (ComparisonExpression)treeRewriter.defaultRewrite((Expression)node, null);
            return this.unwrapCast(expression);
        }

        private Expression unwrapCast(ComparisonExpression expression) {
            Object literalInSourceType;
            ResolvedFunction targetToSource;
            Expression expression2 = expression.getLeft();
            if (!(expression2 instanceof Cast)) {
                return expression;
            }
            Cast cast = (Cast)expression2;
            Object right = new ExpressionInterpreter(expression.getRight(), this.plannerContext, this.session, this.typeAnalyzer.getTypes(this.session, this.types, expression.getRight())).optimize(NoOpSymbolResolver.INSTANCE);
            ComparisonExpression.Operator operator = expression.getOperator();
            if (right == null || right instanceof NullLiteral) {
                return switch (operator) {
                    default -> throw new MatchException(null, null);
                    case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN));
                    case ComparisonExpression.Operator.IS_DISTINCT_FROM -> new IsNotNullPredicate((Expression)cast);
                };
            }
            if (right instanceof Expression) {
                return expression;
            }
            Type sourceType = this.typeAnalyzer.getType(this.session, this.types, cast.getExpression());
            Type targetType = this.typeAnalyzer.getType(this.session, this.types, expression.getRight());
            if (sourceType instanceof TimestampType && targetType == DateType.DATE) {
                return this.unwrapTimestampToDateCast((TimestampType)sourceType, operator, cast.getExpression(), (Long)right).orElse((Expression)expression);
            }
            if (targetType instanceof TimestampWithTimeZoneType) {
                right = UnwrapCastInComparison.withTimeZone((TimestampWithTimeZoneType)targetType, right, this.session.getTimeZoneKey());
            }
            if (!this.hasInjectiveImplicitCoercion(sourceType, targetType, right)) {
                return expression;
            }
            if (TypeUtils.isFloatingPointNaN((Type)targetType, (Object)right)) {
                switch (operator) {
                    case EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                    }
                    case NOT_EQUAL: {
                        return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                    }
                    case IS_DISTINCT_FROM: {
                        if (this.typeHasNaN(sourceType)) break;
                        return BooleanLiteral.TRUE_LITERAL;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not yet implemented: " + String.valueOf(operator));
                    }
                }
            }
            ResolvedFunction sourceToTarget = this.plannerContext.getMetadata().getCoercion(sourceType, targetType);
            Optional sourceRange = sourceType.getRange();
            if (sourceRange.isPresent()) {
                Object max = ((Type.Range)sourceRange.get()).getMax();
                Object maxInTargetType = null;
                try {
                    maxInTargetType = this.coerce(max, sourceToTarget);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (maxInTargetType != null) {
                    int upperBoundComparison = this.compare(targetType, right, maxInTargetType);
                    if (upperBoundComparison > 0) {
                        return switch (operator) {
                            default -> throw new MatchException(null, null);
                            case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> BooleanLiteral.TRUE_LITERAL;
                        };
                    }
                    if (upperBoundComparison == 0) {
                        return switch (operator) {
                            default -> throw new MatchException(null, null);
                            case ComparisonExpression.Operator.GREATER_THAN -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.LESS_THAN -> new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                            case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.IS_DISTINCT_FROM -> new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                        };
                    }
                    Object min = ((Type.Range)sourceRange.get()).getMin();
                    Object minInTargetType = this.coerce(min, sourceToTarget);
                    int lowerBoundComparison = this.compare(targetType, right, minInTargetType);
                    if (lowerBoundComparison < 0) {
                        return switch (operator) {
                            default -> throw new MatchException(null, null);
                            case ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> BooleanLiteral.TRUE_LITERAL;
                        };
                    }
                    if (lowerBoundComparison == 0) {
                        return switch (operator) {
                            default -> throw new MatchException(null, null);
                            case ComparisonExpression.Operator.LESS_THAN -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                            case ComparisonExpression.Operator.GREATER_THAN -> new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                            case ComparisonExpression.Operator.EQUAL, ComparisonExpression.Operator.NOT_EQUAL, ComparisonExpression.Operator.IS_DISTINCT_FROM -> new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                        };
                    }
                }
            }
            try {
                targetToSource = this.plannerContext.getMetadata().getCoercion(targetType, sourceType);
            }
            catch (OperatorNotFoundException e) {
                return expression;
            }
            try {
                literalInSourceType = this.coerce(right, targetToSource);
            }
            catch (TrinoException e) {
                return expression;
            }
            if (targetType.isOrderable()) {
                Object roundtripLiteral = this.coerce(literalInSourceType, sourceToTarget);
                int literalVsRoundtripped = this.compare(targetType, right, roundtripLiteral);
                if (literalVsRoundtripped > 0) {
                    return switch (operator) {
                        default -> throw new MatchException(null, null);
                        case ComparisonExpression.Operator.EQUAL -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        case ComparisonExpression.Operator.NOT_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        case ComparisonExpression.Operator.IS_DISTINCT_FROM -> BooleanLiteral.TRUE_LITERAL;
                        case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> {
                            if (sourceRange.isPresent() && this.compare(sourceType, ((Type.Range)sourceRange.get()).getMin(), literalInSourceType) == 0) {
                                yield new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                            }
                            yield new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                        }
                        case ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    };
                }
                if (literalVsRoundtripped < 0) {
                    return switch (operator) {
                        default -> throw new MatchException(null, null);
                        case ComparisonExpression.Operator.EQUAL -> UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        case ComparisonExpression.Operator.NOT_EQUAL -> UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        case ComparisonExpression.Operator.IS_DISTINCT_FROM -> BooleanLiteral.TRUE_LITERAL;
                        case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                        case ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> sourceRange.isPresent() && this.compare(sourceType, ((Type.Range)sourceRange.get()).getMax(), literalInSourceType) == 0 ? new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType)) : new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    };
                }
            }
            return new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
        }

        private Optional<Expression> unwrapTimestampToDateCast(TimestampType sourceType, ComparisonExpression.Operator operator, Expression timestampExpression, long date) {
            ResolvedFunction targetToSource;
            try {
                targetToSource = this.plannerContext.getMetadata().getCoercion((Type)DateType.DATE, (Type)sourceType);
            }
            catch (OperatorNotFoundException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)((Object)e));
            }
            Expression dateTimestamp = this.literalEncoder.toExpression(this.coerce(date, targetToSource), (Type)sourceType);
            Expression nextDateTimestamp = this.literalEncoder.toExpression(this.coerce(date + 1L, targetToSource), (Type)sourceType);
            return switch (operator) {
                default -> throw new MatchException(null, null);
                case ComparisonExpression.Operator.EQUAL -> Optional.of(ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, timestampExpression, dateTimestamp), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, timestampExpression, nextDateTimestamp)}));
                case ComparisonExpression.Operator.NOT_EQUAL -> Optional.of(ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, timestampExpression, dateTimestamp), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, timestampExpression, nextDateTimestamp)}));
                case ComparisonExpression.Operator.LESS_THAN -> Optional.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, timestampExpression, dateTimestamp));
                case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> Optional.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, timestampExpression, nextDateTimestamp));
                case ComparisonExpression.Operator.GREATER_THAN -> Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, timestampExpression, nextDateTimestamp));
                case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, timestampExpression, dateTimestamp));
                case ComparisonExpression.Operator.IS_DISTINCT_FROM -> Optional.of(ExpressionUtils.or(new Expression[]{new IsNullPredicate(timestampExpression), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, timestampExpression, dateTimestamp), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, timestampExpression, nextDateTimestamp)}));
            };
        }

        private boolean hasInjectiveImplicitCoercion(Type source, Type target, Object value) {
            if (source.equals((Object)BigintType.BIGINT) && target.equals((Object)DoubleType.DOUBLE) || source.equals((Object)BigintType.BIGINT) && target.equals((Object)RealType.REAL) || source.equals((Object)IntegerType.INTEGER) && target.equals((Object)RealType.REAL)) {
                if (target.equals((Object)DoubleType.DOUBLE)) {
                    double doubleValue = (Double)value;
                    return doubleValue > 9.223372036854776E18 || doubleValue < -9.223372036854776E18 || Double.isNaN(doubleValue) || doubleValue > -9.007199254740992E15 && doubleValue < 9.007199254740992E15;
                }
                float realValue = Float.intBitsToFloat(Math.toIntExact((Long)value));
                return source.equals((Object)BigintType.BIGINT) && (realValue > 9.223372E18f || realValue < -9.223372E18f) || source.equals((Object)IntegerType.INTEGER) && (realValue > 2.1474836E9f || realValue < -2.1474836E9f) || Float.isNaN(realValue) || realValue > -8388608.0f && realValue < 8388608.0f;
            }
            if (source instanceof DecimalType) {
                int precision = ((DecimalType)source).getPrecision();
                if (precision > 15 && target.equals((Object)DoubleType.DOUBLE)) {
                    return false;
                }
                if (precision > 7 && target.equals((Object)RealType.REAL)) {
                    return false;
                }
            }
            if (target instanceof TimestampWithTimeZoneType) {
                TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)target;
                if (source instanceof DateType) {
                    if (!UnwrapCastInComparison.getTimeZone(timestampWithTimeZoneType, value).equals((Object)this.session.getTimeZoneKey())) {
                        return false;
                    }
                    return UnwrapCastInComparison.isTimestampToTimestampWithTimeZoneInjectiveAt(this.session.getTimeZoneKey().getZoneId(), UnwrapCastInComparison.getInstantWithTruncation(timestampWithTimeZoneType, value));
                }
                if (source instanceof TimestampType) {
                    if (!UnwrapCastInComparison.getTimeZone(timestampWithTimeZoneType, value).equals((Object)this.session.getTimeZoneKey())) {
                        return false;
                    }
                    return UnwrapCastInComparison.isTimestampToTimestampWithTimeZoneInjectiveAt(this.session.getTimeZoneKey().getZoneId(), UnwrapCastInComparison.getInstantWithTruncation(timestampWithTimeZoneType, value));
                }
                return false;
            }
            if (target instanceof TimeWithTimeZoneType) {
                return false;
            }
            boolean coercible = new TypeCoercion(arg_0 -> ((TypeManager)this.plannerContext.getTypeManager()).getType(arg_0)).canCoerce(source, target);
            if (source instanceof VarcharType) {
                VarcharType sourceVarchar = (VarcharType)source;
                if (target instanceof CharType) {
                    CharType targetChar = (CharType)target;
                    if (sourceVarchar.isUnbounded() || sourceVarchar.getBoundedLength() > targetChar.getLength()) {
                        return false;
                    }
                    Verify.verify((boolean)coercible, (String)"%s was expected to be coercible to %s", (Object)source, (Object)target);
                    if (sourceVarchar.getBoundedLength() == 0) {
                        return true;
                    }
                    int actualLengthWithoutSpaces = SliceUtf8.countCodePoints((Slice)((Slice)value));
                    Verify.verify((actualLengthWithoutSpaces <= targetChar.getLength() ? 1 : 0) != 0, (String)"Incorrect char value [%s] for %s", (Object)((Slice)value).toStringUtf8(), (Object)targetChar);
                    return sourceVarchar.getBoundedLength() == actualLengthWithoutSpaces;
                }
            }
            return coercible;
        }

        private Object coerce(Object value, ResolvedFunction coercion) {
            return this.functionInvoker.invoke(coercion, this.session.toConnectorSession(), value);
        }

        private boolean typeHasNaN(Type type) {
            return type instanceof DoubleType || type instanceof RealType;
        }

        private int compare(Type type, Object first, Object second) {
            Objects.requireNonNull(first, "first is null");
            Objects.requireNonNull(second, "second is null");
            MethodHandle comparisonOperator = this.plannerContext.getTypeOperators().getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            try {
                return Math.toIntExact(comparisonOperator.invoke(first, second));
            }
            catch (Throwable throwable) {
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
            }
        }
    }
}

