/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import io.airlift.slice.SizeOf;
import java.util.Objects;

@Immutable
public class DynamicFilterId {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DynamicFilterId.class);
    private final String id;

    @JsonCreator
    public DynamicFilterId(String id) {
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicFilterId that = (DynamicFilterId)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.id);
    }
}

