/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import io.trino.spi.type.TimeZoneKey;
import java.util.Arrays;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.joda.time.DateTimeZone;

public final class GenerateTimeZoneIndex {
    private GenerateTimeZoneIndex() {
    }

    public static void main(String[] args) throws InterruptedException {
        short zoneKey;
        short zoneKey2;
        String zoneId;
        int offset;
        System.out.println("#");
        System.out.println("# DO NOT REMOVE OR MODIFY EXISTING ENTRIES");
        System.out.println("#");
        System.out.println("# This file contain the fixed numeric id of every supported time zone id.");
        System.out.println("# Every zone id in this file must be supported by java.util.TimeZone and the");
        System.out.println("# Joda time library.  This is because Trino uses both java.util.TimeZone and");
        System.out.println("# the Joda time## for during execution.");
        System.out.println("#");
        System.out.println("# suppress inspection \"UnusedProperty\" for whole file");
        short nextZoneKey = 1;
        for (offset = 840; offset > 0; --offset) {
            zoneId = String.format("-%02d:%02d", offset / 60, Math.abs(offset % 60));
            short s = nextZoneKey;
            nextZoneKey = (short)(nextZoneKey + 1);
            zoneKey2 = s;
            System.out.println(zoneKey2 + " " + zoneId);
        }
        for (offset = 1; offset <= 840; ++offset) {
            zoneId = String.format("+%02d:%02d", offset / 60, Math.abs(offset % 60));
            short s = nextZoneKey;
            nextZoneKey = (short)(nextZoneKey + 1);
            zoneKey2 = s;
            System.out.println(zoneKey2 + " " + zoneId);
        }
        TreeSet jodaZones = new TreeSet(DateTimeZone.getAvailableIDs());
        TreeSet<String> jdkZones = new TreeSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        TreeSet zoneIds = new TreeSet(Sets.filter((Set)Sets.intersection(jodaZones, jdkZones), (Predicate)Predicates.not(GenerateTimeZoneIndex.ignoredZone())));
        for (String zoneId2 : zoneIds) {
            if (zoneId2.indexOf(47) < 0) continue;
            short s = nextZoneKey;
            nextZoneKey = (short)(nextZoneKey + 1);
            zoneKey = s;
            System.out.println(zoneKey + " " + zoneId2);
        }
        for (String zoneId2 : zoneIds) {
            if (zoneId2.indexOf(47) >= 0) continue;
            short s = nextZoneKey;
            nextZoneKey = (short)(nextZoneKey + 1);
            zoneKey = s;
            System.out.println(zoneKey + " " + zoneId2);
        }
        System.out.println();
        System.out.println("# Zones not supported in Java");
        for (String invalidZone : Sets.filter((Set)Sets.difference(jodaZones, jdkZones), (Predicate)Predicates.not(GenerateTimeZoneIndex.ignoredZone()))) {
            System.out.println("# " + invalidZone);
        }
        System.out.println();
        System.out.println("# Zones not supported in Joda");
        for (String invalidZone : Sets.filter((Set)Sets.difference(jdkZones, jodaZones), (Predicate)Predicates.not(GenerateTimeZoneIndex.ignoredZone()))) {
            System.out.println("# " + invalidZone);
        }
        Thread.sleep(1000L);
    }

    public static Predicate<String> ignoredZone() {
        return zoneId -> TimeZoneKey.isUtcZoneId((String)zoneId) || zoneId.startsWith("Etc/");
    }
}

