/*
 * Decompiled with CFR 0.152.
 */
package io.trino.eventlistener;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Key;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.eventlistener.EventListenerManager;
import io.trino.spi.Plugin;
import io.trino.spi.eventlistener.EventListener;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConnectorEventListener {
    @Test
    public void testConnectorWithoutEventListener() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().build());
        ((EventListenerManager)queryRunner.getServer().getInstance(Key.get(EventListenerManager.class))).loadEventListeners();
        Assertions.assertThatCode(() -> queryRunner.execute("SELECT 1")).doesNotThrowAnyException();
    }

    @Test
    public void testConnectorWithEventListener() {
        MockEventListenerFactory listenerFactory = new MockEventListenerFactory();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().build());
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withEventListener(listenerFactory).build()));
        queryRunner.createCatalog("event_listening", "mock", (Map)ImmutableMap.of());
        ((EventListenerManager)queryRunner.getServer().getInstance(Key.get(EventListenerManager.class))).loadEventListeners();
        Assertions.assertThat((AtomicLong)listenerFactory.getEventListenerInvocationCounter).hasValue(1L);
    }

    private static class MockEventListenerFactory
    implements Supplier<EventListener> {
        private final AtomicLong getEventListenerInvocationCounter = new AtomicLong(0L);

        private MockEventListenerFactory() {
        }

        @Override
        public EventListener get() {
            this.getEventListenerInvocationCounter.incrementAndGet();
            return new EventListener(this){};
        }
    }
}

