/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.units.Duration;
import io.trino.execution.SplitConcurrencyController;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSplitConcurrencyController {
    @Test
    public void testRampup() {
        SplitConcurrencyController controller = new SplitConcurrencyController(1, new Duration(1.0, TimeUnit.SECONDS));
        for (int i = 0; i < 10; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(2L), 0.0, i + 1);
            Assertions.assertThat((int)controller.getTargetConcurrency()).isEqualTo(i + 2);
        }
    }

    @Test
    public void testRampdown() {
        SplitConcurrencyController controller = new SplitConcurrencyController(10, new Duration(1.0, TimeUnit.SECONDS));
        for (int i = 0; i < 9; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(2L), 1.0, 10 - i);
            controller.splitFinished(TimeUnit.SECONDS.toNanos(30L), 1.0, 10 - i);
            Assertions.assertThat((int)controller.getTargetConcurrency()).isEqualTo(10 - i - 1);
        }
    }

    @Test
    public void testRapidAdjustForQuickSplits() {
        int i;
        SplitConcurrencyController controller = new SplitConcurrencyController(10, new Duration(1.0, TimeUnit.SECONDS));
        for (i = 0; i < 9; ++i) {
            controller.update(TimeUnit.MILLISECONDS.toNanos(200L), 1.0, 10 - i);
            controller.splitFinished(TimeUnit.MILLISECONDS.toNanos(100L), 1.0, 10 - i);
            Assertions.assertThat((int)controller.getTargetConcurrency()).isEqualTo(10 - i - 1);
        }
        controller.update(TimeUnit.SECONDS.toNanos(30L), 0.0, 1);
        for (i = 0; i < 10; ++i) {
            controller.update(TimeUnit.SECONDS.toNanos(200L), 0.0, i + 1);
            controller.splitFinished(TimeUnit.MILLISECONDS.toNanos(100L), 0.0, i + 1);
            Assertions.assertThat((int)controller.getTargetConcurrency()).isEqualTo(i + 2);
        }
    }
}

