/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.TaskManagerConfig;
import io.trino.util.MachineInfo;
import it.unimi.dsi.fastutil.HashCommon;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestTaskManagerConfig {
    private static final int DEFAULT_PROCESSOR_COUNT = Math.clamp((long)HashCommon.nextPowerOfTwo((int)MachineInfo.getAvailablePhysicalProcessorCount()), 2, 32);
    private static final int DEFAULT_MAX_WRITER_COUNT = Math.clamp((long)HashCommon.nextPowerOfTwo((int)(MachineInfo.getAvailablePhysicalProcessorCount() * 2)), 2, 64);

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TaskManagerConfig)ConfigAssertions.recordDefaults(TaskManagerConfig.class)).setThreadPerDriverSchedulerEnabled(false).setInitialSplitsPerNode(Runtime.getRuntime().availableProcessors() * 2).setSplitConcurrencyAdjustmentInterval(new Duration(100.0, TimeUnit.MILLISECONDS)).setStatusRefreshMaxWait(new Duration(1.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(3.0, TimeUnit.SECONDS)).setTaskTerminationTimeout(new Duration(1.0, TimeUnit.MINUTES)).setPerOperatorCpuTimerEnabled(true).setTaskCpuTimerEnabled(true).setMaxWorkerThreads(Runtime.getRuntime().availableProcessors() * 2).setMinDrivers(Runtime.getRuntime().availableProcessors() * 2 * 2).setMinDriversPerTask(3).setMaxDriversPerTask(Integer.MAX_VALUE).setInfoMaxAge(new Duration(15.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(2.0, TimeUnit.MINUTES)).setMaxIndexMemoryUsage(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setShareIndexLoading(false).setMaxPartialAggregationMemoryUsage(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartialTopNMemory(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSinkMaxBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSinkMaxBroadcastBufferSize(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPagePartitioningBufferPoolSize(8).setScaleWritersEnabled(true).setMinWriterCount(1).setMaxWriterCount(DEFAULT_MAX_WRITER_COUNT).setTaskConcurrency(DEFAULT_PROCESSOR_COUNT).setHttpResponseThreads(100).setHttpTimeoutThreads(3).setTaskNotificationThreads(5).setTaskYieldThreads(3).setDriverTimeoutThreads(5).setLevelTimeMultiplier(new BigDecimal("2")).setStatisticsCpuTimerEnabled(true).setInterruptStuckSplitTasksEnabled(true).setInterruptStuckSplitTasksWarningThreshold(new Duration(10.0, TimeUnit.MINUTES)).setInterruptStuckSplitTasksTimeout(new Duration(15.0, TimeUnit.MINUTES)).setInterruptStuckSplitTasksDetectionInterval(new Duration(2.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        int processorCount = DEFAULT_PROCESSOR_COUNT == 32 ? 16 : 32;
        int maxWriterCount = DEFAULT_MAX_WRITER_COUNT == 32 ? 16 : 32;
        ImmutableMap properties = ImmutableMap.builder().put((Object)"experimental.thread-per-driver-scheduler-enabled", (Object)"true").put((Object)"task.initial-splits-per-node", (Object)"1").put((Object)"task.split-concurrency-adjustment-interval", (Object)"3s").put((Object)"task.status-refresh-max-wait", (Object)"2s").put((Object)"task.info-update-interval", (Object)"2s").put((Object)"task.termination-timeout", (Object)"15s").put((Object)"task.per-operator-cpu-timer-enabled", (Object)"false").put((Object)"task.cpu-timer-enabled", (Object)"false").put((Object)"task.max-index-memory", (Object)"512MB").put((Object)"task.share-index-loading", (Object)"true").put((Object)"task.max-partial-aggregation-memory", (Object)"32MB").put((Object)"task.max-partial-top-n-memory", (Object)"32MB").put((Object)"task.max-local-exchange-buffer-size", (Object)"33MB").put((Object)"task.max-worker-threads", (Object)"3").put((Object)"task.min-drivers", (Object)"2").put((Object)"task.min-drivers-per-task", (Object)"5").put((Object)"task.max-drivers-per-task", (Object)"13").put((Object)"task.info.max-age", (Object)"22m").put((Object)"task.client.timeout", (Object)"10s").put((Object)"sink.max-buffer-size", (Object)"42MB").put((Object)"sink.max-broadcast-buffer-size", (Object)"128MB").put((Object)"driver.max-page-partitioning-buffer-size", (Object)"40MB").put((Object)"driver.page-partitioning-buffer-pool-size", (Object)"0").put((Object)"task.scale-writers.enabled", (Object)"false").put((Object)"task.min-writer-count", (Object)"4").put((Object)"task.max-writer-count", (Object)Integer.toString(maxWriterCount)).put((Object)"task.concurrency", (Object)Integer.toString(processorCount)).put((Object)"task.http-response-threads", (Object)"4").put((Object)"task.http-timeout-threads", (Object)"10").put((Object)"task.task-notification-threads", (Object)"13").put((Object)"task.task-yield-threads", (Object)"8").put((Object)"task.driver-timeout-threads", (Object)"10").put((Object)"task.level-time-multiplier", (Object)"2.1").put((Object)"task.statistics-cpu-timer-enabled", (Object)"false").put((Object)"task.interrupt-stuck-split-tasks-enabled", (Object)"false").put((Object)"task.interrupt-stuck-split-tasks-warning-threshold", (Object)"3m").put((Object)"task.interrupt-stuck-split-tasks-timeout", (Object)"4m").put((Object)"task.interrupt-stuck-split-tasks-detection-interval", (Object)"10m").buildOrThrow();
        TaskManagerConfig expected = new TaskManagerConfig().setThreadPerDriverSchedulerEnabled(true).setInitialSplitsPerNode(1).setSplitConcurrencyAdjustmentInterval(new Duration(3.0, TimeUnit.SECONDS)).setStatusRefreshMaxWait(new Duration(2.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(2.0, TimeUnit.SECONDS)).setTaskTerminationTimeout(new Duration(15.0, TimeUnit.SECONDS)).setPerOperatorCpuTimerEnabled(false).setTaskCpuTimerEnabled(false).setMaxIndexMemoryUsage(DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setShareIndexLoading(true).setMaxPartialAggregationMemoryUsage(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPartialTopNMemory(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxWorkerThreads(3).setMinDrivers(2).setMinDriversPerTask(5).setMaxDriversPerTask(13).setInfoMaxAge(new Duration(22.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSinkMaxBufferSize(DataSize.of((long)42L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSinkMaxBroadcastBufferSize(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPagePartitioningBufferPoolSize(0).setScaleWritersEnabled(false).setMinWriterCount(4).setMaxWriterCount(maxWriterCount).setTaskConcurrency(processorCount).setHttpResponseThreads(4).setHttpTimeoutThreads(10).setTaskNotificationThreads(13).setTaskYieldThreads(8).setDriverTimeoutThreads(10).setLevelTimeMultiplier(new BigDecimal("2.1")).setStatisticsCpuTimerEnabled(false).setInterruptStuckSplitTasksEnabled(false).setInterruptStuckSplitTasksWarningThreshold(new Duration(3.0, TimeUnit.MINUTES)).setInterruptStuckSplitTasksTimeout(new Duration(4.0, TimeUnit.MINUTES)).setInterruptStuckSplitTasksDetectionInterval(new Duration(10.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

