/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.tracing.Tracing;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.PartitionedSplitsInfo;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlStage;
import io.trino.execution.StageId;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TableInfo;
import io.trino.execution.scheduler.DynamicSplitPlacementPolicy;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.PartitionedPipelinedOutputBufferManager;
import io.trino.execution.scheduler.PipelinedStageExecution;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourcePartitionedScheduler;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.execution.scheduler.TaskLifecycleListener;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.failuredetector.FailureDetector;
import io.trino.failuredetector.NoOpFailureDetector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.operator.RetryPolicy;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.split.ConnectorAwareSplitSource;
import io.trino.split.SplitSource;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSourcePartitionedScheduler {
    private static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("plan_id");
    private static final QueryId QUERY_ID = new QueryId("query");
    private static final DynamicFilterId DYNAMIC_FILTER_ID = new DynamicFilterId("filter1");
    private final ExecutorService queryExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stageExecutor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"stageScheduledExecutor-%s"));
    private final InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[0]);
    private final FinalizerService finalizerService = new FinalizerService();
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
    private final TypeOperators typeOperators = new TypeOperators();
    private final Session session = TestingSession.testSessionBuilder().build();

    public TestSourcePartitionedScheduler() {
        this.nodeManager.addNodes(new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
    }

    @BeforeAll
    public void setUp() {
        this.finalizerService.start();
    }

    @AfterAll
    public void destroyExecutor() {
        this.queryExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.finalizerService.destroy();
    }

    @Test
    public void testScheduleNoSplits() {
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(0, TestingSplit::createRemoteSplit), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(1);
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
        stage.abort();
    }

    @Test
    public void testDoesNotScheduleEmptySplit() {
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        ConnectorSplitSource splitSource = TestSourcePartitionedScheduler.createFixedSplitSource(2, TestingSplit::createRemoteSplit);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(splitSource, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        Assertions.assertThat((int)scheduler.schedule().getNewTasks().size()).isEqualTo(1);
        splitSource.getNextBatch(1);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(0);
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
        stage.abort();
    }

    @Test
    public void testScheduleSplitsOneAtATime() {
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(60, TestingSplit::createRemoteSplit), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        for (int i = 0; i < 60; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 59) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assertions.assertThat((boolean)scheduleResult.isFinished()).isFalse();
            }
            Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
            Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(i < 3 ? 1 : 0);
            Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(i < 3 ? i + 1 : 3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBatched() {
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(60, TestingSplit::createRemoteSplit), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 7, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        for (int i = 0; i <= 8; ++i) {
            ScheduleResult scheduleResult = scheduler.schedule();
            if (i == 8) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assertions.assertThat((boolean)scheduleResult.isFinished()).isFalse();
            }
            Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
            Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(i == 0 ? 3 : 0);
            Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min((i + 1) * 7, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSplitsBlock() {
        PartitionedSplitsInfo splitsInfo;
        ScheduleResult scheduleResult;
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(80, TestingSplit::createRemoteSplit), stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        for (int i = 0; i <= 60; ++i) {
            scheduleResult = scheduler.schedule();
            Assertions.assertThat((boolean)scheduleResult.isFinished()).isFalse();
            Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isEqualTo(i != 60);
            Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(i < 3 ? 1 : 0);
            Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(i < 3 ? i + 1 : 3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 1, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(20);
        }
        ((MockRemoteTaskFactory.MockRemoteTask)stage.getAllTasks().get(0)).clearSplits();
        for (int i = 0; i < 20; ++i) {
            scheduleResult = scheduler.schedule();
            if (i == 19) {
                TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, scheduler);
            } else {
                Assertions.assertThat((boolean)scheduleResult.isFinished()).isFalse();
            }
            Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
            Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(0);
            Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(3);
            TestSourcePartitionedScheduler.assertPartitionedSplitCount(stage, Integer.min(i + 41, 60));
        }
        for (RemoteTask remoteTask : stage.getAllTasks()) {
            splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(20);
        }
        stage.abort();
    }

    @Test
    public void testScheduleSlowSplitSource() {
        QueuedSplitSource queuedSplitSource = new QueuedSplitSource(TestingSplit::createRemoteSplit);
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = this.getSourcePartitionedScheduler(queuedSplitSource, stage, (InternalNodeManager)this.nodeManager, nodeTaskMap, 1, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((boolean)scheduleResult.isFinished()).isFalse();
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isFalse();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(0);
        Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(0);
        queuedSplitSource.addSplits(1);
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
    }

    @Test
    public void testNoNodes() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> {
            NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
            InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[0]);
            NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap));
            PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
            StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
            StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((StageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(TestingHandles.TEST_CATALOG_HANDLE, TestSourcePartitionedScheduler.createFixedSplitSource(20, TestingSplit::createRemoteSplit)), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE)), () -> ((StageExecution)stage).getAllTasks()), (int)2, (DynamicFilterService)new DynamicFilterService(this.metadata, this.functionManager, this.typeOperators, new DynamicFilterConfig()), (TableExecuteContextManager)new TableExecuteContextManager(), () -> false);
            scheduler.schedule();
        }).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NO_NODES_AVAILABLE});
    }

    @Test
    public void testWorkerBalancedSplitAssignment() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        PlanFragment firstPlan = TestSourcePartitionedScheduler.createFragment();
        StageExecution firstStage = this.createStageExecution(firstPlan, nodeTaskMap);
        StageScheduler firstScheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(15, TestingSplit::createRemoteSplit), firstStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200, NodeSchedulerConfig.SplitsBalancingPolicy.NODE);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(3);
        Assertions.assertThat((int)firstStage.getAllTasks().size()).isEqualTo(3);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(5);
        }
        InternalNode additionalNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        nodeManager.addNodes(new InternalNode[]{additionalNode});
        PlanFragment secondPlan = TestSourcePartitionedScheduler.createFragment();
        StageExecution secondStage = this.createStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(5, TestingSplit::createRemoteSplit), secondStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200, NodeSchedulerConfig.SplitsBalancingPolicy.NODE);
        scheduleResult = secondScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, secondScheduler);
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(1);
        Assertions.assertThat((int)secondStage.getAllTasks().size()).isEqualTo(1);
        RemoteTask task = (RemoteTask)secondStage.getAllTasks().get(0);
        Assertions.assertThat((int)task.getPartitionedSplitsInfo().getCount()).isEqualTo(5);
        firstStage.abort();
        secondStage.abort();
    }

    @Test
    public void testStageBalancedSplitAssignment() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        PlanFragment firstPlan = TestSourcePartitionedScheduler.createFragment();
        StageExecution firstStage = this.createStageExecution(firstPlan, nodeTaskMap);
        QueuedSplitSource firstSplitSource = new QueuedSplitSource(TestingSplit::createRemoteSplit);
        StageScheduler firstScheduler = this.getSourcePartitionedScheduler(firstSplitSource, firstStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        firstSplitSource.addSplits(15);
        ScheduleResult scheduleResult = firstScheduler.schedule();
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(3);
        Assertions.assertThat((int)firstStage.getAllTasks().size()).isEqualTo(3);
        for (Object remoteTask : firstStage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(5);
        }
        InternalNode additionalNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        nodeManager.addNodes(new InternalNode[]{additionalNode});
        firstSplitSource.addSplits(5);
        firstSplitSource.close();
        scheduleResult = firstScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, firstScheduler);
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(1);
        Assertions.assertThat((int)firstStage.getAllTasks().size()).isEqualTo(4);
        for (RemoteTask remoteTask : firstStage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(5);
        }
        InternalNode anotherAdditionalNode = new InternalNode("other5", URI.create("http://127.0.0.1:15"), NodeVersion.UNKNOWN, false);
        nodeManager.addNodes(new InternalNode[]{anotherAdditionalNode});
        PlanFragment secondPlan = TestSourcePartitionedScheduler.createFragment();
        StageExecution secondStage = this.createStageExecution(secondPlan, nodeTaskMap);
        StageScheduler secondScheduler = this.getSourcePartitionedScheduler(TestSourcePartitionedScheduler.createFixedSplitSource(5, TestingSplit::createRemoteSplit), secondStage, (InternalNodeManager)nodeManager, nodeTaskMap, 200, NodeSchedulerConfig.SplitsBalancingPolicy.STAGE);
        scheduleResult = secondScheduler.schedule();
        TestSourcePartitionedScheduler.assertEffectivelyFinished(scheduleResult, secondScheduler);
        Assertions.assertThat((int)secondStage.getAllTasks().size()).isEqualTo(5);
        for (RemoteTask remoteTask : secondStage.getAllTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(1);
        }
        firstStage.abort();
        secondStage.abort();
    }

    @Test
    public void testNewTaskScheduledWhenChildStageBufferIsUnderutilized() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS)));
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((StageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(TestingHandles.TEST_CATALOG_HANDLE, TestSourcePartitionedScheduler.createFixedSplitSource(1200, TestingSplit::createRemoteSplit)), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE)), () -> ((StageExecution)stage).getAllTasks()), (int)1200, (DynamicFilterService)new DynamicFilterService(this.metadata, this.functionManager, this.typeOperators, new DynamicFilterConfig()), (TableExecuteContextManager)new TableExecuteContextManager(), () -> false);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((Comparable)((ScheduleResult.BlockedReason)scheduleResult.getBlockedReason().get())).isEqualTo((Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(3);
        Assertions.assertThat((int)scheduleResult.getSplitsScheduled()).isEqualTo(768);
        for (RemoteTask remoteTask : scheduleResult.getNewTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(256);
        }
        nodeManager.addNodes(new InternalNode[]{new InternalNode("other4", URI.create("http://127.0.0.4:14"), NodeVersion.UNKNOWN, false)});
        scheduleResult = scheduler.schedule();
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)((ScheduleResult.BlockedReason)scheduleResult.getBlockedReason().get())).isEqualTo((Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assertions.assertThat((int)scheduleResult.getSplitsScheduled()).isEqualTo(256);
    }

    @Test
    public void testNoNewTaskScheduledWhenChildStageBufferIsOverutilized() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager(new InternalNode[]{new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false), new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false), new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)});
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS)));
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((StageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(TestingHandles.TEST_CATALOG_HANDLE, TestSourcePartitionedScheduler.createFixedSplitSource(900, TestingSplit::createRemoteSplit)), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE)), () -> ((StageExecution)stage).getAllTasks()), (int)900, (DynamicFilterService)new DynamicFilterService(this.metadata, this.functionManager, this.typeOperators, new DynamicFilterConfig()), (TableExecuteContextManager)new TableExecuteContextManager(), () -> true);
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((Comparable)((ScheduleResult.BlockedReason)scheduleResult.getBlockedReason().get())).isEqualTo((Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(3);
        Assertions.assertThat((int)scheduleResult.getSplitsScheduled()).isEqualTo(768);
        for (RemoteTask remoteTask : scheduleResult.getNewTasks()) {
            PartitionedSplitsInfo splitsInfo = remoteTask.getPartitionedSplitsInfo();
            Assertions.assertThat((int)splitsInfo.getCount()).isEqualTo(256);
        }
        nodeManager.addNodes(new InternalNode[]{new InternalNode("other4", URI.create("http://127.0.0.4:14"), NodeVersion.UNKNOWN, false)});
        scheduleResult = scheduler.schedule();
        Assertions.assertThat((Comparable)((ScheduleResult.BlockedReason)scheduleResult.getBlockedReason().get())).isEqualTo((Object)ScheduleResult.BlockedReason.SPLIT_QUEUES_FULL);
        Assertions.assertThat((int)scheduleResult.getNewTasks().size()).isEqualTo(0);
        Assertions.assertThat((int)scheduleResult.getSplitsScheduled()).isEqualTo(0);
    }

    @Test
    public void testDynamicFiltersUnblockedOnBlockedBuildSource() {
        PlanFragment plan = TestSourcePartitionedScheduler.createFragment();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        StageExecution stage = this.createStageExecution(plan, nodeTaskMap);
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)this.nodeManager, new NodeSchedulerConfig().setIncludeCoordinator(false), nodeTaskMap));
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.functionManager, this.typeOperators, new DynamicFilterConfig());
        dynamicFilterService.registerQuery(QUERY_ID, SessionTestUtils.TEST_SESSION, (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID), (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID), (Set)ImmutableSet.of((Object)DYNAMIC_FILTER_ID));
        StageScheduler scheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((StageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(TestingHandles.TEST_CATALOG_HANDLE, TestSourcePartitionedScheduler.createBlockedSplitSource()), (SplitPlacementPolicy)new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE)), () -> ((StageExecution)stage).getAllTasks()), (int)2, (DynamicFilterService)dynamicFilterService, (TableExecuteContextManager)new TableExecuteContextManager(), () -> true);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)BigintType.BIGINT);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(QUERY_ID, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(DYNAMIC_FILTER_ID, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assertions.assertThat((Comparable)stage.getState()).isEqualTo((Object)StageExecution.State.PLANNED);
        scheduler.start();
        Assertions.assertThat((int)stage.getAllTasks().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)stage.getState()).isEqualTo((Object)StageExecution.State.SCHEDULING);
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isFalse();
        ScheduleResult scheduleResult = scheduler.schedule();
        Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
        Assertions.assertThat((int)scheduleResult.getSplitsScheduled()).isEqualTo(0);
    }

    private static void assertPartitionedSplitCount(StageExecution stage, int expectedPartitionedSplitCount) {
        Assertions.assertThat((int)stage.getAllTasks().stream().mapToInt(remoteTask -> remoteTask.getPartitionedSplitsInfo().getCount()).sum()).isEqualTo(expectedPartitionedSplitCount);
    }

    private static void assertEffectivelyFinished(ScheduleResult scheduleResult, StageScheduler scheduler) {
        if (scheduleResult.isFinished()) {
            Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
            return;
        }
        Assertions.assertThat((boolean)scheduleResult.getBlocked().isDone()).isTrue();
        ScheduleResult nextScheduleResult = scheduler.schedule();
        Assertions.assertThat((boolean)nextScheduleResult.isFinished()).isTrue();
        Assertions.assertThat((boolean)nextScheduleResult.getBlocked().isDone()).isTrue();
        Assertions.assertThat((int)nextScheduleResult.getNewTasks().size()).isEqualTo(0);
        Assertions.assertThat((int)nextScheduleResult.getSplitsScheduled()).isEqualTo(0);
    }

    private StageScheduler getSourcePartitionedScheduler(ConnectorSplitSource splitSource, StageExecution stage, InternalNodeManager nodeManager, NodeTaskMap nodeTaskMap, int splitBatchSize, NodeSchedulerConfig.SplitsBalancingPolicy splitsBalancingPolicy) {
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setIncludeCoordinator(false).setMaxSplitsPerNode(20).setMinPendingSplitsPerTask(0).setSplitsBalancingPolicy(splitsBalancingPolicy);
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory(nodeManager, nodeSchedulerConfig, nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS)));
        DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeScheduler.createNodeSelector(this.session, Optional.of(TestingHandles.TEST_CATALOG_HANDLE)), () -> ((StageExecution)stage).getAllTasks());
        return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler((StageExecution)stage, (PlanNodeId)TABLE_SCAN_NODE_ID, (SplitSource)new ConnectorAwareSplitSource(TestingHandles.TEST_CATALOG_HANDLE, splitSource), (SplitPlacementPolicy)placementPolicy, (int)splitBatchSize, (DynamicFilterService)new DynamicFilterService(this.metadata, this.functionManager, this.typeOperators, new DynamicFilterConfig()), (TableExecuteContextManager)new TableExecuteContextManager(), () -> false);
    }

    private static PlanFragment createFragment() {
        Symbol symbol = new Symbol("column");
        Symbol buildSymbol = new Symbol("buildColumn");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)TABLE_SCAN_NODE_ID, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false, Optional.empty());
        FilterNode filterNode = new FilterNode(new PlanNodeId("filter_node_id"), (PlanNode)tableScan, DynamicFilters.createDynamicFilterExpression((Metadata)MetadataManager.createTestMetadataManager(), (DynamicFilterId)DYNAMIC_FILTER_ID, (Type)VarcharType.VARCHAR, (Expression)symbol.toSymbolReference()));
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId("plan_fragment_id"), (List)ImmutableList.of((Object)buildSymbol), Optional.empty(), ExchangeNode.Type.REPLICATE, RetryPolicy.NONE);
        return new PlanFragment(new PlanFragmentId("plan_id"), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinNode.Type.INNER, (PlanNode)filterNode, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)DYNAMIC_FILTER_ID, (Object)buildSymbol), Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
    }

    private static ConnectorSplitSource createBlockedSplitSource() {
        return new ConnectorSplitSource(){

            public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
                return new CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch>();
            }

            public void close() {
            }

            public boolean isFinished() {
                return false;
            }
        };
    }

    private static ConnectorSplitSource createFixedSplitSource(int splitCount, Supplier<ConnectorSplit> splitFactory) {
        ImmutableList.Builder splits = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            splits.add((Object)splitFactory.get());
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    private StageExecution createStageExecution(PlanFragment fragment, NodeTaskMap nodeTaskMap) {
        StageId stageId = new StageId(QUERY_ID, 0);
        SqlStage stage = SqlStage.createSqlStage((StageId)stageId, (PlanFragment)fragment, (Map)ImmutableMap.of((Object)TABLE_SCAN_NODE_ID, (Object)new TableInfo(Optional.of("test"), new QualifiedObjectName("test", "test", "test"), TupleDomain.all())), (RemoteTaskFactory)new MockRemoteTaskFactory(this.queryExecutor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (Executor)this.queryExecutor, (Tracer)Tracing.noopTracer(), (Span)Span.getInvalid(), (SplitSchedulerStats)new SplitSchedulerStats());
        ImmutableMap.Builder outputBuffers = ImmutableMap.builder();
        outputBuffers.put((Object)fragment.getId(), (Object)new PartitionedPipelinedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 1));
        fragment.getRemoteSourceNodes().stream().flatMap(node -> node.getSourceFragmentIds().stream()).forEach(fragmentId -> outputBuffers.put(fragmentId, (Object)new PartitionedPipelinedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 10)));
        return PipelinedStageExecution.createPipelinedStageExecution((SqlStage)stage, (Map)outputBuffers.buildOrThrow(), (TaskLifecycleListener)TaskLifecycleListener.NO_OP, (FailureDetector)new NoOpFailureDetector(), (Executor)this.queryExecutor, Optional.of(new int[]{0}), (int)0);
    }

    private static class QueuedSplitSource
    implements ConnectorSplitSource {
        private final Supplier<ConnectorSplit> splitFactory;
        private final LinkedBlockingQueue<ConnectorSplit> queue = new LinkedBlockingQueue();
        private CompletableFuture<?> notEmptyFuture = new CompletableFuture();
        private boolean closed;

        public QueuedSplitSource(Supplier<ConnectorSplit> splitFactory) {
            this.splitFactory = Objects.requireNonNull(splitFactory, "splitFactory is null");
        }

        synchronized void addSplits(int count) {
            if (this.closed) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                this.queue.add(this.splitFactory.get());
                this.notEmptyFuture.complete(null);
            }
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            return ((CompletableFuture)this.notEmptyFuture.thenApply(x -> this.getBatch(maxSize))).thenApply(splits -> new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
        }

        private synchronized List<ConnectorSplit> getBatch(int maxSize) {
            ArrayList elements = new ArrayList(maxSize);
            this.queue.drainTo(elements, maxSize);
            if (this.queue.isEmpty() && !this.closed && this.notEmptyFuture.isDone()) {
                this.notEmptyFuture = new CompletableFuture();
            }
            return ImmutableList.copyOf(elements);
        }

        public synchronized boolean isFinished() {
            return this.closed && this.queue.isEmpty();
        }

        public synchronized void close() {
            this.closed = true;
        }
    }
}

