/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.tree.Expression;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTaskContext;
import io.trino.transaction.TestingTransactionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=5)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkScanFilterAndProjectOperator {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int TOTAL_POSITIONS = 1000000;
    private static final DataSize FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private static final int FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = 256;

    @Benchmark
    public List<Page> benchmarkColumnOriented(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        SourceOperator operator = (SourceOperator)context.getOperatorFactory().createOperator(driverContext);
        ImmutableList.Builder outputPages = ImmutableList.builder();
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBenchmark() {
        Context context = new Context();
        context.setup();
        this.benchmarkColumnOriented(context);
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkScanFilterAndProjectOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        @Param(value={"32", "1024"})
        int positionsPerPage = 32;
        @Param(value={"2", "4", "8", "16", "32"})
        int columnCount = 2;
        @Param(value={"varchar", "bigint"})
        String type = "varchar";
        @Param(value={"false", "true"})
        boolean dictionaryBlocks;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            Type type = TYPE_MAP.get(this.type);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                Symbol symbol = new Symbol(type.getDisplayName().toLowerCase(Locale.ENGLISH) + i2);
                this.symbolTypes.put(symbol, type);
                this.sourceLayout.put(symbol, i2);
            }
            List<RowExpression> projections = this.getProjections(type);
            List<Type> types = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
            List columnHandles = (List)IntStream.range(0, this.columnCount).mapToObj(i -> new TestingMetadata.TestingColumnHandle(Integer.toString(i))).collect(ImmutableList.toImmutableList());
            PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(PLANNER_CONTEXT.getFunctionManager(), 0);
            PageProcessor pageProcessor = (PageProcessor)new ExpressionCompiler(PLANNER_CONTEXT.getFunctionManager(), pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
            CursorProcessor cursorProcessor = (CursorProcessor)new ExpressionCompiler(PLANNER_CONTEXT.getFunctionManager(), pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
            this.createTaskContext();
            this.createScanFilterAndProjectOperatorFactories(this.createInputPages(types), pageProcessor, cursorProcessor, columnHandles, types);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private void createScanFilterAndProjectOperatorFactories(List<Page> inputPages, PageProcessor pageProcessor, CursorProcessor cursorProcessor, List<ColumnHandle> columnHandles, List<Type> types) {
            this.operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("test_source"), (session, split, table, columns, dynamicFilter) -> new FixedPageSource(inputPages), () -> cursorProcessor, () -> pageProcessor, TestingHandles.TEST_TABLE_HANDLE, columnHandles, DynamicFilter.EMPTY, types, FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, 256);
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        private List<Page> createInputPages(List<Type> types) {
            ImmutableList.Builder inputPagesBuilder = ImmutableList.builder();
            for (int i = 0; i < 1000000 / this.positionsPerPage; ++i) {
                inputPagesBuilder.add((Object)Context.createPage(types, this.positionsPerPage, this.dictionaryBlocks));
            }
            return inputPagesBuilder.build();
        }

        private RowExpression getFilter(Type type) {
            if (type == VarcharType.VARCHAR) {
                return this.rowExpression("cast(varchar0 as bigint) % 2 = 0");
            }
            if (type == BigintType.BIGINT) {
                return this.rowExpression("bigint0 % 2 = 0");
            }
            throw new IllegalArgumentException("filter not supported for type : " + String.valueOf(type));
        }

        private List<RowExpression> getProjections(Type type) {
            ImmutableList.Builder builder;
            block3: {
                block2: {
                    builder = ImmutableList.builder();
                    if (type != BigintType.BIGINT) break block2;
                    for (int i = 0; i < this.columnCount; ++i) {
                        builder.add((Object)this.rowExpression("bigint" + i + " + 5"));
                    }
                    break block3;
                }
                if (type != VarcharType.VARCHAR) break block3;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression("concat(varchar" + i + ", 'foo')"));
                }
            }
            return builder.build();
        }

        private RowExpression rowExpression(String value) {
            Expression expression = ExpressionTestUtils.createExpression(value, TRANSACTION_MANAGER, PLANNER_CONTEXT, TypeProvider.copyOf(this.symbolTypes));
            return SqlToRowExpressionTranslator.translate((Expression)expression, ExpressionTestUtils.getTypes(TEST_SESSION, PLANNER_CONTEXT, TypeProvider.copyOf(this.symbolTypes), expression), this.sourceLayout, (Metadata)PLANNER_CONTEXT.getMetadata(), (FunctionManager)PLANNER_CONTEXT.getFunctionManager(), (Session)TEST_SESSION, (boolean)true);
        }

        private static Page createPage(List<? extends Type> types, int positions, boolean dictionary) {
            if (dictionary) {
                return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, positions);
            }
            return SequencePageBuilder.createSequencePage(types, positions);
        }
    }
}

