/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.FeaturesConfig;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMinMaxByAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();
    private static final Collection<Type> STANDARD_TYPES = new TypeRegistry(new TypeOperators(), new FeaturesConfig()).getTypes();

    @Test
    public void testAllRegistered() {
        Set orderableTypes = (Set)TestMinMaxByAggregation.getTypes().stream().filter(Type::isOrderable).collect(ImmutableSet.toImmutableSet());
        for (Type keyType : orderableTypes) {
            for (Type valueType : TestMinMaxByAggregation.getTypes()) {
                Assertions.assertThat((Object)FUNCTION_RESOLUTION.getAggregateFunction("min_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, keyType}))).isNotNull();
                Assertions.assertThat((Object)FUNCTION_RESOLUTION.getAggregateFunction("max_by", TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, keyType}))).isNotNull();
            }
        }
    }

    private static List<Type> getTypes() {
        return ImmutableList.builder().addAll(STANDARD_TYPES).add((Object)VarcharType.VARCHAR).add((Object)DecimalType.createDecimalType((int)1)).add((Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE))).build();
    }

    @Test
    public void testMinUnknown() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null)});
    }

    @Test
    public void testMaxUnknown() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null)});
    }

    @Test
    public void testMinNull() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)1.0, new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)10.0, new Block[]{BlockAssertions.createDoublesBlock(10.0, 9.0, 8.0, 11.0), BlockAssertions.createDoublesBlock(1.0, null, 2.0, null)});
    }

    @Test
    public void testMaxNull() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)10.0, new Block[]{BlockAssertions.createDoublesBlock(8.0, 9.0, 10.0, 11.0), BlockAssertions.createDoublesBlock(-2.0, null, -1.0, null)});
    }

    @Test
    public void testMinDoubleDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)3.0, new Block[]{BlockAssertions.createDoublesBlock(3.0, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(1.0, 1.5, 2.0, 4.0)});
    }

    @Test
    public void testMaxDoubleDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)2.0, new Block[]{BlockAssertions.createDoublesBlock(3.0, 2.0, null), BlockAssertions.createDoublesBlock(1.0, 1.5, null)});
    }

    @Test
    public void testMinVarcharDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)100.0, new Block[]{BlockAssertions.createDoublesBlock(100.0, 1.0, 50.0, 2.0), BlockAssertions.createStringsBlock("a", "b", "c", "d")});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)-1.0, new Block[]{BlockAssertions.createDoublesBlock(100.0, 50.0, 2.0, -1.0), BlockAssertions.createStringsBlock("x", "y", "z", "a")});
    }

    @Test
    public void testMinDoubleVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"z", new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0)});
    }

    @Test
    public void testMaxDoubleVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"hi", new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(Double.NaN, 1.0, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 2.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"b", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN)});
    }

    @Test
    public void testMinRealVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"z", new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(2.0f), Float.valueOf(3.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"b", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(1.0f), Float.valueOf(2.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(2.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN))});
    }

    @Test
    public void testMaxRealVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"hi", new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(1.0f), Float.valueOf(2.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(2.0f))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"b", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN))});
    }

    @Test
    public void testMinLongLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)8L, (Object)9L), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L))), BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2L), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)2L))), BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L)});
    }

    @Test
    public void testMinLongArrayLong() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)3L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L)))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)-1L, new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L)))});
    }

    @Test
    public void testMaxLongArrayLong() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)1L, new Block[]{BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L)))});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)2L, new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)-8L, (Object)9L), (Object)ImmutableList.of((Object)-6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L)))});
    }

    @Test
    public void testMaxLongLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)1L, (Object)2L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(1L, 2L), null)), BlockAssertions.createLongsBlock(1L, 2L, null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2L, (Object)3L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(2L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createLongsBlock(0L, 1L, null, -1L)});
    }

    @Test
    public void testMinLongDecimalDecimal() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)1), DecimalType.createDecimalType((int)19, (int)1)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)19, (int)1)), new Block[]{BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0")});
    }

    @Test
    public void testMaxLongDecimalDecimal() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)1), DecimalType.createDecimalType((int)19, (int)1)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)19, (int)1)), new Block[]{BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0", "1.5")});
    }

    @Test
    public void testMinShortDecimalDecimal() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)1), DecimalType.createDecimalType((int)10, (int)1)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)10, (int)1)), new Block[]{BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0")});
    }

    @Test
    public void testMaxShortDecimalDecimal() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)1), DecimalType.createDecimalType((int)10, (int)1)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)10, (int)1)), new Block[]{BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0", "1.5")});
    }

    @Test
    public void testMinBooleanVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"b", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(true, false, true)});
    }

    @Test
    public void testMaxBooleanVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(false, false, true)});
    }

    @Test
    public void testMinIntegerVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3)});
    }

    @Test
    public void testMaxIntegerVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3)});
    }

    @Test
    public void testMinBooleanLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createBooleansBlock(true, false, true)});
    }

    @Test
    public void testMaxBooleanLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(2L, 2L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createBooleansBlock(false, false, true)});
    }

    @Test
    public void testMinLongVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3)});
    }

    @Test
    public void testMaxLongVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3)});
    }

    @Test
    public void testMinDoubleLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(3L, 4L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0)});
    }

    @Test
    public void testMaxDoubleLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, null)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(2L, 2L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0)});
    }

    @Test
    public void testMinSliceLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(3L, 4L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c")});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c")});
    }

    @Test
    public void testMaxSliceLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(2L, 2L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c")});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createStringsBlock("a", "b", "c")});
    }

    @Test
    public void testMinLongArrayLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(1L, 2L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L)))});
    }

    @Test
    public void testMaxLongArrayLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(3L, 3L), new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L)))});
    }

    @Test
    public void testMinLongArraySlice() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"c", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L)))});
    }

    @Test
    public void testMaxLongArraySlice() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, (Object)"a", new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L)))});
    }

    @Test
    public void testMinUnknownSlice() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null))});
    }

    @Test
    public void testMaxUnknownSlice() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null))});
    }

    @Test
    public void testMinUnknownLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "min_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null))});
    }

    @Test
    public void testMaxUnknownLongArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, "max_by", (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null))});
    }
}

