/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.PagePartitioner;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import io.trino.type.IpAddressType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestPagePartitioner {
    private static final DataSize MAX_MEMORY = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize PARTITION_MAX_MEMORY = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int POSITIONS_PER_PAGE = 8;
    private static final int PARTITION_COUNT = 2;
    private static final PagesSerdeFactory PAGES_SERDE_FACTORY = new PagesSerdeFactory((BlockEncodingSerde)new TestingBlockEncodingSerde(), CompressionCodec.NONE);
    private static final PageDeserializer PAGE_DESERIALIZER = PAGES_SERDE_FACTORY.createDeserializer(Optional.empty());
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-executor-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));

    @AfterAll
    public void tearDownClass() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testOutputForEmptyPage() {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock((Iterable<Long>)ImmutableList.of())});
        pagePartitioner.partitionPage(page, this.operatorContext());
        pagePartitioner.close();
        List<Object> partitioned = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(), 0);
        Assertions.assertThat(partitioned).isEmpty();
    }

    private OperatorContext operatorContext() {
        return new DriverContextBuilder(this.executor, this.scheduledExecutor).buildDriverContext().addOperatorContext(0, new PlanNodeId("plan-node-0"), PartitionedOutputOperator.class.getSimpleName());
    }

    @Test
    public void testOutputEqualsInput() {
        this.testOutputEqualsInput(PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput(PartitioningMode.COLUMNAR);
    }

    private void testOutputEqualsInput(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8)});
        List<Object> expected = TestPagePartitioner.readLongs(Stream.of(page), 0);
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partitioned = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(), 0);
        Assertions.assertThat(partitioned).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void testOutputForPageWithNoBlockPartitionFunction() {
        this.testOutputForPageWithNoBlockPartitionFunction(PartitioningMode.ROW_WISE);
        this.testOutputForPageWithNoBlockPartitionFunction(PartitioningMode.COLUMNAR);
    }

    private void testOutputForPageWithNoBlockPartitionFunction(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withPartitionFunction((PartitionFunction)new BucketPartitionFunction(SystemPartitioningHandle.SystemPartitionFunction.ROUND_ROBIN.createBucketFunction(null, false, 2, null), IntStream.range(0, 2).toArray())).withPartitionChannels((ImmutableList<Integer>)ImmutableList.of()).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactly(new Object[]{0L, 2L, 4L, 6L});
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactly(new Object[]{1L, 3L, 5L, 7L});
    }

    @Test
    public void testOutputForMultipleSimplePages() {
        this.testOutputForMultipleSimplePages(PartitioningMode.ROW_WISE);
        this.testOutputForMultipleSimplePages(PartitioningMode.COLUMNAR);
    }

    private void testOutputForMultipleSimplePages(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page1 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8)});
        Page page2 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(1, 8)});
        Page page3 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(2, 8)});
        List<Object> expected = TestPagePartitioner.readLongs(Stream.of(page1, page2, page3), 0);
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page1, page2, page3);
        List<Object> partitioned = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(), 0);
        Assertions.assertThat(partitioned).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void testOutputForSimplePageWithReplication() {
        this.testOutputForSimplePageWithReplication(PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithReplication(PartitioningMode.COLUMNAR);
    }

    private void testOutputForSimplePageWithReplication(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).replicate().build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L, null)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactly(new Object[]{0L, 2L, null});
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactly(new Object[]{0L, 1L, 3L});
    }

    @Test
    public void testOutputForSimplePageWithNullChannel() {
        this.testOutputForSimplePageWithNullChannel(PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithNullChannel(PartitioningMode.COLUMNAR);
    }

    private void testOutputForSimplePageWithNullChannel(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withNullChannel(0).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L, null)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactlyInAnyOrder(new Object[]{0L, 2L, null});
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactlyInAnyOrder(new Object[]{1L, 3L, null});
    }

    @Test
    public void testOutputForSimplePageWithPartitionConstant() {
        this.testOutputForSimplePageWithPartitionConstant(PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithPartitionConstant(PartitioningMode.COLUMNAR);
    }

    private void testOutputForSimplePageWithPartitionConstant(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withPartitionConstants((List<Optional<NullableValue>>)ImmutableList.of(Optional.of(new NullableValue((Type)BigintType.BIGINT, (Object)1L)))).withPartitionChannels(-1).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L, null)});
        List<Object> allValues = TestPagePartitioner.readLongs(Stream.of(page), 0);
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).isEmpty();
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactlyElementsOf(allValues);
    }

    @Test
    public void testOutputForSimplePageWithPartitionConstantAndHashBlock() {
        this.testOutputForSimplePageWithPartitionConstantAndHashBlock(PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithPartitionConstantAndHashBlock(PartitioningMode.COLUMNAR);
    }

    private void testOutputForSimplePageWithPartitionConstantAndHashBlock(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withPartitionConstants((List<Optional<NullableValue>>)ImmutableList.of(Optional.empty(), Optional.of(new NullableValue((Type)BigintType.BIGINT, (Object)1L)))).withPartitionChannels(0, -1).withHashChannels(0, 1).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactly(new Object[]{1L, 3L});
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactly(new Object[]{0L, 2L});
    }

    @Test
    public void testPartitionPositionsWithRleNotNull() {
        this.testPartitionPositionsWithRleNotNull(PartitioningMode.ROW_WISE);
        this.testPartitionPositionsWithRleNotNull(PartitioningMode.COLUMNAR);
    }

    private void testPartitionPositionsWithRleNotNull(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT, BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{BlockAssertions.createRepeatedValuesBlock(0L, 8), BlockAssertions.createLongSequenceBlock(0, 8)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 1);
        Assertions.assertThat(partition0).containsExactlyElementsOf(TestPagePartitioner.readLongs(Stream.of(page), 1));
        List<Object> partition0HashBlock = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        ((ListAssert)Assertions.assertThat(partition0HashBlock).containsOnly(new Object[]{0L})).hasSize(8);
        Assertions.assertThat(outputBuffer.getEnqueuedDeserialized(1)).isEmpty();
    }

    @Test
    public void testPartitionPositionsWithRleNotNullWithReplication() {
        this.testPartitionPositionsWithRleNotNullWithReplication(PartitioningMode.ROW_WISE);
        this.testPartitionPositionsWithRleNotNullWithReplication(PartitioningMode.COLUMNAR);
    }

    private void testPartitionPositionsWithRleNotNullWithReplication(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT, BigintType.BIGINT}).replicate().build();
        Page page = new Page(new Block[]{BlockAssertions.createRepeatedValuesBlock(0L, 8), BlockAssertions.createLongSequenceBlock(0, 8)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 1);
        Assertions.assertThat(partition0).containsExactlyElementsOf(TestPagePartitioner.readLongs(Stream.of(page), 1));
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 1);
        Assertions.assertThat(partition1).containsExactly(new Object[]{0L});
    }

    @Test
    public void testPartitionPositionsWithRleNullWithNullChannel() {
        this.testPartitionPositionsWithRleNullWithNullChannel(PartitioningMode.ROW_WISE);
        this.testPartitionPositionsWithRleNullWithNullChannel(PartitioningMode.COLUMNAR);
    }

    private void testPartitionPositionsWithRleNullWithNullChannel(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT, BigintType.BIGINT}).withNullChannel(0).build();
        Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Block)BlockAssertions.createLongsBlock(new Long[]{null}), (int)8), BlockAssertions.createLongSequenceBlock(0, 8)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 1);
        Assertions.assertThat(partition0).containsExactlyElementsOf(TestPagePartitioner.readLongs(Stream.of(page), 1));
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 1);
        Assertions.assertThat(partition1).containsExactlyElementsOf(TestPagePartitioner.readLongs(Stream.of(page), 1));
    }

    @Test
    public void testOutputForDictionaryBlock() {
        this.testOutputForDictionaryBlock(PartitioningMode.ROW_WISE);
        this.testOutputForDictionaryBlock(PartitioningMode.COLUMNAR);
    }

    private void testOutputForDictionaryBlock(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongDictionaryBlock(0, 10)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactlyElementsOf(Collections.nCopies(5, 0L));
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactlyElementsOf(Collections.nCopies(5, 1L));
    }

    @Test
    public void testOutputForOneValueDictionaryBlock() {
        this.testOutputForOneValueDictionaryBlock(PartitioningMode.ROW_WISE);
        this.testOutputForOneValueDictionaryBlock(PartitioningMode.COLUMNAR);
    }

    private void testOutputForOneValueDictionaryBlock(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{DictionaryBlock.create((int)4, (Block)BlockAssertions.createLongsBlock(0), (int[])new int[]{0, 0, 0, 0})});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactlyElementsOf(Collections.nCopies(4, 0L));
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).isEmpty();
    }

    @Test
    public void testOutputForViewDictionaryBlock() {
        this.testOutputForViewDictionaryBlock(PartitioningMode.ROW_WISE);
        this.testOutputForViewDictionaryBlock(PartitioningMode.COLUMNAR);
    }

    private void testOutputForViewDictionaryBlock(PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        Page page = new Page(new Block[]{DictionaryBlock.create((int)4, (Block)BlockAssertions.createLongSequenceBlock(4, 8), (int[])new int[]{1, 0, 3, 2})});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partition0 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(0), 0);
        Assertions.assertThat(partition0).containsExactlyInAnyOrder(new Object[]{4L, 6L});
        List<Object> partition1 = TestPagePartitioner.readLongs(outputBuffer.getEnqueuedDeserialized(1), 0);
        Assertions.assertThat(partition1).containsExactlyInAnyOrder(new Object[]{5L, 7L});
    }

    @Test
    public void testOutputForSimplePageWithType() {
        this.testOutputForSimplePageWithType((Type)BigintType.BIGINT, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)BooleanType.BOOLEAN, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)IntegerType.INTEGER, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)CharType.createCharType((int)10), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)VarcharType.createUnboundedVarcharType(), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)DoubleType.DOUBLE, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)SmallintType.SMALLINT, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)TinyintType.TINYINT, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)UuidType.UUID, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)VarbinaryType.VARBINARY, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)DecimalType.createDecimalType((int)1), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)DecimalType.createDecimalType((int)19), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)new ArrayType((Type)BigintType.BIGINT), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)TimestampType.createTimestampType((int)9), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)TimestampType.createTimestampType((int)3), PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)IpAddressType.IPADDRESS, PartitioningMode.ROW_WISE);
        this.testOutputForSimplePageWithType((Type)BigintType.BIGINT, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)BooleanType.BOOLEAN, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)IntegerType.INTEGER, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)CharType.createCharType((int)10), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)VarcharType.createUnboundedVarcharType(), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)DoubleType.DOUBLE, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)SmallintType.SMALLINT, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)TinyintType.TINYINT, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)UuidType.UUID, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)VarbinaryType.VARBINARY, PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)DecimalType.createDecimalType((int)1), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)DecimalType.createDecimalType((int)19), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)new ArrayType((Type)BigintType.BIGINT), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)TimestampType.createTimestampType((int)9), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)TimestampType.createTimestampType((int)3), PartitioningMode.COLUMNAR);
        this.testOutputForSimplePageWithType((Type)IpAddressType.IPADDRESS, PartitioningMode.COLUMNAR);
    }

    private void testOutputForSimplePageWithType(Type type, PartitioningMode partitioningMode) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT, type}).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8), TestPagePartitioner.createBlockForType(type, 8)});
        List<Object> expected = TestPagePartitioner.readChannel(Stream.of(page), 1, type);
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        List<Object> partitioned = TestPagePartitioner.readChannel(outputBuffer.getEnqueuedDeserialized(), 1, type);
        Assertions.assertThat(partitioned).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void testOutputWithMixedRowWiseAndColumnarPartitioning() {
        this.testOutputEqualsInput((Type)BigintType.BIGINT, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)BooleanType.BOOLEAN, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)IntegerType.INTEGER, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)CharType.createCharType((int)10), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)VarcharType.createUnboundedVarcharType(), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)DoubleType.DOUBLE, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)SmallintType.SMALLINT, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)TinyintType.TINYINT, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)UuidType.UUID, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)VarbinaryType.VARBINARY, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)DecimalType.createDecimalType((int)1), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)DecimalType.createDecimalType((int)19), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)new ArrayType((Type)BigintType.BIGINT), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)TimestampType.createTimestampType((int)9), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)TimestampType.createTimestampType((int)3), PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)IpAddressType.IPADDRESS, PartitioningMode.COLUMNAR, PartitioningMode.ROW_WISE);
        this.testOutputEqualsInput((Type)BigintType.BIGINT, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)BooleanType.BOOLEAN, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)IntegerType.INTEGER, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)CharType.createCharType((int)10), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)VarcharType.createUnboundedVarcharType(), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)DoubleType.DOUBLE, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)SmallintType.SMALLINT, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)TinyintType.TINYINT, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)UuidType.UUID, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)VarbinaryType.VARBINARY, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)DecimalType.createDecimalType((int)1), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)DecimalType.createDecimalType((int)19), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)new ArrayType((Type)BigintType.BIGINT), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)TimestampType.createTimestampType((int)9), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)TimestampType.createTimestampType((int)3), PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
        this.testOutputEqualsInput((Type)IpAddressType.IPADDRESS, PartitioningMode.ROW_WISE, PartitioningMode.COLUMNAR);
    }

    @Test
    public void testOutputBytesWhenReused() {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).build();
        OperatorContext operatorContext = this.operatorContext();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(1, 1, 1, 1, 1, 1)});
        pagePartitioner.partitionPage(page, operatorContext);
        Assertions.assertThat((long)operatorContext.getOutputDataSize().getTotalCount()).isEqualTo(0L);
        pagePartitioner.prepareForRelease(operatorContext);
        Assertions.assertThat((long)operatorContext.getOutputDataSize().getTotalCount()).isEqualTo(page.getSizeInBytes());
        pagePartitioner.prepareForRelease(operatorContext);
        Assertions.assertThat((long)operatorContext.getOutputDataSize().getTotalCount()).isEqualTo(page.getSizeInBytes());
        pagePartitioner.partitionPage(page, operatorContext);
        pagePartitioner.prepareForRelease(operatorContext);
        Assertions.assertThat((long)operatorContext.getOutputDataSize().getTotalCount()).isEqualTo(page.getSizeInBytes() * 2L);
        pagePartitioner.close();
        List<Slice> output = outputBuffer.getEnqueued();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
    }

    @Test
    public void testMemoryReleased() {
        this.testMemoryReleased(PartitioningMode.ROW_WISE);
        this.testMemoryReleased(PartitioningMode.COLUMNAR);
    }

    private void testMemoryReleased(PartitioningMode partitioningMode) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withMemoryContext(memoryContext).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L, null)});
        TestPagePartitioner.processPages(pagePartitioner, partitioningMode, page);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
    }

    @Test
    public void testMemoryReleasedOnFailure() {
        this.testMemoryReleasedOnFailure(PartitioningMode.ROW_WISE);
        this.testMemoryReleasedOnFailure(PartitioningMode.COLUMNAR);
    }

    private void testMemoryReleasedOnFailure(PartitioningMode partitioningMode) {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        RuntimeException exception = new RuntimeException();
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        outputBuffer.throwOnEnqueue(exception);
        PagePartitioner pagePartitioner = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT}).withMemoryContext(memoryContext).build();
        Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(0L, 1L, 2L, 3L, null)});
        partitioningMode.partitionPage(pagePartitioner, page);
        Assertions.assertThatThrownBy(() -> ((PagePartitioner)pagePartitioner).close()).isEqualTo((Object)exception);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
    }

    private void testOutputEqualsInput(Type type, PartitioningMode mode1, PartitioningMode mode2) {
        TestOutputBuffer outputBuffer = new TestOutputBuffer();
        PagePartitionerBuilder pagePartitionerBuilder = this.pagePartitioner(outputBuffer, new Type[]{BigintType.BIGINT, type, type});
        PagePartitioner pagePartitioner = pagePartitionerBuilder.build();
        Page input = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8), TestPagePartitioner.createBlockForType(type, 8), TestPagePartitioner.createBlockForType(type, 8)});
        List<Object> expected = TestPagePartitioner.readChannel(Stream.of(input, input), 1, type);
        mode1.partitionPage(pagePartitioner, input);
        mode2.partitionPage(pagePartitioner, input);
        pagePartitioner.close();
        List<Object> partitioned = TestPagePartitioner.readChannel(outputBuffer.getEnqueuedDeserialized(), 1, type);
        Assertions.assertThat(partitioned).containsExactlyInAnyOrderElementsOf(expected);
        outputBuffer.clear();
    }

    private static Block createBlockForType(Type type, int positionsPerPage) {
        return BlockAssertions.createRandomBlockForType(type, positionsPerPage, 0.2f);
    }

    private static void processPages(PagePartitioner pagePartitioner, PartitioningMode partitioningMode, Page ... pages) {
        for (Page page : pages) {
            partitioningMode.partitionPage(pagePartitioner, page);
        }
        pagePartitioner.close();
    }

    private static List<Object> readLongs(Stream<Page> pages, int channel) {
        return TestPagePartitioner.readChannel(pages, channel, (Type)BigintType.BIGINT);
    }

    private static List<Object> readChannel(Stream<Page> pages, int channel, Type type) {
        ArrayList result = new ArrayList();
        pages.forEach(page -> {
            Block block = page.getBlock(channel);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    result.add(null);
                    continue;
                }
                result.add(type.getObjectValue(null, block, i));
            }
        });
        return Collections.unmodifiableList(result);
    }

    private PagePartitionerBuilder pagePartitioner(TestOutputBuffer outputBuffer, Type ... types) {
        return this.pagePartitioner((List<Type>)ImmutableList.copyOf((Object[])types), outputBuffer);
    }

    private PagePartitionerBuilder pagePartitioner(List<Type> types, TestOutputBuffer outputBuffer) {
        return this.pagePartitioner(outputBuffer).withTypes(types);
    }

    private PagePartitionerBuilder pagePartitioner(TestOutputBuffer outputBuffer) {
        return new PagePartitionerBuilder(this.executor, this.scheduledExecutor, outputBuffer);
    }

    public static class TestOutputBuffer
    implements OutputBuffer {
        private final Multimap<Integer, Slice> enqueued = ArrayListMultimap.create();
        private RuntimeException throwOnEnqueue;

        public Stream<Page> getEnqueuedDeserialized() {
            return this.getEnqueued().stream().map(arg_0 -> ((PageDeserializer)PAGE_DESERIALIZER).deserialize(arg_0));
        }

        public List<Slice> getEnqueued() {
            return ImmutableList.copyOf((Collection)this.enqueued.values());
        }

        public void clear() {
            this.enqueued.clear();
        }

        public Stream<Page> getEnqueuedDeserialized(int partition) {
            return this.getEnqueued(partition).stream().map(arg_0 -> ((PageDeserializer)PAGE_DESERIALIZER).deserialize(arg_0));
        }

        public List<Slice> getEnqueued(int partition) {
            Collection serializedPages = this.enqueued.get((Object)partition);
            return ImmutableList.copyOf((Collection)serializedPages);
        }

        public void throwOnEnqueue(RuntimeException throwOnEnqueue) {
            this.throwOnEnqueue = throwOnEnqueue;
        }

        public void enqueue(int partition, List<Slice> pages) {
            if (this.throwOnEnqueue != null) {
                throw this.throwOnEnqueue;
            }
            this.enqueued.putAll((Object)partition, pages);
        }

        public OutputBufferInfo getInfo() {
            return null;
        }

        public BufferState getState() {
            return BufferState.NO_MORE_BUFFERS;
        }

        public double getUtilization() {
            return 0.0;
        }

        public OutputBufferStatus getStatus() {
            return OutputBufferStatus.initial();
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        }

        public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        }

        public ListenableFuture<BufferResult> get(PipelinedOutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
            return null;
        }

        public void acknowledge(PipelinedOutputBuffers.OutputBufferId bufferId, long token) {
        }

        public void destroy(PipelinedOutputBuffers.OutputBufferId bufferId) {
        }

        public ListenableFuture<Void> isFull() {
            return null;
        }

        public void enqueue(List<Slice> pages) {
        }

        public void setNoMorePages() {
        }

        public void destroy() {
        }

        public void abort() {
        }

        public long getPeakMemoryUsage() {
            return 0L;
        }

        public Optional<Throwable> getFailureCause() {
            return Optional.empty();
        }
    }

    public static class PagePartitionerBuilder {
        public static final PositionsAppenderFactory POSITIONS_APPENDER_FACTORY = new PositionsAppenderFactory(new BlockTypeOperators());
        private final OutputBuffer outputBuffer;
        private final DriverContextBuilder driverContextBuilder;
        private ImmutableList<Integer> partitionChannels = ImmutableList.of((Object)0);
        private List<Optional<NullableValue>> partitionConstants = ImmutableList.of();
        private PartitionFunction partitionFunction = new SumModuloPartitionFunction(2, 0);
        private boolean shouldReplicate;
        private OptionalInt nullChannel = OptionalInt.empty();
        private List<Type> types;
        private AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();

        PagePartitionerBuilder(ExecutorService executor, ScheduledExecutorService scheduledExecutor, OutputBuffer outputBuffer) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.driverContextBuilder = new DriverContextBuilder(executor, scheduledExecutor);
        }

        public PagePartitionerBuilder withPartitionChannels(Integer ... partitionChannels) {
            return this.withPartitionChannels((ImmutableList<Integer>)ImmutableList.copyOf((Object[])partitionChannels));
        }

        public PagePartitionerBuilder withPartitionChannels(ImmutableList<Integer> partitionChannels) {
            this.partitionChannels = partitionChannels;
            return this;
        }

        public PagePartitionerBuilder withPartitionConstants(List<Optional<NullableValue>> partitionConstants) {
            this.partitionConstants = partitionConstants;
            return this;
        }

        public PagePartitionerBuilder withHashChannels(int ... hashChannels) {
            return this.withPartitionFunction(new SumModuloPartitionFunction(2, hashChannels));
        }

        public PagePartitionerBuilder withPartitionFunction(PartitionFunction partitionFunction) {
            this.partitionFunction = partitionFunction;
            return this;
        }

        public PagePartitionerBuilder replicate() {
            return this.withShouldReplicate(true);
        }

        public PagePartitionerBuilder withShouldReplicate(boolean shouldReplicate) {
            this.shouldReplicate = shouldReplicate;
            return this;
        }

        public PagePartitionerBuilder withNullChannel(int nullChannel) {
            return this.withNullChannel(OptionalInt.of(nullChannel));
        }

        public PagePartitionerBuilder withNullChannel(OptionalInt nullChannel) {
            this.nullChannel = nullChannel;
            return this;
        }

        public PagePartitionerBuilder withTypes(Type ... types) {
            return this.withTypes((List<Type>)ImmutableList.copyOf((Object[])types));
        }

        public PagePartitionerBuilder withTypes(List<Type> types) {
            this.types = types;
            return this;
        }

        public PagePartitionerBuilder withMemoryContext(AggregatedMemoryContext memoryContext) {
            this.memoryContext = memoryContext;
            return this;
        }

        public PartitionedOutputOperator buildPartitionedOutputOperator() {
            DriverContext driverContext = this.driverContextBuilder.buildDriverContext();
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory(this.partitionFunction, this.partitionChannels, this.partitionConstants, this.shouldReplicate, this.nullChannel, this.outputBuffer, PARTITION_MAX_MEMORY, POSITIONS_APPENDER_FACTORY, Optional.empty(), this.memoryContext, 1, Optional.empty());
            OperatorFactory factory = operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), this.types, Function.identity(), PAGES_SERDE_FACTORY);
            PartitionedOutputOperator operator = (PartitionedOutputOperator)factory.createOperator(driverContext);
            factory.noMoreOperators();
            return operator;
        }

        public PagePartitioner build() {
            return new PagePartitioner(this.partitionFunction, this.partitionChannels, this.partitionConstants, this.shouldReplicate, this.nullChannel, this.outputBuffer, PAGES_SERDE_FACTORY, this.types, PARTITION_MAX_MEMORY, POSITIONS_APPENDER_FACTORY, Optional.empty(), this.memoryContext, true);
        }
    }

    public static class DriverContextBuilder {
        private final ExecutorService executor;
        private final ScheduledExecutorService scheduledExecutor;

        DriverContextBuilder(ExecutorService executor, ScheduledExecutorService scheduledExecutor) {
            this.executor = Objects.requireNonNull(executor, "executor is null");
            this.scheduledExecutor = Objects.requireNonNull(scheduledExecutor, "scheduledExecutor is null");
        }

        public DriverContext buildDriverContext() {
            return TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
        }
    }

    private static enum PartitioningMode {
        ROW_WISE{

            @Override
            public void partitionPage(PagePartitioner pagePartitioner, Page page) {
                pagePartitioner.partitionPageByRow(page);
            }
        }
        ,
        COLUMNAR{

            @Override
            public void partitionPage(PagePartitioner pagePartitioner, Page page) {
                pagePartitioner.partitionPageByColumn(page);
            }
        };


        public abstract void partitionPage(PagePartitioner var1, Page var2);
    }

    private record SumModuloPartitionFunction(int partitionCount, int[] hashChannels) implements PartitionFunction
    {
        private SumModuloPartitionFunction {
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0);
        }

        public int getPartition(Page page, int position) {
            long value = 0L;
            for (int hashChannel : this.hashChannels) {
                value += page.getBlock(hashChannel).getLong(position, 0);
            }
            return Math.toIntExact(Math.abs(value) % (long)this.partitionCount);
        }
    }
}

