/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Strings;
import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.likematcher.LikeMatcher;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.type.JoniRegexp;
import io.trino.util.Failures;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkLike {
    private static final String LONG_STRING = Strings.repeat((String)"a", (int)100) + Strings.repeat((String)"b", (int)100) + Strings.repeat((String)"a", (int)100) + Strings.repeat((String)"b", (int)100) + "the quick brown fox jumps over the lazy dog";
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    @Benchmark
    public boolean matchJoni(Data data) {
        return BenchmarkLike.likeVarchar(data.data, data.joniPattern);
    }

    @Benchmark
    public boolean matchOptimized(Data data) {
        return data.optimizedMatcher.match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public boolean matchNonOptimized(Data data) {
        return data.nonOptimizedMatcher.match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public JoniRegexp compileJoni(Data data) {
        return BenchmarkLike.compileJoni(data.benchmarkCase.pattern(), '\u0000', false);
    }

    @Benchmark
    public LikeMatcher compileOptimized(Data data) {
        return LikeMatcher.compile((String)data.benchmarkCase.pattern(), Optional.empty(), (boolean)true);
    }

    @Benchmark
    public LikeMatcher compileNonOptimized(Data data) {
        return LikeMatcher.compile((String)data.benchmarkCase.pattern(), Optional.empty(), (boolean)false);
    }

    @Benchmark
    public boolean dynamicJoni(Data data) {
        return BenchmarkLike.likeVarchar(data.data, BenchmarkLike.compileJoni(Slices.utf8Slice((String)data.benchmarkCase.pattern()).toStringUtf8(), '0', false));
    }

    @Benchmark
    public boolean dynamicOptimized(Data data) {
        return LikeMatcher.compile((String)data.benchmarkCase.pattern(), Optional.empty(), (boolean)true).match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public boolean dynamicNonOptimized(Data data) {
        return LikeMatcher.compile((String)data.benchmarkCase.pattern(), Optional.empty(), (boolean)false).match(data.bytes, 0, data.bytes.length);
    }

    public static boolean likeVarchar(Slice value, JoniRegexp pattern) {
        int offset = value.byteArrayOffset();
        Matcher matcher = pattern.regex().matcher(value.byteArray(), offset, offset + value.length());
        return matcher.match(offset, offset + value.length(), 0) != -1;
    }

    private static JoniRegexp compileJoni(String patternString, char escapeChar, boolean shouldEscape) {
        byte[] bytes = BenchmarkLike.likeToRegex(patternString, escapeChar, shouldEscape).getBytes(StandardCharsets.UTF_8);
        Regex joniRegex = new Regex(bytes, 0, bytes.length, 4, (Encoding)NonStrictUTF8Encoding.INSTANCE, SYNTAX);
        return new JoniRegexp(Slices.wrappedBuffer((byte[])bytes), joniRegex);
    }

    private static String likeToRegex(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            BenchmarkLike.checkEscape(!escaped || currentChar == '%' || currentChar == '_' || currentChar == escapeChar);
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        BenchmarkLike.checkEscape(!escaped);
        regex.append('$');
        return regex.toString();
    }

    private static void checkEscape(boolean condition) {
        Failures.checkCondition((boolean)condition, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (String)"Escape character must be followed by '%%', '_' or the escape character itself", (Object[])new Object[0]);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkLike.class.getSimpleName() + ".*").resultFormat(ResultFormatType.JSON).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param
        private BenchmarkCase benchmarkCase;
        private Slice data;
        private byte[] bytes;
        private JoniRegexp joniPattern;
        private LikeMatcher optimizedMatcher;
        private LikeMatcher nonOptimizedMatcher;

        @Setup
        public void setup() {
            this.optimizedMatcher = LikeMatcher.compile((String)this.benchmarkCase.pattern(), Optional.empty(), (boolean)true);
            this.nonOptimizedMatcher = LikeMatcher.compile((String)this.benchmarkCase.pattern(), Optional.empty(), (boolean)false);
            this.joniPattern = BenchmarkLike.compileJoni(this.benchmarkCase.pattern(), '0', false);
            this.bytes = this.benchmarkCase.text().getBytes(StandardCharsets.UTF_8);
            this.data = Slices.wrappedBuffer((byte[])this.bytes);
        }
    }

    public static enum BenchmarkCase {
        ANY("%", LONG_STRING),
        WILDCARD_PREFIX("_%", LONG_STRING),
        WILDCARD_SUFFIX("%_", LONG_STRING),
        PREFIX("the%", "the quick brown fox jumps over the lazy dog"),
        SUFFIX("%dog", "the quick brown fox jumps over the lazy dog"),
        FIXED_WILDCARD("_____", "abcdef"),
        SHORT_TOKENS_1("%a%b%a%b%", LONG_STRING),
        SHORT_TOKENS_2("%the%quick%brown%fox%jumps%over%the%lazy%dog%", LONG_STRING),
        SHORT_TOKEN("%the%", LONG_STRING),
        LONG_TOKENS_1("%aaaaaaaaab%bbbbbbbbba%aaaaaaaaab%bbbbbbbbbt%", LONG_STRING),
        LONG_TOKENS_2("%aaaaaaaaaaaaaaaaaaaaaaaaaa%aaaaaaaaaaaaaaaaaaaaaaaaaathe%", LONG_STRING),
        LONG_TOKEN_1("%bbbbbbbbbbbbbbbthe%", LONG_STRING),
        LONG_TOKEN_2("%the quick brown fox%", LONG_STRING),
        LONG_TOKEN_3("%aaaaaaaxaaaaaa%", LONG_STRING),
        SHORT_TOKENS_WITH_LONG_SKIP("%the%dog%", LONG_STRING);

        private final String pattern;
        private final String text;

        private BenchmarkCase(String pattern, String text) {
            this.pattern = pattern;
            this.text = text;
        }

        public String pattern() {
            return this.pattern;
        }

        public String text() {
            return this.text;
        }
    }
}

