/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.TrinoException;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePattern;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestLikeFunctions {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    private static Slice offsetHeapSlice(String value) {
        Slice source = Slices.utf8Slice((String)value);
        Slice result = Slices.allocate((int)(source.length() + 5));
        result.setBytes(2, source);
        return result.slice(2, source.length());
    }

    @Test
    public void testLikeBasic() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b__").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foobar"), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (LikePattern)matcher)).isTrue();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "'foob'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b'").binding("a", "'foob'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo '").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo '").binding("a", "CAST('foo ' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo___'").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo%'").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo' AS varchar(6))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo  ' AS varchar(3))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE CAST('foo   ' AS varchar(6))").binding("a", "CAST('foo' AS varchar(6))")))).isEqualTo(false);
    }

    @Test
    public void testLikeChar() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b__").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foobar"), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foobar"), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)6L, (Slice)Slices.utf8Slice((String)"foob"), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)6L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)7L, (Slice)Slices.utf8Slice((String)"foob"), (LikePattern)matcher)).isFalse();
        Assertions.assertThat((boolean)LikeFunctions.likeChar((Long)7L, (Slice)TestLikeFunctions.offsetHeapSlice("foob"), (LikePattern)matcher)).isFalse();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fo_'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fo%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%foo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '_oo'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "CAST('foob' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f%b__'").binding("a", "CAST('foob' AS char(7))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'ja\u017a\u0144'").binding("a", "CAST('ja\u017a\u0144' AS char(4))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'fob'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo   '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo __'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%foo'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f#_#_' ESCAPE '#'").binding("a", "CAST('foo' AS char(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'f#_#_' ESCAPE '#'").binding("a", "CAST('f__' AS char(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo    '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo __ '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '_______'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE '%%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo   %%%%%%%'").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  %%%%%%% '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foo  %%%%%%%  '").binding("a", "CAST('foo' AS char(6))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a LIKE 'foobar%%%%%%%'").binding("a", "CAST('foobar' AS char(6))")))).isEqualTo(true);
    }

    @Test
    public void testLikeSpacesInPattern() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"ala  ").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala  "), (LikePattern)matcher)).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"ala"), (LikePattern)matcher)).isFalse();
    }

    @Test
    public void testLikeNewlineInPattern() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"%o\nbar").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testLikeNewlineBeforeMatch() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"%b%").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testLikeNewlineInMatch() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"f%b%").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo\nbar"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testLikeUtf8Pattern() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%\u540d\u8a89%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"foo"), (LikePattern)matcher)).isFalse();
    }

    @Test
    public void testLikeInvalidUtf8Value() {
        Slice value = Slices.wrappedBuffer((byte[])new byte[]{97, 98, 99, -1, 120, 121});
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)value, (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testBackslashesNoSpecialTreatment() {
        LikePattern matcher = LikePattern.compile((String)Slices.utf8Slice((String)"\\abc\\/\\\\").toStringUtf8(), Optional.empty());
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testSelfEscaping() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\\\abc\\%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"\\abc%"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testAlternateEscapedCharacters() {
        LikePattern matcher = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"xxx%x_abcxx"), (Slice)Slices.utf8Slice((String)"x"));
        Assertions.assertThat((boolean)LikeFunctions.likeVarchar((Slice)Slices.utf8Slice((String)"x%_abcx"), (LikePattern)matcher)).isTrue();
    }

    @Test
    public void testInvalidLikePattern() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"#"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#abc"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"abc#"), (Slice)Slices.utf8Slice((String)"#"))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testIsLikePattern() {
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty())).isFalse();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#")))).isFalse();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#")))).isFalse();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#")))).isFalse();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty())).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty())).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#")))).isTrue();
        Assertions.assertThat((boolean)LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#")))).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.isLikePattern((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testPatternConstantPrefixBytes() {
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc"), Optional.empty())).isEqualTo(3);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#_def"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo(8);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc##def"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo(8);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#%def"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo(8);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc%def"), Optional.empty())).isEqualTo(3);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef_"), Optional.empty())).isEqualTo(6);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abcdef##_"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo(8);
        Assertions.assertThat((int)LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"%abcdef#_"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#abc"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> LikeFunctions.patternConstantPrefixBytes((Slice)Slices.utf8Slice((String)"abc#"), Optional.of(Slices.utf8Slice((String)"#")))).isInstanceOf(TrinoException.class)).hasMessage("Escape character must be followed by '%', '_' or the escape character itself");
    }

    @Test
    public void testUnescapeValidLikePattern() {
        Assertions.assertThat((Comparable)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc"), Optional.empty())).isEqualTo((Object)Slices.utf8Slice((String)"abc"));
        Assertions.assertThat((Comparable)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"abc#_"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo((Object)Slices.utf8Slice((String)"abc_"));
        Assertions.assertThat((Comparable)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a##bc#_"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo((Object)Slices.utf8Slice((String)"a#bc_"));
        Assertions.assertThat((Comparable)LikeFunctions.unescapeLiteralLikePattern((Slice)Slices.utf8Slice((String)"a###_bc"), Optional.of(Slices.utf8Slice((String)"#")))).isEqualTo((Object)Slices.utf8Slice((String)"a#_bc"));
    }

    @Test
    public void testLikeWithDynamicPattern() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (\n    VALUES\n        ('a', 'a'),\n        ('b', 'a'),\n        ('c', '%')) t(value, pattern)\nWHERE value LIKE pattern\n")))).matches("VALUES 'a', 'c'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (\n    VALUES\n        ('a%b', 'aX%b', 'X'),\n        ('a0b', 'aX%b', 'X'),\n        ('b_', 'aY_', 'Y'),\n        ('c%', 'cZ%', 'Z')) t(value, pattern, esc)\nWHERE value LIKE pattern ESCAPE esc\n")))).matches("VALUES 'a%b', 'c%'");
    }
}

