/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.io.BaseEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestVarbinaryFunctions {
    private static final byte[] ALL_BYTES = new byte[256];
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBinaryLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'58F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
    }

    @Test
    public void testLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('' AS VARBINARY)")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('a' AS VARBINARY)")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("length", "CAST('abc' AS VARBINARY)")))).isEqualTo(3L);
    }

    @Test
    public void testConcat() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("CONCAT", "X''")::evaluate).hasCauseMessageContaining("There must be two or more concatenation arguments");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobar"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY) || CAST ('baz' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbaz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(' foo ' AS VARBINARY) || CAST ('  bar  ' AS VARBINARY) || CAST ('   baz   ' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)" foo   bar     baz   "));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY) || CAST ('bazbaz' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbazbaz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'000102' || X'AAABAC' || X'FDFEFF'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"000102AAABACFDFEFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'CAFFEE' || X'F7' || X'DE58'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CAFFEEF7DE58"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'58' || X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'' || X'58' || X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'58' || X'' || X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'58' || X'F7' || X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'' || X'58' || X'' || X'F7' || X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("X'' || X'' || X'' || X'' || X'' || X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "CAST('foo' AS VARBINARY)", "CAST ('bar' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobar"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "CAST('foo' AS VARBINARY)", "CAST ('bar' AS VARBINARY)", "CAST ('baz' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbaz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "CAST('foo' AS VARBINARY)", "CAST ('bar' AS VARBINARY)", "CAST ('bazbaz' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbazbaz"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X'000102'", "X'AAABAC'", "X'FDFEFF'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"000102AAABACFDFEFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X'CAFFEE'", "X'F7'", "X'DE58'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CAFFEEF7DE58"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X'58'", "X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X''", "X'58'", "X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X'58'", "X''", "X'F7'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("CONCAT", "X'58'", "X'F7'", "X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "X''", "X'58'", "X''", "X'F7'", "X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("concat", "X''", "X''", "X''", "X''", "X''", "X''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
    }

    @Test
    public void testToBase64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64", "CAST('' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64(""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64", "CAST('a' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64("a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64", "CAST('abc' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64("abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64", "CAST('hello world' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "to_base64(CAST('' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "to_base64(CAST('a' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "to_base64(CAST('abc' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "CAST(to_base64(CAST('' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "CAST(to_base64(CAST('a' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64", "CAST(to_base64(CAST('abc' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64", "from_base64('%s')".formatted(TestVarbinaryFunctions.encodeBase64(ALL_BYTES)))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64(ALL_BYTES));
    }

    @Test
    public void testToBase64Url() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64url", "CAST('' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64Url(""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64url", "CAST('a' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64Url("a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64url", "CAST('abc' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64Url("abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64url", "CAST('hello world' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64Url() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "to_base64url(CAST('' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "to_base64url(CAST('a' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "to_base64url(CAST('abc' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "CAST(to_base64url(CAST('' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "CAST(to_base64url(CAST('a' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base64url", "CAST(to_base64url(CAST('abc' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base64url", "from_base64url('%s')".formatted(TestVarbinaryFunctions.encodeBase64Url(ALL_BYTES)))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase64Url(ALL_BYTES));
    }

    @Test
    public void testToBase32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "CAST('' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase32(""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "CAST('a' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase32("a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "CAST('abc' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase32("abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "CAST('hello world' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("NBSWY3DPEB3W64TMMQ======");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "NULL")))).isNull((Type)VarcharType.VARCHAR);
    }

    @Test
    public void testFromBase32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "'ME======'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "'MFRGG==='")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "'NBSWY3DPEB3W64TMMQ======'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"hello world"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "to_base32(CAST('' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "to_base32(CAST('a' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "to_base32(CAST('abc' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "to_base32(CAST('hello world' AS VARBINARY))")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"hello world"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(to_base32(CAST('' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(to_base32(CAST('a' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(to_base32(CAST('abc' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(to_base32(CAST('hello world' AS VARBINARY)) AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"hello world"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_base32", "from_base32('%s')".formatted(TestVarbinaryFunctions.encodeBase32(ALL_BYTES)))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeBase32(ALL_BYTES));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(NULL AS VARCHAR)")))).isNull((Type)VarbinaryType.VARBINARY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_base32", "CAST(NULL AS VARBINARY)")))).isNull((Type)VarbinaryType.VARBINARY);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base32", "'1='")::evaluate).hasMessage("Invalid input length 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base32", "'M1======'")::evaluate).hasMessage("Unrecognized character: 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base32", "CAST('1=' AS VARBINARY)")::evaluate).hasMessage("Invalid input length 1");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_base32", "CAST('M1======' AS VARBINARY)")::evaluate).hasMessage("Unrecognized character: 1");
    }

    @Test
    public void testToHex() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_hex", "CAST('' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeHex(""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_hex", "CAST('a' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeHex("a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_hex", "CAST('abc' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo(TestVarbinaryFunctions.encodeHex("abc"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_hex", "CAST('hello world' AS VARBINARY)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("68656C6C6F20776F726C64");
    }

    @Test
    public void testFromHex() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "''")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "'61'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "'617a6f'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "'617A6F'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "CAST('61' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_hex", "CAST('617a6F' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_hex", "from_hex('%s')".formatted(BaseEncoding.base16().encode(ALL_BYTES)))))).hasType((Type)VarcharType.VARCHAR).isEqualTo(BaseEncoding.base16().encode(ALL_BYTES));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'f/'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'f:'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'f@'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'fG'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'f`'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'fg'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_hex", "'fff'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testToBigEndian64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_64", "0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_64", "1")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000001"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_64", "9223372036854775807")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FFFFFFFFFFFFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_64", "-9223372036854775807")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8000000000000001"));
    }

    @Test
    public void testFromBigEndian64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_64", "from_hex('0000000000000000')")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_64", "from_hex('0000000000000001')")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_64", "from_hex('7FFFFFFFFFFFFFFF')")))).isEqualTo(Long.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_64", "from_hex('8000000000000001')")))).isEqualTo(-9223372036854775807L);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_64", "from_hex('')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_64", "from_hex('1111')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_64", "from_hex('000000000000000011')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testToBigEndian32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_32", "0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_32", "1")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000001"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_32", "2147483647")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FFFFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_big_endian_32", "-2147483647")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"80000001"));
    }

    @Test
    public void testFromBigEndian32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_32", "from_hex('00000000')")))).hasType((Type)IntegerType.INTEGER).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_32", "from_hex('00000001')")))).hasType((Type)IntegerType.INTEGER).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_32", "from_hex('7FFFFFFF')")))).hasType((Type)IntegerType.INTEGER).isEqualTo(Integer.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_big_endian_32", "from_hex('80000001')")))).hasType((Type)IntegerType.INTEGER).isEqualTo(-2147483647);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_32", "from_hex('')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_32", "from_hex('1111')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_big_endian_32", "from_hex('000000000000000011')")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testToIEEE754Binary32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(0.0 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(1.0 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3F800000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(3.14 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"4048F5C3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(NAN() AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FC00000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(INFINITY() AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7F800000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(-INFINITY() AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FF800000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(3.4028235E38 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7F7FFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(-3.4028235E38 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FF7FFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(1.4E-45 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000001"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_32", "CAST(-1.4E-45 AS REAL)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"80000001"));
    }

    @Test
    public void testFromIEEE754Binary32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "from_hex('3F800000')")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(1.0 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "from_hex('4048F5C3')")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(3.14f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(3.14 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(3.14f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(NAN() AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(Float.NaN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(INFINITY() AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(Float.POSITIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(-INFINITY() AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(Float.NEGATIVE_INFINITY));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(3.4028235E38 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(Float.MAX_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(-3.4028235E38 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(-3.4028235E38f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(1.4E-45 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(Float.MIN_VALUE));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_32", "to_ieee754_32(CAST(-1.4E-45 AS REAL))")))).hasType((Type)RealType.REAL).isEqualTo(Float.valueOf(-1.4E-45f));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_ieee754_32", "from_hex('0000')")::evaluate).hasMessage("Input floating-point value must be exactly 4 bytes long");
    }

    @Test
    public void testToIEEE754Binary64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "0.0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "1.0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3FF0000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "3.1415926")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"400921FB4D12D84A"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "NAN()")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FF8000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "INFINITY()")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FF0000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "-INFINITY()")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FFF0000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "1.7976931348623157E308")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FEFFFFFFFFFFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "-1.7976931348623157E308")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FFEFFFFFFFFFFFFF"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "4.9E-324")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000001"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("to_ieee754_64", "-4.9E-324")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8000000000000001"));
    }

    @Test
    public void testFromIEEE754Binary64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "from_hex('0000000000000000')")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "from_hex('3FF0000000000000')")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(3.1415926)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(3.1415926);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(NAN())")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NaN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(INFINITY())")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.POSITIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(-INFINITY())")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.NEGATIVE_INFINITY);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(1.7976931348623157E308)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(-1.7976931348623157E308)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-1.7976931348623157E308);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(4.9E-324)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(Double.MIN_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("from_ieee754_64", "to_ieee754_64(-4.9E-324)")))).hasType((Type)DoubleType.DOUBLE).isEqualTo(-4.9E-324);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("from_ieee754_64", "from_hex('00000000')")::evaluate).hasMessage("Input floating-point value must be exactly 8 bytes long");
    }

    @Test
    public void testLpad() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "x'1234'", "7", "x'45'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"45454545451234"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "x'1234'", "7", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"45244524451234"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "x'1234'", "3", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"451234"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "x'1234'", "0", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("lpad", "x'1234'", "1", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("lpad", "x'2312'", "-1", "x'4524'")::evaluate).hasMessage("Target length must be in the range [0..2147483647]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("lpad", "x'2312'", "1", "x''")::evaluate).hasMessage("Padding bytes must not be empty");
    }

    @Test
    public void testRpad() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "x'1234'", "7", "x'45'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12344545454545"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "x'1234'", "7", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12344524452445"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "x'1234'", "3", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"123445"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "x'23'", "0", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("rpad", "x'1234'", "1", "x'4524'")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rpad", "x'1234'", "-1", "x'4524'")::evaluate).hasMessage("Target length must be in the range [0..2147483647]");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.function("rpad", "x'1234'", "1", "x''")::evaluate).hasMessage("Padding bytes must not be empty");
    }

    @Test
    public void testMd5() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("md5", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D41D8CD98F00B204E9800998ECF8427E"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("md5", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"533F6357E0210E67D91F651BC49E1278"));
    }

    @Test
    public void testSha1() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha1", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"DA39A3EE5E6B4B0D3255BFEF95601890AFD80709"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha1", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FB78992E561929A6967D5328F49413FA99048D06"));
    }

    @Test
    public void testSha256() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha256", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha256", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"02208B9403A87DF9F4ED6B2EE2657EFAA589026B4CCE9ACCC8E8A5BF3D693C86"));
    }

    @Test
    public void testSha512() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha512", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CF83E1357EEFB8BDF1542850D66D8007D620E4050B5715DC83F4A921D36CE9CE47D0D13C5D85F2B0FF8318D2877EEC2F63B931BD47417A81A538327AF927DA3E"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("sha512", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8A4B59FB9188D09B989FF596AC9CEFBF2ED91DED8DCD9498E8BF2236814A92B23BE6867E7FC340880E514F8FDF97E1F147EA4B0FD6C2DA3557D0CF1C0B58A204"));
    }

    @Test
    public void testMurmur3() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("murmur3", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000000000000000000000000000"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("murmur3", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"93192FE805BE23041C8318F67EC4F2BC"));
    }

    @Test
    public void testXxhash64() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("xxhash64", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"EF46DB3751D8E999"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("xxhash64", "CAST('hashme' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"F9D96E0E1165E892"));
    }

    @Test
    public void testSpookyHash() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("spooky_hash_v2_32", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"6BF50919"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("spooky_hash_v2_32", "CAST('hello' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D382E6CA"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("spooky_hash_v2_64", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"232706FC6BF50919"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("spooky_hash_v2_64", "CAST('hello' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3768826AD382E6CA"));
    }

    @Test
    public void testCrc32() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("crc32", "to_utf8('CRC me!')")))).isEqualTo(38028046L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("crc32", "to_utf8('1234567890')")))).isEqualTo(639479525L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("crc32", "to_utf8(CAST(1234567890 AS VARCHAR))")))).isEqualTo(639479525L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("crc32", "to_utf8('ABCDEFGHIJK')")))).isEqualTo(1129618807L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("crc32", "to_utf8('ABCDEFGHIJKLM')")))).isEqualTo(4223167559L);
    }

    @Test
    public void testVarbinarySubstring() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "5")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "-5")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "-50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "5", "6")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratica"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "5", "10")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "5", "50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "50", "10")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "-5", "4")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"call"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "-5", "40")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "-50", "4")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "0", "4")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("SUBSTR", "VARBINARY 'Quadratically'", "5", "0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "VARBINARY 'Quadratically'").binding("start", "5")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "VARBINARY 'Quadratically'").binding("start", "50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "VARBINARY 'Quadratically'").binding("start", "-5")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "VARBINARY 'Quadratically'").binding("start", "-50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "VARBINARY 'Quadratically'").binding("start", "0")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "VARBINARY 'Quadratically'").binding("start", "5").binding("length", "6")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratica"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "VARBINARY 'Quadratically'").binding("start", "5").binding("length", "50")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "X'4FE15FF5'").binding("start", "1").binding("length", "1")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{79}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start FOR length)").binding("value", "X'4FE15FF5'").binding("start", "2").binding("length", "2")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{225, 95}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "X'4FE15FF5'").binding("start", "3")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{95, 245}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SUBSTRING(value FROM start)").binding("value", "X'4FE15FF5'").binding("start", "-2")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{95, 245}));
    }

    @Test
    public void testHmacMd5() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_md5", "CAST('' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"63530468A04E386459855DA0063B6596"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_md5", "CAST('hashme' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0A26EBEB0E7B65F528D96F7BC631BC8F"));
    }

    @Test
    public void testHmacSHA1() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha1", "CAST('' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"F42BB0EEB018EBBD4597AE7213711EC60760843F"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha1", "CAST('hashme' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"2E7C4C6AEFA7E69F106EEE3CE21944D0046D2F3D"));
    }

    @Test
    public void testHmacSHA256() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha256", "CAST('' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"5D5D139563C95B5967B9BD9A8C9B233A9DEDB45072794CD232DC1B74832607D0"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha256", "CAST('hashme' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D3D72F9FACDE059DA3A4EB43A9ABDD4B35118E0FEF00E6D16FB04BB332AF0484"));
    }

    @Test
    public void testHmacSHA512() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha512", "CAST('' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"84FA5AA0279BBC473267D05A53EA03310A987CECC4C1535FF29B6D76B8F1444A728DF3AADB89D4A9A6709E1998F373566E8F824A8CA93B1821F0B69BC2A2F65E"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("hmac_sha512", "CAST('hashme' AS VARBINARY)", "CAST('key' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FEFA712B67DED871E1ED987F8B20D6A69EB9FCC87974218B9A1A6D5202B54C18ECDA4839A979DED22F07E0881CF40B762691992D120408F49D6212E112509D72"));
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as varbinary)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "X'58'")))).isEqualTo(false);
    }

    @Test
    public void testReverse() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "CAST('' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "CAST('hello' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"olleh"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "CAST('Quadratically' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"yllacitardauQ"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("reverse", "CAST('racecar' AS VARBINARY)")))).isEqualTo(SqlVarbinaryTestingUtil.sqlVarbinary((String)"racecar"));
    }

    private static String encodeBase64(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    private static String encodeBase64(String value) {
        return TestVarbinaryFunctions.encodeBase64(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase64Url(byte[] value) {
        return Base64.getUrlEncoder().encodeToString(value);
    }

    private static String encodeBase64Url(String value) {
        return TestVarbinaryFunctions.encodeBase64Url(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase32(String value) {
        return TestVarbinaryFunctions.encodeBase32(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase32(byte[] value) {
        return BaseEncoding.base32().encode(value);
    }

    private static String encodeHex(String value) {
        return BaseEncoding.base16().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    static {
        for (int i = 0; i < ALL_BYTES.length; ++i) {
            TestVarbinaryFunctions.ALL_BYTES[i] = (byte)i;
        }
    }
}

