/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.ExpressionVerifier;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.Map;

public final class ExpressionTestUtils {
    private static final SqlParser SQL_PARSER = new SqlParser();

    private ExpressionTestUtils() {
    }

    public static void assertExpressionEquals(Expression actual, Expression expected) {
        ExpressionTestUtils.assertExpressionEquals(actual, expected, new SymbolAliases());
    }

    public static void assertExpressionEquals(Expression actual, Expression expected, SymbolAliases symbolAliases) {
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        if (!((Boolean)verifier.process((Node)actual, expected)).booleanValue()) {
            ExpressionTestUtils.failNotEqual(actual, expected, null);
        }
    }

    private static void failNotEqual(Object actual, Object expected, String message) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        throw new AssertionError((Object)((String)formatted + " expected [" + String.valueOf(expected) + "] but found [" + String.valueOf(actual) + "]"));
    }

    public static Expression createExpression(Session session, String expression, TransactionManager transactionManager, PlannerContext plannerContext, TypeProvider symbolTypes) {
        Expression parsedExpression = SQL_PARSER.createExpression(expression);
        return ExpressionTestUtils.planExpression(transactionManager, plannerContext, session, symbolTypes, parsedExpression);
    }

    public static Expression createExpression(String expression, TransactionManager transactionManager, PlannerContext plannerContext, TypeProvider symbolTypes) {
        return ExpressionTestUtils.createExpression(SessionTestUtils.TEST_SESSION, expression, transactionManager, plannerContext, symbolTypes);
    }

    public static Expression planExpression(TransactionManager transactionManager, PlannerContext plannerContext, Session session, TypeProvider typeProvider, Expression expression) {
        if (session.getTransactionId().isPresent()) {
            return ExpressionTestUtils.planExpressionInExistingTx(plannerContext, typeProvider, expression, session);
        }
        return (Expression)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> ExpressionTestUtils.planExpressionInExistingTx(plannerContext, typeProvider, expression, transactionSession));
    }

    private static Expression planExpressionInExistingTx(PlannerContext plannerContext, TypeProvider typeProvider, Expression expression, Session transactionSession) {
        return ExpressionTestUtils.resolveFunctionCalls(plannerContext, transactionSession, typeProvider, ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)expression));
    }

    public static Expression resolveFunctionCalls(PlannerContext plannerContext, Session session, TypeProvider typeProvider, Expression expression) {
        return ExpressionTestUtils.resolveFunctionCalls(plannerContext, session, typeProvider, expression, Scope.builder().build());
    }

    public static Expression resolveFunctionCalls(PlannerContext plannerContext, Session session, TypeProvider typeProvider, Expression expression, Scope scope) {
        final ExpressionAnalyzer analyzer = ExpressionAnalyzer.createWithoutSubqueries((PlannerContext)plannerContext, (AccessControl)new AllowAllAccessControl(), (Session)session, (TypeProvider)typeProvider, (Map)ImmutableMap.of(), node -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.EXPRESSION_NOT_CONSTANT, (Node)node, (String)"Constant expression cannot contain a subquery", (Object[])new Object[0]), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        analyzer.analyze(expression, scope);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ResolvedFunction resolvedFunction = (ResolvedFunction)analyzer.getResolvedFunctions().get(NodeRef.of((Node)node));
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                FunctionCall newFunctionCall = new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getProcessingMode(), rewritten.getArguments());
                return this.coerceIfNecessary((Expression)node, (Expression)newFunctionCall);
            }

            protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                rewrittenExpression = this.coerceIfNecessary(node, rewrittenExpression);
                return rewrittenExpression;
            }

            private Expression coerceIfNecessary(Expression originalExpression, Expression rewrittenExpression) {
                Type coercion = (Type)analyzer.getExpressionCoercions().get(NodeRef.of((Node)originalExpression));
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, TypeSignatureTranslator.toSqlType((Type)coercion), false, analyzer.getTypeOnlyCoercions().contains(NodeRef.of((Node)originalExpression)));
                }
                return rewrittenExpression;
            }
        }, (Expression)expression);
    }

    public static Map<NodeRef<Expression>, Type> getTypes(Session session, PlannerContext plannerContext, TypeProvider typeProvider, Expression expression) {
        if (session.getTransactionId().isPresent()) {
            return TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)plannerContext).getTypes(session, typeProvider, expression);
        }
        return (Map)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (Metadata)plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(session, transactionSession -> TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)plannerContext).getTypes(transactionSession, typeProvider, expression));
    }
}

