/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.FeaturesConfig;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.sql.analyzer.RegexLibrary;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setRedistributeWrites(true).setScaleWriters(true).setWriterScalingMinDataProcessed(DataSize.of((long)120L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxMemoryPerPartitionWriter(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setRegexLibrary(RegexLibrary.JONI).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setSpillEnabled(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setSpillerSpillPaths("").setSpillerThreads(4).setSpillMaxUsedSpaceThreshold(0.9).setMemoryRevokingThreshold(0.9).setMemoryRevokingTarget(0.5).setExchangeCompressionCodec(CompressionCodec.NONE).setExchangeDataIntegrityVerification(FeaturesConfig.DataIntegrityVerification.ABORT).setPagesIndexEagerCompactionEnabled(false).setFilterAndProjectMinOutputPageSize(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setFilterAndProjectMinOutputPageRowCount(256).setMaxRecursionDepth(10).setMaxGroupingSets(2048).setOmitDateTimeTypePrecision(false).setLegacyCatalogRoles(false).setIncrementalHashArrayLoadFactorEnabled(true).setLegacyMaterializedViewGracePeriod(false).setHideInaccessibleColumns(false).setForceSpillingJoin(false).setFaultTolerantExecutionExchangeEncryptionEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"redistribute-writes", (Object)"false").put((Object)"scale-writers", (Object)"false").put((Object)"writer-scaling-min-data-processed", (Object)"4GB").put((Object)"max-memory-per-partition-writer", (Object)"4GB").put((Object)"regex-library", (Object)"RE2J").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"spill-enabled", (Object)"true").put((Object)"aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"spiller-spill-path", (Object)"/tmp/custom/spill/path1,/tmp/custom/spill/path2").put((Object)"spiller-threads", (Object)"42").put((Object)"spiller-max-used-space-threshold", (Object)"0.8").put((Object)"memory-revoking-threshold", (Object)"0.2").put((Object)"memory-revoking-target", (Object)"0.8").put((Object)"exchange.compression-codec", (Object)"ZSTD").put((Object)"exchange.data-integrity-verification", (Object)"RETRY").put((Object)"pages-index.eager-compaction-enabled", (Object)"true").put((Object)"filter-and-project-min-output-page-size", (Object)"1MB").put((Object)"filter-and-project-min-output-page-row-count", (Object)"2048").put((Object)"max-recursion-depth", (Object)"8").put((Object)"analyzer.max-grouping-sets", (Object)"2047").put((Object)"deprecated.omit-datetime-type-precision", (Object)"true").put((Object)"deprecated.legacy-catalog-roles", (Object)"true").put((Object)"incremental-hash-array-load-factor.enabled", (Object)"false").put((Object)"legacy.materialized-view-grace-period", (Object)"true").put((Object)"hide-inaccessible-columns", (Object)"true").put((Object)"force-spilling-join-operator", (Object)"true").put((Object)"fault-tolerant-execution.exchange-encryption-enabled", (Object)"false").buildOrThrow();
        FeaturesConfig expected = new FeaturesConfig().setRedistributeWrites(false).setScaleWriters(false).setWriterScalingMinDataProcessed(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxMemoryPerPartitionWriter(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setRegexLibrary(RegexLibrary.RE2J).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setSpillEnabled(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setSpillerSpillPaths("/tmp/custom/spill/path1,/tmp/custom/spill/path2").setSpillerThreads(42).setSpillMaxUsedSpaceThreshold(0.8).setMemoryRevokingThreshold(0.2).setMemoryRevokingTarget(0.8).setExchangeCompressionCodec(CompressionCodec.ZSTD).setExchangeDataIntegrityVerification(FeaturesConfig.DataIntegrityVerification.RETRY).setPagesIndexEagerCompactionEnabled(true).setFilterAndProjectMinOutputPageSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFilterAndProjectMinOutputPageRowCount(2048).setMaxRecursionDepth(8).setMaxGroupingSets(2047).setOmitDateTimeTypePrecision(true).setLegacyCatalogRoles(true).setIncrementalHashArrayLoadFactorEnabled(false).setLegacyMaterializedViewGracePeriod(true).setHideInaccessibleColumns(true).setForceSpillingJoin(true).setFaultTolerantExecutionExchangeEncryptionEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

