/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.operator.RetryPolicy;
import io.trino.sql.DynamicFilters;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestAddDynamicFilterSource
extends BasePlanTest {
    public TestAddDynamicFilterSource() {
        super((Map<String, String>)ImmutableMap.of((Object)"retry_policy", (Object)RetryPolicy.TASK.name(), (Object)"enable_dynamic_filtering", (Object)"true", (Object)"join_reordering_strategy", (Object)OptimizerConfig.JoinReorderingStrategy.NONE.name()));
    }

    @Test
    public void testBroadcastInnerJoin() {
        this.assertDistributedPlan("SELECT l.suppkey FROM lineitem l, supplier s WHERE l.suppkey = s.suppkey", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.BROADCAST), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_SK", "SUPPLIER_SK").dynamicFilter("LINEITEM_SK", "SUPPLIER_SK").left(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey"))).with(this.numberOfDynamicFilters(1))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(DynamicFilterSourceNode.class, PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK", (Object)"suppkey")))))))));
    }

    @Test
    public void testPartitionedInnerJoin() {
        this.assertDistributedPlan("SELECT l.suppkey FROM lineitem l, supplier s WHERE l.suppkey = s.suppkey", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_SK", "SUPPLIER_SK").dynamicFilter("LINEITEM_SK", "SUPPLIER_SK").left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey"))).with(this.numberOfDynamicFilters(1)))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(DynamicFilterSourceNode.class, PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK", (Object)"suppkey")))))))));
    }

    @Test
    public void testSemiJoin() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : Arrays.asList(OptimizerConfig.JoinDistributionType.BROADCAST, OptimizerConfig.JoinDistributionType.PARTITIONED)) {
            SemiJoinNode.DistributionType semiJoinDistributionType = joinDistributionType == OptimizerConfig.JoinDistributionType.PARTITIONED ? SemiJoinNode.DistributionType.PARTITIONED : SemiJoinNode.DistributionType.REPLICATED;
            this.assertDistributedPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", this.noSemiJoinRewrite(joinDistributionType), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.semiJoin("X", "Y", "S", Optional.of(semiJoinDistributionType), Optional.of(true), PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))).with(this.numberOfDynamicFilters(1)), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, joinDistributionType == OptimizerConfig.JoinDistributionType.PARTITIONED ? ExchangeNode.Type.REPARTITION : ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(DynamicFilterSourceNode.class, PlanMatchPattern.project(PlanMatchPattern.filter("Z % 4 = 0", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey", (Object)"Z", (Object)"linenumber")))))))))));
        }
    }

    @Test
    public void testInnerJoinWithUnionAllOnBuild() {
        this.assertDistributedPlan("SELECT l.suppkey FROM lineitem l JOIN (SELECT suppkey FROM supplier UNION ALL SELECT suppkey FROM supplier) s ON l.suppkey = s.suppkey", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.BROADCAST), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_SK", "SUPPLIER_SK").dynamicFilter("LINEITEM_SK", "SUPPLIER_SK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(DynamicFilterSourceNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), Optional.empty(), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), (List<String>)ImmutableList.of((Object)"SUPPLIER_SK"), Optional.empty(), PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK_1", (Object)"suppkey")), PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK_2", (Object)"suppkey"))))))))));
        this.assertDistributedPlan("SELECT l.suppkey FROM lineitem l JOIN (SELECT suppkey FROM supplier UNION ALL SELECT suppkey FROM supplier) s ON l.suppkey = s.suppkey", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_SK", "SUPPLIER_SK").left(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.empty(), Optional.empty(), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), (List<String>)ImmutableList.of((Object)"SUPPLIER_SK"), Optional.empty(), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK_1", (Object)"suppkey"))), PlanMatchPattern.exchange(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK_2", (Object)"suppkey"))))))));
    }

    @Test
    public void testCrossJoinInequality() {
        this.assertDistributedPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey BETWEEN l.orderkey AND l.partkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY BETWEEN L_ORDERKEY AND L_PARTKEY", PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.dynamicFilter((List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("L_ORDERKEY", ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, "O_ORDERKEY"), (Object)new PlanMatchPattern.DynamicFilterPattern("L_PARTKEY", ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, "O_ORDERKEY"))).left(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey")))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, PlanMatchPattern.node(DynamicFilterSourceNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))))))))));
        this.assertDistributedPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE o.orderkey >= l.orderkey AND o.orderkey <= l.partkey - 1", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY >= L_ORDERKEY AND O_ORDERKEY <= expr", PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("L_PARTKEY - BIGINT '1'")), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey", (Object)"L_PARTKEY", (Object)"partkey"))))))))));
    }

    @Test
    public void testJoinWithPrePartitionedBuild() {
        this.assertDistributedPlan("SELECT * FROM lineitem JOIN (SELECT suppkey FROM supplier GROUP BY 1) s ON lineitem.suppkey = s.suppkey", this.withJoinDistributionType(OptimizerConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.equiCriteria("LINEITEM_SK", "SUPPLIER_SK").left(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_SK", (Object)"suppkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("supplier", (Map<String, String>)ImmutableMap.of((Object)"SUPPLIER_SK", (Object)"suppkey")))))));
    }

    private Matcher numberOfDynamicFilters(final int numberOfDynamicFilters) {
        return new Matcher(){

            @Override
            public boolean shapeMatches(PlanNode node) {
                return node instanceof FilterNode;
            }

            @Override
            public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
                FilterNode filterNode = (FilterNode)node;
                return new MatchResult(DynamicFilters.extractDynamicFilters((Expression)filterNode.getPredicate()).getDynamicConjuncts().size() == numberOfDynamicFilters);
            }
        };
    }

    private Session noSemiJoinRewrite(OptimizerConfig.JoinDistributionType distributionType) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").setSystemProperty("join_distribution_type", distributionType.name()).build();
    }

    private Session withJoinDistributionType(OptimizerConfig.JoinDistributionType distributionType) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", distributionType.name()).build();
    }
}

