/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.PartialTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartialTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setTransactionId(TransactionId.create()).build();
    private static final TypeAnalyzer TYPE_ANALYZER = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("double_symbol_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bigint_symbol_1"), (Object)BigintType.BIGINT).put((Object)new Symbol("timestamp3_symbol_1"), (Object)TimestampType.TIMESTAMP_MILLIS).put((Object)new Symbol("row_symbol_1"), (Object)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5)), RowType.field((String)"timestamptz3_field_1", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)})).buildOrThrow());

    @Test
    public void testPartialTranslator() {
        SymbolReference rowSymbolReference = new SymbolReference("row_symbol_1");
        SubscriptExpression dereferenceExpression1 = new SubscriptExpression((Expression)rowSymbolReference, (Expression)new LongLiteral("1"));
        SubscriptExpression dereferenceExpression2 = new SubscriptExpression((Expression)rowSymbolReference, (Expression)new LongLiteral("2"));
        SubscriptExpression dereferenceExpression3 = new SubscriptExpression((Expression)rowSymbolReference, (Expression)new LongLiteral("3"));
        StringLiteral stringLiteral = new StringLiteral("abcd");
        SymbolReference symbolReference1 = new SymbolReference("double_symbol_1");
        SymbolReference timestamp3SymbolReference = new SymbolReference("timestamp3_symbol_1");
        this.assertFullTranslation((Expression)symbolReference1);
        this.assertFullTranslation((Expression)dereferenceExpression1);
        this.assertFullTranslation((Expression)stringLiteral);
        this.assertFullTranslation((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)symbolReference1, (Expression)dereferenceExpression1));
        this.assertPartialTranslation((Expression)new CoalesceExpression((Expression)new AtTimeZone((Expression)timestamp3SymbolReference, (Expression)stringLiteral), (Expression)dereferenceExpression3, new Expression[0]), List.of(timestamp3SymbolReference, stringLiteral, dereferenceExpression3));
        FunctionCall functionCallExpression = new FunctionCall(TestingPlannerContext.PLANNER_CONTEXT.getMetadata().resolveBuiltinFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR})).toQualifiedName(), (List)ImmutableList.of((Object)stringLiteral, (Object)dereferenceExpression2));
        this.assertFullTranslation((Expression)functionCallExpression);
    }

    private void assertPartialTranslation(Expression expression, List<Expression> subexpressions) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
        Assertions.assertThat((int)subexpressions.size()).isEqualTo(translation.size());
        for (Expression subexpression : subexpressions) {
            Assertions.assertThat((Map)translation).containsEntry((Object)NodeRef.of((Node)subexpression), (Object)((ConnectorExpression)ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)subexpression, (TypeProvider)TYPE_PROVIDER, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TYPE_ANALYZER).get()));
        }
    }

    private void assertFullTranslation(Expression expression) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
        Assertions.assertThat((Object)((NodeRef)Iterables.getOnlyElement(translation.keySet()))).isEqualTo((Object)NodeRef.of((Node)expression));
        Assertions.assertThat((Object)((ConnectorExpression)Iterables.getOnlyElement(translation.values()))).isEqualTo(ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression, (TypeProvider)TYPE_PROVIDER, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TYPE_ANALYZER).get());
    }
}

