/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.UnwrapYearInComparison;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnwrapYearInComparison
extends BasePlanTest {
    @Test
    public void testEquals() {
        this.testUnwrap("date", "year(a) = -0001", "a BETWEEN DATE '-0001-01-01' AND DATE '-0001-12-31'");
        this.testUnwrap("date", "year(a) = 1960", "a BETWEEN DATE '1960-01-01' AND DATE '1960-12-31'");
        this.testUnwrap("date", "year(a) = 2022", "a BETWEEN DATE '2022-01-01' AND DATE '2022-12-31'");
        this.testUnwrap("date", "year(a) = 9999", "a BETWEEN DATE '9999-01-01' AND DATE '9999-12-31'");
        this.testUnwrap("timestamp", "year(a) = -0001", "a BETWEEN TIMESTAMP '-0001-01-01 00:00:00.000' AND TIMESTAMP '-0001-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) = 1960", "a BETWEEN TIMESTAMP '1960-01-01 00:00:00.000' AND TIMESTAMP '1960-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) = 9999", "a BETWEEN TIMESTAMP '9999-01-01 00:00:00.000' AND TIMESTAMP '9999-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(0)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00' AND TIMESTAMP '2022-12-31 23:59:59'");
        this.testUnwrap("timestamp(1)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0' AND TIMESTAMP '2022-12-31 23:59:59.9'");
        this.testUnwrap("timestamp(2)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00' AND TIMESTAMP '2022-12-31 23:59:59.99'");
        this.testUnwrap("timestamp(3)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(4)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000' AND TIMESTAMP '2022-12-31 23:59:59.9999'");
        this.testUnwrap("timestamp(5)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000' AND TIMESTAMP '2022-12-31 23:59:59.99999'");
        this.testUnwrap("timestamp(6)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000' AND TIMESTAMP '2022-12-31 23:59:59.999999'");
        this.testUnwrap("timestamp(7)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999'");
        this.testUnwrap("timestamp(8)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999'");
        this.testUnwrap("timestamp(9)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999'");
        this.testUnwrap("timestamp(10)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999999'");
        this.testUnwrap("timestamp(11)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999999'");
        this.testUnwrap("timestamp(12)", "year(a) = 2022", "a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999999'");
    }

    @Test
    public void testInPredicate() {
        this.testUnwrap("date", "year(a) IN (1000, 1400, 1800)", "a BETWEEN DATE '1000-01-01' AND DATE '1000-12-31' OR a BETWEEN DATE '1400-01-01' AND DATE '1400-12-31' OR a BETWEEN DATE '1800-01-01' AND DATE '1800-12-31'");
        this.testUnwrap("timestamp", "year(a) IN (1000, 1400, 1800)", "a BETWEEN TIMESTAMP '1000-01-01 00:00:00.000' AND TIMESTAMP '1000-12-31 23:59:59.999' OR a BETWEEN TIMESTAMP '1400-01-01 00:00:00.000' AND TIMESTAMP '1400-12-31 23:59:59.999' OR a BETWEEN TIMESTAMP '1800-01-01 00:00:00.000' AND TIMESTAMP '1800-12-31 23:59:59.999'");
    }

    @Test
    public void testNotEquals() {
        this.testUnwrap("date", "year(a) <> -0001", "NOT (a BETWEEN DATE '-0001-01-01' AND DATE '-0001-12-31')");
        this.testUnwrap("date", "year(a) <> 1960", "NOT (a BETWEEN DATE '1960-01-01' AND DATE '1960-12-31')");
        this.testUnwrap("date", "year(a) <> 2022", "NOT (a BETWEEN DATE '2022-01-01' AND DATE '2022-12-31')");
        this.testUnwrap("date", "year(a) <> 9999", "NOT (a BETWEEN DATE '9999-01-01' AND DATE '9999-12-31')");
        this.testUnwrap("timestamp", "year(a) <> -0001", "NOT (a BETWEEN TIMESTAMP '-0001-01-01 00:00:00.000' AND TIMESTAMP '-0001-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) <> 1960", "NOT (a BETWEEN TIMESTAMP '1960-01-01 00:00:00.000' AND TIMESTAMP '1960-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) <> 9999", "NOT (a BETWEEN TIMESTAMP '9999-01-01 00:00:00.000' AND TIMESTAMP '9999-12-31 23:59:59.999')");
        this.testUnwrap("timestamp(0)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00' AND TIMESTAMP '2022-12-31 23:59:59')");
        this.testUnwrap("timestamp(1)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0' AND TIMESTAMP '2022-12-31 23:59:59.9')");
        this.testUnwrap("timestamp(2)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00' AND TIMESTAMP '2022-12-31 23:59:59.99')");
        this.testUnwrap("timestamp(3)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999')");
        this.testUnwrap("timestamp(4)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000' AND TIMESTAMP '2022-12-31 23:59:59.9999')");
        this.testUnwrap("timestamp(5)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000' AND TIMESTAMP '2022-12-31 23:59:59.99999')");
        this.testUnwrap("timestamp(6)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000' AND TIMESTAMP '2022-12-31 23:59:59.999999')");
        this.testUnwrap("timestamp(7)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999')");
        this.testUnwrap("timestamp(8)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999')");
        this.testUnwrap("timestamp(9)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999')");
        this.testUnwrap("timestamp(10)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999999')");
        this.testUnwrap("timestamp(11)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999999')");
        this.testUnwrap("timestamp(12)", "year(a) <> 2022", "NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999999')");
    }

    @Test
    public void testLessThan() {
        this.testUnwrap("date", "year(a) < -0001", "a < DATE '-0001-01-01'");
        this.testUnwrap("date", "year(a) < 1960", "a < DATE '1960-01-01'");
        this.testUnwrap("date", "year(a) < 2022", "a < DATE '2022-01-01'");
        this.testUnwrap("date", "year(a) < 9999", "a < DATE '9999-01-01'");
        this.testUnwrap("timestamp", "year(a) < -0001", "a < TIMESTAMP '-0001-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) < 1960", "a < TIMESTAMP '1960-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) < 9999", "a < TIMESTAMP '9999-01-01 00:00:00.000'");
        this.testUnwrap("timestamp(0)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00'");
        this.testUnwrap("timestamp(1)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.0'");
        this.testUnwrap("timestamp(2)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.00'");
        this.testUnwrap("timestamp(3)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.000'");
        this.testUnwrap("timestamp(4)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.0000'");
        this.testUnwrap("timestamp(5)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.00000'");
        this.testUnwrap("timestamp(6)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.000000'");
        this.testUnwrap("timestamp(7)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.0000000'");
        this.testUnwrap("timestamp(8)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.00000000'");
        this.testUnwrap("timestamp(9)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.000000000'");
        this.testUnwrap("timestamp(10)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.0000000000'");
        this.testUnwrap("timestamp(11)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.00000000000'");
        this.testUnwrap("timestamp(12)", "year(a) < 2022", "a < TIMESTAMP '2022-01-01 00:00:00.000000000000'");
    }

    @Test
    public void testLessThanOrEqual() {
        this.testUnwrap("date", "year(a) <= -0001", "a <= DATE '-0001-12-31'");
        this.testUnwrap("date", "year(a) <= 1960", "a <= DATE '1960-12-31'");
        this.testUnwrap("date", "year(a) <= 2022", "a <= DATE '2022-12-31'");
        this.testUnwrap("date", "year(a) <= 9999", "a <= DATE '9999-12-31'");
        this.testUnwrap("timestamp", "year(a) <= -0001", "a <= TIMESTAMP '-0001-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) <= 1960", "a <= TIMESTAMP '1960-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) <= 9999", "a <= TIMESTAMP '9999-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(0)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59'");
        this.testUnwrap("timestamp(1)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.9'");
        this.testUnwrap("timestamp(2)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.99'");
        this.testUnwrap("timestamp(3)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(4)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.9999'");
        this.testUnwrap("timestamp(5)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.99999'");
        this.testUnwrap("timestamp(6)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.999999'");
        this.testUnwrap("timestamp(7)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.9999999'");
        this.testUnwrap("timestamp(8)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.99999999'");
        this.testUnwrap("timestamp(9)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.999999999'");
        this.testUnwrap("timestamp(10)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.9999999999'");
        this.testUnwrap("timestamp(11)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.99999999999'");
        this.testUnwrap("timestamp(12)", "year(a) <= 2022", "a <= TIMESTAMP '2022-12-31 23:59:59.999999999999'");
    }

    @Test
    public void testGreaterThan() {
        this.testUnwrap("date", "year(a) > -0001", "a > DATE '-0001-12-31'");
        this.testUnwrap("date", "year(a) > 1960", "a > DATE '1960-12-31'");
        this.testUnwrap("date", "year(a) > 2022", "a > DATE '2022-12-31'");
        this.testUnwrap("date", "year(a) > 9999", "a > DATE '9999-12-31'");
        this.testUnwrap("timestamp", "year(a) > -0001", "a > TIMESTAMP '-0001-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) > 1960", "a > TIMESTAMP '1960-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp", "year(a) > 9999", "a > TIMESTAMP '9999-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(0)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59'");
        this.testUnwrap("timestamp(1)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.9'");
        this.testUnwrap("timestamp(2)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.99'");
        this.testUnwrap("timestamp(3)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.999'");
        this.testUnwrap("timestamp(4)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.9999'");
        this.testUnwrap("timestamp(5)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.99999'");
        this.testUnwrap("timestamp(6)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.999999'");
        this.testUnwrap("timestamp(7)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.9999999'");
        this.testUnwrap("timestamp(8)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.99999999'");
        this.testUnwrap("timestamp(9)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.999999999'");
        this.testUnwrap("timestamp(10)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.9999999999'");
        this.testUnwrap("timestamp(11)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.99999999999'");
        this.testUnwrap("timestamp(12)", "year(a) > 2022", "a > TIMESTAMP '2022-12-31 23:59:59.999999999999'");
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.testUnwrap("date", "year(a) >= -0001", "a >= DATE '-0001-01-01'");
        this.testUnwrap("date", "year(a) >= 1960", "a >= DATE '1960-01-01'");
        this.testUnwrap("date", "year(a) >= 2022", "a >= DATE '2022-01-01'");
        this.testUnwrap("date", "year(a) >= 9999", "a >= DATE '9999-01-01'");
        this.testUnwrap("timestamp", "year(a) >= -0001", "a >= TIMESTAMP '-0001-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) >= 1960", "a >= TIMESTAMP '1960-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.000'");
        this.testUnwrap("timestamp", "year(a) >= 9999", "a >= TIMESTAMP '9999-01-01 00:00:00.000'");
        this.testUnwrap("timestamp(0)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00'");
        this.testUnwrap("timestamp(1)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.0'");
        this.testUnwrap("timestamp(2)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.00'");
        this.testUnwrap("timestamp(3)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.000'");
        this.testUnwrap("timestamp(4)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.0000'");
        this.testUnwrap("timestamp(5)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.00000'");
        this.testUnwrap("timestamp(6)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.000000'");
        this.testUnwrap("timestamp(7)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.0000000'");
        this.testUnwrap("timestamp(8)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.00000000'");
        this.testUnwrap("timestamp(9)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.000000000'");
        this.testUnwrap("timestamp(10)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.0000000000'");
        this.testUnwrap("timestamp(11)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.00000000000'");
        this.testUnwrap("timestamp(12)", "year(a) >= 2022", "a >= TIMESTAMP '2022-01-01 00:00:00.000000000000'");
    }

    @Test
    public void testDistinctFrom() {
        this.testUnwrap("date", "year(a) IS DISTINCT FROM -0001", "a IS NULL OR NOT (a BETWEEN DATE '-0001-01-01' AND DATE '-0001-12-31')");
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 1960", "a IS NULL OR NOT (a BETWEEN DATE '1960-01-01' AND DATE '1960-12-31')");
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN DATE '2022-01-01' AND DATE '2022-12-31')");
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 9999", "a IS NULL OR NOT (a BETWEEN DATE '9999-01-01' AND DATE '9999-12-31')");
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM -0001", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '-0001-01-01 00:00:00.000' AND TIMESTAMP '-0001-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 1960", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '1960-01-01 00:00:00.000' AND TIMESTAMP '1960-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999')");
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 9999", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '9999-01-01 00:00:00.000' AND TIMESTAMP '9999-12-31 23:59:59.999')");
        this.testUnwrap("timestamp(0)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00' AND TIMESTAMP '2022-12-31 23:59:59')");
        this.testUnwrap("timestamp(1)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0' AND TIMESTAMP '2022-12-31 23:59:59.9')");
        this.testUnwrap("timestamp(2)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00' AND TIMESTAMP '2022-12-31 23:59:59.99')");
        this.testUnwrap("timestamp(3)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000' AND TIMESTAMP '2022-12-31 23:59:59.999')");
        this.testUnwrap("timestamp(4)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000' AND TIMESTAMP '2022-12-31 23:59:59.9999')");
        this.testUnwrap("timestamp(5)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000' AND TIMESTAMP '2022-12-31 23:59:59.99999')");
        this.testUnwrap("timestamp(6)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000' AND TIMESTAMP '2022-12-31 23:59:59.999999')");
        this.testUnwrap("timestamp(7)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999')");
        this.testUnwrap("timestamp(8)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999')");
        this.testUnwrap("timestamp(9)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999')");
        this.testUnwrap("timestamp(10)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.0000000000' AND TIMESTAMP '2022-12-31 23:59:59.9999999999')");
        this.testUnwrap("timestamp(11)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.00000000000' AND TIMESTAMP '2022-12-31 23:59:59.99999999999')");
        this.testUnwrap("timestamp(12)", "year(a) IS DISTINCT FROM 2022", "a IS NULL OR NOT (a BETWEEN TIMESTAMP '2022-01-01 00:00:00.000000000000' AND TIMESTAMP '2022-12-31 23:59:59.999999999999')");
    }

    @Test
    public void testNull() {
        this.testUnwrap("date", "year(a) = CAST(NULL AS BIGINT)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("timestamp", "year(a) = CAST(NULL AS BIGINT)", "CAST(NULL AS BOOLEAN)");
    }

    @Test
    public void testNaN() {
        this.testUnwrap("date", "year(a) = nan()", "year(a) IS NULL AND CAST(NULL AS BOOLEAN)");
        this.testUnwrap("timestamp", "year(a) = nan()", "year(a) IS NULL AND CAST(NULL AS BOOLEAN)");
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("date", String.format("year(a) = %s '2022'", type), "a BETWEEN DATE '2022-01-01' AND DATE '2022-12-31'");
        }
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES DATE '2022-01-01') t(a) WHERE 2022 = year(a)", PlanMatchPattern.output(PlanMatchPattern.filter("A BETWEEN DATE '2022-01-01' AND DATE '2022-12-31'", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testLeapYear() {
        this.testUnwrap("date", "year(a) = 2024", "a BETWEEN DATE '2024-01-01' AND DATE '2024-12-31'");
        this.testUnwrap("timestamp", "year(a) = 2024", "a BETWEEN TIMESTAMP '2024-01-01 00:00:00.000' AND TIMESTAMP '2024-12-31 23:59:59.999'");
    }

    @Test
    public void testCalculateRangeEndInclusive() {
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(1960, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(2024, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999999));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999999));
    }

    private static long toEpochMicros(LocalDateTime localDateTime) {
        return Math.multiplyExact(localDateTime.toEpochSecond(ZoneOffset.UTC), 1000000) + (long)(localDateTime.getNano() / 1000);
    }

    private void testUnwrap(String inputType, String inputPredicate, String expectedPredicate) {
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s OR rand() = 42", inputType, inputPredicate);
        try {
            this.assertPlan(sql, this.getQueryRunner().getDefaultSession(), PlanMatchPattern.output(PlanMatchPattern.filter(expectedPredicate + " OR random() = 42e0", PlanMatchPattern.values("a"))));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }
}

