/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ApplyTableScanRedirection;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import io.trino.tests.BogusType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApplyTableScanRedirection {
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName SOURCE_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").build();
    private static final String SOURCE_COLUMN_NAME_A = "source_col_a";
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_A = new MockConnectorColumnHandle("source_col_a", (Type)VarcharType.VARCHAR);
    private static final String SOURCE_COLUMN_NAME_B = "source_col_b";
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_B = new MockConnectorColumnHandle("source_col_b", (Type)VarcharType.VARCHAR);
    private static final SchemaTableName DESTINATION_TABLE = new SchemaTableName("target_schema", "target_table");
    private static final String DESTINATION_COLUMN_NAME_A = "destination_col_a";
    private static final ColumnHandle DESTINATION_COLUMN_HANDLE_A = new MockConnectorColumnHandle("destination_col_a", (Type)VarcharType.VARCHAR);
    private static final String DESTINATION_COLUMN_NAME_B = "destination_col_b";
    private static final ColumnHandle DESTINATION_COLUMN_HANDLE_B = new MockConnectorColumnHandle("destination_col_b", (Type)VarcharType.VARCHAR);
    private static final String DESTINATION_COLUMN_NAME_C = "destination_col_c";
    private static final ColumnHandle DESTINATION_COLUMN_HANDLE_C = new MockConnectorColumnHandle("destination_col_c", (Type)BigintType.BIGINT);
    private static final String DESTINATION_COLUMN_NAME_D = "destination_col_d";

    private static TableHandle createTableHandle(RuleTester ruleTester, ConnectorTableHandle tableHandle) {
        return new TableHandle(ruleTester.getCurrentCatalogHandle(), tableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create());
    }

    @Test
    public void testDoesNotFire() {
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.empty());
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getPlannerContext())).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE)), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_A));
            }).doesNotFire();
        }
    }

    @Test
    public void testDoesNotFireForDeleteTableScan() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_A));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getPlannerContext())).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE)), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_A), true);
            }).doesNotFire();
        }
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_A));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getPlannerContext())).withSession(MOCK_SESSION).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
        }
    }

    @Test
    public void testMismatchedTypesWithCoercion() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_C));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getPlannerContext())).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE)), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_A));
            }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"COL", (Object)PlanMatchPattern.expression("CAST(DEST_COL AS VARCHAR)")), PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE)::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_C).equals(arg_0)))));
        }
    }

    @Test
    public void testMismatchedTypesWithMissingCoercion() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_D));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            LocalQueryRunner runner = ruleTester.getQueryRunner();
            runner.inTransaction(MOCK_SESSION, transactionSession -> {
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runner.createPlan(transactionSession, "SELECT source_col_a FROM test_table")).isInstanceOf(TrinoException.class)).hasMessageMatching("Cast not possible from redirected column test_catalog.target_schema.target_table.destination_col_d with type Bogus to source column .*test_catalog.test_schema.test_table.*source_col_a.* with type: varchar");
                return null;
            });
        }
    }

    @Test
    public void testApplyTableScanRedirection() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_A));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new ApplyTableScanRedirection(ruleTester.getPlannerContext())).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE)), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_A));
            }).matches(PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE)::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0))));
        }
    }

    @Test
    public void testApplyTableScanRedirectionWithFilter() {
        MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect = this.getMockApplyRedirect((Map<ColumnHandle, String>)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_NAME_A, (Object)SOURCE_COLUMN_HANDLE_B, (Object)DESTINATION_COLUMN_NAME_B));
        MockConnectorFactory mockFactory = this.createMockFactory(Optional.of(applyTableScanRedirect));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ApplyTableScanRedirection applyTableScanRedirection = new ApplyTableScanRedirection(ruleTester.getPlannerContext());
            TupleDomain constraint = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo"))));
            ruleTester.assertThat((Rule<?>)applyTableScanRedirection).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE, (TupleDomain<ColumnHandle>)constraint, Optional.empty())), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_A), (TupleDomain<ColumnHandle>)constraint);
            }).matches(PlanMatchPattern.filter("DEST_COL = VARCHAR 'foo'", PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE)::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0)))));
            ruleTester.assertThat((Rule<?>)applyTableScanRedirection).withSession(MOCK_SESSION).on(p -> {
                Symbol column = p.symbol(SOURCE_COLUMN_NAME_B, (Type)VarcharType.VARCHAR);
                return p.tableScan(TestApplyTableScanRedirection.createTableHandle(ruleTester, new MockConnectorTableHandle(SOURCE_TABLE, (TupleDomain<ColumnHandle>)constraint, Optional.empty())), (List<Symbol>)ImmutableList.of((Object)column), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)column, (Object)SOURCE_COLUMN_HANDLE_B), (TupleDomain<ColumnHandle>)TupleDomain.all());
            }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("DEST_COL_B")), PlanMatchPattern.filter("DEST_COL_A = VARCHAR 'foo'", PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE)::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_A", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0), (Object)"DEST_COL_B", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_B).equals(arg_0))))));
        }
    }

    private MockConnectorFactory.ApplyTableScanRedirect getMockApplyRedirect(Map<ColumnHandle, String> redirectionMapping) {
        return (session, handle) -> Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName("test_catalog", DESTINATION_TABLE), redirectionMapping, ((MockConnectorTableHandle)handle).getConstraint().transformKeys(MockConnectorColumnHandle.class::cast).transformKeys(redirectionMapping::get)));
    }

    private MockConnectorFactory createMockFactory(Optional<MockConnectorFactory.ApplyTableScanRedirect> applyTableScanRedirect) {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)SOURCE_TABLE)) {
                return ImmutableList.of((Object)new ColumnMetadata(SOURCE_COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(SOURCE_COLUMN_NAME_B, (Type)VarcharType.VARCHAR));
            }
            if (schemaTableName.equals((Object)DESTINATION_TABLE)) {
                return ImmutableList.of((Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_A, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_B, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_C, (Type)BigintType.BIGINT), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_D, (Type)BogusType.BOGUS));
            }
            throw new IllegalArgumentException();
        });
        applyTableScanRedirect.ifPresent(builder::withApplyTableScanRedirect);
        return builder.build();
    }
}

