/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushJoinIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestPushJoinIntoTableScan {
    private static final String SCHEMA = "test_schema";
    private static final String TABLE_A = "test_table_a";
    private static final String TABLE_B = "test_table_b";
    private static final SchemaTableName TABLE_A_SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "test_table_a");
    private static final SchemaTableName TABLE_B_SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "test_table_b");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").build();
    private static final String COLUMN_A1 = "columna1";
    public static final Variable COLUMN_A1_VARIABLE = new Variable("columna1", (Type)BigintType.BIGINT);
    private static final ColumnHandle COLUMN_A1_HANDLE = new MockConnectorColumnHandle("columna1", (Type)BigintType.BIGINT);
    private static final String COLUMN_A2 = "columna2";
    private static final ColumnHandle COLUMN_A2_HANDLE = new MockConnectorColumnHandle("columna2", (Type)BigintType.BIGINT);
    private static final String COLUMN_B1 = "columnb1";
    public static final Variable COLUMN_B1_VARIABLE = new Variable("columnb1", (Type)BigintType.BIGINT);
    private static final ColumnHandle COLUMN_B1_HANDLE = new MockConnectorColumnHandle("columnb1", (Type)BigintType.BIGINT);
    private static final Map<String, ColumnHandle> TABLE_A_ASSIGNMENTS = ImmutableMap.of((Object)"columna1", (Object)COLUMN_A1_HANDLE, (Object)"columna2", (Object)COLUMN_A2_HANDLE);
    private static final Map<String, ColumnHandle> TABLE_B_ASSIGNMENTS = ImmutableMap.of((Object)"columnb1", (Object)COLUMN_B1_HANDLE);
    private static final List<ColumnMetadata> TABLE_A_COLUMN_METADATA = (List)TABLE_A_ASSIGNMENTS.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((MockConnectorColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
    private static final List<ColumnMetadata> TABLE_B_COLUMN_METADATA = (List)TABLE_B_ASSIGNMENTS.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((MockConnectorColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
    public static final SchemaTableName JOIN_PUSHDOWN_SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "TABLE_A_JOINED_WITH_B");
    public static final ColumnHandle JOIN_COLUMN_A1_HANDLE = new MockConnectorColumnHandle("join_columna1", (Type)BigintType.BIGINT);
    public static final ColumnHandle JOIN_COLUMN_A2_HANDLE = new MockConnectorColumnHandle("join_columna2", (Type)BigintType.BIGINT);
    public static final ColumnHandle JOIN_COLUMN_B1_HANDLE = new MockConnectorColumnHandle("join_columnb1", (Type)BigintType.BIGINT);
    public static final MockConnectorTableHandle JOIN_CONNECTOR_TABLE_HANDLE = new MockConnectorTableHandle(JOIN_PUSHDOWN_SCHEMA_TABLE_NAME, (TupleDomain<ColumnHandle>)TupleDomain.none(), Optional.of(ImmutableList.of((Object)JOIN_COLUMN_A1_HANDLE, (Object)JOIN_COLUMN_A2_HANDLE, (Object)JOIN_COLUMN_B1_HANDLE)));
    public static final Map<ColumnHandle, ColumnHandle> JOIN_TABLE_A_COLUMN_MAPPING = ImmutableMap.of((Object)COLUMN_A1_HANDLE, (Object)JOIN_COLUMN_A1_HANDLE, (Object)COLUMN_A2_HANDLE, (Object)JOIN_COLUMN_A2_HANDLE);
    public static final Map<ColumnHandle, ColumnHandle> JOIN_TABLE_B_COLUMN_MAPPING = ImmutableMap.of((Object)COLUMN_B1_HANDLE, (Object)JOIN_COLUMN_B1_HANDLE);
    public static final List<ColumnMetadata> JOIN_TABLE_COLUMN_METADATA = (List)JOIN_TABLE_A_COLUMN_MAPPING.entrySet().stream().map(entry -> new ColumnMetadata(((MockConnectorColumnHandle)entry.getValue()).getName(), ((MockConnectorColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());

    @ParameterizedTest
    @MethodSource(value={"testPushJoinIntoTableScanParams"})
    public void testPushJoinIntoTableScan(JoinNode.Type joinType, Optional<ComparisonExpression.Operator> filterComparisonOperator) {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            Assertions.assertThat((Object)((MockConnectorTableHandle)left).getTableName()).isEqualTo((Object)TABLE_A_SCHEMA_TABLE_NAME);
            Assertions.assertThat((Object)((MockConnectorTableHandle)right).getTableName()).isEqualTo((Object)TABLE_B_SCHEMA_TABLE_NAME);
            Assertions.assertThat((Comparable)applyJoinType).isEqualTo((Object)this.toSpiJoinType(joinType));
            JoinCondition.Operator expectedOperator = filterComparisonOperator.map(this::getConditionOperator).orElse(JoinCondition.Operator.EQUAL);
            Assertions.assertThat((List)joinConditions).containsExactly((Object[])new JoinCondition[]{new JoinCondition(expectedOperator, (ConnectorExpression)COLUMN_A1_VARIABLE, (ConnectorExpression)COLUMN_B1_VARIABLE)});
            return Optional.of(new JoinApplicationResult((Object)JOIN_CONNECTOR_TABLE_HANDLE, JOIN_TABLE_A_COLUMN_MAPPING, JOIN_TABLE_B_COLUMN_MAPPING, false));
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                if (filterComparisonOperator.isEmpty()) {
                    return p.join(joinType, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
                }
                return p.join(joinType, (PlanNode)left, (PlanNode)right, (Expression)new ComparisonExpression((ComparisonExpression.Operator)filterComparisonOperator.get(), (Expression)columnA1Symbol.toSymbolReference(), (Expression)columnB1Symbol.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
            }).matches(PlanMatchPattern.project(PlanMatchPattern.tableScan(JOIN_PUSHDOWN_SCHEMA_TABLE_NAME.getTableName())));
        }
    }

    public static Stream<Arguments> testPushJoinIntoTableScanParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.empty()}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.LESS_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.GREATER_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.NOT_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.empty()}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.LESS_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.GREATER_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.NOT_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.empty()}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.LESS_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.GREATER_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.NOT_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.empty()}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.LESS_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.GREATER_THAN)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.NOT_EQUAL)}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, Optional.of(ComparisonExpression.Operator.IS_DISTINCT_FROM)}));
    }

    @Test
    public void testPushJoinIntoTableScanWithComplexFilter() {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            ((ListAssert)Assertions.assertThat((List)joinConditions).as("joinConditions", new Object[0])).isEqualTo(List.of(new JoinCondition(JoinCondition.Operator.GREATER_THAN, (ConnectorExpression)new Call((Type)BigintType.BIGINT, StandardFunctions.MULTIPLY_FUNCTION_NAME, List.of(new Constant((Object)44L, (Type)BigintType.BIGINT), new Variable(COLUMN_A1, (Type)BigintType.BIGINT))), (ConnectorExpression)new Variable(COLUMN_B1, (Type)BigintType.BIGINT))));
            return Optional.of(new JoinApplicationResult((Object)JOIN_CONNECTOR_TABLE_HANDLE, JOIN_TABLE_A_COLUMN_MAPPING, JOIN_TABLE_B_COLUMN_MAPPING, false));
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new GenericLiteral("BIGINT", "44"), (Expression)columnA1Symbol.toSymbolReference()), (Expression)columnB1Symbol.toSymbolReference()), new JoinNode.EquiJoinClause[0]);
            }).matches(PlanMatchPattern.project(PlanMatchPattern.tableScan(JOIN_PUSHDOWN_SCHEMA_TABLE_NAME.getTableName())));
        }
    }

    @Test
    public void testPushJoinIntoTableScanDoesNotFireForDifferentCatalogs() {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            throw new IllegalStateException("applyJoin should not be called!");
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.getQueryRunner().createCatalog("another_catalog", "mock", (Map)ImmutableMap.of());
            TableHandle tableBHandleAnotherCatalog = TestPushJoinIntoTableScan.createTableHandle(new MockConnectorTableHandle(new SchemaTableName(SCHEMA, TABLE_B)), TestingHandles.createTestCatalogHandle((String)"another_catalog"));
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(tableBHandleAnotherCatalog, (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
            }).doesNotFire();
        }
    }

    @Test
    public void testPushJoinIntoTableScanDoesNotFireWhenDisabled() {
        Session joinPushDownDisabledSession = Session.builder((Session)MOCK_SESSION).setSystemProperty("allow_pushdown_into_connectors", "false").build();
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            throw new IllegalStateException("applyJoin should not be called!");
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(joinPushDownDisabledSession).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
            }).doesNotFire();
        }
    }

    @Test
    public void testPushJoinIntoTableScanDoesNotFireWhenAllPushdownsDisabled() {
        Session allPushdownsDisabledSession = Session.builder((Session)MOCK_SESSION).setSystemProperty("allow_pushdown_into_connectors", "false").build();
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            throw new IllegalStateException("applyJoin should not be called!");
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(allPushdownsDisabledSession).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
            }).doesNotFire();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testPushJoinIntoTableScanPreservesEnforcedConstraintParams"})
    public void testPushJoinIntoTableScanPreservesEnforcedConstraint(JoinNode.Type joinType, TupleDomain<ColumnHandle> leftConstraint, TupleDomain<ColumnHandle> rightConstraint, TupleDomain<Predicate<ColumnHandle>> expectedConstraint) {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> Optional.of(new JoinApplicationResult((Object)JOIN_CONNECTOR_TABLE_HANDLE, JOIN_TABLE_A_COLUMN_MAPPING, JOIN_TABLE_B_COLUMN_MAPPING, false)));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE), leftConstraint);
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE), rightConstraint);
                return p.join(joinType, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
            }).matches(PlanMatchPattern.project(PlanMatchPattern.tableScan(tableHandle -> JOIN_PUSHDOWN_SCHEMA_TABLE_NAME.equals((Object)((MockConnectorTableHandle)tableHandle).getTableName()), expectedConstraint, (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of())));
        }
    }

    public static Stream<Arguments> testPushJoinIntoTableScanPreservesEnforcedConstraintParams() {
        Domain columnA1Domain = Domain.multipleValues((Type)BigintType.BIGINT, List.of(Long.valueOf(3L)));
        Domain columnA2Domain = Domain.multipleValues((Type)BigintType.BIGINT, List.of(Long.valueOf(10L), Long.valueOf(20L)));
        Domain columnB1Domain = Domain.multipleValues((Type)BigintType.BIGINT, List.of(Long.valueOf(30L), Long.valueOf(40L)));
        return Stream.of(Arguments.of((Object[])new Object[]{JoinNode.Type.INNER, TupleDomain.withColumnDomains(Map.of(COLUMN_A1_HANDLE, columnA1Domain, COLUMN_A2_HANDLE, columnA2Domain)), TupleDomain.withColumnDomains(Map.of(COLUMN_B1_HANDLE, columnB1Domain)), TupleDomain.withColumnDomains(Map.of(Predicates.equalTo((Object)JOIN_COLUMN_A1_HANDLE), columnA1Domain, Predicates.equalTo((Object)JOIN_COLUMN_A2_HANDLE), columnA2Domain, Predicates.equalTo((Object)JOIN_COLUMN_B1_HANDLE), columnB1Domain))}), Arguments.of((Object[])new Object[]{JoinNode.Type.RIGHT, TupleDomain.withColumnDomains(Map.of(COLUMN_A1_HANDLE, columnA1Domain, COLUMN_A2_HANDLE, columnA2Domain)), TupleDomain.withColumnDomains(Map.of(COLUMN_B1_HANDLE, columnB1Domain)), TupleDomain.withColumnDomains(Map.of(Predicates.equalTo((Object)JOIN_COLUMN_A1_HANDLE), columnA1Domain.union(Domain.onlyNull((Type)BigintType.BIGINT)), Predicates.equalTo((Object)JOIN_COLUMN_A2_HANDLE), columnA2Domain.union(Domain.onlyNull((Type)BigintType.BIGINT)), Predicates.equalTo((Object)JOIN_COLUMN_B1_HANDLE), columnB1Domain))}), Arguments.of((Object[])new Object[]{JoinNode.Type.LEFT, TupleDomain.withColumnDomains(Map.of(COLUMN_A1_HANDLE, columnA1Domain, COLUMN_A2_HANDLE, columnA2Domain)), TupleDomain.withColumnDomains(Map.of(COLUMN_B1_HANDLE, columnB1Domain)), TupleDomain.withColumnDomains(Map.of(Predicates.equalTo((Object)JOIN_COLUMN_A1_HANDLE), columnA1Domain, Predicates.equalTo((Object)JOIN_COLUMN_A2_HANDLE), columnA2Domain, Predicates.equalTo((Object)JOIN_COLUMN_B1_HANDLE), columnB1Domain.union(Domain.onlyNull((Type)BigintType.BIGINT))))}), Arguments.of((Object[])new Object[]{JoinNode.Type.FULL, TupleDomain.withColumnDomains(Map.of(COLUMN_A1_HANDLE, columnA1Domain, COLUMN_A2_HANDLE, columnA2Domain)), TupleDomain.withColumnDomains(Map.of(COLUMN_B1_HANDLE, columnB1Domain)), TupleDomain.withColumnDomains(Map.of(Predicates.equalTo((Object)JOIN_COLUMN_A1_HANDLE), columnA1Domain.union(Domain.onlyNull((Type)BigintType.BIGINT)), Predicates.equalTo((Object)JOIN_COLUMN_A2_HANDLE), columnA2Domain.union(Domain.onlyNull((Type)BigintType.BIGINT)), Predicates.equalTo((Object)JOIN_COLUMN_B1_HANDLE), columnB1Domain.union(Domain.onlyNull((Type)BigintType.BIGINT))))}));
    }

    @Test
    public void testPushJoinIntoTableDoesNotFireForCrossJoin() {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> {
            throw new IllegalStateException("applyJoin should not be called!");
        });
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE));
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE));
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause[0]);
            }).doesNotFire();
        }
    }

    @Test
    public void testPushJoinIntoTableRequiresFullColumnHandleMappingInResult() {
        MockConnectorFactory connectorFactory = this.createMockConnectorFactory((session, applyJoinType, left, right, joinConditions, leftAssignments, rightAssignments) -> Optional.of(new JoinApplicationResult((Object)JOIN_CONNECTOR_TABLE_HANDLE, (Map)ImmutableMap.of((Object)COLUMN_A1_HANDLE, (Object)JOIN_COLUMN_A1_HANDLE, (Object)COLUMN_A2_HANDLE, (Object)JOIN_COLUMN_A2_HANDLE), (Map)ImmutableMap.of(), false)));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(connectorFactory).build();){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ruleTester.assertThat((Rule<?>)new PushJoinIntoTableScan(ruleTester.getPlannerContext(), ruleTester.getTypeAnalyzer())).withSession(MOCK_SESSION).on(p -> {
                Symbol columnA1Symbol = p.symbol(COLUMN_A1);
                Symbol columnA2Symbol = p.symbol(COLUMN_A2);
                Symbol columnB1Symbol = p.symbol(COLUMN_B1);
                TupleDomain leftConstraint = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)COLUMN_A2_HANDLE, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)));
                TupleDomain rightConstraint = TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)COLUMN_B1_HANDLE, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)45L)));
                TableScanNode left = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_A), (List<Symbol>)ImmutableList.of((Object)columnA1Symbol, (Object)columnA2Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnA1Symbol, (Object)COLUMN_A1_HANDLE, (Object)columnA2Symbol, (Object)COLUMN_A2_HANDLE), (TupleDomain<ColumnHandle>)leftConstraint);
                TableScanNode right = p.tableScan(ruleTester.getCurrentCatalogTableHandle(SCHEMA, TABLE_B), (List<Symbol>)ImmutableList.of((Object)columnB1Symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnB1Symbol, (Object)COLUMN_B1_HANDLE), (TupleDomain<ColumnHandle>)rightConstraint);
                return p.join(JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, new JoinNode.EquiJoinClause(columnA1Symbol, columnB1Symbol));
            }).matches(PlanMatchPattern.anyTree(new PlanMatchPattern[0]))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Column handle mappings do not match old column handles");
        }
    }

    private static TableHandle createTableHandle(ConnectorTableHandle tableHandle) {
        return TestPushJoinIntoTableScan.createTableHandle(tableHandle, TestingHandles.TEST_CATALOG_HANDLE);
    }

    private static TableHandle createTableHandle(ConnectorTableHandle tableHandle, CatalogHandle catalogHandle) {
        return new TableHandle(catalogHandle, tableHandle, new ConnectorTransactionHandle(){});
    }

    private MockConnectorFactory createMockConnectorFactory(MockConnectorFactory.ApplyJoin applyJoin) {
        return MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)SCHEMA)).withListTables((connectorSession, schema) -> SCHEMA.equals(schema) ? ImmutableList.of((Object)TABLE_A_SCHEMA_TABLE_NAME.getTableName(), (Object)TABLE_B_SCHEMA_TABLE_NAME.getTableName()) : ImmutableList.of()).withApplyJoin(applyJoin).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)TABLE_A_SCHEMA_TABLE_NAME)) {
                return TABLE_A_COLUMN_METADATA;
            }
            if (schemaTableName.equals((Object)TABLE_B_SCHEMA_TABLE_NAME)) {
                return TABLE_B_COLUMN_METADATA;
            }
            if (schemaTableName.equals((Object)JOIN_PUSHDOWN_SCHEMA_TABLE_NAME)) {
                return JOIN_TABLE_COLUMN_METADATA;
            }
            throw new RuntimeException("Unknown table: " + String.valueOf(schemaTableName));
        }).build();
    }

    private JoinType toSpiJoinType(JoinNode.Type joinType) {
        switch (joinType) {
            case INNER: {
                return JoinType.INNER;
            }
            case LEFT: {
                return JoinType.LEFT_OUTER;
            }
            case RIGHT: {
                return JoinType.RIGHT_OUTER;
            }
            case FULL: {
                return JoinType.FULL_OUTER;
            }
        }
        throw new IllegalArgumentException("Unknown join type: " + String.valueOf(joinType));
    }

    private JoinCondition.Operator getConditionOperator(ComparisonExpression.Operator operator) {
        switch (operator) {
            case EQUAL: {
                return JoinCondition.Operator.EQUAL;
            }
            case NOT_EQUAL: {
                return JoinCondition.Operator.NOT_EQUAL;
            }
            case LESS_THAN: {
                return JoinCondition.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return JoinCondition.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return JoinCondition.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return JoinCondition.Operator.GREATER_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return JoinCondition.Operator.IS_DISTINCT_FROM;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(operator));
    }
}

