/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.LogicalExpression;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestSimplifyExpressions {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies("NOT X", "NOT X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT NOT X", "X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT NOT NOT X", "NOT X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X > Y)", "X <= Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X > (NOT NOT Y))", "X <= Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("X > (NOT NOT Y)", "X > Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X AND Y AND (NOT (Z OR V)))", "(NOT X) OR (NOT Y) OR (Z OR V)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (NOT (Z OR V)))", "(NOT X) AND (NOT Y) AND (Z OR V)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X OR Y OR (Z OR V))", "(NOT X) AND (NOT Y) AND ((NOT Z) AND (NOT V))", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BigintType.BIGINT, (Object)"Y", (Object)BigintType.BIGINT));
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)DoubleType.DOUBLE, (Object)"Y", (Object)DoubleType.DOUBLE));
        TestSimplifyExpressions.assertSimplifies("NOT (X IS DISTINCT FROM Y)", "NOT (X IS DISTINCT FROM Y)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)VarcharType.VARCHAR, (Object)"Y", (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testLikeExpressions() {
        TestSimplifyExpressions.assertSimplifies("name LIKE '%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)2)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)2)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%' ESCAPE '\\'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)CharType.createCharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%' ESCAPE '\\'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.createVarcharType((int)10)));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%' ESCAPE '\\'", "name IS NOT NULL", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", "name LIKE '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '\\'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE 'This is a constant'", "name = VARCHAR 'This is a constant'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '!@#$#!'", "name = VARCHAR '!@#$#!'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587abc\u5b57\u6bcd\ud83d\ude02'", "name = VARCHAR '\u4e2d\u6587abc\u5b57\u6bcd\ud83d\ude02'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\\%' ESCAPE '\\'", "name = VARCHAR '%'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE 'abc\\%' ESCAPE '\\'", "name = VARCHAR 'abc%'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\\%%%%' ESCAPE '\\'", "name LIKE '\\%%%%' ESCAPE '\\'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%\\%\\%%%%' ESCAPE '\\'", "name LIKE '%\\%\\%%%%' ESCAPE '\\'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%' ESCAPE '%'", "name = VARCHAR '%'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '%%%%' ESCAPE '%'", "name = VARCHAR '%%'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
        TestSimplifyExpressions.assertSimplifies("name LIKE '\u4e2d\u6587%%abc\u5b57\u6bcd\ud83d\ude02' ESCAPE '%'", "name = VARCHAR '\u4e2d\u6587%abc\u5b57\u6bcd\ud83d\ude02'", (Map<String, Type>)ImmutableMap.of((Object)"name", (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies("X AND Y", "X AND Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("X OR Y", "X OR Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("X AND X", "X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("X OR X", "X", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Y)", "X OR Y", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A AND V) OR V", "V", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A OR V) AND V", "V", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A OR B OR C) AND (A OR B)", "A OR B", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (A AND B AND C)", "A AND B", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("I = ((A OR B) AND (A OR B OR C))", "I = (A OR B)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"I", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(X OR Y) AND (X OR Z)", "(X OR Y) AND (X OR Z)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(X AND Y AND V) OR (X AND Y AND Z)", "(X AND Y) AND (V OR Z)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((X OR Y OR V) AND (X OR Y OR Z)) = I", "((X OR Y) OR (V AND Z)) = I", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN, (Object)"I", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND V) OR ((X OR V) AND V)", "V", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND X) OR ((X OR V) AND V)", "X OR V", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((X OR V) AND Z) OR ((X OR V) AND V)", "(X OR V) AND (Z OR V)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("X AND ((Y AND Z) OR (Y AND V) OR (Y AND X))", "X AND Y AND (Z OR V OR X)", (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A AND B AND C AND D) OR (A AND B AND E) OR (A AND F)", "A AND ((B AND C AND D) OR (B AND E) OR F)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN, (Object)"F", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((A AND B) OR (A AND C)) AND D", "A AND (B OR C) AND D", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("((A OR B) AND (A OR C)) OR D", "(A OR B OR D) AND (A OR C OR D)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(((A AND B) OR (A AND C)) AND D) OR E", "(A OR E) AND (B OR C OR E) AND (D OR E)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(((A OR B) AND (A OR C)) OR D) AND E", "(A OR (B AND C) OR D) AND E", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D)", "(A OR C) AND (A OR D) AND (B OR C) AND (B OR D)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A AND B) OR (C AND D) OR (E AND F)", "(A AND B) OR (C AND D) OR (E AND F)", (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN, (Object)"F", (Object)BooleanType.BOOLEAN));
        Map symbolTypes = (Map)IntStream.range(1, 61).mapToObj(i -> "A" + i).collect(ImmutableMap.toImmutableMap(Function.identity(), x -> BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", "(A1 AND A2) OR (A3 AND A4) OR (A5 AND A6) OR (A7 AND A8) OR (A9 AND A10) OR (A11 AND A12) OR (A13 AND A14) OR (A15 AND A16) OR (A17 AND A18) OR (A19 AND A20) OR (A21 AND A22) OR (A23 AND A24) OR (A25 AND A26) OR (A27 AND A28) OR (A29 AND A30) OR (A31 AND A32) OR (A33 AND A34) OR (A35 AND A36) OR (A37 AND A38) OR (A39 AND A40) OR (A41 AND A42) OR (A43 AND A44) OR (A45 AND A46) OR (A47 AND A48) OR (A49 AND A50) OR (A51 AND A52) OR (A53 AND A54) OR (A55 AND A56) OR (A57 AND A58) OR (A59 AND A60)", symbolTypes);
    }

    @Test
    public void testMultipleNulls() {
        TestSimplifyExpressions.assertSimplifies("null AND null AND null AND false", "false");
        TestSimplifyExpressions.assertSimplifies("null AND null AND null AND B1", "null AND B1", (Map<String, Type>)ImmutableMap.of((Object)"B1", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies("null OR null OR null OR true", "true");
        TestSimplifyExpressions.assertSimplifies("null OR null OR null OR B1", "null OR B1", (Map<String, Type>)ImmutableMap.of((Object)"B1", (Object)BooleanType.BOOLEAN));
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(11))", "'12300000000'");
        TestSimplifyExpressions.assertSimplifies("CAST(-12300000000 AS varchar(50))", "CAST('-12300000000' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(3))", "CAST(12300000000 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-12300000000 AS varchar(3))", "CAST(-12300000000 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(12300000000 AS varchar(3)) = '12300000000'", "CAST(12300000000 AS varchar(3)) = '12300000000'");
    }

    @Test
    public void testCastIntegerToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(4))", "'1234'");
        TestSimplifyExpressions.assertSimplifies("CAST(-1234 AS varchar(50))", "CAST('-1234' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(3))", "CAST(1234 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-1234 AS varchar(3))", "CAST(-1234 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(1234 AS varchar(3)) = '1234'", "CAST(1234 AS varchar(3)) = '1234'");
    }

    @Test
    public void testCastSmallintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(4))", "'1234'");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '-1234' AS varchar(50))", "CAST('-1234' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(3))", "CAST(SMALLINT '1234' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '-1234' AS varchar(3))", "CAST(SMALLINT '-1234' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(SMALLINT '1234' AS varchar(3)) = '1234'", "CAST(SMALLINT '1234' AS varchar(3)) = '1234'");
    }

    @Test
    public void testCastTinyintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(3))", "'123'");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '-123' AS varchar(50))", "CAST('-123' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(2))", "CAST(TINYINT '123' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '-123' AS varchar(2))", "CAST(TINYINT '-123' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(TINYINT '123' AS varchar(2)) = '123'", "CAST(TINYINT '123' AS varchar(2)) = '123'");
    }

    @Test
    public void testCastShortDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(4))", "'12.4'");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-12.4' AS varchar(50))", "CAST('-12.4' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(3))", "CAST(DECIMAL '12.4' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-12.4' AS varchar(3))", "CAST(DECIMAL '-12.4' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '12.4' AS varchar(3)) = '12.4'", "CAST(DECIMAL '12.4' AS varchar(3)) = '12.4'");
    }

    @Test
    public void testCastLongDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(20))", "'100000000000000000.1'");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-100000000000000000.1' AS varchar(50))", "CAST('-100000000000000000.1' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(3))", "CAST(DECIMAL '100000000000000000.1' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '-100000000000000000.1' AS varchar(3))", "CAST(DECIMAL '-100000000000000000.1' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DECIMAL '100000000000000000.1' AS varchar(3)) = '100000000000000000.1'", "CAST(DECIMAL '100000000000000000.1' AS varchar(3)) = '100000000000000000.1'");
    }

    @Test
    public void testCastDoubleToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(0e0 AS varchar(3))", "'0E0'");
        TestSimplifyExpressions.assertSimplifies("CAST(-0e0 AS varchar(4))", "'-0E0'");
        TestSimplifyExpressions.assertSimplifies("CAST(0e0 / 0e0 AS varchar(3))", "'NaN'");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'Infinity' AS varchar(8))", "'Infinity'");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(5))", "'1.2E3'");
        TestSimplifyExpressions.assertSimplifies("CAST(-12e2 AS varchar(50))", "CAST('-1.2E3' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(3))", "CAST(12e2 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(-12e2 AS varchar(3))", "CAST(-12e2 AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'NaN' AS varchar(2))", "CAST(DOUBLE 'NaN' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(DOUBLE 'Infinity' AS varchar(7))", "CAST(DOUBLE 'Infinity' AS varchar(7))");
        TestSimplifyExpressions.assertSimplifies("CAST(12e2 AS varchar(3)) = '1200.0'", "CAST(12e2 AS varchar(3)) = '1200.0'");
    }

    @Test
    public void testCastRealToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '0e0' AS varchar(3))", "'0E0'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-0e0' AS varchar(4))", "'-0E0'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '0e0' / REAL '0e0' AS varchar(3))", "'NaN'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'Infinity' AS varchar(8))", "'Infinity'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(5))", "'1.2E3'");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-12e2' AS varchar(50))", "CAST('-1.2E3' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(3))", "CAST(REAL '12e2' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '-12e2' AS varchar(3))", "CAST(REAL '-12e2' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'NaN' AS varchar(2))", "CAST(REAL 'NaN' AS varchar(2))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL 'Infinity' AS varchar(7))", "CAST(REAL 'Infinity' AS varchar(7))");
        TestSimplifyExpressions.assertSimplifies("CAST(REAL '12e2' AS varchar(3)) = '1200.0'", "CAST(REAL '12e2' AS varchar(3)) = '1200.0'");
    }

    @Test
    public void testCastDateToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies("CAST(DATE '2013-02-02' AS varchar(10))", "'2013-02-02'");
        TestSimplifyExpressions.assertSimplifies("CAST(DATE '2013-02-02' AS varchar(50))", "CAST('2013-02-02' AS varchar(50))");
        TestSimplifyExpressions.assertSimplifies("CAST(DATE '2013-02-02' AS varchar(3))", "CAST(DATE '2013-02-02' AS varchar(3))");
        TestSimplifyExpressions.assertSimplifies("CAST(DATE '2013-02-02' AS varchar(3)) = '2013-02-02'", "CAST(DATE '2013-02-02' AS varchar(3)) = '2013-02-02'");
    }

    private static void assertSimplifies(@Language(value="SQL") String expression, @Language(value="SQL") String expected) {
        TestSimplifyExpressions.assertSimplifies(expression, expected, (Map<String, Type>)ImmutableMap.of());
    }

    private static void assertSimplifies(@Language(value="SQL") String expression, @Language(value="SQL") String expected, Map<String, Type> symbolTypes) {
        Expression expectedExpression = TestSimplifyExpressions.normalize(ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected)));
        Assertions.assertThat((Object)TestSimplifyExpressions.simplify(expression, symbolTypes)).isEqualTo((Object)expectedExpression);
    }

    private static Expression simplify(@Language(value="SQL") String expression, Map<String, Type> symbolTypes) {
        Map symbols = (Map)symbolTypes.entrySet().stream().collect(ImmutableMap.toImmutableMap(symbolTypeEntry -> new Symbol((String)symbolTypeEntry.getKey()), Map.Entry::getValue));
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression));
        return TestSimplifyExpressions.normalize(SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(symbols), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT)));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 = I2)", "I1 <> I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 > I2)", "I1 <= I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (I3 > I4))", "I1 <> I2 AND I3 <= I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (I1 = I2) OR NOT(I3 > I4))", "I1 <> I2 AND I3 > I4");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (B1 AND B2) OR NOT (B3 OR B4))", "I1 <> I2 AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (I1 IS DISTINCT FROM I2)", "NOT (I1 IS DISTINCT FROM I2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 = D2)", "D1 <> D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <> D2)", "D1 = D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 = R2)", "R1 <> R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <> R2)", "R1 = R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 IS DISTINCT FROM D2)", "NOT (D1 IS DISTINCT FROM D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 IS DISTINCT FROM R2)", "NOT (R1 IS DISTINCT FROM R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > D2)", "NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 >= D2)", "NOT (D1 >= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 < D2)", "NOT (D1 < D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 >= R2)", "NOT (R1 >= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 < R2)", "NOT (R1 < R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 <= R2)", "NOT (R1 <= R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (D1 <= D2)", "NOT (D1 <= D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (D1 <= D2)", "D1 <= D2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (R1 > R2)", "NOT (R1 > R2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT NOT (R1 > R2)", "R1 > R2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((I1 = I2) OR (D1 > D2))", "I1 <> I2 AND NOT (D1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT NOT NOT (NOT NOT (R1 < R2) OR NOT(I1 > I2))", "NOT (R1 < R2) AND I1 > I2");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT ((D1 > D2) OR (B1 AND B2) OR NOT (B3 OR B4))", "NOT (D1 > D2) AND (NOT B1 OR NOT B2) AND (B3 OR B4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (((D1 > D2) AND (I1 < I2)) OR ((B1 AND B2) AND (R1 > R2)))", "(NOT (D1 > D2) OR I1 >= I2) AND ((NOT B1 OR NOT B2) OR NOT (R1 > R2))");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("IF (NOT (I1 < I2), D1, D2)", "IF (I1 >= I2, D1, D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (D1 > 1)", "NOT (D1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > D2)", "NOT (1 > D2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (R1 > 1)", "NOT (R1 > 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("NOT (1 > R2)", "NOT (1 > R2)");
    }

    @Test
    public void testRewriteOrExpression() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 ", "I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I1 IN (3, 4)", "I1 IN (1, 2, 3, 4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I1 = I2", "I1 IN (1, 2, I2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I2 = 3 OR I2 = 4", "I1 IN (1, 2) OR I2 IN (3, 4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 IN (1, 2)", "I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I2 IN (1, 2) OR I2 IN (2, 3)", "I1 = 1 OR I2 IN (1, 2, 3)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 IN (1)", "I1 = 1");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 IN (1)", "I1 = 1");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 IN (2)", "I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 IN (1, 2) OR I1 = 1", "I1 IN (1, 2)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 IN (1, 2) OR I2 = 1 OR I1 = 3 OR I2 = 4", "I1 IN (1, 2, 3) OR I2 IN (1, 4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 IN (1, 2) OR I1 = 3 OR I1 IN (4, 5, 6) OR I2 = 3 OR I2 IN (3, 4)", "I1 IN (1, 2, 3, 4, 5, 6) OR I2 IN (3, 4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I1 = 2 OR I1 IN (3, 4) OR I1 IN (SELECT 1)", "I1 IN (1, 2, 3, 4) OR I1 IN (SELECT 1)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I2 = 2 OR I1 = 3 OR I2 = 4", "I1 IN (1, 3) OR I2 IN (2, 4)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I2 = 2 OR I1 = 3 OR I2 IS NULL", "I1 IN(1, 3) OR I2 = 2 OR I2 IS NULL");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I2 IN (2, 3) OR I1 = 4 OR I2 IN (5, 6)", "I1 IN (1, 4) OR I2 IN (2, 3, 5, 6)");
        TestSimplifyExpressions.assertSimplifiesNumericTypes("I1 = 1 OR I2 = 2 OR I1 = 3 OR I2 = I1", "I1 IN (1, 3) OR I2 IN (2, I1)");
    }

    private static void assertSimplifiesNumericTypes(String expression, String expected) {
        Expression actualExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expression));
        Expression expectedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)SQL_PARSER.createExpression(expected));
        Expression rewritten = SimplifyExpressions.rewrite((Expression)actualExpression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.numericAndBooleanSymbolTypeMapFor(actualExpression)), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT));
        Assertions.assertThat((Object)TestSimplifyExpressions.normalize(rewritten)).isEqualTo((Object)TestSimplifyExpressions.normalize(expectedExpression));
    }

    private static Map<Symbol, Type> numericAndBooleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> {
            switch (symbol.getName().charAt(0)) {
                case 'I': {
                    return IntegerType.INTEGER;
                }
                case 'D': {
                    return DoubleType.DOUBLE;
                }
                case 'R': {
                    return RealType.REAL;
                }
                case 'B': {
                    return BooleanType.BOOLEAN;
                }
            }
            return BigintType.BIGINT;
        }));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = ExpressionUtils.extractPredicates((LogicalExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return ExpressionUtils.logicalExpression((LogicalExpression.Operator)node.getOperator(), predicates);
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return new Cast(node.getExpression(), node.getType(), node.isSafe(), false);
        }
    }
}

