/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestColumnMask {
    private static final String LOCAL_CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String USER = "user";
    private static final String VIEW_OWNER = "view-owner";
    private static final String RUN_AS_USER = "run-as-user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private final QueryAssertions assertions;
    private final TestingAccessControlManager accessControl;

    public TestColumnMask() {
        StandaloneQueryRunner runner = new StandaloneQueryRunner(SESSION);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog(LOCAL_CATALOG, "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        ConnectorViewDefinition view = new ConnectorViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty())), Optional.empty(), Optional.of(VIEW_OWNER), false, (List)ImmutableList.of());
        ConnectorViewDefinition viewWithNested = new ConnectorViewDefinition("SELECT * FROM (\n    VALUES\n        ROW(ROW(1,2), 0),\n        ROW(ROW(3,4), 1)\n) t(nested, id)\n", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nested", RowType.from((List)ImmutableList.of((Object)RowType.field((Type)IntegerType.INTEGER), (Object)RowType.field((Type)IntegerType.INTEGER))).getTypeId(), Optional.empty()), (Object)new ConnectorViewDefinition.ViewColumn("id", IntegerType.INTEGER.getTypeId(), Optional.empty())), Optional.empty(), Optional.of(VIEW_OWNER), false, (List)ImmutableList.of());
        ConnectorMaterializedViewDefinition materializedView = new ConnectorMaterializedViewDefinition("SELECT * FROM local.tiny.nation", Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("regionkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("comment", VarcharType.createVarcharType((int)152).getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of(VIEW_OWNER), (List)ImmutableList.of());
        ConnectorMaterializedViewDefinition freshMaterializedView = new ConnectorMaterializedViewDefinition("SELECT * FROM local.tiny.nation", Optional.of(new CatalogSchemaTableName(LOCAL_CATALOG, "tiny", "nation")), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("regionkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("comment", VarcharType.createVarcharType((int)152).getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of(VIEW_OWNER), (List)ImmutableList.of());
        ConnectorMaterializedViewDefinition materializedViewWithCasts = new ConnectorMaterializedViewDefinition("SELECT nationkey, cast(name as varchar(1)) as name, regionkey, comment FROM local.tiny.nation", Optional.of(new CatalogSchemaTableName(LOCAL_CATALOG, "tiny", "nation")), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("name", VarcharType.createVarcharType((int)2).getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("regionkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorMaterializedViewDefinition.Column("comment", VarcharType.createVarcharType((int)152).getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of(VIEW_OWNER), (List)ImmutableList.of());
        runner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_HIDDEN_COLUMN;
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_WITH_HIDDEN_COLUMN_DATA;
            }
            throw new UnsupportedOperationException();
        }).withGetViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_view"), (Object)view, (Object)new SchemaTableName("default", "view_with_nested"), (Object)viewWithNested)).withGetMaterializedViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_materialized_view"), (Object)materializedView, (Object)new SchemaTableName("default", "nation_fresh_materialized_view"), (Object)freshMaterializedView, (Object)new SchemaTableName("default", "materialized_view_with_casts"), (Object)materializedViewWithCasts)).build()));
        runner.createCatalog(MOCK_CATALOG, MOCK_CATALOG, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testSimpleMask() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "custkey", USER, ViewExpression.builder().identity(USER).expression("-custkey").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '-370'");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "custkey", USER, ViewExpression.builder().identity(USER).expression("NULL").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders WHERE orderkey = 1")))).matches("VALUES CAST(NULL AS BIGINT)");
    }

    @Test
    public void testConditionalMask() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "custkey", USER, ViewExpression.builder().identity(USER).expression("IF (orderkey < 2, null, -custkey)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey FROM orders LIMIT 2")))).matches("VALUES (NULL), CAST('-781' AS BIGINT)");
    }

    @Test
    public void testMultipleMasksOnDifferentColumns() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "custkey", USER, ViewExpression.builder().identity(USER).expression("-custkey").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderstatus", USER, ViewExpression.builder().identity(USER).expression("'X'").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT custkey, orderstatus FROM orders WHERE orderkey = 1")))).matches("VALUES (BIGINT '-370', 'X')");
    }

    @Test
    public void testReferenceInUsingClause() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).expression("IF(orderkey = 1, -orderkey)").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "lineitem"), "orderkey", USER, ViewExpression.builder().identity(USER).expression("IF(orderkey = 1, -orderkey)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders JOIN lineitem USING (orderkey)")))).matches("VALUES BIGINT '6'");
    }

    @Test
    public void testCoercibleType() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("CAST(clerk AS VARCHAR(5))").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('Clerk' AS VARCHAR(15))");
    }

    @Test
    public void testSubquery() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT cast(max(name) AS VARCHAR(15)) FROM nation)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('VIETNAM' AS VARCHAR(15))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT cast(max(name) AS VARCHAR(15)) FROM nation WHERE nationkey = orderkey)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT clerk FROM orders WHERE orderkey = 1")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(15))");
    }

    @Test
    public void testMaterializedView() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_fresh_materialized_view"), "name", USER, ViewExpression.builder().identity(USER).expression("reverse(name)").build());
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_materialized_view"), "name", USER, ViewExpression.builder().identity(USER).expression("reverse(name)").build());
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "materialized_view_with_casts"), "name", USER, ViewExpression.builder().identity(USER).expression("reverse(name)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)USER).build()).build(), "SELECT name FROM mock.default.nation_fresh_materialized_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)USER).build()).build(), "SELECT name FROM mock.default.nation_materialized_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)USER).build()).build(), "SELECT name FROM mock.default.materialized_view_with_casts WHERE nationkey = 1")))).matches("VALUES 'RA'");
    }

    @Test
    public void testView() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), "name", VIEW_OWNER, ViewExpression.builder().identity(VIEW_OWNER).expression("reverse(name)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), "name", VIEW_OWNER, ViewExpression.builder().identity(VIEW_OWNER).catalog(LOCAL_CATALOG).schema("tiny").expression("reverse(name)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)VIEW_OWNER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), "name", RUN_AS_USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("reverse(name)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), "name", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("reverse(name)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT name FROM mock.default.nation_view WHERE nationkey = 1")))).matches("VALUES CAST('ANITNEGRA' AS VARCHAR(25))");
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "custkey", USER, ViewExpression.builder().identity(USER).expression("-custkey").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (SELECT custkey FROM orders WHERE orderkey = 1) SELECT * FROM t")))).matches("VALUES BIGINT '-370'");
    }

    @Test
    public void testOtherSchema() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("sf1").expression("(SELECT count(*) FROM customer)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT max(orderkey) FROM orders")))).matches("VALUES BIGINT '150000'");
    }

    @Test
    public void testDifferentIdentity() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("100").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT sum(orderkey) FROM orders)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT max(orderkey) FROM orders")))).matches("VALUES BIGINT '1500000'");
    }

    @Test
    public void testRecursion() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT orderkey FROM orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT orderkey FROM local.tiny.orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", RUN_AS_USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT orderkey FROM orders)").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT orderkey FROM orders)").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessageMatching(".*\\QColumn mask for 'local.tiny.orders.orderkey' is recursive\\E.*");
    }

    @Test
    public void testLimitedScope() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "customer"), "custkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT min(custkey) FROM customer WHERE customer.custkey = orders.custkey) FROM orders")).hasMessage("line 1:34: Invalid column mask for 'local.tiny.customer.custkey': Column 'orderkey' cannot be resolved");
    }

    @Test
    public void testSqlInjection() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), "name", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("(SELECT name FROM region WHERE regionkey = 0)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1")))).matches("VALUES CAST('AFRICA' AS VARCHAR(25))");
    }

    @Test
    public void testInvalidMasks() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("$$$").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:22: Invalid column mask for 'local.tiny.orders.orderkey': mismatched input '$'. Expecting: <expression>");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("unknown_column").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:22: Invalid column mask for 'local.tiny.orders.orderkey': Column 'unknown_column' cannot be resolved");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("'foo'").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:22: Expected column mask for 'local.tiny.orders.orderkey' to be of type bigint, but was varchar(3)");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("count(*) > 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:10: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [count(*)]");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("row_number() OVER () > 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:22: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [row_number() OVER ()]");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("grouping(orderkey) = 0").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("line 1:20: Column mask for 'orders.orderkey' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]");
    }

    @Test
    public void testShowStats() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("7").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT * FROM orders)")))).containsAll("VALUES\n (VARCHAR 'orderkey', CAST(NULL AS double), 1e0, 0e1, NULL, '7', '7'),\n (VARCHAR 'clerk', 15e3, 1e3, 0e1, NULL, CAST(NULL AS varchar), CAST(NULL AS varchar)),\n (NULL, NULL, NULL, NULL, 15e3, NULL, NULL)\n");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT orderkey FROM orders)")))).matches("VALUES\n (VARCHAR 'orderkey', CAST(NULL AS double), 1e0, 0e1, NULL, VARCHAR '7', VARCHAR '7'),\n (NULL, NULL, NULL, NULL, 15e3, NULL, NULL)\n");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT clerk FROM orders)")))).matches("VALUES\n (VARCHAR 'clerk', 15e3, 1e3, 0e1, NULL, CAST(NULL AS varchar), CAST(NULL AS varchar)),\n (NULL, NULL, NULL, NULL, 15e3, NULL, NULL)\n");
    }

    @Test
    public void testJoin() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey + 1").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders JOIN orders USING (orderkey)")))).matches("VALUES BIGINT '15000'");
    }

    @Test
    public void testColumnMaskingUsingRestrictedColumn() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.custkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderkey", USER, ViewExpression.builder().identity(USER).expression("custkey").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT orderkey FROM orders")).hasMessage("Access Denied: Cannot select from columns [orderkey, custkey] in table or view local.tiny.orders");
    }

    @Test
    public void testInsertWithColumnMasking() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("clerk").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO orders SELECT * FROM orders")).hasMessage("Insert into table with column masks is not supported");
    }

    @Test
    public void testDeleteWithColumnMasking() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("clerk").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("DELETE FROM orders")).hasMessage("line 1:1: Delete from table with column mask");
    }

    @Test
    public void testUpdateWithColumnMasking() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("clerk").build());
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE orders SET clerk = 'X'")).hasMessage("line 1:1: Updating a table with column masks is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE orders SET orderkey = -orderkey")).hasMessage("line 1:1: Updating a table with column masks is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE orders SET clerk = 'X', orderkey = -orderkey")).hasMessage("line 1:1: Updating a table with column masks is not supported");
    }

    @Test
    public void testNotReferencedAndDeniedColumnMasking() {
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.clerk", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("clerk").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.totalprice", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "totalprice", USER, ViewExpression.builder().identity(USER).expression("totalprice").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
        this.accessControl.reset();
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.clerk", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderstatus", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("(SELECT orderstatus FROM local.tiny.orders)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT orderkey FROM orders WHERE orderkey = 1")))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testColumnMaskWithHiddenColumns() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation_with_hidden_column"), "name", USER, ViewExpression.builder().identity(USER).expression("'POLAND'").build());
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("SELECT * FROM mock.tiny.nation_with_hidden_column WHERE nationkey = 1").assertThat())).skippingTypesCheck().matches("VALUES (BIGINT '1', 'POLAND', BIGINT '1', 'al foxes promise slyly according to the regular accounts. bold requests alon')");
        ((QueryAssertions.QueryAssert)((Object)this.assertions.query("SELECT DISTINCT name FROM mock.tiny.nation_with_hidden_column WHERE nationkey = 1").assertThat())).skippingTypesCheck().matches("VALUES 'POLAND'");
        Assertions.assertThatThrownBy(() -> this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column SELECT * FROM mock.tiny.nation_with_hidden_column")).hasMessage("Insert into table with column masks is not supported");
        Assertions.assertThatThrownBy(() -> this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column")).hasMessage("line 1:1: Delete from table with column mask");
        Assertions.assertThatThrownBy(() -> this.assertions.query("UPDATE mock.tiny.nation_with_hidden_column SET name = 'X'")).hasMessage("line 1:1: Updating a table with column masks is not supported");
    }

    @Test
    public void testMultipleMasksUsingOtherMaskedColumns() {
        String query = "SELECT comment, orderstatus, clerk FROM orders WHERE orderkey = 1";
        String expected = "VALUES (CAST('nstructions sleep furiously among ' as varchar(79)), 'O', 'Clerk#000000951')";
        this.accessControl.reset();
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches(expected);
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "comment", USER, ViewExpression.builder().identity(USER).expression("cast(regexp_replace(comment,'(password: [^ ]+)','password: ****') as varchar(79))").build());
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "orderstatus", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(comment,'(country: [^ ]+)') IN ('country: 1'), '*', orderstatus)").build());
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(comment,'(country: [^ ]+)') IN ('country: 1'), '***', clerk)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches(expected);
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("cast(regexp_replace(clerk,'(password: [^ ]+)','password: ****') as varchar(15))").build());
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "comment", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'(country: [^ ]+)') IN ('country: 1'), '***', comment)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches(expected);
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("cast(regexp_replace(clerk,'(password: [^ ]+)','password: ****') as varchar(15))").build());
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "orderstatus", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'(country: [^ ]+)') IN ('country: 1'), '*', orderstatus)").build());
        this.accessControl.columnMask(new QualifiedObjectName("test_catalog", "tiny", "orders"), "comment", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'(country: [^ ]+)') IN ('country: 1'), '***', comment)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches(expected);
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("cast(regexp_replace(clerk,'(Clerk#)','***#') as varchar(15))").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "comment", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'([1-9]+)') IN ('951'), '***', comment)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches("VALUES (CAST('***' as varchar(79)), 'O', CAST('***#000000951' as varchar(15)))");
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "clerk", USER, ViewExpression.builder().identity(USER).expression("cast('###' as varchar(15))").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "orderstatus", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'([1-9]+)') IN ('951'), '*', orderstatus)").build());
        this.accessControl.columnMask(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), "comment", USER, ViewExpression.builder().identity(USER).expression("if(regexp_extract(clerk,'([1-9]+)') IN ('951'), '***', comment)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query(query)))).matches("VALUES (CAST('***' as varchar(79)), '*', CAST('###' as varchar(15)))");
    }

    @Test
    public void testColumnAliasing() {
        this.accessControl.reset();
        this.accessControl.columnMask(new QualifiedObjectName(MOCK_CATALOG, "default", "view_with_nested"), "nested", USER, ViewExpression.builder().identity(USER).expression("if(id = 0, nested)").build());
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT nested[1] FROM mock.default.view_with_nested")))).matches("VALUES 1, NULL");
    }
}

