/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestExecuteImmediate {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testNoParameters() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("EXECUTE IMMEDIATE 'SELECT * FROM (VALUES 1, 2, 3)'")))).matches("VALUES 1,2,3");
    }

    @Test
    public void testParameterInLambda() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("EXECUTE IMMEDIATE 'SELECT * FROM (VALUES ARRAY[1,2,3], ARRAY[4,5,6]) t(a) WHERE any_match(t.a, v -> v = ?)' USING 1")))).matches("VALUES ARRAY[1,2,3]");
    }

    @Test
    public void testQuotesInStatement() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("EXECUTE IMMEDIATE 'SELECT ''foo'''")))).matches("VALUES 'foo'");
    }

    @Test
    public void testSyntaxError() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("EXECUTE IMMEDIATE 'SELECT ''foo'")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessageMatching("line 1:27: mismatched input '''. Expecting: .*");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("EXECUTE IMMEDIATE\n'SELECT ''foo'")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessageMatching("line 2:8: mismatched input '''. Expecting: .*");
    }

    @Test
    public void testSemanticError() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("EXECUTE IMMEDIATE 'SELECT * FROM tiny.tpch.orders'")).hasMessageMatching("line 1:34: Catalog 'tiny' does not exist");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("EXECUTE IMMEDIATE\n'SELECT *\nFROM tiny.tpch.orders'")).hasMessageMatching("line 3:6: Catalog 'tiny' does not exist");
    }
}

